/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.CurrentToolbarOptionsImpl;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.ceditor.find.ReplaceToolbar;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.Replacer;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchHistoryPopup;
import oracle.javatools.ui.search.SearchListener;

public final class FindToolbar {
    static final int SEARCHFIELD_WIDTH = 270;
    private Listeners listeners = new Listeners();
    private final BasicEditorPane editor;
    private final SearchField searchField;
    private int searchLocation = 0;
    private SelectionHelper selectionCriteria = new SelectionHelper();
    private static final HighlightStyle selectRegionStyle;
    private final Toolbar toolbar = new Toolbar();

    public FindToolbar(BasicEditorPane editor) {
        this.editor = editor;
        this.searchField = new SearchField();
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchField.setAutoFind(true);
        this.searchField.addSearchListener((SearchListener)this.listeners);
        this.searchField.setPrompt(Bundle.get("FD_TOOLBAR_PROMPT"));
        PromptedTextField textField = this.searchField.getTextField();
        InputMap inputMap = textField.getInputMap(0);
        ActionMap actionMap = textField.getActionMap();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindToolbar.this.cancel();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
        actionMap.put(cancelAction, cancelAction);
        textField.addFocusListener(this.listeners);
        textField.setName("find-option-text");
        editor.addFocusListener((FocusListener)this.listeners);
        Dimension preferredSize = this.searchField.getPreferredSize();
        this.searchField.setMaximumSize(new Dimension(270, preferredSize.height));
        this.searchField.setMinimumSize(new Dimension(270, preferredSize.height));
        this.searchField.setPreferredSize(new Dimension(Math.max(preferredSize.width, 270), preferredSize.height));
        this.searchField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindToolbar.this.validateRegExp();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindToolbar.this.validateRegExp();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindToolbar.this.validateRegExp();
            }
        });
        new SearchHistoryPopup(this.searchField, (SearchHistoryPopup.HistoryProvider)FindHistoryProvider.INSTANCE);
        this.toolbar.add((Component)this.searchField);
    }

    void cancel() {
        Finder.clearHighlights((BasicEditorPane)this.editor);
        this.editor.requestFocus();
        this.updateSearchActions();
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(this.editor);
        if (findToolbarController != null) {
            findToolbarController.setFindShowing(false);
        }
    }

    Toolbar getToolbar() {
        return this.toolbar;
    }

    public static FindToolbar getFindToolbar(BasicEditorPane editor) {
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(editor);
        return findToolbarController == null ? null : findToolbarController.getFindToolbar();
    }

    static String getIncrementalSearchString(BasicEditorPane editorPane) {
        FindToolbar incrementalSearch = FindToolbar.getFindToolbar(editorPane);
        if (incrementalSearch != null && incrementalSearch.searchField.isShowing() && incrementalSearch.searchField.getText().length() > 0) {
            return incrementalSearch.searchField.getText();
        }
        return "";
    }

    void refind(int location) {
        this.searchLocation = location;
        this.refind();
    }

    void refind() {
        this.find(this.searchField.getText());
    }

    private void find(String searchText) {
        ReplaceToolbar replaceToolbar = ReplaceToolbar.getReplaceToolbar(this.editor);
        if (replaceToolbar != null) {
            replaceToolbar.reset();
        }
        Replacer.clearHighlights((BasicEditorPane)this.editor);
        if (searchText.length() == 0) {
            return;
        }
        FindCriteria criteria = FindOptions.createFindCriteria(this.editor);
        criteria.setText(searchText);
        criteria.setLocation(criteria.getDirection() == FindCriteria.Direction.FORWARD ? this.editor.getSelectionEnd() : this.editor.getSelectionStart());
        if (!criteria.isWrap()) {
            if (criteria.getDirection() == FindCriteria.Direction.FORWARD) {
                criteria.setLowerBound(this.searchLocation);
                criteria.setUpperBound(this.editor.getDocument().getLength());
            } else {
                criteria.setLowerBound(0);
                criteria.setUpperBound(this.editor.getSelectionEnd());
            }
        }
        if (FindOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getSearchSelected()) {
            if (this.editor.hasSelection() && this.selectionCriteria.newSearch) {
                this.selectionCriteria.lowerBound = this.editor.getSelectionStart();
                this.selectionCriteria.upperBound = this.editor.getSelectionEnd();
            }
            criteria.setLowerBound(this.selectionCriteria.lowerBound);
            criteria.setUpperBound(this.selectionCriteria.upperBound);
            this.selectionCriteria.highlight();
        } else {
            this.selectionCriteria.lowerBound = -1;
            this.selectionCriteria.upperBound = -1;
        }
        this.selectionCriteria.newSearch = false;
        criteria.setLocation(this.searchLocation);
        FindController.find(this.editor, criteria);
        this.updateSearchActions();
    }

    private void updateSearchActions() {
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(this.editor);
        findToolbarController.updateVisibleActions();
    }

    void findNext(boolean forward) {
        String text = this.searchField.getText();
        if (text.length() == 0) {
            return;
        }
        FindOptions findOptions = FindController.getFindOptions();
        findOptions.updateHistory(true, text);
        FindCriteria criteria = (FindCriteria)this.editor.getProperty("find-criteria");
        if (criteria == null) {
            criteria = FindOptions.createFindCriteria(this.editor);
        }
        criteria.setLocation(forward ? this.editor.getSelectionEnd() : this.editor.getSelectionStart());
        criteria.setDirection(forward ? FindCriteria.Direction.FORWARD : FindCriteria.Direction.BACKWARD);
        if (this.selectionCriteria.lowerBound >= 0 || this.selectionCriteria.upperBound >= 0) {
            this.selectionCriteria.highlight();
        }
        FindController.find(this.editor, criteria);
        criteria.setDirection(FindCriteria.Direction.FORWARD);
        criteria.setLocation(this.editor.getSelectionEnd());
    }

    public void dispose() {
        this.editor.removeFocusListener((FocusListener)this.listeners);
        Finder.dispose((BasicEditorPane)this.editor);
    }

    void validateRegExp() {
        FindOptions findOptions = FindController.getFindOptions();
        if (findOptions.getRegexpSearch()) {
            try {
                FindCriteria criteria = FindOptions.createFindCriteria(this.editor);
                criteria.setText(this.searchField.getText());
                FindUtils.getRegExPattern((FindCriteria)criteria);
                this.searchField.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            catch (PatternSyntaxException patternEx) {
                this.searchField.setForeground(Colors.FIELD_ERROR_TEXT);
            }
        } else {
            this.searchField.setForeground(UIManager.getColor("ComboBox.foreground"));
        }
    }

    void setSearchFieldText(String text) {
        this.searchField.setText(text, true);
    }

    SearchField getSearchField() {
        return this.searchField;
    }

    void setFindCount(int count, int index) {
        if (count < 0) {
            this.searchField.setInfoText("");
        } else {
            this.searchField.setInfoText(index > 0 ? Bundle.format("FD_FIND_COUNT", index, count) : Bundle.format("FD_FIND_COUNT", 0, 0));
        }
    }

    void populateCurrentOptions(CurrentToolbarOptionsImpl currentOptions) {
        currentOptions.setSearchText(this.searchField.getText());
    }

    void selectedRegion(boolean selectedRegion) {
        if (this.selectionCriteria.selectRegionLayer != null) {
            this.selectionCriteria.selectRegionLayer.removeAllHighlights();
        }
        if (selectedRegion) {
            this.selectionCriteria.lowerBound = this.editor.getSelectionStart();
            this.selectionCriteria.upperBound = this.editor.getSelectionEnd();
            this.selectionCriteria.highlight();
        } else {
            this.selectionCriteria.lowerBound = -1;
            this.selectionCriteria.upperBound = -1;
            this.selectionCriteria.newSearch = true;
            FindCriteria criteria = (FindCriteria)this.editor.getProperty("find-criteria");
            if (criteria != null) {
                criteria.setLowerBound(-1);
                criteria.setUpperBound(-1);
            }
        }
    }

    static {
        HighlightRegistry registry = EditorProperties.getProperties().getHighlightRegistry();
        selectRegionStyle = registry.createStyle("find-select-region", Bundle.get("FD_TOOLBAR_SELECTED_TEXT_STYLE"), 75, null, new Color(210, 230, 255));
    }

    private class Listeners
    implements SearchListener,
    FocusListener,
    PropertyChangeListener {
        private int _hasGlobalFocusListener;

        private Listeners() {
        }

        private void installFocusListener() {
            ++this._hasGlobalFocusListener;
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this);
        }

        private void deinstallFocusListener() {
            KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            currentKeyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this);
            --this._hasGlobalFocusListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component focusedComponent;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (focusedComponent = (Component)evt.getNewValue()) != null) {
                boolean isInSearchFields = false;
                if (SwingUtilities.isDescendingFrom(focusedComponent, (Component)FindToolbar.this.searchField)) {
                    isInSearchFields = true;
                }
                if (!isInSearchFields) {
                    this.deinstallFocusListener();
                }
            }
        }

        public void searchPerformed(SearchEvent se) {
            if (FindToolbar.this.searchField.getText().length() == 0) {
                FindToolbar.this.searchField.setInfoText("");
                Finder.clearHighlights((BasicEditorPane)FindToolbar.this.editor);
            }
            try {
                if (se.isTriggeredByKeypress()) {
                    FindToolbar.this.searchLocation = FindToolbar.this.editor.getSelectionStart();
                    String searchText = se.getSearchText();
                    FindToolbar.this.find(searchText);
                } else {
                    SearchEvent.Direction direction = se.getDirection();
                    FindToolbar.this.findNext(direction == SearchEvent.Direction.FORWARD);
                }
            }
            catch (ExpiredTextBufferException e) {
                Exceptions.swallow((Throwable)e);
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            PromptedTextField textField = FindToolbar.this.searchField.getTextField();
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(FindToolbar.this.editor);
            if (e.getSource() == textField) {
                textField.selectAll();
                findToolbarController.updateVisibleActions();
                this.installFocusListener();
            } else if (e.getSource() == FindToolbar.this.editor) {
                FindToolbar.this.selectionCriteria.newSearch = true;
                if (FindToolbar.this.selectionCriteria.selectRegionLayer != null) {
                    FindToolbar.this.selectionCriteria.selectRegionLayer.removeAllHighlights();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == FindToolbar.this.editor) {
                FindToolbarController findToolbarController;
                String findText = FindToolbar.this.searchField.getText();
                if (findText != null && findText.length() > 0) {
                    FindOptions.getInstance((PropertyStorage)Preferences.getPreferences()).updateHistory(true, findText);
                }
                if ((findToolbarController = AbstractFindToolbarController.getFindController(FindToolbar.this.editor)) != null) {
                    findToolbarController.updateVisibleActions();
                }
            }
        }
    }

    private class SelectionHelper {
        private int lowerBound = -1;
        private int upperBound = -1;
        private boolean newSearch = true;
        private HighlightLayer selectRegionLayer;

        private SelectionHelper() {
        }

        private void highlight() {
            if (this.selectRegionLayer != null) {
                this.selectRegionLayer.removeAllHighlights();
            } else {
                this.selectRegionLayer = FindToolbar.this.editor.createHighlightLayer();
            }
            this.selectRegionLayer.addHighlight(selectRegionStyle, FindToolbar.this.selectionCriteria.lowerBound, FindToolbar.this.selectionCriteria.upperBound);
        }
    }

    private static class FindHistoryProvider
    implements SearchHistoryPopup.HistoryProvider {
        private static final FindHistoryProvider INSTANCE = new FindHistoryProvider();

        private FindHistoryProvider() {
        }

        public List<String> getHistory() {
            FindOptions findOptions = FindController.getFindOptions();
            List<String> history = findOptions.getSearchHistory();
            return history;
        }
    }
}

