/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;
import oracle.jdevimpl.deploy.stripe.DirectoryModuleIO;
import oracle.jdevimpl.deploy.stripe.JarModuleIO;

public class PackingListIO
extends AbstractModuleIO {
    protected final String xmlHead1 = "<?xml version = '1.0' encoding = '";
    protected final String xmlHead2 = "' ?>\n<archive xmlns=\"http://xmlns.oracle.com/jdeveloper/1013/jdev-deployment/packinglist\">";
    final ArchiveIO impl_;
    final OutputType outputType_;

    protected String getPackingListEntryName() {
        return "packingList.xml";
    }

    public PackingListIO(OutputType outputType) {
        this.outputType_ = outputType;
        switch (outputType) {
            case JAR_PACKING_LIST: {
                this.impl_ = new JarModuleIO.DeploymentModuleJarIO(this);
                break;
            }
            case DIRECTORY_PACKING_LIST: {
                this.impl_ = new DirectoryModuleIO.DeploymentModuleDirectoryIO(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Should specify a valid OutputType");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitImpl() throws IOException {
        URL persistedOutputLocation;
        block16: {
            URL outputLocation = this.getURL();
            persistedOutputLocation = null;
            String packingListEntryName = this.getPackingListEntryName();
            ArrayList<URL> modifiedFiles = new ArrayList<URL>();
            try {
                URL outputParentDir = URLFileSystem.getParent((URL)outputLocation);
                URLFileSystem.mkdirs((URL)outputParentDir);
                persistedOutputLocation = URLFileSystem.createTempFile((String)(URLFileSystem.getName((URL)outputLocation) + "_contents"), (String)".tmp", (URL)outputParentDir);
                ArchiveIO.recursiveDelete(persistedOutputLocation);
                persistedOutputLocation = URLFactory.newDirURL((URL)persistedOutputLocation, (String)"");
                URLFileSystem.mkdirs((URL)persistedOutputLocation);
                URL packingListURL = URLFileSystem.createTempFile((String)"_packingList", (String)".xml", (URL)persistedOutputLocation);
                modifiedFiles.add(packingListURL);
                String encoding = System.getProperty("deployment.moduleio.packinglist.encoding");
                if (encoding == null) {
                    EnvironOptions eo = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                    encoding = eo.getEncoding();
                }
                OutputStreamWriter p = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)packingListURL), encoding);
                p.write("<?xml version = '1.0' encoding = '" + encoding + "' ?>\n<archive xmlns=\"http://xmlns.oracle.com/jdeveloper/1013/jdev-deployment/packinglist\">\n");
                DefaultArchive packingListArchive = DefaultArchive.create(this.archive_.isIncludeManifest(), false);
                Iterator<ArchiveEntry> iter = this.archive_.getArchiveEntries();
                while (iter.hasNext()) {
                    ArchiveEntry entry;
                    ArchiveEntry packingListEntry = entry = iter.next();
                    if (this.isModified(entry)) {
                        URL fileURL = URLFactory.newURL((URL)persistedOutputLocation, (String)entry.getName());
                        modifiedFiles.add(fileURL);
                        InputStream in = this.archive_.openInputStream(entry);
                        URLFileSystem.copy((InputStream)in, (URL)fileURL);
                        packingListArchive.addContents(new ArchiveEntry(entry.getName(), fileURL));
                        URL packingListEntryURL = null;
                        packingListEntryURL = this.outputType_ == OutputType.JAR_PACKING_LIST ? URLFactory.newJarURL((URL)outputLocation, (String)entry.getName()) : URLFactory.newURL((URL)outputLocation, (String)entry.getName());
                        packingListEntry = new ArchiveEntry(entry.getName(), packingListEntryURL);
                    } else if (entry.getURL() == null) {
                        this.archive_.getPrintWriter().println("Warning: Skipping entry " + entry.getName() + ". No content.");
                        continue;
                    }
                    p.write("  <entry>\n");
                    p.write("    <name>" + packingListEntry.getName() + "</name>\n");
                    p.write("    <url>" + packingListEntry.getURL().toExternalForm() + "</url>\n");
                    p.write("  </entry>\n");
                }
                p.write("</archive>\n");
                p.close();
                this.archive_.addContents(new ArchiveEntry(packingListEntryName, packingListURL));
                packingListArchive.addContents(new ArchiveEntry(packingListEntryName, packingListURL));
                this.impl_.write(packingListArchive, outputLocation, this.archive_.getPrintWriter());
                Assert.println((String)("Packing list archive commited to " + outputLocation));
                if (this.outputType_ != OutputType.JAR_PACKING_LIST) break block16;
            }
            catch (Throwable throwable) {
                if (this.outputType_ == OutputType.JAR_PACKING_LIST) {
                    for (URL url : modifiedFiles) {
                        try {
                            URLFileSystem.deleteEx((URL)url);
                        }
                        catch (Throwable t) {
                            this.archive_.getPrintWriter().println("Could not remove " + url.toString() + ":" + t.getMessage());
                        }
                    }
                }
                if (persistedOutputLocation != null) {
                    ArchiveIO.recursiveDelete(persistedOutputLocation);
                }
                throw throwable;
            }
            for (URL url : modifiedFiles) {
                try {
                    URLFileSystem.deleteEx((URL)url);
                }
                catch (Throwable t) {
                    this.archive_.getPrintWriter().println("Could not remove " + url.toString() + ":" + t.getMessage());
                }
            }
        }
        if (persistedOutputLocation != null) {
            ArchiveIO.recursiveDelete(persistedOutputLocation);
        }
    }

    protected ArchiveEntry copyToOutputLocation(ArchiveEntry entry, URL directory) throws IOException {
        InputStream in = this.getInputStream(entry);
        URL newUrl = URLFactory.newURL((URL)directory, (String)entry.getName());
        URLFileSystem.copy((InputStream)in, (URL)newUrl);
        return new ArchiveEntry(entry.getName(), newUrl);
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean isArchiveReadOnly() {
        return false;
    }

    public static enum OutputType {
        JAR_PACKING_LIST,
        DIRECTORY_PACKING_LIST;

    }

    public static class PackingListIOFactory
    implements DeploymentModuleIOFactory {
        @Override
        public DeploymentModuleIO create(String moduleIO) {
            if ("Persistence.PackingList.FILE".equals(moduleIO)) {
                return new PackingListIO(OutputType.JAR_PACKING_LIST);
            }
            if ("Persistence.PackingList.DIRECTORY".equals(moduleIO)) {
                return new PackingListIO(OutputType.DIRECTORY_PACKING_LIST);
            }
            return null;
        }
    }
}

