/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DependableFactory;
import oracle.jdeveloper.deploy.DeploymentProfiles;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.DependableFactory;
import oracle.jdeveloper.deploy.spi.providers.AbstractDependableFactoryProvider;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class ProfilesDependableFactoryProvider
extends AbstractDependableFactoryProvider {
    @Override
    protected boolean canCreate(Element element, ToolkitContext tkContext, Cookie cookie) {
        if (!(element instanceof DataContainer)) {
            return false;
        }
        DependableFactory.SpiData spi = new DependableFactory.SpiData(tkContext.getIdeContext());
        if (spi.getDepth() != DependableFactory.Parms.Depth.CHILDREN) {
            return false;
        }
        cookie.bind(ToolkitContext.class, tkContext);
        return true;
    }

    @Override
    protected Dependable[] createDependables(Element element, Cookie cookie) {
        ToolkitContext tkContext = cookie.get(ToolkitContext.class);
        DataContainer dc = (DataContainer)element;
        Context dcContext = tkContext.getIdeContext();
        Context spiContext = new Context(dcContext);
        DependableFactory.SpiData spi = new DependableFactory.SpiData(spiContext);
        spi.setDepth(DependableFactory.Parms.Depth.SELF);
        spi.setParent((Element)dc);
        ToolkitRegistry tkReg = tkContext.getMainToolkitRegistry();
        ArrayList deps = new ArrayList();
        DeploymentProfiles profiles = DeploymentProfiles.getInstance(dc, dcContext);
        Iterator<Profile> iter = profiles.iterator();
        while (iter.hasNext()) {
            Profile p = iter.next();
            try {
                DependableFactory[] factories;
                ToolkitBuilder builder = tkReg.getBuilder(p, spiContext, DependableFactory.class);
                for (DependableFactory df : factories = builder.narrowBuildToolkits(new DependableFactory[0])) {
                    Dependable[] ds = df.createDependables();
                    Collections.addAll(deps, ds);
                }
            }
            catch (ToolkitBuildException e) {
                Assert.printStackTrace((String)String.format("Could not build DependableNodeFactory for %s (%s)", p.getName(), p.getClass().getName()));
            }
        }
        return deps.toArray(new Dependable[deps.size()]);
    }

    @Override
    protected Class getTypeForNarrow() {
        return DeploymentProfiles.class;
    }
}

