/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.text.DateFormat;
import java.util.Calendar;
import oracle.jdevimpl.deploy.res.FwkArb;

public class DeployMessages {
    public static String deploymentStarted() {
        return FwkArb.getString(14);
    }

    public static String deploymentFinished() {
        return FwkArb.getString(16);
    }

    public static String deploymentCanceled() {
        return FwkArb.getString(18);
    }

    public static String deploymentIncomplete() {
        return FwkArb.getString(19);
    }

    public static String deploymentElapsed(long milliseconds) {
        long seconds = (milliseconds + 500L) / 1000L;
        if (seconds == 0L) {
            String fastText = FwkArb.getString(39);
            return FwkArb.format(30, fastText);
        }
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        String secondsText = FwkArb.format(seconds == 1L ? 36 : 35, Long.toString(seconds));
        String minutesText = "";
        if ((minutes -= hours * 60L) > 0L) {
            minutesText = FwkArb.format(minutes == 1L ? 34 : 33, Long.toString(minutes));
        }
        String hoursText = "";
        if (hours > 0L) {
            hoursText = FwkArb.format(hours == 1L ? 32 : 31, Long.toString(hours));
        }
        String elapsedText = secondsText;
        if (hoursText.length() > 0) {
            elapsedText = FwkArb.format(38, hoursText, minutesText, secondsText);
        } else if (minutesText.length() > 0) {
            elapsedText = FwkArb.format(37, minutesText, secondsText);
        }
        return FwkArb.format(30, elapsedText);
    }

    public static String currentDateTime() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }
}

