/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.meta.pattern.builder.Narrower;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBException;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBFramework;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;

public abstract class OBStager<R, O, C> {
    final OBFramework<R, O, C> recognizer_;
    private OBContext<R, O, C> context_ = null;
    protected final R recognize_;
    protected final Class type_;
    protected final C userContext_;
    List<OBBuilder<R, O, C>> builders_ = null;

    public OBStager(OBFramework<R, O, C> recognizer, R recognize, C userContext, Class type) {
        this.recognizer_ = recognizer;
        this.recognize_ = recognize;
        this.type_ = type;
        this.userContext_ = userContext;
        Assert.println((recognizer.getRecognizers(this.type_).size() == 0 ? 1 : 0) != 0, (String)("No recognizers for registered type " + this.type_.getName()));
    }

    protected abstract OBContext<R, O, C> newOBContext(OBFramework<R, O, C> var1, C var2, List<OBRecognizer<R, O, C>> var3, int var4, OBContext<R, O, C> var5);

    protected synchronized OBContext<R, O, C> context() {
        if (this.context_ == null) {
            List<OBRecognizer<R, O, C>> recognizers = this.recognizer_.getRecognizers(this.type_);
            this.context_ = this.newOBContext(this.recognizer_, this.userContext_, recognizers, recognizers.size(), null);
        }
        return this.context_;
    }

    public Class[] types() {
        List<OBBuilder<R, O, C>> builders = this.builders();
        Class[] objectClasses = new Class[builders.size()];
        for (int i = 0; i < objectClasses.length; ++i) {
            objectClasses[i] = builders.get(i).getObjectClass();
        }
        return objectClasses;
    }

    public Class[] typesForNarrow() {
        List<OBBuilder<R, O, C>> builders = this.builders();
        Class[] narrowClasses = new Class[builders.size()];
        for (int i = 0; i < narrowClasses.length; ++i) {
            narrowClasses[i] = builders.get(i).getTypeForNarrow();
        }
        return narrowClasses;
    }

    public <X> X build(Class<X> objectClass) {
        List<OBBuilder<R, O, C>> builders = this.builders();
        for (OBBuilder<R, O, C> b : builders) {
            if (b.getObjectClass() != objectClass) continue;
            O object = b.getObject();
            return (X)object;
        }
        throw new OBException("Object class " + objectClass.getName() + " is unrecognized in this context.");
    }

    public List<O> buildAll() {
        List<OBBuilder<R, O, C>> builders = this.builders();
        ArrayList<O> retList = new ArrayList<O>(builders.size());
        for (int i = 0; i < builders.size(); ++i) {
            assert (builders.get(i).getObject() != null);
            retList.add(builders.get(i).getObject());
        }
        return retList;
    }

    protected List<OBBuilder<R, O, C>> builders() {
        if (this.builders_ == null) {
            this.builders_ = this.context().getSpiRecognizer().createOBBuilder(this.recognize_, this.type_);
        }
        return this.builders_;
    }

    protected Class[] narrow() {
        Narrower<Class> n = new Narrower<Class>(){

            @Override
            public boolean isBassignableToA(Class a, Class b) {
                return a.isAssignableFrom(b);
            }

            public Class[] newArray(int size) {
                return new Class[size];
            }
        };
        return n.narrow(this.typesForNarrow());
    }

    protected List<OBBuilder<R, O, C>> narrowBuilders() {
        List<OBBuilder<R, O, C>> builders = this.builders();
        Narrower n = new Narrower<OBBuilder<R, O, C>>(){

            @Override
            public boolean isBassignableToA(OBBuilder<R, O, C> a, OBBuilder<R, O, C> b) {
                return a.getTypeForNarrow().isAssignableFrom(b.getTypeForNarrow());
            }

            public OBBuilder<R, O, C>[] newArray(int size) {
                return new OBBuilder[0];
            }
        };
        return n.narrow(builders);
    }

    protected List<O> narrowBuild() {
        List<OBBuilder<R, O, C>> narrowBuilders = this.narrowBuilders();
        ArrayList<O> built = new ArrayList<O>(narrowBuilders.size());
        for (int i = 0; i < narrowBuilders.size(); ++i) {
            built.add(narrowBuilders.get(i).getObject());
        }
        return built;
    }
}

