/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBFramework;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;

public abstract class OBSpiRecognizer<R, O, C> {
    private static boolean DEBUG = Boolean.getBoolean("ob.spirecognizer.debug");
    private static ThreadLocal<Integer> indent = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    final OBContext<R, O, C> context_;

    static String indentBegin() {
        assert (DEBUG);
        assert (indent != null);
        String s = OBSpiRecognizer.indent(indent.get());
        indent.set(indent.get() + 1);
        return s;
    }

    static String indent(int ind) {
        char[] chars = new char[ind];
        for (int i = 0; i < ind; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }

    static String indentEnd() {
        assert (DEBUG);
        assert (indent != null);
        indent.set(indent.get() - 1);
        return OBSpiRecognizer.indent(indent.get());
    }

    public OBSpiRecognizer(OBContext<R, O, C> context) {
        this.context_ = context;
    }

    protected List<OBBuilder<R, O, C>> createOBBuilder(R recognize, Class type) {
        return this.createOBBuilder(recognize, this.context_.getContext(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OBBuilder<R, O, C>> createOBBuilder(R recognize, C context, Class type) {
        ArrayList<OBBuilder<R, O, C>> buildersList = new ArrayList<OBBuilder<R, O, C>>();
        for (int i = this.context_.recognizersSize() - 1; i >= 0; --i) {
            OBRecognizer<R, O, C> r = this.context_.recognizers().get(i);
            OBContext<R, O, C> childCtx = this.context_.newOBContext(context, i);
            PerformanceLogger pl = PerformanceLogger.get();
            OBBuilder<R, O, C> builder = null;
            String id = "OBSpiRecognizer.recognize." + (int)(Math.random() * 1000.0);
            pl.startTiming(id);
            if (DEBUG) {
                Assert.println((String)(OBSpiRecognizer.indentBegin() + "Calling recognizer " + r.toString() + ", type=" + type));
            }
            try {
                builder = r.recognize(recognize, childCtx, type);
            }
            catch (Throwable throwable) {
                pl.stopTiming(id, "Recognizer=" + r, OBFramework.TIMING_THRESHOLD);
                if (DEBUG) {
                    Assert.println((String)(builder != null ? OBSpiRecognizer.indentEnd() + "Created builder " + builder.toString() + ", recognizer=" + r.toString() + ", type=" + type : OBSpiRecognizer.indentEnd() + "Builder not created, recognizer=" + r.toString() + ", type=" + type));
                }
                throw throwable;
            }
            pl.stopTiming(id, "Recognizer=" + r, OBFramework.TIMING_THRESHOLD);
            if (DEBUG) {
                Assert.println((String)(builder != null ? OBSpiRecognizer.indentEnd() + "Created builder " + builder.toString() + ", recognizer=" + r.toString() + ", type=" + type : OBSpiRecognizer.indentEnd() + "Builder not created, recognizer=" + r.toString() + ", type=" + type));
            }
            if (builder != null) {
                assert (this.checkType(builder, type));
                buildersList.add(builder);
            }
            if (childCtx.isConsumed()) break;
        }
        return buildersList;
    }

    private boolean checkType(OBBuilder<R, O, C> b, Class type) {
        if (!type.isAssignableFrom(b.getObjectClass())) {
            throw new AssertionError((Object)(b.getClass().getName() + " + did not return object of type " + type.getName()));
        }
        return true;
    }
}

