/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.InvalidProfileException;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileOperationException;
import oracle.jdeveloper.deploy.ProfileStorage;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.spi.DataElement;
import oracle.jdeveloper.deploy.spi.ProfileReader;
import oracle.jdeveloper.deploy.spi.ProfileWriter;

public class DeploymentProfiles
implements ToolkitFactory {
    private volatile ProfileReader[] readers_;
    private volatile ProfileWriter[] writers_;
    final Element element_;
    final Context context_;

    private DeploymentProfiles(Element element, Context context) {
        this.element_ = element;
        this.context_ = context;
    }

    public static DeploymentProfiles getInstance(DataContainer container) {
        return DeploymentProfiles.getInstance(container, Context.newIdeContext((Node)container));
    }

    public static DeploymentProfiles getInstance(DataContainer container, Context context) {
        return new DeploymentProfiles((Element)container, context);
    }

    public static DeploymentProfiles getInstance(ProfileStorage storage) {
        return DeploymentProfiles.getInstance(storage, Context.newIdeContext());
    }

    public static DeploymentProfiles getInstance(ProfileStorage storage, Context context) {
        return new DeploymentProfiles(DeploymentProfiles.makeElement(storage), context);
    }

    private synchronized ProfileReader[] getReaders() {
        if (this.readers_ == null) {
            this.readers_ = ToolkitFactory.Utils.build(this.element_, this.context_, ProfileReader.class, new ProfileReader[0]);
        }
        return this.readers_;
    }

    private synchronized ProfileWriter[] getWriters() {
        if (this.writers_ == null) {
            this.writers_ = ToolkitFactory.Utils.build(this.element_, this.context_, ProfileWriter.class, new ProfileWriter[0]);
        }
        return this.writers_;
    }

    private synchronized void invalidateReaders() {
        this.readers_ = null;
    }

    public void addProfile(Profile profile) throws InvalidProfileException, ProfileOperationException {
        for (ProfileWriter w : this.getWriters()) {
            if (!w.write(profile)) continue;
            this.invalidateReaders();
            return;
        }
        throw new InvalidProfileException("No profile writer found");
    }

    public Profile getProfileByName(String name) {
        ProfileReader r;
        Profile p = null;
        ProfileReader[] profileReaderArray = this.getReaders();
        int n = profileReaderArray.length;
        for (int i = 0; i < n && (p = (r = profileReaderArray[i]).getProfileByName(name)) == null; ++i) {
        }
        if (p == null) {
            p = this.getBc4jProfile(name);
        }
        return p;
    }

    @Deprecated
    Profile getBc4jProfile(String name) {
        for (Profile p : this.getProfiles()) {
            if (p == null) continue;
            Iterator iter = p.getChildren();
            while (iter != null && iter.hasNext()) {
                Profile child;
                String profileName;
                Element e = (Element)iter.next();
                if (!(e instanceof Profile) || !name.equals(profileName = (child = (Profile)e).getName())) continue;
                return child;
            }
        }
        return null;
    }

    public void removeProfile(String name) {
        for (ProfileWriter w : this.getWriters()) {
            if (!w.removeByName(name)) continue;
            this.invalidateReaders();
            return;
        }
    }

    public Set<String> getProfileNames() {
        HashSet<String> names = new HashSet<String>();
        for (ProfileReader r : this.getReaders()) {
            names.addAll(r.getProfileNames());
        }
        return names;
    }

    public Profile[] getProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (ProfileReader r : this.getReaders()) {
            profiles.addAll(r.getAllProfiles());
        }
        return profiles.toArray(new Profile[0]);
    }

    public void setProfiles(Profile[] profiles) {
        for (ProfileWriter w : this.getWriters()) {
            w.removeAll();
        }
        block1: for (Profile p : profiles) {
            for (ProfileWriter w : this.getWriters()) {
                if (!w.write(p)) continue;
                this.invalidateReaders();
                continue block1;
            }
        }
    }

    public Iterator<Profile> iterator() {
        ProfileReader[] readers = this.getReaders();
        return new ProfileIterator(readers);
    }

    private static Element makeElement(ProfileStorage storage) {
        if (storage instanceof Element) {
            return (Element)storage;
        }
        return new DPProfileStorage(storage);
    }

    private static class ProfileIterator
    implements Iterator {
        final ProfileReader[] readers_;
        int index_ = 0;
        Profile profile_ = null;
        boolean read_ = false;
        boolean resetIter_ = true;
        Iterator<Profile> iter_ = null;

        ProfileIterator(ProfileReader[] readers) {
            this.readers_ = readers;
        }

        @Override
        public boolean hasNext() {
            if (!this.read_) {
                this.read_ = this.read();
            }
            return this.read_;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Iteration error");
            }
            Profile t = this.profile_;
            this.profile_ = null;
            this.read_ = false;
            return t;
        }

        @Override
        public void remove() {
        }

        boolean read() {
            while (this.index_ < this.readers_.length) {
                if (this.resetIter_) {
                    this.iter_ = this.readers_[this.index_].iterator();
                    this.resetIter_ = false;
                }
                if (this.iter_.hasNext()) {
                    this.profile_ = this.iter_.next();
                    return true;
                }
                ++this.index_;
                this.resetIter_ = true;
            }
            return false;
        }
    }

    private static class DPProfileStorage
    extends DataElement
    implements ProfileStorage {
        DPProfileStorage(ProfileStorage ps) {
            super(ps, ProfileStorage.class);
        }

        @Override
        public DataContainer getDataContainer() {
            return ((ProfileStorage)this.getData()).getDataContainer();
        }

        public HashStructure getProperties() {
            return ((ProfileStorage)this.getData()).getProperties();
        }
    }
}

