/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.jar.Manifest;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.ArchiveEntry;

public interface Archive
extends Copyable {
    public static final int BUFFER_SIZE = 8192;
    public static final Comparator ARCHIVE_ENTRY_NAME_COMPARATOR = new Comparator(){

        public int compare(Object lhs, Object rhs) {
            String s1 = ((ArchiveEntry)lhs).getName();
            String s2 = ((ArchiveEntry)rhs).getName();
            return s1.compareTo(s2);
        }
    };

    public Manifest getManifest();

    public String getManifestAsString() throws IOException;

    public void setCreatedBy(String var1);

    public String getMainAttribute(String var1);

    public void setMainAttribute(String var1, String var2);

    public void setMainClass(String var1);

    public void setCompressed(boolean var1);

    public void setCompressionLevel(int var1);

    public boolean isIncludeManifest();

    public void setIncludeManifest(boolean var1);

    public void setReportNameCollisions(boolean var1);

    public void mergeManifest(Manifest var1);

    public void mergeManifest(URL var1) throws IOException;

    public void addContents(Collection var1, String var2);

    public void addContents(Collection var1);

    public void addContents(ArchiveEntry var1);

    public boolean containsEntry(String var1);

    public ArchiveEntry removeEntry(String var1);

    public void addContents(ArchiveEntry[] var1);

    public void addDirectoryTrees(URL[] var1, String var2);

    public Iterator<ArchiveEntry> getArchiveEntries();

    public SortedSet getMissingEntryNames();

    public ArchiveEntry getEntryByName(String var1);

    public ArchiveEntry renameEntry(String var1, String var2);

    public boolean hasContents();

    public boolean isCompressed();

    public int getCompressionLevel();
}

