/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.utils;

import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.utils.PgqlConstants;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTrans;
import oracle.pg.rdbms.pgql.PgqlSqlDropTrans;
import oracle.pg.rdbms.pgql.PgqlSqlModifyTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.Pgql;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.ir.StatementType;

public class PgqlQueryExecuter
implements PgqlConstants {
    private Connection connection;
    private PgqlConnection pgqlConnection;
    private PgqlStatement pgqlStatement;
    private String pgqlQuery;
    private Pgql pgqlParser;

    public PgqlQueryExecuter() {
        this.connection = null;
        this.pgqlQuery = "";
        try {
            this.pgqlParser = new Pgql();
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
    }

    public PgqlQueryExecuter(Connection connection) {
        this.connection = connection;
        this.pgqlConnection = PgqlConnection.getConnection((Connection)connection);
        this.pgqlStatement = this.pgqlConnection.createStatement();
        try {
            this.pgqlParser = new Pgql();
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
    }

    public void createStatement() {
        if (this.pgqlStatement != null) {
            this.closeStatement();
        }
        this.pgqlStatement = this.pgqlConnection.createStatement();
    }

    public void setQuery(String string) {
        this.pgqlQuery = string;
    }

    public StatementType getQueryType() {
        StatementType statementType = null;
        try {
            PgqlResult pgqlResult = this.pgqlParser.parse(this.pgqlQuery);
            if (!pgqlResult.isQueryValid() && pgqlResult.getPgqlStatement() == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlResult.getErrorMessages(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
                return null;
            }
            statementType = pgqlResult.getPgqlStatement().getStatementType();
        }
        catch (PgqlToSqlException | PgqlException throwable) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
        return statementType;
    }

    public Object[] translatePgqlToSql() {
        Object[] objectArray = null;
        PgqlSqlTrans pgqlSqlTrans = null;
        try {
            pgqlSqlTrans = this.pgqlStatement.translateStatement(this.pgqlQuery, 0, 2, -1, "", "AUTO_COMMIT=F");
            switch (pgqlSqlTrans.getTranslationType()) {
                case QUERY: {
                    PgqlSqlQueryTrans pgqlSqlQueryTrans = (PgqlSqlQueryTrans)pgqlSqlTrans;
                    objectArray = new String[]{pgqlSqlQueryTrans.getSqlTranslation()};
                    break;
                }
                case MODIFY: {
                    PgqlSqlModifyTrans pgqlSqlModifyTrans = (PgqlSqlModifyTrans)pgqlSqlTrans;
                    objectArray = pgqlSqlModifyTrans.getMatchTranslation();
                    if (objectArray != null) break;
                    List list = pgqlSqlModifyTrans.getSqlModifyTranslations();
                    Object[] objectArray2 = (Object[])list.get(0);
                    objectArray = (String[])objectArray2[0];
                    break;
                }
                case CREATE: {
                    PgqlSqlCreateTrans pgqlSqlCreateTrans = (PgqlSqlCreateTrans)pgqlSqlTrans;
                    objectArray = pgqlSqlCreateTrans.getCreateTranslation();
                    break;
                }
                case DROP: {
                    PgqlSqlDropTrans pgqlSqlDropTrans = (PgqlSqlDropTrans)pgqlSqlTrans;
                    objectArray = new String[]{pgqlSqlDropTrans.getDropTranslation()};
                }
            }
        }
        catch (PgqlToSqlException | PgqlException throwable) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.toString(), (String)PgqlResources.getString("TRANSLATION_ERROR"), null);
        }
        return objectArray;
    }

    public PgqlResultSet executeSelectQuery() throws PgqlToSqlException, PgqlException {
        PgqlResultSet pgqlResultSet = null;
        pgqlResultSet = this.pgqlStatement.executeQuery(this.pgqlQuery);
        return pgqlResultSet;
    }

    public boolean executeNonSelectQuery() throws PgqlToSqlException, PgqlException {
        boolean bl = this.pgqlStatement.execute(this.pgqlQuery);
        return bl;
    }

    public long getModifyCount() {
        return this.pgqlStatement.getModifyCount();
    }

    public void cancelQuery() {
        try {
            this.pgqlStatement.cancel();
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
    }

    public void closeStatement() {
        if (this.pgqlStatement != null) {
            try {
                this.pgqlStatement.close();
            }
            catch (PgqlException pgqlException) {
                ExceptionHandler.handleException((Throwable)pgqlException);
            }
        }
    }
}

