/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.tasks;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.tasks.PgqlRaptorTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.javatools.icons.OracleIcons;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.StatementType;

public class RunScriptTask<V>
extends PgqlRaptorTask<V> {
    private static final int MAX_ROWS_ON_SELECT = 5000;

    public RunScriptTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, bl, iRaptorTaskRunMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected V doWork() throws TaskException {
        this.pgqlResultsPanelContext.getExecuter().createStatement();
        IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = this.getRaptorTaskProgressUpdater();
        for (String string : this.queries) {
            Object object;
            this.pgqlResultsPanelContext.getExecuter().setQuery(string);
            StatementType statementType = this.pgqlResultsPanelContext.getExecuter().getQueryType();
            PgqlResultSet pgqlResultSet = null;
            try {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(PgqlResources.get("EXECUTING") + string);
                }
                long l = -1L;
                boolean bl = false;
                object = null;
                switch (statementType) {
                    case SELECT: {
                        pgqlResultSet = this.pgqlResultsPanelContext.getExecuter().executeSelectQuery();
                        if (pgqlResultSet == null) break;
                        object = this.showQueryResultOnPanel(pgqlResultSet, statementType);
                        break;
                    }
                    case GRAPH_MODIFY: 
                    case CREATE_PROPERTY_GRAPH: 
                    case DROP_PROPERTY_GRAPH: {
                        bl = this.pgqlResultsPanelContext.getExecuter().executeNonSelectQuery();
                        l = this.pgqlResultsPanelContext.getExecuter().getModifyCount();
                        object = this.showQueryResultOnPanel(l, statementType);
                        break;
                    }
                    case CALL: {
                        bl = this.pgqlResultsPanelContext.getExecuter().executeNonSelectQuery();
                        object = this.showQueryResultOnPanel(l, statementType);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(PgqlResources.getString("QUERYTYPE_NOT_AVAILABLE"));
                    }
                }
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
                arrayList.add(this.closeListener);
                if (this.pgqlResultsPanelContext.getTabCount() == 0 && !this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                    this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                    if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                        this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                    }
                }
                String string2 = PgqlResources.getString("PGQLEditor.ScriptOutput");
                if (!this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                    this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), string2, (Component)object, arrayList);
                    this.pgqlResultsPanelContext.setIsScriptResultTabOpen(true);
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                } else {
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getPanelIndex((Component)object));
                }
                this.pgqlResultsPanelContext.setWasLastQueryStatement(false);
                this.closeResultSet(pgqlResultSet);
            }
            catch (ExecutionException executionException) {
                this.pgqlResultsPanelContext.getExecuter().cancelQuery();
                break;
            }
            catch (IllegalArgumentException | PgqlToSqlException | PgqlException throwable) {
                Component component = this.showErrorOnPanel(throwable.toString());
                ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
                arrayList.add(this.closeListener);
                if (this.pgqlResultsPanelContext.getTabCount() == 0 && !this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                    this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                    if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                        this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                    }
                }
                object = PgqlResources.getString("PGQLEditor.ScriptOutput");
                if (!this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                    this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), (String)object, component, arrayList);
                    this.pgqlResultsPanelContext.setIsScriptResultTabOpen(true);
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                } else {
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getPanelIndex(component));
                }
                this.pgqlResultsPanelContext.setWasLastQueryStatement(false);
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                this.closeResultSet(pgqlResultSet);
                this.pgqlResultsPanelContext.getExecuter().closeStatement();
                continue;
            }
            finally {
                this.closeResultSet(pgqlResultSet);
                this.pgqlResultsPanelContext.getExecuter().closeStatement();
            }
            this.pgqlResultsPanelContext.getExecuter().closeStatement();
        }
        this.pgqlResultsPanelContext.setLastNumberOfQueriesExecuted(this.queries.length);
        return null;
    }

    public Component showQueryResultOnPanel(PgqlResultSet pgqlResultSet, StatementType statementType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = System.out;
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        System.setOut(printStream2);
        pgqlResultSet.print(printStream2, 5000L, 0);
        String string = byteArrayOutputStream.toString();
        this.pgqlResultsPanelContext.getEditor().setEditable(true);
        String string2 = this.pgqlResultsPanelContext.getEditor().getText();
        String string3 = string2 + "\n\n";
        this.pgqlResultsPanelContext.getEditor().setText(string3 + string);
        this.pgqlResultsPanelContext.getEditor().setEditable(false);
        this.pgqlResultsPanelContext.getEditor().setCaretPosition(0);
        System.setOut(printStream);
        return this.pgqlResultsPanelContext.getScriptRunnerPane();
    }
}

