/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.tasks;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.utils.PgqlResultsPanelContext;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.javatools.icons.OracleIcons;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.StatementType;

public abstract class PgqlRaptorTask<V>
extends RaptorTask<V> {
    protected final Icon _problemIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"run.png"), OracleIcons.getIcon((String)"exception.png"));
    protected String[] queries = null;
    protected PgqlResultsPanelContext pgqlResultsPanelContext = null;
    protected final ITabCloseListner closeListener = new ITabCloseListner(){

        public void tabClosed() {
            if (PgqlRaptorTask.this.pgqlResultsPanelContext.getResultsPane() != null && PgqlRaptorTask.this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() <= 0 && PgqlRaptorTask.this.pgqlResultsPanelContext.getSplitPane() != null) {
                PgqlRaptorTask.this.pgqlResultsPanelContext.getSplitPane().remove((Component)PgqlRaptorTask.this.pgqlResultsPanelContext.getResultsPane());
                PgqlRaptorTask.this.pgqlResultsPanelContext.setTabCount(0);
            }
            if (PgqlRaptorTask.this.pgqlResultsPanelContext.getResultsPane().getPanelIndex((Component)((Object)PgqlRaptorTask.this.pgqlResultsPanelContext.getScriptRunnerPane())) == -1) {
                PgqlRaptorTask.this.pgqlResultsPanelContext.setIsScriptResultTabOpen(false);
            }
        }
    };

    public PgqlRaptorTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, bl, iRaptorTaskRunMode);
    }

    public String[] getQueries() {
        return this.queries;
    }

    public PgqlRaptorTask<V> setQueries(String[] stringArray) {
        this.queries = stringArray;
        return this;
    }

    public PgqlResultsPanelContext getPgqlResultsPanelContext() {
        return this.pgqlResultsPanelContext;
    }

    public PgqlRaptorTask<V> setPgqlResultsPanelContext(PgqlResultsPanelContext pgqlResultsPanelContext) {
        this.pgqlResultsPanelContext = pgqlResultsPanelContext;
        return this;
    }

    protected Component showQueryResultOnPanel(long l, StatementType statementType) {
        this.pgqlResultsPanelContext.getEditor().setEditable(true);
        String string = this.pgqlResultsPanelContext.getEditor().getText();
        String string2 = string + "\n\n";
        if (statementType == StatementType.GRAPH_MODIFY) {
            String string3 = PgqlResources.format(l == 1L ? "PGQLEditor.OneRowModified" : "PGQLEditor.MultipleRowsModified", l);
            this.pgqlResultsPanelContext.getEditor().setText(string2 + string3 + "\n");
        } else if (statementType == StatementType.CREATE_PROPERTY_GRAPH) {
            this.pgqlResultsPanelContext.getEditor().setText(string2 + PgqlResources.getString("PGQLEditor.GraphCreated") + "\n");
        } else if (statementType == StatementType.DROP_PROPERTY_GRAPH) {
            this.pgqlResultsPanelContext.getEditor().setText(string2 + PgqlResources.getString("PGQLEditor.GraphDropped") + "\n");
        } else if (statementType == StatementType.CALL) {
            this.pgqlResultsPanelContext.getEditor().setText(string2 + PgqlResources.getString("PGQLEditor.FunctionExecutedSuccessfully") + "\n");
        }
        this.pgqlResultsPanelContext.getEditor().setEditable(false);
        this.pgqlResultsPanelContext.getEditor().setCaretPosition(0);
        return this.pgqlResultsPanelContext.getScriptRunnerPane();
    }

    protected Component showErrorOnPanel(String string) {
        this.pgqlResultsPanelContext.getEditor().setEditable(true);
        String string2 = this.pgqlResultsPanelContext.getEditor().getText();
        String string3 = string2 + "\n\n";
        this.pgqlResultsPanelContext.getEditor().setText(string3 + string);
        this.pgqlResultsPanelContext.getEditor().setEditable(false);
        this.pgqlResultsPanelContext.getEditor().setCaretPosition(0);
        return this.pgqlResultsPanelContext.getScriptRunnerPane();
    }

    protected void focusTab(int n) {
        this.pgqlResultsPanelContext.getResultsPane().setSelectedIndex(n);
    }

    protected void closeResultSet(PgqlResultSet pgqlResultSet) {
        if (pgqlResultSet != null) {
            try {
                pgqlResultSet.close();
            }
            catch (PgqlException pgqlException) {
                ExceptionHandler.handleException((Throwable)pgqlException);
            }
        }
    }
}

