/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bm.util.ui.table.CellUtils;
import oracle.bm.util.ui.table.FlatTableHeaderRenderer;

public class SingleSelectionTable
extends JTable {
    private MouseTracker m_mouseTracker = new MouseTracker();
    private FocusAdapter m_focusForwarder = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            SingleSelectionTable.this.focusEditor();
        }
    };
    private DelayedEditorChange m_delayedEditorChange = new DelayedEditorChange();
    private InvisiblePanel m_hiddenComponent = new InvisiblePanel();

    public SingleSelectionTable() {
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(cm.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        abstract class MoveAction
        extends AbstractAction {
            private final Action m_action;

            public MoveAction(Action action) {
                this.m_action = action;
            }

            @Override
            public void actionPerformed(final ActionEvent e) {
                abstract class ColumnAction
                extends FocusAdapter {
                    ColumnAction() {
                    }

                    @Override
                    public void focusGained(FocusEvent event) {
                        SingleSelectionTable.this.removeFocusListener(this);
                        SingleSelectionTable.this.addFocusListener(SingleSelectionTable.this.m_focusForwarder);
                        this.doAction();
                    }

                    public final void doAction() {
                        boolean wasEditing = SingleSelectionTable.this.isEditing();
                        if (wasEditing) {
                            SingleSelectionTable.this.getCellEditor().stopCellEditing();
                        }
                        boolean checkFocus = this.doSubAction();
                        if (wasEditing) {
                            SingleSelectionTable.this.focusedEditCellAt(SingleSelectionTable.this.getSelectionModel().getAnchorSelectionIndex(), SingleSelectionTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex(), null, checkFocus);
                        }
                    }

                    protected abstract boolean doSubAction();
                }
                ColumnAction columnAction;
                Component c = SwingUtilities.findFocusOwner(SingleSelectionTable.this.getEditorComponent());
                if (c != null && !(c instanceof NavigationPanel)) {
                    this.transferFocus(c);
                    return;
                }
                int column = SingleSelectionTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                class EndColumnAction
                extends ColumnAction {
                    EndColumnAction() {
                    }

                    @Override
                    protected boolean doSubAction() {
                        this.transferFocus(SingleSelectionTable.this);
                        return false;
                    }
                }
                class MidColumnAction
                extends ColumnAction {
                    MidColumnAction() {
                    }

                    @Override
                    protected boolean doSubAction() {
                        m_action.actionPerformed(e);
                        return true;
                    }
                }
                ColumnAction columnAction2 = columnAction = this.atEnd(column) ? new EndColumnAction() : new MidColumnAction();
                if (SingleSelectionTable.this.hasFocus()) {
                    columnAction.doAction();
                } else {
                    SingleSelectionTable.this.removeFocusListener(SingleSelectionTable.this.m_focusForwarder);
                    SingleSelectionTable.this.addFocusListener(columnAction);
                    SingleSelectionTable.this.requestFocus();
                }
            }

            protected abstract void transferFocus(Component var1);

            protected abstract boolean atEnd(int var1);
        }
        map.put("selectNextColumnCell", new MoveAction(map.get("selectNextColumnCell")){
            {
                super(action);
            }

            @Override
            protected void transferFocus(Component c) {
                FocusManager.getCurrentManager().focusNextComponent(c);
            }

            @Override
            protected boolean atEnd(int column) {
                return column == SingleSelectionTable.this.getColumnCount() - 1;
            }
        });
        map.put("selectPreviousColumnCell", new MoveAction(map.get("selectPreviousColumnCell")){
            {
                super(action);
            }

            @Override
            protected void transferFocus(Component c) {
                FocusManager.getCurrentManager().focusPreviousComponent(c);
            }

            @Override
            protected boolean atEnd(int column) {
                return column == 0;
            }
        });
        class IgnoreMoveAction
        extends AbstractAction {
            boolean m_up;
            Action m_action;

            public IgnoreMoveAction(boolean up, Action action) {
                this.m_up = up;
                this.m_action = action;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                int rowCount = SingleSelectionTable.this.getRowCount();
                if (rowCount > 0) {
                    if (this.m_up ? SingleSelectionTable.this.isRowSelected(0) : SingleSelectionTable.this.isRowSelected(rowCount - 1)) {
                        return;
                    }
                    this.m_action.actionPerformed(event);
                }
            }
        }
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return !SingleSelectionTable.this.hasFocus();
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                if (SingleSelectionTable.this.isEditing()) {
                    SingleSelectionTable.this.getCellEditor().cancelCellEditing();
                }
            }
        });
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    public SingleSelectionTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(cm.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        map.put("selectNextColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new /* invalid duplicate definition of identical inner class */);
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    public SingleSelectionTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(cm.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        map.put("selectNextColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new /* invalid duplicate definition of identical inner class */);
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    public SingleSelectionTable(TableModel dm) {
        super(dm);
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(cm.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        map.put("selectNextColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new /* invalid duplicate definition of identical inner class */);
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    public SingleSelectionTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm2 = this.getColumnModel();
        cm2.getColumn(cm2.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        map.put("selectNextColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new /* invalid duplicate definition of identical inner class */);
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    public SingleSelectionTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.addFocusListener(this.m_focusForwarder);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new FlatTableHeaderRenderer());
        TableColumnModel cm2 = this.getColumnModel();
        cm2.getColumn(cm2.getColumnCount() - 1).setResizable(false);
        ActionMap map = this.getActionMap();
        map.put("selectNextColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousColumnCell", new /* invalid duplicate definition of identical inner class */);
        map.put("selectPreviousRow", new IgnoreMoveAction(true, map.get("selectPreviousRow")));
        map.put("selectPreviousRowExtendSelection", new IgnoreMoveAction(true, map.get("selectPreviousRowExtendSelection")));
        map.put("selectNextRow", new IgnoreMoveAction(false, map.get("selectNextRow")));
        map.put("selectNextRowExtendSelection", new IgnoreMoveAction(false, map.get("selectNextRowExtendSelection")));
        Object nullAction = new Object();
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), nullAction);
        im.put(KeyStroke.getKeyStroke(10, 1), nullAction);
        map.put("cancel", new /* invalid duplicate definition of identical inner class */);
        if (this.getRowCount() > 0) {
            this.changeSelection(0, 0, true, false);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        Component editorComponent;
        TableColumn resizingColumn;
        TableColumn tableColumn = resizingColumn = this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        if (this.isEditing() && (editorComponent = this.getEditorComponent()) != null) {
            this.editorComp.setBounds(this.getCellRect(this.editingRow, this.editingColumn, false));
        }
        this.resizeAndRepaint();
    }

    @Override
    public boolean isFocusTraversable() {
        return this.getRowCount() > 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getType() == 2) {
            int end;
            int start;
            int selectedRow = this.getSelectedRow();
            int focusedColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            int oldIndex = e.getFirstRow();
            int newIndex = e.getLastRow();
            if (selectedRow > oldIndex && selectedRow <= newIndex) {
                --selectedRow;
            } else if (selectedRow >= newIndex && selectedRow < oldIndex) {
                ++selectedRow;
            } else if (selectedRow == oldIndex) {
                selectedRow = newIndex;
            } else {
                return;
            }
            if (this.isEditing()) {
                this.editingRow = selectedRow;
                Component editorComponent = this.getEditorComponent();
                if (editorComponent != null) {
                    this.editorComp.setBounds(this.getCellRect(this.editingRow, this.editingColumn, false));
                }
            }
            this.changeSelection(selectedRow, focusedColumn, true, false);
            if (oldIndex < newIndex) {
                start = oldIndex;
                end = newIndex;
            } else {
                start = newIndex;
                end = oldIndex;
            }
            this.repaint(0, start * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), (end - start + 1) * this.getRowHeight());
        } else {
            super.tableChanged(e);
            if (this.getRowCount() == 0) {
                this.getSelectionModel().clearSelection();
            }
            if (this.getSelectedRow() == -1 && this.getRowCount() > 0) {
                this.changeSelection(0, 0, true, false);
            }
        }
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        this.changeSelection(row, column, true, true);
        this.m_hiddenComponent.setEditorComponent(super.prepareEditor(editor, row, column));
        return this.m_hiddenComponent;
    }

    @Override
    public void removeEditor() {
        boolean editorFocused;
        boolean bl = editorFocused = SwingUtilities.findFocusOwner(this.m_hiddenComponent) != null;
        if (editorFocused) {
            this.m_delayedEditorChange.delayedRemoveEditor();
        } else {
            this.removeEditorImpl();
        }
    }

    private final void removeEditorImpl() {
        this.m_hiddenComponent.removeEditorComponent();
        super.removeEditor();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, false, false);
        if (toggle) {
            super.changeSelection(rowIndex, columnIndex, true, true);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (e instanceof MouseEvent && ((MouseEvent)e).getID() == 501) {
            this.m_mouseTracker.setPressEvent((MouseEvent)e);
            this.addMouseListener(this.m_mouseTracker);
            this.addMouseMotionListener(this.m_mouseTracker);
            this.focusedEditCellAt(row, column, e, false);
            return false;
        }
        return this.focusedEditCellAt(row, column, e, true);
    }

    private boolean focusedEditCellAt(int row, int column, EventObject e, boolean checkFocus) {
        boolean success = true;
        if (row != this.editingRow || column != this.editingColumn || this.editorComp == null) {
            boolean editorFocused;
            boolean bl = editorFocused = SwingUtilities.findFocusOwner(this.m_hiddenComponent) != null;
            if (editorFocused) {
                this.m_delayedEditorChange.delayedEditCellAt(row, column, e, checkFocus);
                success = false;
            } else {
                success = this.focusedEditCellAtImpl(row, column, e);
            }
        }
        if (checkFocus && this.hasFocus()) {
            this.focusEditor();
        }
        return success;
    }

    private final boolean focusedEditCellAtImpl(int row, int column, EventObject e) {
        boolean success = super.editCellAt(row, column, e);
        try {
            Field erField = JTable.class.getDeclaredField("editorRemover");
            erField.setAccessible(true);
            PropertyChangeListener editorRemover = (PropertyChangeListener)erField.get(this);
            if (editorRemover != null) {
                Class<?> kfm = Class.forName("java.awt.KeyboardFocusManager");
                Object fm = kfm.getDeclaredMethod("getCurrentKeyboardFocusManager", null).invoke(null, null);
                kfm.getDeclaredMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class).invoke(fm, "focusOwner", editorRemover);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private void focusEditor() {
        Component editorComponent = this.getRealEditorComponent();
        if (editorComponent != null) {
            editorComponent.requestFocus();
        }
    }

    private Component getRealEditorComponent() {
        Component editorComponent = this.getEditorComponent();
        if (editorComponent != null) {
            editorComponent = ((InvisiblePanel)editorComponent).getEditorComponent();
        }
        return editorComponent;
    }

    private class MouseTracker
    extends MouseInputAdapter {
        private MouseEvent m_pressEvent = null;

        private MouseTracker() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            SingleSelectionTable.this.removeMouseListener(this);
            SingleSelectionTable.this.removeMouseMotionListener(this);
            if (this.m_pressEvent != null) {
                this.doEditCellAt(event);
                Component editorComponent = SingleSelectionTable.this.getRealEditorComponent();
                if (editorComponent != null) {
                    editorComponent.requestFocus();
                    editorComponent.dispatchEvent(SwingUtilities.convertMouseEvent(this.m_pressEvent.getComponent(), this.m_pressEvent, editorComponent));
                    editorComponent.dispatchEvent(SwingUtilities.convertMouseEvent(event.getComponent(), event, editorComponent));
                }
                this.m_pressEvent = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (this.m_pressEvent != null) {
                this.doEditCellAt(event);
            }
        }

        public void setPressEvent(MouseEvent event) {
            this.m_pressEvent = event;
        }

        private void doEditCellAt(MouseEvent event) {
            int row = SingleSelectionTable.this.getSelectionModel().getAnchorSelectionIndex();
            int column = SingleSelectionTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (row != SingleSelectionTable.this.getEditingRow() || column != SingleSelectionTable.this.getEditingColumn()) {
                TableCellEditor tce = SingleSelectionTable.this.getCellEditor();
                if (tce != null) {
                    tce.cancelCellEditing();
                }
                if (row != -1 && column != -1) {
                    this.m_pressEvent = new MouseEvent(event.getComponent(), 501, event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
                    SingleSelectionTable.this.focusedEditCellAt(row, column, this.m_pressEvent, false);
                }
            }
        }
    }

    private class DelayedEditorChange
    extends FocusAdapter {
        private boolean m_pending = false;
        private int m_row;
        private int m_column;
        private EventObject m_e;
        private boolean m_checkFocus;
        private boolean m_doEdit;

        private DelayedEditorChange() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            SingleSelectionTable.this.removeFocusListener(this);
            SingleSelectionTable.this.addFocusListener(SingleSelectionTable.this.m_focusForwarder);
            this.m_pending = false;
            if (this.m_doEdit) {
                SingleSelectionTable.this.focusedEditCellAtImpl(this.m_row, this.m_column, this.m_e);
                if (this.m_checkFocus) {
                    SingleSelectionTable.this.focusEditor();
                }
            } else {
                SingleSelectionTable.this.removeEditorImpl();
            }
        }

        public void delayedEditCellAt(int row, int column, EventObject e, boolean checkFocus) {
            if (!this.m_pending || !(this.m_e instanceof MouseEvent) || e != null) {
                this.m_row = row;
                this.m_column = column;
                this.m_e = e;
                this.m_checkFocus = checkFocus;
                this.m_doEdit = true;
                this.createDelayedOperation();
            }
        }

        public void delayedRemoveEditor() {
            this.m_doEdit = false;
            this.createDelayedOperation();
        }

        private void createDelayedOperation() {
            if (!this.m_pending) {
                this.m_pending = true;
                SingleSelectionTable.this.removeFocusListener(SingleSelectionTable.this.m_focusForwarder);
                SingleSelectionTable.this.addFocusListener(this);
                SingleSelectionTable.this.requestFocus();
            }
        }
    }

    private class InvisiblePanel
    extends JPanel
    implements FocusListener {
        private Component m_component;
        private JPanel m_previousComponent;
        private JPanel m_nextComponent;

        public InvisiblePanel() {
            this.m_previousComponent = new NavigationPanel("selectPreviousColumnCell");
            this.m_nextComponent = new NavigationPanel("selectNextColumnCell");
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_previousComponent, "Center");
            this.m_previousComponent.setLayout(new BorderLayout());
            this.m_previousComponent.add((Component)this.m_nextComponent, "East");
            this.m_nextComponent.setPreferredSize(new Dimension(0, 0));
            this.addFocusListener(this);
        }

        public void setEditorComponent(Component component) {
            if (this.m_component != null) {
                this.removeEditorComponent();
            }
            this.m_component = component;
            this.m_previousComponent.add(this.m_component, "Center", 0);
            if (component instanceof JComponent) {
                ((JComponent)component).setNextFocusableComponent(null);
            }
        }

        public Component getEditorComponent() {
            return this.m_component;
        }

        public void removeEditorComponent() {
            if (this.m_component != null) {
                this.m_previousComponent.remove(this.m_component);
                this.m_component = null;
            }
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return CellUtils.processKeyBinding(this.getEditorComponent(), ks, e, condition, pressed);
        }

        @Override
        public boolean isFocusTraversable() {
            return this.m_component != null;
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.m_component.requestFocus();
        }

        @Override
        public void focusLost(FocusEvent event) {
        }
    }

    private class NavigationPanel
    extends JPanel
    implements FocusListener {
        private String m_actionKey;

        public NavigationPanel(String actionKey) {
            this.m_actionKey = actionKey;
            this.addFocusListener(this);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public void focusGained(FocusEvent event) {
            Action action = SingleSelectionTable.this.getActionMap().get(this.m_actionKey);
            action.actionPerformed(new ActionEvent(SingleSelectionTable.this, 0, this.m_actionKey));
        }

        @Override
        public void focusLost(FocusEvent event) {
        }
    }
}

