/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.datatransfer;

import java.util.List;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.bm.ide.datatransfer.FlavorAdapter;
import oracle.bm.ide.datatransfer.LazySelector;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.bm.javatools.datatransfer.FlavorSelectionManager;
import oracle.bm.javatools.datatransfer.FlavorSelector;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class SelectorHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension/oracle.bm.jdukshare", "selector-hook");
    private static SelectorHook INSTANCE = new SelectorHook();
    private FlavorSelectionManager m_manager = new FlavorSelectionManager();

    private SelectorHook() {
        HashStructureHook hsh = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT);
        hsh.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                this.addSelectors(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                this.addSelectors(e.getCombinedHashStructure());
            }

            private void addSelectors(HashStructure hs) {
                if (hs == null) {
                    return;
                }
                List selectors = hs.getAsList("selector");
                if (selectors == null) {
                    return;
                }
                for (Object selector : selectors) {
                    if (!(selector instanceof HashStructure)) continue;
                    HashStructure selectorHS = (HashStructure)selector;
                    LazyClassAdapter lca = LazyClassAdapter.getInstance((HashStructure)selectorHS);
                    MetaClass mc = lca.getMetaClass("class/#text");
                    List flavors = selectorHS.getAsList("flavor");
                    for (Flavor flavor : FlavorAdapter.getFlavors(flavors)) {
                        try {
                            SelectorHook.this.m_manager.addSelector(flavor, new LazySelector((MetaClass<FlavorSelector>)mc));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public FlavorSelectionManager getFlavorSelectionManager() {
        return this.m_manager;
    }

    public static SelectorHook getHook() {
        return INSTANCE;
    }
}

