/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.util.XmlNameUtils;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;

public class XmlWriter {
    private int indent = 2;
    private BufferedWriter writer;
    private Deque<Element> stack = new ArrayDeque<Element>();
    public String lineBreakSequence;
    public int lineCount;

    public XmlWriter(URL url, String encoding, boolean standalone) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), encoding));
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(encoding);
        this.writer.write("\" standalone=\"");
        this.writer.write(standalone ? "yes" : "no");
        this.writer.write("\"?>");
    }

    public XmlWriter(URL url) throws IOException {
        this(url, IdeUtil.getIdeIanaEncoding(), true);
    }

    public void close() throws IOException {
        this.writeNewLine();
        this.writer.close();
    }

    public void writeTextElement(String name, Object ... content) throws IOException {
        this.writeElementBegin(name);
        this.writeText(content);
        this.writeElementEnd(name);
    }

    public void writeEmptyElement(String name) throws IOException {
        this.writeElementBegin(name, true);
        this.writeElementEnd(name);
    }

    public void writeElementBegin(String name) throws IOException {
        this.writeElementBegin(name, false);
    }

    private void writeElementBegin(String name, boolean inline) throws IOException {
        if (!this.stack.isEmpty()) {
            this.stack.peek().beginTagEnd();
        }
        this.stack.push(new Element(name, inline));
    }

    public void writeAttribute(String name, Object value) {
        if (this.stack.isEmpty()) {
            throw new IllegalArgumentException("not writing element");
        }
        this.stack.peek().addAttribute(name, value);
    }

    public void writeText(Object ... content) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalArgumentException("not writing element");
        }
        if (content != null) {
            for (Object item : content) {
                if (item == null) continue;
                this.stack.peek().beginTagEnd();
                String text = String.valueOf(item);
                block5: for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '<': {
                            this.writer.write("&lt;");
                            continue block5;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block5;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
            }
        }
    }

    public void writeElementEnd(String name) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalArgumentException("not writing element");
        }
        Element element = this.stack.peek();
        if (!name.equals(element.name)) {
            throw new IllegalArgumentException("name \"" + name + "\" conflicts with matching begin element name \"" + element.name + "\"");
        }
        element.endTag();
        this.stack.pop();
    }

    public void writeNewLine() throws IOException {
        if (this.lineBreakSequence == null) {
            this.lineBreakSequence = Ide.getEnvironOptions().getLineBreakSequence();
        }
        this.writer.write(this.lineBreakSequence);
        ++this.lineCount;
        for (int i = 0; i < (this.stack.size() - 1) * this.indent; ++i) {
            this.writer.write(32);
        }
    }

    private class Element {
        private String name;
        private EnumSet<State> states = EnumSet.noneOf(State.class);
        private Map<String, Object> attributes;
        private int beginTagLineCount;

        Element(String name, boolean inline) {
            XmlNameUtils.validateName((CharSequence)name);
            this.name = name;
            if (inline) {
                this.states.add(State.INLINE);
            }
        }

        private void beginTagBegin() throws IOException {
            if (!this.states.add(State.BEGIN_TAG_BEGUN)) {
                return;
            }
            if (!this.states.contains((Object)State.INLINE)) {
                XmlWriter.this.writeNewLine();
            }
            this.beginTagLineCount = XmlWriter.this.lineCount;
            XmlWriter.this.writer.write(60);
            XmlWriter.this.writer.write(this.name);
            if (this.attributes != null) {
                for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                    XmlWriter.this.writer.write(32);
                    XmlWriter.this.writer.write(entry.getKey());
                    XmlWriter.this.writer.write("=\"");
                    String text = String.valueOf(entry.getValue());
                    block6: for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        switch (c) {
                            case '<': {
                                XmlWriter.this.writer.write("&lt;");
                                continue block6;
                            }
                            case '&': {
                                XmlWriter.this.writer.write("&amp;");
                                continue block6;
                            }
                            case '\"': {
                                XmlWriter.this.writer.write("&quot;");
                                continue block6;
                            }
                            default: {
                                XmlWriter.this.writer.write(c);
                            }
                        }
                    }
                    XmlWriter.this.writer.write(34);
                }
            }
        }

        private void beginTagEnd() throws IOException {
            this.beginTagBegin();
            if (!this.states.add(State.BEGIN_TAG_ENDED)) {
                return;
            }
            XmlWriter.this.writer.write(62);
        }

        private void endTag() throws IOException {
            this.beginTagBegin();
            if (!this.states.add(State.END_TAG_ENDED)) {
                return;
            }
            if (this.states.add(State.BEGIN_TAG_ENDED)) {
                XmlWriter.this.writer.write("/>");
            } else {
                if (XmlWriter.this.lineCount > this.beginTagLineCount) {
                    XmlWriter.this.writeNewLine();
                }
                XmlWriter.this.writer.write("</");
                XmlWriter.this.writer.write(this.name);
                XmlWriter.this.writer.write(62);
            }
        }

        public void addAttribute(String name, Object value) {
            XmlNameUtils.validateName((CharSequence)name);
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }

        public void setState(State state) {
            this.states.add(state);
        }
    }

    private static enum State {
        INLINE,
        BEGIN_TAG_BEGUN,
        BEGIN_TAG_ENDED,
        END_TAG_ENDED;

    }
}

