/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Iterators {
    private static Iterator EMPTY_ITERATOR = new EmptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> singletonIterator(T item) {
        return new SingletonIterator<T>(item);
    }

    public static <T> Iterator<T> arrayIterator(T ... items) {
        return new ArrayIterator<T>(items);
    }

    private static class SingletonIterator<T>
    implements Iterator<T> {
        private T item;
        boolean done;

        private SingletonIterator(T item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return this.item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private T[] items;
        private int next;

        private ArrayIterator(T[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.items.length;
        }

        @Override
        public T next() {
            if (this.next >= this.items.length) {
                throw new NoSuchElementException();
            }
            return this.items[this.next++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

