/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

public class Classes {
    private Classes() {
    }

    public static Class getPrimitiveType(Class type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    public static Class getWrapperType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    public static String getMethodDescriptor(String name, String returnType, String[] parameterTypes) {
        StringBuffer buffer = new StringBuffer(name);
        buffer.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            buffer.append(Classes.getTypeDescriptor(parameterTypes[i]));
        }
        buffer.append(')');
        buffer.append(Classes.getTypeDescriptor(returnType));
        return buffer.toString();
    }

    public static String getTypeDescriptor(String type) {
        if (type.endsWith("[]")) {
            return "[" + type.substring(0, type.length() - 2);
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("void")) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ";";
    }
}

