/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.management.Memory;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.model.ProjectModelAdapter;
import oracle.jdevimpl.audit.model.WorkspaceModelAdapter;
import oracle.jdevimpl.audit.report.AbstractReporter;
import oracle.jdevimpl.audit.report.ReportBundle;

public class XmlReporter
implements AbstractReporter {
    private AuditModel model;
    private URL outputFile;
    private String title;
    private String encoding = IdeUtil.getIdeIanaEncoding();
    private PrintWriter writer;
    private int indent = 2;
    private int depth = 0;
    private int modelErrorCount = 0;
    private int nextId = 0;
    private Map<ModelAdapter, String> models = new LinkedHashMap<ModelAdapter, String>();
    private Map<Category, String> categories = new LinkedHashMap<Category, String>();
    private Map<Rule, String> rules = new LinkedHashMap<Rule, String>();
    private Map<Transform, String> transforms = new LinkedHashMap<Transform, String>();
    private static final int MODEL_ERROR_LIMIT = 5;
    private static final String SCHEMA_URI = "http://xmlns.oracle.com/jdeveloper/1013/audit";
    private static final String DOCUMENT_ROOT = "audit";
    private static final Log LOG = new Log("report");
    private static final Log MEMORY_LOG = new Log(new String[]{"memory-statistics", "report"});
    private static final char[][] ESCAPES = new char[][]{{'?', 'N', 'U', 'L', '?'}, {'?', 'S', 'O', 'H', '?'}, {'?', 'S', 'T', 'X', '?'}, {'?', 'E', 'T', 'X', '?'}, {'?', 'E', 'O', 'T', '?'}, {'?', 'E', 'N', 'Q', '?'}, {'?', 'A', 'C', 'K', '?'}, {'?', 'B', 'E', 'L', '?'}, {'?', 'B', 'S', '?'}, {'\t'}, {'\n'}, {'?', 'V', 'T', '?'}, {'?', 'F', 'F', '?'}, {'\r'}, {'?', 'S', 'O', '?'}, {'?', 'S', 'I', '?'}, {'?', 'D', 'L', 'E', '?'}, {'?', 'D', 'C', '1', '?'}, {'?', 'D', 'C', '2', '?'}, {'?', 'D', 'C', '3', '?'}, {'?', 'D', 'C', '4', '?'}, {'?', 'N', 'A', 'K', '?'}, {'?', 'S', 'Y', 'N', '?'}, {'?', 'E', 'T', 'B', '?'}, {'?', 'C', 'A', 'N', '?'}, {'?', 'E', 'M', '?'}, {'?', 'S', 'U', 'B', '?'}, {'?', 'E', 'S', 'C', '?'}, {'?', 'F', 'S', '?'}, {'?', 'G', 'S', '?'}, {'?', 'R', 'S', '?'}, {'?', 'U', 'S', '?'}, {' '}, {'!'}, {'\"'}, {'#'}, {'$'}, {'%'}, {'&', 'a', 'm', 'p', ';'}, {'\''}, {'('}, {')'}, {'*'}, {'+'}, {','}, {'-'}, {'.'}, {'/'}, {'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {':'}, {';'}, {'&', 'l', 't', ';'}, {'='}, {'>'}, {'?'}, {'@'}, {'A'}, {'B'}, {'C'}, {'D'}, {'E'}, {'F'}, {'G'}, {'H'}, {'I'}, {'J'}, {'K'}, {'L'}, {'M'}, {'N'}, {'O'}, {'P'}, {'Q'}, {'R'}, {'S'}, {'T'}, {'U'}, {'V'}, {'W'}, {'X'}, {'Y'}, {'Z'}, {'['}, {'\\'}, {']'}, {'^'}, {'_'}, {'`'}, {'a'}, {'b'}, {'c'}, {'d'}, {'e'}, {'f'}, {'g'}, {'h'}, {'i'}, {'j'}, {'k'}, {'l'}, {'m'}, {'n'}, {'o'}, {'p'}, {'q'}, {'r'}, {'s'}, {'t'}, {'u'}, {'v'}, {'w'}, {'x'}, {'y'}, {'z'}, {'{'}, {'|'}, {'}'}, {'~'}, {'?', 'D', 'E', 'L', '?'}, {'?', 'P', 'A', 'D', '?'}, {'?', 'H', 'O', 'P', '?'}, {'?', 'B', 'P', 'H', '?'}, {'?', 'N', 'B', 'H', '?'}, {'?', 'I', 'N', 'D', '?'}, {'?', 'N', 'E', 'L', '?'}, {'?', 'S', 'S', 'A', '?'}, {'?', 'E', 'S', 'A', '?'}, {'?', 'H', 'T', 'S', '?'}, {'?', 'H', 'T', 'J', '?'}, {'?', 'L', 'T', 'S', '?'}, {'?', 'P', 'L', 'D', '?'}, {'?', 'P', 'L', 'U', '?'}, {'?', 'R', 'I', '?'}, {'?', 'S', 'S', '2', '?'}, {'?', 'S', 'S', '3', '?'}, {'?', 'D', 'C', 'S', '?'}, {'?', 'P', 'U', '1', '?'}, {'?', 'P', 'U', '2', '?'}, {'?', 'S', 'T', 'S', '?'}, {'?', 'C', 'C', 'H', '?'}, {'?', 'M', 'W', '?'}, {'?', 'S', 'P', 'A', '?'}, {'?', 'E', 'P', 'A', '?'}, {'?', 'S', 'O', 'S', '?'}, {'?', 'S', 'G', 'C', 'I', '?'}, {'?', 'S', 'C', 'I', '?'}, {'?', 'C', 'S', 'I', '?'}, {'?', 'S', 'T', '?'}, {'?', 'O', 'S', 'C', '?'}, {'?', 'P', 'M', '?'}, {'?', 'A', 'P', 'C', '?'}};
    protected String lineBreakSequence;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = IdeUtil.getIdeIanaEncoding();
        }
        this.encoding = encoding;
    }

    public URL getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(URL destination) {
        LOG.trace("setting destination to {0}", (Object)destination);
        this.outputFile = destination;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setModel(AuditModel model) {
        this.model = model;
    }

    public AuditModel getModel() {
        return this.model;
    }

    @Override
    public void report() throws InvocationTargetException {
        try {
            LOG.trace("creating output stream {0}", (Object)this.outputFile);
            BufferedOutputStream output = this.outputFile == null ? new BufferedOutputStream(new StandardOutputStream()) : new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.outputFile));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.getEncoding())));
            this.writeXmlDeclaration();
            this.writeModel(this.model);
        }
        catch (CancellationException e) {
            throw new InvocationTargetException(e);
        }
        catch (InterruptedException e) {
            throw new InvocationTargetException(e);
        }
        catch (Throwable e) {
            LOG.trace("unexpected exception creating report {0}: {1}", (Object)this.outputFile, (Object)e);
            throw new InvocationTargetException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        Node node = NodeFactory.find((URL)this.outputFile);
        if (node != null) {
            try {
                node.revert();
            }
            catch (IOException e) {
                LOG.trace("unexpected exception reverting report {0}: {1}", (Object)this.outputFile, (Object)e);
                throw new InvocationTargetException(e);
            }
        }
    }

    protected void indent() {
        ++this.depth;
    }

    protected void undent() {
        --this.depth;
    }

    protected void writeXmlDeclaration() {
        this.writeLine("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\" standalone=\"yes\"?>");
    }

    protected void writeTextElement(String name, Object object) {
        this.writeTextElement(name, null, object);
    }

    protected void writeTextElement(String name, String[] attributes, Object object) {
        String text;
        String string = text = object != null ? String.valueOf(object) : "";
        if ("".equals(text)) {
            this.writeBeginTag(name, attributes, true, true);
        } else {
            this.writeBeginTag(name, attributes, false, false);
            this.writeText(text);
            this.writeEndTag(name, false);
        }
    }

    protected void writeCommentLine(String text) {
        this.writeComment(text);
        this.writer.println();
    }

    protected void writeComment(String text) {
        this.writer.print("<!--");
        this.writeText(text);
        this.writer.print("-->");
    }

    protected void writeText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= '\u009f') {
                this.writer.write(ESCAPES[c]);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void writeBeginTag(String name) {
        this.writeBeginTag(name, null, false, true);
    }

    protected void writeBeginTag(String name, String[] attributes, boolean empty, boolean wrap) {
        this.writeIndent();
        this.writer.print('<');
        this.writeName(name);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; i += 2) {
                this.writer.print(' ');
                this.writer.print(attributes[i]);
                this.writer.print("=\"");
                this.writer.print(attributes[i + 1]);
                this.writer.print('\"');
            }
        }
        if (empty) {
            this.writer.print('/');
        }
        this.writer.print('>');
        if (wrap) {
            this.newline();
        }
        if (!empty) {
            this.indent();
        }
    }

    protected void writeEndTag(String name) {
        this.writeEndTag(name, true);
    }

    protected void writeEndTag(String name, boolean indent) {
        this.undent();
        if (indent) {
            this.writeIndent();
        }
        this.writer.print("</");
        this.writeName(name);
        this.writer.print('>');
        this.newline();
    }

    protected void writeName(String name) {
        this.writer.print(name);
    }

    protected void writeIndent() {
        int count = this.depth * this.indent;
        while (count-- > 0) {
            this.writer.write(32);
        }
    }

    protected void writeLine(String text) {
        this.writeIndent();
        this.writer.print(text);
        this.newline();
    }

    protected void newline() {
        if (this.lineBreakSequence == null) {
            this.lineBreakSequence = Ide.getEnvironOptions().getLineBreakSequence();
        }
        this.writer.write(this.lineBreakSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeModel(AuditModel model) throws InterruptedException {
        this.models.clear();
        this.categories.clear();
        this.rules.clear();
        this.transforms.clear();
        this.modelErrorCount = 0;
        this.writeLine("<!DOCTYPE audit [");
        this.indent();
        this.writeLine("<!ATTLIST category id ID #REQUIRED>");
        this.writeLine("<!ATTLIST column id ID #REQUIRED>");
        this.writeLine("<!ATTLIST construct id ID #REQUIRED parent IDREF #REQUIRED root (false|true) \"false\">");
        this.writeLine("<!ATTLIST model id ID #REQUIRED>");
        this.writeLine("<!ATTLIST location model IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST rule id ID #REQUIRED category IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST transform id ID #REQUIRED>");
        this.writeLine("<!ATTLIST transform-applied transform IDREF #REQUIRED>");
        this.writeLine("<!ATTLIST value column IDREF #REQUIRED over-threshold (false|true) \"false\">");
        this.writeLine("<!ATTLIST violation rule IDREF #REQUIRED parent IDREF #REQUIRED suppressed (false|true) \"false\">");
        this.undent();
        this.writeLine("]>");
        this.newline();
        Object root = model.getRoot();
        ArrayList<ModelAdapter> adapters = new ArrayList<ModelAdapter>(4);
        ModelAdapter adapter = model.getLocation(root).getModel();
        while (!(adapter instanceof WorkspaceModelAdapter) && (adapter = adapter.getContainingAdapter()) != null) {
            adapters.add(adapter);
        }
        int i = adapters.size();
        while (--i >= 0) {
            ModelAdapter adapter2 = (ModelAdapter)adapters.get(i);
            if (this.models.containsKey(adapter2)) continue;
            this.models.put(adapter2, "d" + this.models.size());
        }
        this.collect(model, root);
        this.writeBeginTag(DOCUMENT_ROOT, new String[]{"xmlns", SCHEMA_URI}, false, true);
        String title = this.getTitle();
        if (title == null) {
            Object name;
            List<Location> locations = model.getLocations();
            if (locations.size() == 1) {
                Location location = locations.get(0);
                ModelAdapter adapter3 = location.getModel();
                adapter3.beginRead();
                try {
                    name = adapter3.getLabel(location);
                }
                finally {
                    adapter3.endRead();
                }
            } else {
                name = ReportBundle.get("multiple.selection.name");
            }
            title = ReportBundle.format("audit.default-title", name);
        }
        this.writeTextElement("title", title);
        this.writeStatistics(model);
        this.writeLocations(model);
        this.writeProfile(model);
        this.writeColumns(model);
        this.writeModels();
        this.writeCategories();
        this.writeRules();
        this.writeTransforms();
        this.writeConstruct(model, null, root, null, false);
        this.writeEndTag(DOCUMENT_ROOT);
    }

    private void collect(AuditModel model, Object object) {
        Violation violation;
        ModelAdapter rowModel = model.getLocation(object).getModel();
        if (!this.models.containsKey(rowModel)) {
            this.models.put(rowModel, "d" + this.models.size());
        }
        if ((violation = model.getViolation(object)) == null) {
            for (Object child : model.getVisibleChildren(object)) {
                this.collect(model, child);
            }
        } else {
            Rule rule = violation.getRule();
            Category category = rule.category();
            if (!this.categories.containsKey(category)) {
                this.categories.put(category, "c" + this.categories.size());
            }
            if (!this.rules.containsKey(rule)) {
                this.rules.put(rule, "r" + this.rules.size());
            }
            for (Transform transform : model.getTransformsApplied(violation)) {
                if (this.transforms.containsKey(transform)) continue;
                this.transforms.put(transform, "t" + this.transforms.size());
            }
        }
    }

    private void writeStatistics(AuditModel model) {
        Object root = model.getRoot();
        int fileCount = model.getCount(root, AuditModel.Count.VISIBLE_FILES);
        int exceptionCount = model.getCount(root, AuditModel.Count.VISIBLE_OUT_OF_BANDS);
        int errorCount = model.getCount(root, AuditModel.Count.VISIBLE_ERRORS);
        int warningCount = model.getCount(root, AuditModel.Count.VISIBLE_WARNINGS);
        int incompleteCount = model.getCount(root, AuditModel.Count.VISIBLE_INCOMPLETES);
        int advisoryCount = model.getCount(root, AuditModel.Count.VISIBLE_ADVISORIES);
        this.writeTextElement("model-count", String.valueOf(fileCount));
        this.writeTextElement("violation-count", String.valueOf(errorCount + warningCount + incompleteCount + advisoryCount));
        this.writeTextElement("exception-count", String.valueOf(exceptionCount));
        this.writeTextElement("error-count", String.valueOf(errorCount));
        this.writeTextElement("warning-count", String.valueOf(warningCount));
        this.writeTextElement("incomplete-count", String.valueOf(incompleteCount));
        this.writeTextElement("advisory-count", String.valueOf(advisoryCount));
    }

    private void writeModels() {
        this.writeBeginTag("models");
        for (Map.Entry<ModelAdapter, String> entry : this.models.entrySet()) {
            ModelAdapter model = entry.getKey();
            String id = entry.getValue();
            this.writeBeginTag("model", new String[]{"id", id}, false, true);
            this.writeFile(model.getUrl());
            this.writePackage(model.getDirectory());
            this.writeProject(model.getProject());
            this.writeWorkspace(model.getWorkspace());
            this.writeTextElement("label", model.getShortLabel());
            this.writeEndTag("model");
        }
        this.writeEndTag("models");
    }

    private void writeFile(URL url) {
        if (url != null) {
            this.writeBeginTag("file");
            this.writeTextElement("url", url);
            this.writeTextElement("path", URLFileSystem.getPlatformPathName((URL)url));
            this.writeEndTag("file");
        }
    }

    private void writePackage(ContentDirectory packag) {
        if (packag != null) {
            this.writeTextElement("package", packag.getRelativePath().replace('/', '.'));
        }
    }

    private void writeProject(Project project) {
        if (project != null) {
            this.writeBeginTag("project");
            this.writeTextElement("label", project.getShortLabel());
            this.writeFile(project.getURL());
            this.writeEndTag("project");
        }
    }

    private void writeWorkspace(Workspace workspace) {
        if (workspace != null) {
            this.writeBeginTag("workspace");
            this.writeTextElement("label", workspace.getShortLabel());
            this.writeFile(workspace.getURL());
            this.writeEndTag("workspace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocations(AuditModel model) throws InterruptedException {
        this.writeBeginTag("locations");
        for (Location location : model.getLocations()) {
            location.getModel().beginRead();
            try {
                this.writeLocation(location);
            }
            finally {
                location.getModel().endRead();
            }
        }
        this.writeEndTag("locations");
    }

    private void writeLocation(Location location) {
        ModelAdapter model = location.getModel();
        String modelId = this.models.get(model);
        this.writeBeginTag("location", new String[]{"model", modelId}, false, true);
        int offset = location.getOffset();
        this.writeTextElement("offset", String.valueOf(offset));
        this.writeTextElement("length", String.valueOf(location.getLength()));
        this.writeTextElement("line-number", String.valueOf(model.getLineOffset(offset) + 1));
        this.writeTextElement("column-offset", String.valueOf(model.getColumnOffset(offset)));
        this.writeEndTag("location");
    }

    private void writeProfile(AuditModel model) {
        this.writeBeginTag("profile");
        this.writeTextElement("name", model.getProfile().getName());
        this.writeFile(model.getProfile().getURL());
        this.writeEndTag("profile");
    }

    private void writeColumns(AuditModel model) {
        this.writeBeginTag("columns");
        int size = model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            Metric column = model.getColumn(i);
            String label = column.label();
            String description = column.description();
            this.writeBeginTag("column", new String[]{"id", "a" + i}, false, true);
            this.writeTextElement("name", column.id());
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("type", column.getType());
            this.writeTextElement("threshold", column.getThreshold());
            this.writeEndTag("column");
        }
        this.writeEndTag("columns");
    }

    private void writeCategories() {
        this.writeBeginTag("categories");
        for (Map.Entry<Category, String> entry : this.categories.entrySet()) {
            Category category = entry.getKey();
            String id = entry.getValue();
            String name = category.id();
            String label = category.label();
            String description = category.description();
            this.writeBeginTag("category", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("category");
        }
        this.writeEndTag("categories");
    }

    private void writeRules() {
        this.writeBeginTag("rules");
        for (Map.Entry<Rule, String> entry : this.rules.entrySet()) {
            Rule rule = entry.getKey();
            String id = entry.getValue();
            String cid = this.categories.get(rule.category());
            this.writeBeginTag("rule", new String[]{"id", id, "category", cid}, false, true);
            String name = rule.id();
            String label = rule.label();
            String description = rule.description();
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("severity", rule.getSeverity());
            this.writeEndTag("rule");
        }
        this.writeEndTag("rules");
    }

    private void writeTransforms() {
        this.writeBeginTag("transforms");
        for (Map.Entry<Transform, String> entry : this.transforms.entrySet()) {
            Transform transform = entry.getKey();
            String id = entry.getValue();
            String name = transform.id();
            String label = transform.label();
            String description = transform.description();
            this.writeBeginTag("transform", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("transform");
        }
        this.writeEndTag("transforms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeConstruct(AuditModel model, String parentId, Object object, ModelAdapter lockedModel, boolean activeNodeUsageCycle) throws InterruptedException {
        Location location = model.getLocation(object);
        ModelAdapter currentModel = location.getModel();
        boolean atRoot = lockedModel == null;
        boolean modelEntered = currentModel != lockedModel;
        boolean endNodeUsageCycle = false;
        if (modelEntered) {
            if (!activeNodeUsageCycle && (atRoot || currentModel instanceof ProjectModelAdapter)) {
                this.printRunningStatistics("begin reporting {0}", currentModel);
                Node.beginThreadNodeUsageCycle();
                activeNodeUsageCycle = true;
                endNodeUsageCycle = true;
            }
            LOG.trace("beginning read of {0}", (Object)currentModel);
            currentModel.beginRead();
            lockedModel = currentModel;
        }
        LOG.trace("writing construct {0}", object);
        try {
            Violation violation = model.getViolation(object);
            if (violation == null) {
                String id = "o" + this.nextId++;
                String[] attributes = parentId == null ? new String[]{"id", id, "parent", id, "root", "true"} : new String[]{"id", id, "parent", parentId};
                this.writeBeginTag("construct", attributes, false, true);
                this.writeLocation(location);
                Class<?> type = model.getType(object);
                this.writeTextElement("type", type);
                this.writeTextElement("kind", this.trim(currentModel.getType().label(type)));
                this.writeTextElement("name", this.trim(model.getSummary(object)));
                this.writeTextElement("label", this.trim(model.getLabel(object)));
                this.writeValues(model, object);
                this.writeBeginTag("children");
                for (Object child : model.getVisibleChildren(object)) {
                    try {
                        this.writeConstruct(model, id, child, lockedModel, activeNodeUsageCycle);
                    }
                    catch (UnwindException e) {
                        if (modelEntered) continue;
                        throw e;
                    }
                    catch (InterruptedException | OutOfMemoryError | CancellationException e) {
                        throw e;
                    }
                    catch (ModelAccessError e) {
                        AuditLogger.log((Throwable)e, "reporter", null, "model", null, location, e.getDetail());
                        this.writeCommentLine(e.toString());
                        if (++this.modelErrorCount > 5) {
                            CancellationException exception = new CancellationException("Audit cancelled after 5 exceptions during report phase");
                            this.writeCommentLine(exception.toString());
                            exception.initCause(e);
                            throw exception;
                        }
                        if (modelEntered) continue;
                        throw new UnwindException(e);
                    }
                    catch (Throwable e) {
                        AuditLogger.log(e, "reporter", null, "construct", null, location, new Object[0]);
                        this.writeCommentLine(e.toString());
                        if (++this.modelErrorCount > 5) {
                            CancellationException exception = new CancellationException("Audit cancelled after 5 exceptions during report phase");
                            this.writeCommentLine(exception.toString());
                            exception.initCause(e);
                            throw exception;
                        }
                        if (modelEntered) continue;
                        throw new UnwindException(e);
                    }
                }
                this.writeEndTag("children");
                this.writeEndTag("construct");
            } else {
                this.writeViolation(model, parentId, object, violation);
            }
            if (!modelEntered) return;
        }
        catch (Throwable throwable) {
            if (!modelEntered) throw throwable;
            LOG.trace("ending read of {0}", (Object)currentModel);
            currentModel.endRead();
            if (endNodeUsageCycle) {
                this.printRunningStatistics("end reporting {0}", currentModel);
                Node.endThreadNodeUsageCycle();
            } else if (activeNodeUsageCycle) {
                Node.endThreadNodeUsage((Node)currentModel.getNode());
            }
            if (Ide.getIdeArgs().getCreateUI() || !(currentModel instanceof ProjectModelAdapter)) throw throwable;
            try {
                currentModel.getProject().close();
                throw throwable;
            }
            catch (IOException e) {
                AuditLogger.error(e, "Unexpected exception closing {0}: {1}", currentModel, e);
            }
            throw throwable;
        }
        LOG.trace("ending read of {0}", (Object)currentModel);
        currentModel.endRead();
        if (endNodeUsageCycle) {
            this.printRunningStatistics("end reporting {0}", currentModel);
            Node.endThreadNodeUsageCycle();
        } else if (activeNodeUsageCycle) {
            Node.endThreadNodeUsage((Node)currentModel.getNode());
        }
        if (Ide.getIdeArgs().getCreateUI() || !(currentModel instanceof ProjectModelAdapter)) return;
        try {
            currentModel.getProject().close();
            return;
        }
        catch (IOException e) {
            AuditLogger.error(e, "Unexpected exception closing {0}: {1}", currentModel, e);
        }
    }

    private String trim(String text) {
        if (text == null) {
            return null;
        }
        return text.trim();
    }

    private void writeViolation(AuditModel model, String parentId, Object object, Violation violation) {
        LOG.trace("writing violation {0}", object);
        String rid = this.rules.get(violation.getRule());
        int attributesLength = 4;
        if (violation.getVariation() != null) {
            attributesLength += 2;
        }
        if (violation.getSuppressionCount() > 0) {
            attributesLength += 2;
        }
        String[] attributes = new String[attributesLength];
        int i = 0;
        attributes[i++] = "parent";
        attributes[i++] = parentId;
        attributes[i++] = "rule";
        attributes[i++] = rid;
        if (violation.getVariation() != null) {
            attributes[i++] = "variation";
            attributes[i++] = violation.getVariation();
        }
        if (violation.getSuppressionCount() > 0) {
            attributes[i++] = "suppressed";
            attributes[i++] = "true";
        }
        this.writeBeginTag("violation", attributes, false, true);
        this.writeLocation(model.getLocation(object));
        this.writeTextElement("message", model.getLabel(object));
        this.writeValues(model, object);
        this.writeTransformsApplied(model, object);
        this.writeEndTag("violation");
    }

    protected void writeValues(AuditModel model, Object object) {
        this.writeBeginTag("values");
        int size = model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            Object value;
            Metric column = model.getColumn(i);
            String[] attributes = column.isOutOfBand(value = model.getValue(object, i)) ? new String[]{"column", "a" + i, "over-threshold", "true"} : new String[]{"column", "a" + i};
            this.writeTextElement("value", attributes, column.representation(value));
        }
        this.writeEndTag("values");
    }

    protected void writeTransformsApplied(AuditModel model, Object object) {
        this.writeBeginTag("transforms-applied");
        for (Transform transform : model.getTransformsApplied(model.getViolation(object))) {
            String tid = this.transforms.get(transform);
            this.writeBeginTag("transform-applied", new String[]{"transform", tid}, true, true);
        }
        this.writeEndTag("transforms-applied");
    }

    private void printRunningStatistics(String message, Object ... arguments) {
        if (MEMORY_LOG.isEnabled()) {
            String EOL = System.getProperty("line.separator");
            StringBuilder openNodes = new StringBuilder(EOL);
            Iterator i = NodeFactory.getOpenNodes();
            while (i.hasNext()) {
                openNodes.append("  ");
                openNodes.append(((Node)i.next()).getLongLabel());
                openNodes.append(EOL);
            }
            MEMORY_LOG.trace("{0}: {1} nodes, {2} open nodes:{3}{4}{5}", new Object[]{Log.format((String)message, (Object[])arguments), NodeFactory.getCachedNodeCount(), NodeFactory.getOpenNodeCount(), openNodes, Memory.summary(), EOL});
        }
    }

    static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static final class UnwindException
    extends RuntimeException {
        public UnwindException(Throwable cause) {
            super(cause);
        }
    }
}

