/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Log;

public class AuditPreferences
extends HashStructureAdapter
implements oracle.jdeveloper.audit.AuditPreferences,
Copyable {
    private static Map<String, PropertyAdapter> propertyAdapters = new HashMap<String, PropertyAdapter>();
    private static AuditPreferences instance;
    private static Log LOG;
    private StructureChangeAdapter adapter;

    private <T> T getValue(String name) {
        PropertyAdapter adapter = propertyAdapters.get(name);
        return adapter.getValue(this.getHashStructure());
    }

    private <T> void setValue(String name, T value) {
        PropertyAdapter adapter = propertyAdapters.get(name);
        adapter.setValue(this.getHashStructure(), value);
    }

    public static synchronized AuditPreferences getAuditPreferences() {
        if (instance == null) {
            instance = new AuditPreferences(AuditPreferences.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)"audit-preferences"), true);
            LOG.trace("created canonical {0}", (Object)instance);
        }
        LOG.trace("getting canonical {0}", (Object)instance);
        return instance;
    }

    static AuditPreferences getAuditPreferences(PropertyStorage storage) {
        AuditPreferences preferences = new AuditPreferences(AuditPreferences.findOrCreate((PropertyStorage)storage, (String)"audit-preferences"), false);
        LOG.trace("created {0} on {1}", (Object)preferences, (Object)storage);
        return preferences;
    }

    public AuditPreferences() {
        this(HashStructure.newInstance(), false);
        LOG.trace("created {0} on new HashStructure", (Object)this);
    }

    private AuditPreferences(HashStructure structure, boolean listeners) {
        super(structure);
        if (listeners) {
            this.adapter = new StructureChangeAdapter(this);
            this.getHashStructure().addStructureChangeListener((StructureChangeListener)this.adapter);
        }
    }

    public Object copyTo(Object that) {
        if (that == null) {
            that = new AuditPreferences();
        }
        if (this.getClass() != that.getClass()) {
            throw new IllegalArgumentException(this.getClass().getName() + " != " + that.getClass().getName());
        }
        this.copyToImpl((AuditPreferences)that);
        return that;
    }

    void unsetDefaultValues() {
        for (Map.Entry<String, PropertyAdapter> entry : propertyAdapters.entrySet()) {
            PropertyAdapter adapter = entry.getValue();
            adapter.unsetIfDefault(this.getHashStructure());
        }
    }

    @Override
    public boolean isAuditWhileEditing() {
        return (Boolean)this.getValue("auditWhileEditing");
    }

    @Override
    public void setAuditWhileEditing(boolean newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)newValue, (Object)"auditWhileEditing", (Object)this);
        this.setValue("auditWhileEditing", newValue);
    }

    @Override
    public boolean isShowCodeAssistanceInGutter() {
        return (Boolean)this.getValue("showCodeAssistanceInGutter");
    }

    @Override
    public void setShowCodeAssistanceInGutter(boolean newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)newValue, (Object)"showCodeAssistanceInGutter", (Object)this);
        this.setValue("showCodeAssistanceInGutter", newValue);
    }

    @Override
    public String getAssistProfile() {
        return (String)this.getValue("assistProfile");
    }

    @Override
    public void setAssistProfile(String newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)newValue, (Object)"assistProfile", (Object)this);
        this.setValue("assistProfile", newValue);
    }

    @Override
    public int getEditorDelay() {
        return (Integer)this.getValue("editorDelay");
    }

    @Override
    public void setEditorDelay(int newValue) {
        LOG.trace("setting {1} to {0} on {2}", newValue, (Object)"editorDelay", (Object)this);
        this.setValue("editorDelay", newValue);
    }

    @Override
    public boolean isAuditDuringCompile() {
        return (Boolean)this.getValue("auditDuringCompile");
    }

    @Override
    public void setAuditDuringCompile(boolean newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)newValue, (Object)"auditDuringCompile", (Object)this);
        this.setValue("auditDuringCompile", newValue);
    }

    @Override
    public String getCompileProfile() {
        return (String)this.getValue("compileProfile");
    }

    @Override
    public void setCompileProfile(String newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)newValue, (Object)"compileProfile", (Object)this);
        this.setValue("compileProfile", newValue);
    }

    @Override
    public float getMaximumFileSize() {
        return ((Float)this.getValue("maximumFileSize")).floatValue();
    }

    @Override
    public void setMaximumFileSize(float newValue) {
        LOG.trace("setting {1} to {0} on {2}", (Object)Float.valueOf(newValue), (Object)"maximumFileSize", (Object)this);
        this.setValue("maximumFileSize", Float.valueOf(newValue));
    }

    @Override
    public boolean isAuditUsesJot() {
        return System.getProperty("AUDIT_USES_JOT") != null;
    }

    @Override
    public boolean isAuditUsesAuditJavac() {
        return !this.isAuditUsesJot();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        LOG.trace("adding {0} to {1}", (Object)listener, (Object)this);
        if (this.adapter == null) {
            throw new UnsupportedOperationException();
        }
        this.adapter.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        LOG.trace("adding {0} on {1} to {2}", (Object)listener, (Object)propertyName, (Object)this);
        if (this.adapter == null) {
            throw new UnsupportedOperationException();
        }
        this.adapter.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        LOG.trace("removing {0} from {1}", (Object)listener, (Object)this);
        if (this.adapter == null) {
            throw new UnsupportedOperationException();
        }
        this.adapter.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        LOG.trace("removing {0} on {1} from {2}", (Object)listener, (Object)propertyName, (Object)this);
        if (this.adapter == null) {
            throw new UnsupportedOperationException();
        }
        this.adapter.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AuditPreferences@");
        buffer.append(System.identityHashCode(this));
        buffer.append(" {");
        if (this.isAuditDuringCompile()) {
            buffer.append("compiling ");
            buffer.append(this.getCompileProfile());
            buffer.append(", ");
        }
        if (this.isAuditWhileEditing()) {
            buffer.append("editing ");
            buffer.append(this.getAssistProfile());
            buffer.append(", gutter ");
            buffer.append(this.isShowCodeAssistanceInGutter());
            buffer.append(", delay ");
            buffer.append(this.getEditorDelay());
            buffer.append("ms, ");
        }
        buffer.append("maximum file size ");
        buffer.append(this.getMaximumFileSize());
        buffer.append("Mb, ");
        if (this.isAuditUsesAuditJavac()) {
            buffer.append("using Audit-Javac, ");
        } else if (this.isAuditUsesJot()) {
            buffer.append("using JOT, ");
        }
        if (this.adapter != null) {
            buffer.append((Object)this.adapter);
        } else {
            buffer.append("unlistenable");
        }
        return buffer.toString();
    }

    static {
        propertyAdapters.put("auditWhileEditing", new BooleanPropertyAdapter("auditWhileEditing", true));
        propertyAdapters.put("showCodeAssistanceInGutter", new BooleanPropertyAdapter("showCodeAssistanceInGutter", true));
        propertyAdapters.put("assistProfile", new StringPropertyAdapter("assistProfile", null));
        propertyAdapters.put("auditDuringCompile", new BooleanPropertyAdapter("auditDuringCompile", false));
        propertyAdapters.put("compileProfile", new StringPropertyAdapter("compileProfile", null));
        propertyAdapters.put("editorDelay", new IntegerPropertyAdapter("editorDelay", 800));
        propertyAdapters.put("maximumFileSize", new FloatPropertyAdapter("maximumFileSize", Float.valueOf(5.0f)));
        LOG = new Log("audit-preferences");
    }

    private static abstract class PropertyAdapter<T> {
        private String name;
        private T defaultValue;

        PropertyAdapter(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        String getName() {
            return this.name;
        }

        T getDefaultValue() {
            return this.defaultValue;
        }

        abstract T getValue(HashStructure var1);

        abstract void setValue(HashStructure var1, T var2);

        abstract T getOldValue(ChangeInfo var1);

        abstract T getNewValue(ChangeInfo var1);

        void unsetIfDefault(HashStructure structure) {
            T value = this.getValue(structure);
            if (this.defaultValue != null ? this.defaultValue.equals(value) : this.defaultValue == value) {
                structure.remove(this.name);
            }
        }
    }

    private static class StructureChangeAdapter
    extends StructureChangeListener {
        private AuditPreferences source;
        private PropertyChangeSupport support;
        private int count;

        public StructureChangeAdapter(AuditPreferences source) {
            this.source = source;
            this.support = new PropertyChangeSupport(source);
        }

        public void structureValuesChanged(StructureChangeEvent event) {
            for (ChangeInfo change : event.getChangeDetails()) {
                if (change.getChangeType() == 2) continue;
                String propertyName = change.getPropertyLocalName();
                PropertyAdapter adapter = propertyAdapters.get(propertyName);
                Object oldValue = adapter.getOldValue(change);
                Object newValue = adapter.getNewValue(change);
                LOG.trace("firing {0} changed from {1} to {2} on {3}", (Object)propertyName, oldValue, newValue, (Object)this.source);
                this.support.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
            ++this.count;
        }

        public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(propertyName, listener);
            ++this.count;
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
            --this.count;
        }

        public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(propertyName, listener);
            --this.count;
        }

        public boolean equals(Object that) {
            return super.equals(that);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.count + (this.count == 1 ? " listener" : " listeners");
        }
    }

    private static class BooleanPropertyAdapter
    extends PropertyAdapter<Boolean> {
        private BooleanPropertyAdapter(String name, Boolean defaultValue) {
            super(name, defaultValue);
        }

        @Override
        Boolean getValue(HashStructure structure) {
            return structure.getBoolean(this.getName(), ((Boolean)this.getDefaultValue()).booleanValue());
        }

        @Override
        void setValue(HashStructure structure, Boolean value) {
            structure.putBoolean(this.getName(), value.booleanValue());
        }

        @Override
        Boolean getOldValue(ChangeInfo info) {
            return info.getOldValueAsBoolean();
        }

        @Override
        Boolean getNewValue(ChangeInfo info) {
            return info.getNewValueAsBoolean();
        }
    }

    private static class StringPropertyAdapter
    extends PropertyAdapter<String> {
        private StringPropertyAdapter(String name, String defaultValue) {
            super(name, defaultValue);
        }

        @Override
        String getValue(HashStructure structure) {
            return structure.getString(this.getName(), (String)this.getDefaultValue());
        }

        @Override
        void setValue(HashStructure structure, String value) {
            structure.putString(this.getName(), value);
        }

        @Override
        String getOldValue(ChangeInfo info) {
            return info.getOldValueAsString();
        }

        @Override
        String getNewValue(ChangeInfo info) {
            return info.getNewValueAsString();
        }
    }

    private static class IntegerPropertyAdapter
    extends PropertyAdapter<Integer> {
        private IntegerPropertyAdapter(String name, Integer defaultValue) {
            super(name, defaultValue);
        }

        @Override
        Integer getValue(HashStructure structure) {
            return structure.getInt(this.getName(), ((Integer)this.getDefaultValue()).intValue());
        }

        @Override
        void setValue(HashStructure structure, Integer value) {
            structure.putInt(this.getName(), value.intValue());
        }

        @Override
        Integer getOldValue(ChangeInfo info) {
            return info.getOldValueAsInt();
        }

        @Override
        Integer getNewValue(ChangeInfo info) {
            return info.getNewValueAsInt();
        }
    }

    private static class FloatPropertyAdapter
    extends PropertyAdapter<Float> {
        private FloatPropertyAdapter(String name, Float defaultValue) {
            super(name, defaultValue);
        }

        @Override
        Float getValue(HashStructure structure) {
            return Float.valueOf(structure.getFloat(this.getName(), ((Float)this.getDefaultValue()).floatValue()));
        }

        @Override
        void setValue(HashStructure structure, Float value) {
            structure.putFloat(this.getName(), value.floatValue());
        }

        @Override
        Float getOldValue(ChangeInfo info) {
            return Float.valueOf(info.getOldValueAsFloat());
        }

        @Override
        Float getNewValue(ChangeInfo info) {
            return Float.valueOf(info.getNewValueAsFloat());
        }
    }
}

