/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdeveloper.audit.model.ContentRootFactory;
import oracle.jdevimpl.audit.model.DefaultContentRoot;

public final class ApplicationContentRootFactory
implements ContentRootFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getWorkspaceRoots(Workspace workspace, IntersectedFilters applicationContentFilters, IntersectedFilters auxiliaryContentFilters, Collection<ContentRoot> roots) {
        HashMap<String, ContentSetProviderReference> providers = new HashMap<String, ContentSetProviderReference>();
        for (ContentSetProviderReference provider : ApplicationContent.getContentSetProviderReferences()) {
            if (!provider.applicationLevelContent()) continue;
            providers.put(provider.key(), provider);
        }
        ApplicationContent content = ApplicationContent.getInstance((PropertyStorage)workspace);
        ListStructure contentSetList = content.getContentSetList();
        Object object = contentSetList.iteratorLock();
        synchronized (object) {
            for (Object o : contentSetList) {
                Object label;
                if (o == null) continue;
                String key = o.toString();
                ContentSetProviderReference provider = (ContentSetProviderReference)providers.get(key);
                Object object2 = label = provider == null ? null : provider.label();
                if (label == null) {
                    int slash = key.lastIndexOf(47);
                    label = slash + 1 < key.length() ? "<" + key.substring(slash + 1) + ">" : "<" + key.substring(0, slash) + ">";
                }
                LinkedList<ContentSet> queue = new LinkedList<ContentSet>();
                ContentSet contentSet = content.getContentSet(key);
                queue.add(contentSet);
                while (!queue.isEmpty()) {
                    ContentSet set = (ContentSet)queue.remove();
                    PatternFilters rootFilters = set.getPatternFilters();
                    URLPath path = set.getURLPath();
                    Object object3 = path.iteratorLock();
                    synchronized (object3) {
                        for (URL url : path) {
                            roots.add(new DefaultContentRoot(url, ContentRoot.WORKSPACE, key, (String)label, provider == null ? false : provider.canContainJavaSources(), applicationContentFilters.intersectWith(rootFilters)));
                        }
                    }
                    int count = set.countContentSets();
                    for (int n = 0; n < count; ++n) {
                        queue.add(set.getContentSet(n));
                    }
                }
            }
        }
    }

    @Override
    public void getProjectRoots(Workspace workspace, Project project, IntersectedFilters projectContentFilters, IntersectedFilters auxiliaryContentFilters, Collection<ContentRoot> roots) {
    }
}

