/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;

public class PatternFilter
extends AuditModelFilter {
    public static final Kind NAME = Kind.NAME;
    public static final Kind PACKAGE = Kind.PACKAGE;
    public static final Kind PATH = Kind.PATH;
    public static final Kind MESSAGE = Kind.MESSAGE;
    private String kindKey;
    private String textKey;
    private Kind kind = Kind.NAME;
    private String text = "";
    private Matcher matcher;

    public PatternFilter() {
    }

    public PatternFilter(String persistenceKey) {
        this.kindKey = persistenceKey + ".kind";
        this.textKey = persistenceKey + ".text";
        this.kind = (Kind)((Object)Cache.get(this.kindKey, (Object)this.kind));
        this.text = (String)Cache.get(this.textKey, this.text);
    }

    public void setKind(Kind kind) {
        if (kind == null) {
            throw new NullArgumentException("type == null");
        }
        this.kind = kind;
        this.matcher = null;
        if (this.kindKey != null) {
            Cache.put(this.kindKey, (Object)kind);
        }
        if (!this.text.isEmpty()) {
            this.fireStateChanged();
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.matcher = null;
        if (this.textKey != null) {
            Cache.put(this.textKey, text);
        }
        this.fireStateChanged();
    }

    public String getText() {
        return this.text;
    }

    public void setAll(Kind type, String text) {
        boolean textChanged;
        if (type == null) {
            throw new NullArgumentException("type == null");
        }
        if (text == null) {
            text = "";
        }
        boolean typeChanged = type != this.kind;
        boolean bl = textChanged = !text.equals(this.text);
        if (!typeChanged && !textChanged) {
            return;
        }
        if (typeChanged) {
            this.kind = type;
            if (this.kindKey != null) {
                Cache.put(this.kindKey, text);
            }
        }
        if (textChanged) {
            this.text = text;
            if (this.textKey != null) {
                Cache.put(this.textKey, text);
            }
        }
        this.matcher = null;
        if (textChanged || !text.isEmpty()) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isVisible(Object object) {
        if (this.text.isEmpty()) {
            return true;
        }
        Location location = this.getModel().getLocation(object);
        if (location == null) {
            return true;
        }
        switch (this.kind) {
            case NAME: {
                return this.isVisible(URLFileSystem.getFileName((URL)location.getModel().getUrl()));
            }
            case PACKAGE: {
                ContentDirectory directory = location.getModel().getDirectory();
                return directory == null || this.isVisible(directory.getRelativePath());
            }
            case PATH: {
                ModelAdapter model = location.getModel();
                ContentDirectory directory = model.getDirectory();
                return directory == null || this.isVisible(directory.getRelativePath() + "/" + URLFileSystem.getFileName((URL)model.getUrl()));
            }
            case MESSAGE: {
                Violation violation = this.getModel().getViolation(object);
                return violation == null || this.isVisible(violation.getMessage());
            }
        }
        throw new IllegalStateException("type = " + this.kind);
    }

    public boolean isVisible(String name) {
        if (this.matcher != null) {
            this.matcher.reset(name);
        } else {
            StringBuilder builder = new StringBuilder();
            int flags = 0;
            switch (this.kind) {
                case NAME: {
                    block26: for (int j = 0; j < this.text.length(); ++j) {
                        char c = this.text.charAt(j);
                        switch (c) {
                            case '*': {
                                builder.append(".*");
                                continue block26;
                            }
                            case '?': {
                                builder.append('.');
                                continue block26;
                            }
                            case '.': {
                                builder.append("\\.");
                                continue block26;
                            }
                            case '\\': {
                                if (j + 1 < this.text.length()) {
                                    builder.append('\\').append(this.text.charAt(++j));
                                    continue block26;
                                }
                                builder.append('\\');
                                continue block26;
                            }
                            default: {
                                builder.append(c);
                            }
                        }
                    }
                    builder.append(".*");
                    break;
                }
                case PACKAGE: {
                    block27: for (int j = 0; j < this.text.length(); ++j) {
                        char c = this.text.charAt(j);
                        switch (c) {
                            case '*': {
                                builder.append(".*");
                                continue block27;
                            }
                            case '?': {
                                builder.append('.');
                                continue block27;
                            }
                            case '.': {
                                builder.append("/");
                                continue block27;
                            }
                            case '$': 
                            case '(': 
                            case ')': 
                            case '+': 
                            case '[': 
                            case ']': 
                            case '^': 
                            case '{': 
                            case '}': {
                                builder.append('\\').append(c);
                                continue block27;
                            }
                            case '\\': {
                                if (j + 1 < this.text.length()) {
                                    builder.append('\\').append(this.text.charAt(++j));
                                    continue block27;
                                }
                                builder.append('\\');
                                continue block27;
                            }
                            default: {
                                builder.append(c);
                            }
                        }
                    }
                    break;
                }
                case PATH: {
                    boolean isSegment = true;
                    boolean isContinuation = false;
                    int index = 0;
                    int size = this.text.length();
                    while (index < size) {
                        boolean willBeSegment = false;
                        boolean willBeContinuation = false;
                        char c = this.text.charAt(index++);
                        switch (c) {
                            case '?': {
                                builder.append('.');
                                break;
                            }
                            case '\\': {
                                if (File.separatorChar != '\\') {
                                    if (index < size) {
                                        builder.append('\\').append(this.text.charAt(index++));
                                        break;
                                    }
                                    builder.append('\\');
                                    break;
                                }
                            }
                            case '/': {
                                if (index == size) {
                                    builder.append("(?:/.*)?");
                                    break;
                                }
                                builder.append('/');
                                willBeSegment = true;
                                break;
                            }
                            case '*': {
                                int last;
                                int count = 1;
                                while (index < size && this.text.charAt(index) == '*') {
                                    ++index;
                                    ++count;
                                }
                                if (isSegment && count == 2 && index < size && this.isSeparator(this.text.charAt(index))) {
                                    assert (!isContinuation) : "continuation, pattern " + this.text.substring(0, index) + "!" + this.text.substring(index) + "\"\"\", builder " + builder + "\"";
                                    ++index;
                                    while (this.text.regionMatches(index, "**/", 0, 3)) {
                                        index += 3;
                                    }
                                    if (builder.length() != 0) {
                                        last = builder.length() - 1;
                                        assert (builder.charAt(last) == '/') : "segment, pattern " + this.text.substring(0, index) + "!" + this.text.substring(index) + "\"\"\", builder " + builder + "\"";
                                        builder.setLength(last);
                                    }
                                    if (index < size) {
                                        builder.append("(?:.*/)?");
                                    } else {
                                        builder.append(".*");
                                    }
                                    willBeContinuation = true;
                                    break;
                                }
                                if (isSegment && count == 2 && index == size) {
                                    assert (!isContinuation) : "continuation, pattern " + this.text.substring(0, index) + "!" + this.text.substring(index) + "\"\"\", builder " + builder + "\"";
                                    if (builder.length() != 0) {
                                        last = builder.length() - 1;
                                        assert (builder.charAt(last) == '/') : "segment, pattern " + this.text.substring(0, index) + "!" + this.text.substring(index) + "\"\"\", builder " + builder + "\"";
                                        builder.setLength(last);
                                        builder.append("(?:/.*)?");
                                        break;
                                    }
                                    builder.append(".*");
                                    break;
                                }
                                builder.append("[^/]*");
                                break;
                            }
                            case '$': 
                            case '(': 
                            case ')': 
                            case '+': 
                            case '.': 
                            case '[': 
                            case ']': 
                            case '^': 
                            case '{': 
                            case '}': {
                                builder.append('\\').append(c);
                                break;
                            }
                            default: {
                                builder.append(c);
                            }
                        }
                        isSegment = willBeSegment;
                        isContinuation = willBeContinuation;
                    }
                    break;
                }
                case MESSAGE: {
                    builder.append("\\b").append(Pattern.quote(this.text));
                    flags = 2;
                }
            }
            this.matcher = Pattern.compile(builder.toString()).matcher(name);
        }
        return this.matcher.matches();
    }

    private boolean isSeparator(char c) {
        return c == '/' || c == File.separatorChar;
    }

    public String toString() {
        return this.getKind() + ":\"" + this.getText() + "\"->" + (String)(this.matcher != null ? "\"" + this.matcher.pattern() + "\"" : "null");
    }

    public static enum Kind {
        NAME,
        PACKAGE,
        PATH,
        MESSAGE;

    }
}

