/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class HierarchyFilter
extends AuditModelFilter {
    private static final boolean DEFAULT_HIERARCHY = true;
    private static final boolean DEFAULT_EMPTY_HIERARCHY = false;
    private boolean hierarchy;
    private boolean emptyHierarchy;
    private final ModelTypeFactory factory;
    private List<ModelType> modelTypes = Collections.emptyList();
    private final Map<Class<?>, Boolean> visibilityByPresentationType = new LinkedHashMap();
    private final Map<Class<?>, ModelType> modelTypeByPresentationType = new LinkedHashMap();
    private final String hierarchyKey;
    private final String emptyHierarchyKey;
    private final String typesKey;
    private static final Log LOG = new Log("typefilter");

    public HierarchyFilter() {
        this(null, AuditManager.getAuditManager().getDefaultModelTypeFactory(), true, false);
    }

    public HierarchyFilter(boolean hierarchy, boolean emptyHierarchy) {
        this(null, AuditManager.getAuditManager().getDefaultModelTypeFactory(), hierarchy, emptyHierarchy);
    }

    public HierarchyFilter(String persistenceKey) {
        this(persistenceKey, AuditManager.getAuditManager().getDefaultModelTypeFactory(), true, false);
    }

    public HierarchyFilter(String persistenceKey, ModelTypeFactory factory, boolean hierarchy, boolean emptyHierarchy) {
        if (persistenceKey != null) {
            this.hierarchyKey = persistenceKey + ".hierarchy";
            this.emptyHierarchyKey = persistenceKey + ".empty-hierarchy";
            this.typesKey = persistenceKey + ".types";
        } else {
            this.typesKey = null;
            this.emptyHierarchyKey = null;
            this.hierarchyKey = null;
        }
        this.hierarchy = Cache.get(this.hierarchyKey, hierarchy);
        this.emptyHierarchy = Cache.get(this.emptyHierarchyKey, emptyHierarchy);
        this.factory = factory;
        this.visibilityByPresentationType.put(Violation.class, Boolean.TRUE);
        this.load();
    }

    public void setHierarchy(boolean hierarchy) {
        if (hierarchy == this.hierarchy) {
            return;
        }
        this.hierarchy = hierarchy;
        Cache.put(this.hierarchyKey, hierarchy);
        this.fireStateChanged();
    }

    public void setEmptyHierarchy(boolean emptyHierarchy) {
        if (emptyHierarchy == this.emptyHierarchy) {
            return;
        }
        this.emptyHierarchy = emptyHierarchy;
        Cache.put(this.emptyHierarchyKey, emptyHierarchy);
        this.fireStateChanged();
    }

    public boolean isHierarchy() {
        return this.hierarchy;
    }

    public boolean isEmptyHierarchy() {
        return this.emptyHierarchy;
    }

    @Override
    public boolean isVisible(Object object) {
        AuditModel model = this.getModel();
        return model.isViolation(object) || this.hierarchy && this.isVisible(model.getType(object)) && (this.emptyHierarchy || model.isOutOfBand(object) || model.getCount(object, AuditModel.Count.VISIBLE_ISSUES) != 0 || model.getCount(object, AuditModel.Count.VISIBLE_OUT_OF_BANDS) != 0);
    }

    public synchronized void setTypeVisibility(Class<?> type, boolean visible) {
        this.setAll(this.hierarchy, this.emptyHierarchy, Collections.singletonMap(type, visible));
    }

    public synchronized void setTypeVisibilities(Map<Class<?>, Boolean> visibilities) {
        this.setAll(this.hierarchy, this.emptyHierarchy, visibilities);
    }

    public synchronized void setAll(boolean hierarchy, boolean emptyHierarchy, Map<Class<?>, Boolean> visibilities) {
        boolean emptyHierarchyChanged;
        boolean hierarchyChanged;
        boolean bl = hierarchyChanged = hierarchy != this.hierarchy;
        if (hierarchyChanged) {
            this.hierarchy = hierarchy;
            Cache.put(this.hierarchyKey, hierarchy);
        }
        boolean bl2 = emptyHierarchyChanged = emptyHierarchy != this.emptyHierarchy;
        if (emptyHierarchyChanged) {
            this.emptyHierarchy = emptyHierarchy;
            Cache.put(this.emptyHierarchyKey, hierarchy);
        }
        this.load();
        HashSet<ModelType> changedModelTypes = new HashSet<ModelType>();
        for (Map.Entry<Class<?>, Boolean> entry : visibilities.entrySet()) {
            Class<?> type = entry.getKey();
            boolean visible = entry.getValue();
            assert (this.visibilityByPresentationType.containsKey(type));
            if (visible == this.visibilityByPresentationType.put(type, visible)) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(type));
        }
        if (!changedModelTypes.isEmpty()) {
            for (ModelType changedModelType : changedModelTypes) {
                this.write(changedModelType);
            }
        }
        if (hierarchyChanged || hierarchy && (emptyHierarchyChanged || !changedModelTypes.isEmpty())) {
            this.fireStateChanged();
        }
    }

    public void setVisibleTypes(Class<?> ... types) {
        this.load();
        HashSet invisibleTypes = new HashSet(this.visibilityByPresentationType.keySet());
        invisibleTypes.remove(Violation.class);
        HashSet<ModelType> changedModelTypes = new HashSet<ModelType>();
        for (Class<?> type : types) {
            assert (this.visibilityByPresentationType.containsKey(type));
            invisibleTypes.remove(type);
            Boolean wasVisible = this.visibilityByPresentationType.put(type, Boolean.TRUE);
            if (wasVisible == Boolean.TRUE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(type));
        }
        for (Class clazz : invisibleTypes) {
            assert (this.visibilityByPresentationType.containsKey(clazz));
            Boolean wasVisible = this.visibilityByPresentationType.put(clazz, Boolean.FALSE);
            if (wasVisible == Boolean.FALSE) continue;
            changedModelTypes.add(this.modelTypeByPresentationType.get(clazz));
        }
        if (!changedModelTypes.isEmpty()) {
            for (ModelType modelType : changedModelTypes) {
                this.write(modelType);
            }
            if (this.hierarchy) {
                this.fireStateChanged();
            }
        }
    }

    synchronized boolean isVisible(Class<?> type) {
        Boolean visible = this.visibilityByPresentationType.get(type);
        if (visible == null) {
            LOG.trace("unrecognized type {0}", type);
            this.reload();
            visible = this.visibilityByPresentationType.get(type);
            LOG.trace("type {0} visibility after reload: {1}", type, (Object)visible);
        }
        return visible == Boolean.TRUE;
    }

    public Collection<ModelType> getModelTypes() {
        this.load();
        return this.modelTypes;
    }

    public ModelType getModelType(Class<?> type) {
        this.load();
        return this.modelTypeByPresentationType.get(type);
    }

    public String getLabel(Class<?> type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).label(type);
    }

    public String getSummary(Class<?> type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).summary(type);
    }

    public Icon getIcon(Class<?> type) {
        this.load();
        return this.modelTypeByPresentationType.get(type).icon(type);
    }

    private Collection<String> read(ModelType type) {
        if (this.typesKey == null) {
            return null;
        }
        return (Collection)Cache.get(this.getModelTypeKey(type));
    }

    private void write(ModelType modelType) {
        if (this.typesKey == null) {
            return;
        }
        Collection<Class<?>> types = modelType.getPresentationTypes();
        ArrayList<String> visibleTypes = new ArrayList<String>();
        for (Class<?> type : types) {
            if (!this.isVisible(type)) continue;
            visibleTypes.add(type.getName());
        }
        String key = this.getModelTypeKey(modelType);
        Cache.put(key, visibleTypes);
        LOG.trace("wrote type filter cache {0} to {1}", (Object)key, visibleTypes);
    }

    private String getModelTypeKey(ModelType modelType) {
        if (this.typesKey == null) {
            return null;
        }
        return this.typesKey + "." + Strings.removeSuffix(Strings.lastToken(modelType.getClass().getName(), '.'), "Type").toLowerCase();
    }

    private void load() {
        if (this.modelTypes.isEmpty()) {
            this.reload();
        }
    }

    private void reload() {
        int oldSize = this.modelTypes.size();
        this.modelTypes = this.factory.getModelTypes();
        int newSize = this.modelTypes.size();
        for (int i = oldSize; i < newSize; ++i) {
            ModelType modelType = this.modelTypes.get(i);
            LOG.trace("loading model type {0}", (Object)modelType);
            Collection<Class<?>> allTypes = modelType.getPresentationTypes();
            if (allTypes == null) continue;
            Collection<String> names = this.read(modelType);
            if (names != null) {
                for (Class<?> type : allTypes) {
                    this.modelTypeByPresentationType.put(type, modelType);
                    this.visibilityByPresentationType.put(type, names.contains(type.getName()));
                }
                continue;
            }
            for (Class<?> type : allTypes) {
                this.modelTypeByPresentationType.put(type, modelType);
                this.visibilityByPresentationType.put(type, Boolean.FALSE);
            }
            Collection<Class<?>> visibleTypes = modelType.getDefaultPresentationTypes();
            if (visibleTypes == null) continue;
            for (Class<?> type : visibleTypes) {
                this.visibilityByPresentationType.put(type, Boolean.TRUE);
            }
        }
    }
}

