/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.IdeConstants;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.PolygonIcon;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModelAdapter;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.AuditTreeTableModel;
import oracle.jdevimpl.audit.swing.RowTableTransferHandler;

public class AuditTreeTable
extends JFastTreeTable
implements Peekable,
MouseListener,
TreeExpansionListener,
TreeWillExpandListener {
    private AuditTreeTableModel model;
    private AuditTreeTableColumn[] columns;
    private Set<Object> hiddenColumnIds;
    private RowActionListener rowActionListener;
    private boolean peeking = false;
    private static final ViewTransferHandler TRANSFER_HANDLER = new ViewTransferHandler();
    private static final Log LOG = new Log("treetable");
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final Object[] NO_SELECTION = new Object[0];

    public AuditTreeTable(AuditTreeTableModel model) {
        super((TreeTableModel)model);
        this.model = model;
        this.setTransferHandler(TRANSFER_HANDLER);
        this.addMouseListener(this);
        TreeTableModelAdapter modelAdapter = (TreeTableModelAdapter)this.getModel();
        modelAdapter.setCoalescingEnabled(true);
        model.setTableModel(modelAdapter);
        JTree tree = this.getTree();
        model.setComponents(this, tree);
        tree.setRootVisible(true);
        tree.setLargeModel(true);
        tree.setShowsRootHandles(false);
        tree.addTreeExpansionListener(this);
        tree.addTreeWillExpandListener(this);
        tree.setScrollsOnExpand(true);
        JTableHeader header = this.getTableHeader();
        TreeRenderer treeRenderer = new TreeRenderer(header.getForeground(), header.getBackground());
        tree.setCellRenderer(treeRenderer);
        header.setBorder(null);
        header.addMouseListener(this);
        this.setBorder(null);
    }

    public AuditTreeTableModel getTreeTableModel() {
        return this.model;
    }

    public JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent event) {
                int viewColumn = this.columnAtPoint(event.getPoint());
                if (viewColumn < 0) {
                    return null;
                }
                int modelColumn = this.getColumnModel().getColumn(viewColumn).getModelIndex();
                if (modelColumn < 0) {
                    return null;
                }
                if (modelColumn == 0) {
                    return BUNDLE.get("column.construct.tip");
                }
                return AuditTreeTable.this.getTreeTableModel().getModel().getColumn(modelColumn).label();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                LOG.trace("removing column {0}", e.getFromIndex());
                super.columnRemoved(e);
                TableColumn column = this.getDraggedColumn();
                if (column != null && this.viewIndexForColumn(this.draggedColumn) < 0) {
                    this.setDraggedColumn(null);
                    this.setDraggedDistance(0);
                }
            }

            private int viewIndexForColumn(TableColumn column) {
                TableColumnModel model = this.getColumnModel();
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    if (model.getColumn(i) != column) continue;
                    return i;
                }
                return -1;
            }
        };
    }

    public void createDefaultColumnsFromModel() {
        LOG.trace("creating new columns from model");
        TreeTableModel treeTableModel = this.getTreeModel();
        if (treeTableModel == null || this.columns != null) {
            return;
        }
        int LEFT = -this.getFont().getSize() / 2;
        boolean CENTER = false;
        int RIGHT = -LEFT;
        AuditModel model = ((AuditTreeTableModel)treeTableModel).getModel();
        TableColumnModel columnModel = this.getColumnModel();
        this.columns = new AuditTreeTableColumn[model.getColumnCount()];
        this.hiddenColumnIds = new HashSet<Object>();
        JTableHeader header = this.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = header.getDefaultRenderer();
        Color headerForeground = header.getForeground();
        Color headerBackground = header.getBackground();
        AuditTreeTableColumn column = new AuditTreeTableColumn();
        column.setModelIndex(0);
        column.setIdentifier(null);
        String label = BUNDLE.get("column.construct.label");
        column.setHeaderValue(label);
        column.setHeaderRenderer(new TableHeaderRenderer(model, defaultHeaderRenderer, LEFT));
        column.setActionLabel(label);
        column.setMinWidth(60);
        column.setWidth(120);
        column.setPreferredWidth(this.getToolkit().getScreenSize().width);
        column.setCellRenderer(new TableRenderer((TableCellRenderer)((Object)this.getTree()), headerForeground, headerBackground, LEFT));
        this.columns[0] = column;
        columnModel.addColumn(column);
        for (int i = 1; i < model.getColumnCount(); ++i) {
            Metric metric = model.getColumn(i);
            String id = metric.id();
            label = metric.label();
            String shortLabel = metric.shortLabel();
            Class<?> type = metric.getType();
            int alignment = Number.class.isAssignableFrom(type) ? RIGHT : (Boolean.class.isAssignableFrom(type) ? 0 : LEFT);
            column = new AuditTreeTableColumn();
            column.setModelIndex(i);
            column.setIdentifier(id);
            column.setHeaderValue(shortLabel);
            column.setHeaderRenderer(new TableHeaderRenderer(model, defaultHeaderRenderer, alignment));
            column.setActionLabel(label);
            column.setMinWidth(50);
            column.setWidth(120);
            column.setPreferredWidth(120);
            column.setCellRenderer(new TableRenderer(this.getDefaultRenderer(type), headerForeground, headerBackground, alignment));
            this.columns[i] = column;
            if (metric.isEnabled()) {
                columnModel.addColumn(column);
                continue;
            }
            this.hiddenColumnIds.add(id);
        }
    }

    public Object[] getSelectedObjects() {
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths == null) {
            return NO_SELECTION;
        }
        Object[] selection = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            selection[i] = paths[i].getLastPathComponent();
        }
        return selection;
    }

    public void addRowSelectionListener(TreeSelectionListener listener) {
        this.getTree().addTreeSelectionListener(listener);
    }

    public void removeRowSelectionListener(TreeSelectionListener listener) {
        this.getTree().removeTreeSelectionListener(listener);
    }

    public void addRowActionListener(RowActionListener listener) {
        if (this.rowActionListener != null) {
            throw new IllegalStateException("row action listener already added");
        }
        this.rowActionListener = listener;
    }

    public void removeRowActionListener(RowActionListener listener) {
        this.rowActionListener = null;
    }

    public void toggleRow(int row) {
        JTree tree = this.getTree();
        if (tree.isCollapsed(row)) {
            tree.expandRow(row);
        } else {
            tree.collapseRow(row);
        }
    }

    public void expandAll() {
        JTree tree = this.getTree();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public void collapseAll() {
        this.model.fireTreeStructureChanged(this.model, new TreePath(this.model.getRoot()));
    }

    public void paint(Graphics g) {
        this.paintUnoptimized(g);
    }

    public void processMouseEvent(MouseEvent event) {
        int row;
        if (event.isPopupTrigger() && (row = this.rowAtPoint(event.getPoint())) >= 0 && !this.isRowSelected(row)) {
            this.setRowSelectionInterval(row, row);
        }
        super.processMouseEvent(event);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        Object object = event.getPath().getLastPathComponent();
        LOG.trace("tree collapsed at {0}", object);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Object object = event.getPath().getLastPathComponent();
        LOG.trace("tree expanded at {0}", object);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath object = event.getPath();
        LOG.trace("tree will collapse at {0}", (Object)object);
        if (object.getPathCount() <= 1) {
            throw new ExpandVetoException(event);
        }
    }

    public String getToolTipText() {
        if (this.peeking) {
            return null;
        }
        return super.getToolTipText();
    }

    public String getToolTipText(MouseEvent event) {
        if (this.peeking) {
            return null;
        }
        Point point = event.getPoint();
        int viewColumn = this.columnAtPoint(point);
        int row = this.rowAtPoint(point);
        if (viewColumn == -1 || row == -1) {
            return null;
        }
        int modelColumn = this.convertColumnIndexToModel(viewColumn);
        Object value = this.getValueAt(row, this.convertColumnIndexToView(0));
        AuditModel model = this.model.getModel();
        if (modelColumn > 0) {
            return String.valueOf(model.getValue(value, modelColumn));
        }
        try {
            return value == model.getRoot() ? AuditTreeTable.rootSummary(model, value) : model.getSummary(value);
        }
        catch (ModelAccessError e) {
            return e.getMessage();
        }
        catch (CancellationException e) {
            return null;
        }
        catch (ExpiredTextBufferException e) {
            return null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            int columnNumber;
            if (e.getSource() == this) {
                int column;
                int row;
                if (e.getClickCount() == 2 && (row = this.rowAtPoint(e.getPoint())) >= 0 && ((column = this.convertColumnIndexToModel(this.columnAtPoint(e.getPoint()))) > 0 || column == 0 && this.tree.getRowBounds(row).contains(e.getPoint()))) {
                    this.rowActionListener.rowActionPerformed(this, row);
                }
            } else if (e.getClickCount() == 1 && (columnNumber = this.convertColumnIndexToModel(this.columnAtPoint(e.getPoint()))) >= 0) {
                this.model.getModel().setSortColumn(columnNumber);
                ((JTableHeader)e.getSource()).repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            MenuUtils.showPopupMenu((JPopupMenu)this.columnVisibilityPopupMenu(), (Component)this.getTableHeader(), (int)e.getX(), (int)e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            MenuUtils.showPopupMenu((JPopupMenu)this.columnVisibilityPopupMenu(), (Component)this.getTableHeader(), (int)e.getX(), (int)e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Peek peek(Point p) {
        Peek peek;
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
        int row = this.rowAtPoint(p);
        int col = this.columnAtPoint(p);
        if (this.getCellRect(row, col, false).contains(p) && (peek = this.createPeek(row, col)) != null) {
            peek.showPeek();
            if (this.getCellRenderer(row, col) instanceof JComponent) {
                ((JComponent)((Object)this.getCellRenderer(row, col))).setToolTipText(null);
            }
            this.peeking = true;
            peek.getGhostPointingPalette().addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    peek.getGhostPointingPalette().removeAncestorListener((AncestorListener)this);
                    AuditTreeTable.this.peeking = false;
                }
            });
            return peek;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peek createPeek(int row, int col) {
        Object value = this.getValueAt(row, this.convertColumnIndexToView(0));
        AuditModel aModel = this.model.getModel();
        Location location = aModel.getFocusLocation(value);
        if (location == null) {
            location = aModel.getLocation(value);
        }
        if (location != null) {
            int line = -1;
            try {
                location.getModel().beginRead();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            try {
                line = location.getModel().getLineOffset(location.getOffset());
            }
            finally {
                location.getModel().endRead();
            }
            if (line > 0) {
                int pad = 4;
                String text = PeekHelper.getPeekText((URL)location.getModel().getUrl(), (int)line, (int)pad);
                if (text != null) {
                    Rectangle rect = this.getCellRect(row, 0, true);
                    rect.add(this.getCellRect(row, this.getColumnCount(), true));
                    rect = rect.intersection(this.getVisibleRect());
                    CodePeek peek = PeekHelper.createCodePeek((JComponent)((Object)this), (String)location.getModel().getUrl().getFile(), (String)text, (String)URLFileSystem.getFileName((URL)location.getModel().getUrl()), (Rectangle)rect);
                    if (peek != null) {
                        int hiLine = line < pad ? line : pad;
                        PeekHelper.addHighlight((CodePeek)peek, (int)hiLine, (String)"caret-line-highlight");
                        return peek;
                    }
                }
            }
        }
        return null;
    }

    private static String label(AuditModel model, Object value) {
        String text;
        try {
            text = value == model.getRoot() ? AuditTreeTable.rootSummary(model, value) : model.getLabel(value);
        }
        catch (ModelAccessError e) {
            text = e.getMessage();
        }
        catch (CancellationException e) {
            text = "...";
        }
        catch (ExpiredTextBufferException e) {
            text = "...";
        }
        return text;
    }

    private static String rootSummary(AuditModel model, Object row) {
        return BUNDLE.get("results.summary.label", new Object[]{model.getLabel(row), AuditTreeTable.text(model, "documents", AuditModel.Count.FILES, AuditModel.Count.VISIBLE_FILES), AuditTreeTable.text(model, "issues", AuditModel.Count.ISSUES, AuditModel.Count.VISIBLE_ISSUES)});
    }

    private static String text(AuditModel model, String prefix, AuditModel.Count totalName, AuditModel.Count visibleName) {
        Object root = model.getRoot();
        int total = model.getCount(root, totalName);
        int visible = model.getCount(root, visibleName);
        StringBuffer key = new StringBuffer(prefix);
        key.append('-');
        key.append((char)(total == 0 ? 48 : (total == 1 ? 49 : 110)));
        if (total > visible) {
            key.append('-');
            key.append((char)(visible == 0 ? 48 : (visible == 1 ? 49 : 110)));
        }
        return BUNDLE.get(key.toString(), new Object[]{total, visible});
    }

    public JPopupMenu columnVisibilityPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        for (AuditTreeTableColumn column : this.columns) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(column);
            item.setSelected(!this.hiddenColumnIds.contains(column.getIdentifier()));
            popup.add(item);
        }
        return popup;
    }

    private static class ViewTransferHandler
    extends RowTableTransferHandler {
        private ViewTransferHandler() {
        }

        @Override
        protected Object getRowValue(JTable table, int row) {
            Object value = super.getRowValue(table, row);
            AuditModel model = ((AuditTreeTable)((Object)table)).getTreeTableModel().getModel();
            return AuditTreeTable.label(model, value);
        }
    }

    private static class TreeRenderer
    extends DefaultTreeCellRenderer {
        private Color summaryForeground;
        private Color summaryBackground;
        private Color defaultBackground;
        private Color defaultSelectedBackground;

        public TreeRenderer(Color foreground, Color background) {
            this.summaryBackground = background;
            this.summaryForeground = foreground;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AuditTreeTableModel treeTableModel = (AuditTreeTableModel)((Object)tree.getModel());
            AuditModel model = treeTableModel.getModel();
            String text = AuditTreeTable.label(model, value);
            this.selected = selected;
            LOG.trace("rendering {1} at {0} as \"{2}\"", row, value, (Object)text);
            Component component = super.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, hasFocus);
            if (this.defaultBackground == null) {
                this.defaultBackground = this.getBackgroundNonSelectionColor();
                this.defaultSelectedBackground = this.getBackgroundSelectionColor();
            }
            if (component instanceof JLabel) {
                Icon icon;
                JLabel label = (JLabel)component;
                try {
                    icon = model.getIcon(value);
                }
                catch (Exception e) {
                    icon = OracleIcons.getIcon((String)"unknownstatus.png");
                }
                label.setIcon(icon);
            }
            if (row == 0 && !selected) {
                component.setForeground(this.summaryForeground);
                component.setBackground(this.summaryBackground);
                this.setBackgroundNonSelectionColor(this.summaryBackground);
            } else if (selected) {
                component.setForeground(this.getTextSelectionColor());
                component.setBackground(this.defaultSelectedBackground);
                this.setBackgroundSelectionColor(this.defaultSelectedBackground);
            } else {
                component.setForeground(this.getTextNonSelectionColor());
                component.setBackground(this.defaultBackground);
                this.setBackgroundNonSelectionColor(this.defaultBackground);
            }
            return component;
        }

        @Override
        public JToolTip createToolTip() {
            return new MultiLineToolTip();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = Short.MAX_VALUE;
            return size;
        }
    }

    private class AuditTreeTableColumn
    extends TableColumn
    implements Action {
        private String actionLabel;

        private AuditTreeTableColumn() {
        }

        public void setActionLabel(String label) {
            this.actionLabel = label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableColumnModel columnModel = AuditTreeTable.this.getTableHeader().getColumnModel();
            if (AuditTreeTable.this.hiddenColumnIds.contains(this.getIdentifier())) {
                AuditTreeTable.this.hiddenColumnIds.remove(this.getIdentifier());
                columnModel.addColumn(this);
                columnModel.moveColumn(columnModel.getColumnCount() - 1, this.modelIndex);
            } else {
                columnModel.removeColumn(this);
                AuditTreeTable.this.hiddenColumnIds.add(this.getIdentifier());
                if (AuditTreeTable.this.model.getModel().getSortColumn() == this.modelIndex) {
                    AuditTreeTable.this.model.getModel().setSortColumn(0);
                }
            }
        }

        @Override
        public Object getValue(String key) {
            return key == "Name" ? this.actionLabel : null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return this.modelIndex != 0;
        }

        public String toString() {
            return "column " + this.getIdentifier() + " " + this.getModelIndex();
        }
    }

    private static class TableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;
        private AuditModel model;
        private int alignment;
        private Border leftBorder;
        private Border middleBorder;
        private Border rightBorder;
        private static PolygonIcon arrowUp;
        private static PolygonIcon arrowDown;

        public TableHeaderRenderer(AuditModel model, TableCellRenderer renderer, int alignment) {
            this.model = model;
            this.renderer = renderer;
            this.alignment = alignment < 0 ? 2 : (alignment > 0 ? 4 : 0);
            int leftPad = Math.max(2, -alignment);
            int rightPad = Math.max(2, alignment);
            this.leftBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, leftPad, 1, rightPad));
            this.middleBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, leftPad, 1, rightPad));
            this.rightBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, leftPad, 1, rightPad));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int index = table.convertColumnIndexToModel(column);
            Component component = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                Icon icon = null;
                LOG.trace("rendering column {0}, table column {1}, sorter column {2}", index, column, this.model.getSortColumn());
                if (index == this.model.getSortColumn()) {
                    icon = this.model.getSortDirection() > 0 ? this.getSortAscendingIcon() : this.getSortDescendingIcon();
                }
                JLabel label = (JLabel)component;
                label.setHorizontalAlignment(this.alignment);
                label.setIcon(icon);
                if (column == 0) {
                    label.setBorder(this.leftBorder);
                } else if (column < table.getColumnCount() - 1) {
                    label.setBorder(this.middleBorder);
                } else {
                    label.setBorder(this.rightBorder);
                }
            }
            return component;
        }

        protected Icon icon(int direction) {
            return direction > 0 ? this.getSortAscendingIcon() : this.getSortDescendingIcon();
        }

        protected Icon getSortDescendingIcon() {
            if (arrowUp == null) {
                arrowUp = new PolygonIcon();
                arrowUp.addPoint(0, 3);
                arrowUp.addPoint(3, 0);
                arrowUp.addPoint(6, 3);
            }
            return arrowUp;
        }

        protected Icon getSortAscendingIcon() {
            if (arrowDown == null) {
                arrowDown = new PolygonIcon();
                arrowDown.addPoint(0, 0);
                arrowDown.addPoint(3, 3);
                arrowDown.addPoint(6, 0);
            }
            return arrowDown;
        }
    }

    private static class TableRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;
        private Color summaryForeground;
        private Color summaryBackground;
        private AuditTreeTableModel model;
        private int alignment;
        private TripleBorder border;

        public TableRenderer(TableCellRenderer renderer, Color foreground, Color background, int alignment) {
            this.renderer = renderer;
            this.summaryBackground = background;
            this.summaryForeground = foreground;
            this.alignment = alignment < 0 ? 2 : (alignment > 0 ? 4 : 0);
            int leftPad = Math.max(2, -alignment);
            int rightPad = Math.max(2, alignment);
            this.border = new TripleBorder(null, BorderFactory.createEmptyBorder(0, leftPad, 0, rightPad));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            Metric metric;
            AuditModel auditModel;
            if (this.model == null) {
                this.model = (AuditTreeTableModel)((Object)((AuditTreeTable)((Object)table)).getTree().getModel());
            }
            int index = table.convertColumnIndexToModel(column);
            boolean highlight = false;
            if (value != null && index > 0 && (auditModel = this.model.getModel()) != null && (metric = auditModel.getColumn(index)) != null) {
                highlight = metric.isOutOfBand(value);
                value = metric.representation(value);
            }
            Component component = this.renderer.getTableCellRendererComponent(table, value, selected, hasFocus, row, column);
            if (row == 0 && !selected) {
                component.setForeground(highlight ? Color.red : this.summaryForeground);
                component.setBackground(this.summaryBackground);
            } else if (selected) {
                component.setForeground(table.getSelectionForeground());
                component.setBackground(table.getSelectionBackground());
            } else {
                component.setForeground(highlight ? Color.red : table.getForeground());
                component.setBackground(table.getBackground());
            }
            if (highlight) {
                component.setFont(component.getFont().deriveFont(2));
            }
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                this.border.setDynamicBorder(jComponent.getBorder());
                jComponent.setBorder(this.border);
            }
            return component;
        }
    }

    public static interface RowActionListener {
        public void rowActionPerformed(AuditTreeTable var1, int var2);
    }

    public static class TripleBorder
    extends AbstractBorder {
        protected Border dynamicBorder;
        protected Border outsideBorder;
        protected Border insideBorder;

        public TripleBorder(Border outsideBorder, Border insideBorder) {
            this.outsideBorder = outsideBorder;
            this.insideBorder = insideBorder;
        }

        public void setDynamicBorder(Border border) {
            if (border instanceof TripleBorder) {
                this.setDynamicBorder(((TripleBorder)border).getDynamicBorder());
            } else {
                this.dynamicBorder = border;
            }
        }

        public Border getDynamicBorder() {
            return this.dynamicBorder;
        }

        @Override
        public boolean isBorderOpaque() {
            return !(this.outsideBorder != null && !this.outsideBorder.isBorderOpaque() || this.dynamicBorder != null && !this.dynamicBorder.isBorderOpaque() || this.insideBorder != null && !this.insideBorder.isBorderOpaque());
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets nextInsets;
            int px = x;
            int py = y;
            int pw = width;
            int ph = height;
            if (this.outsideBorder != null) {
                this.outsideBorder.paintBorder(c, g, px, py, pw, ph);
                nextInsets = this.outsideBorder.getBorderInsets(c);
                px += nextInsets.left;
                py += nextInsets.top;
                pw = pw - nextInsets.right - nextInsets.left;
                ph = ph - nextInsets.bottom - nextInsets.top;
            }
            if (this.dynamicBorder != null) {
                this.dynamicBorder.paintBorder(c, g, px, py, pw, ph);
                nextInsets = this.dynamicBorder.getBorderInsets(c);
                px += nextInsets.left;
                py += nextInsets.top;
                pw = pw - nextInsets.right - nextInsets.left;
                ph = ph - nextInsets.bottom - nextInsets.top;
            }
            if (this.insideBorder != null) {
                this.insideBorder.paintBorder(c, g, px, py, pw, ph);
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets nextInsets;
            insets.bottom = 0;
            insets.right = 0;
            insets.left = 0;
            insets.top = 0;
            if (this.outsideBorder != null) {
                nextInsets = this.outsideBorder.getBorderInsets(c);
                insets.top += nextInsets.top;
                insets.left += nextInsets.left;
                insets.right += nextInsets.right;
                insets.bottom += nextInsets.bottom;
            }
            if (this.dynamicBorder != null) {
                nextInsets = this.dynamicBorder.getBorderInsets(c);
                insets.top += nextInsets.top;
                insets.left += nextInsets.left;
                insets.right += nextInsets.right;
                insets.bottom += nextInsets.bottom;
            }
            if (this.insideBorder != null) {
                nextInsets = this.insideBorder.getBorderInsets(c);
                insets.top += nextInsets.top;
                insets.left += nextInsets.left;
                insets.right += nextInsets.right;
                insets.bottom += nextInsets.bottom;
            }
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }
    }
}

