/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.ValueHandle;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;
import oracle.jdevimpl.audit.util.XmlWriter;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileReaderWriter {
    private static final ValueHandle ENABLED_TRUE = DefaultProfile.ENABLED_TRUE;
    private static final ValueHandle ENABLED_FALSE = DefaultProfile.ENABLED_FALSE;
    private String version;
    private String id;
    private String name;
    private boolean sealed;
    private MultiMap<String, ValueHandle> delta;
    private static final String FORMAT_VERSION = "12.1.2";
    public static final String SEALED_ID = "oracle.ide.audit.internal.sealed";
    private static final String AUDIT_PROFILE = "audit-profile";
    private static final Log LOG = new Log("audit-profile");
    private URL url;
    private boolean abbreviatedParse;
    private SAXParser parser;
    private Locator locator;
    private final List<String> expected = new ArrayList<String>();
    private int level;
    private static final Object[] MIGRATE_11 = new Object[]{"adffaces-category.adffaces-rule-actionInCmdToolbarBtn", "oracle.adf.faces.actionInCmdToolbarBtn", "adffaces-category.adffaces-rule-afattrtofattr", "oracle.adf.faces.afattrtofattr", "adffaces-category.adffaces-rule-aflongidsonnc", "oracle.adf.faces.aflongidsonnc", "adffaces-category.adffaces-rule-afvalidatortofvalidator", "oracle.adf.faces.afvalidatortofvalidator", "adffaces-category.adffaces-rule-calendarCustomFacetName", "oracle.adf.faces.calendarCustomFacetName", "adffaces-category.adffaces-rule-calendarFacetNameConflict", "oracle.adf.faces.calendarFacetNameConflict", "adffaces-category.adffaces-rule-commandbtnusage", "oracle.adf.faces.commandbtnusage", "adffaces-category.adffaces-rule-deprecatedscopedid", "oracle.adf.faces.deprecatedscopedid", "adffaces-category.adffaces-rule-endswithpercentagestyles", "oracle.adf.faces.endswithpercentagestyles", "adffaces-category.adffaces-rule-facetrefusage1", "oracle.adf.faces.facetrefusage1", "adffaces-category.adffaces-rule-facetrefusage2", "oracle.adf.faces.facetrefusage2", "adffaces-category.adffaces-rule-facetwidthheightstyles", "oracle.adf.faces.facetwidthheightstyles", "adffaces-category.adffaces-rule-heighttopbottomstyles", "oracle.adf.faces.heighttopbottomstyles", "adffaces-category.adffaces-rule-invalidscopedid", "oracle.adf.faces.invalidscopedid", "adffaces-category.adffaces-rule-jspScriptletUsage", "oracle.adf.faces.jspScriptletUsage", "adffaces-category.adffaces-rule-notscopedadffacescomponent", "oracle.adf.faces.notscopedadffacescomponent", "adffaces-category.adffaces-rule-percentageheightrule", "oracle.adf.faces.percentageheightrule", "adffaces-category.adffaces-rule-percentagewidthrule", "oracle.adf.faces.percentagewidthrule", "adffaces-category.adffaces-rule-pglendswithpercentagestyles", "oracle.adf.faces.pglendswithpercentagestyles", "adffaces-category.adffaces-rule-popupInCmdToolbarBtn", "oracle.adf.faces.popupInCmdToolbarBtn", "adffaces-category.adffaces-rule-positionstyles", "oracle.adf.faces.positionstyles", "adffaces-category.adffaces-rule-targetdoesnotsendclientcomponent", "oracle.adf.faces.targetdoesnotsendclientcomponent", "adffaces-category.adffaces-rule-targetnotcollectioncomponent", "oracle.adf.faces.targetnotcollectioncomponent", "adffaces-category.adffaces-rule-targetnotpopup", "oracle.adf.faces.targetnotpopup", "adffaces-category.adffaces-rule-usesuploadwithinputfile", "oracle.adf.faces.usesuploadwithinputfile", "adffaces-category.adffaces-rule-varusage", "oracle.adf.faces.varusage", "adffaces-category.adffaces-rule-verbatimScript", "oracle.adf.faces.verbatimScript", "adffaces-category.adffaces-rule-verbatimUsage", "oracle.adf.faces.verbatimUsage", "adffaces-category.adffaces-rule-widthleftrightstyles", "oracle.adf.faces.widthleftrightstyles", "adffacesacc-category.adffacesacc-rule-choosecolornotreferred", "oracle.adf.faces.choosecolornotreferred", "adffacesacc-category.adffacesacc-rule-choosedatenotreferred", "oracle.adf.faces.choosedatenotreferred", "adffacesacc-category.adffacesacc-rule-chooseidcolorpointsnowhere", "oracle.adf.faces.chooseidcolorpointsnowhere", "adffacesacc-category.adffacesacc-rule-chooseiddatepointsnowhere", "oracle.adf.faces.chooseiddatepointsnowhere", "adffacesacc-category.adffacesacc-rule-compnotlabelled", "oracle.adf.faces.compnotlabelled", "adffacesacc-category.adffacesacc-rule-compreqleadingheader", "oracle.adf.faces.compreqleadingheader", "adffacesacc-category.adffacesacc-rule-compreqnoncolheadertext", "oracle.adf.faces.compreqnoncolheadertext", "adffacesacc-category.adffacesacc-rule-compreqsearchdesc", null, "adffacesacc-category.adffacesacc-rule-compreqshortdesc", "oracle.adf.faces.compreqshortdesc", "adffacesacc-category.adffacesacc-rule-compreqsummary", "oracle.adf.faces.compreqsummary", "adffacesacc-category.adffacesacc-rule-compreqtext", "oracle.adf.faces.compreqtext", "adffacesacc-category.adffacesacc-rule-compreqtextorshortdesc", "oracle.adf.faces.compreqtextorshortdesc", "adffacesacc-category.adffacesacc-rule-compreqtitle", "oracle.adf.faces.compreqtitle", "adffacesacc-category.adffacesacc-rule-compreqtrailingheader", "oracle.adf.faces.compreqtrailingheader", "adffacesacc-category.adffacesacc-rule-forpointsnowhere", "oracle.adf.faces.forpointsnowhere", "adffacesacc-category.adffacesacc-rule-imgshortdesc", "oracle.adf.faces.imgshortdesc", "adffacesacc-category.adffacesacc-rule-tablecolneedsheaders", "oracle.adf.faces.tablecolneedsheaders", "adffacesacc-category.adffacesacc-rule-tableneedsrowheader", "oracle.adf.faces.tableneedsrowheader", "adfjavaaudit-internal-package-import", "oracle.adf.java.adfjavaaudit-internal-package-import", "adfm-application.adfm-check-page-definition-extension", "oracle.adf.model.check-page-definition-extension", "adfm-application.adfm-check-page-duplicate-cpxnames", "oracle.adf.model.check-page-duplicate-cpxnames", "adfm-configuration.adfm-check-duplicate-dcxnames", "oracle.adf.model.check-page-duplicate-dcxnames", "adfm-placeholder.adfm-bound-to-placeholder", "oracle.adf.model.bound-to-placeholder", "adfm-structuredefinition.adfm-struturedef-primary-key-check", "oracle.adf.model.structure-definition-primary-key-check", "adfmc-duplicate-id-found", null, "adfmc-invalid-attr-type", null, "adfmc-no-id-found", null, "api.boolean-constructor", "oracle.jdeveloper.java.boolean-constructor", "api.classic-forname", "oracle.jdeveloper.java.classic-forname", "api.equals-without-hashcode", "oracle.jdeveloper.java.equals-without-hashcode", "api.finalizer", "oracle.jdeveloper.java.finalizer", "api.hashcode-without-equals", "oracle.jdeveloper.java.hashcode-without-equals", "api.no-tostring", "oracle.jdeveloper.java.no-tostring", "api.null-array-return", "oracle.jdeveloper.java.null-array-return", "api.null-collection-return", "oracle.jdeveloper.java.null-collection-return", "api.null-map-return", "oracle.jdeveloper.java.null-map-return", "api.string-constructor", "oracle.jdeveloper.java.string-constructor", "api.swap-equals-param", "oracle.jdeveloper.java.swap-equals-arguments", "assists.boolean-expression-assist", "oracle.jdeveloper.java.boolean-expression-assist", "assists.constant-expression-assist", "oracle.jdeveloper.java.constant-expression-assist", "assists.ctor-assist", "oracle.jdeveloper.java.new-class-expression-assist", "assists.for-assist", "oracle.jdeveloper.java.for-assist", "assists.if-assist", "oracle.jdeveloper.java.if-assist", "assists.import-assist", "oracle.jdeveloper.java.import-assist", "assists.local-variable-assist", "oracle.jdeveloper.java.local-variable-assist", "compid-customization-id-found", "oracle.adf.faces.compid-customization-id-found", "compid-test-id-found", "oracle.adf.faces.compid-test-id-found", "complexity.dit", "oracle.jdeveloper.java.dit", "complexity.vg", "oracle.jdeveloper.java.vg", "declarations.unconventional-class-modifier-order", "oracle.jdeveloper.java.unconventional-class-modifier-order", "declarations.unconventional-field-modifier-order", "oracle.jdeveloper.java.unconventional-field-modifier-order", "declarations.unconventional-method-modifier-order", "oracle.jdeveloper.java.unconventional-method-modifier-order", "duplicate-id-found", "oracle.adf.faces.duplicate-id-found", "dvt-category.dvt-rule-visibletorendered", "oracle.adf.dvt.visibletorendered", "dvt-category.dvtgraph-graph-deprecated-tag-rule", "oracle.adf.dvt.graph-deprecated-tag", "dvt-category.dvtgraph-imageFormat-deprecated-value-rule", "oracle.adf.dvt.graph-imageFormat-deprecated-value", "dvt-category.dvtgraph-numberFormat-deprecated-tag-rule", "oracle.adf.dvt.graph-numberFormat-deprecated-tag", "dvt-category.dvtgraph-rule-invalid-attr-value", "oracle.adf.dvt.graph-invalid-attr-value", "dvt-category.dvthv-rule-compmustbeinsidehv", "oracle.adf.dvt.hv-compmustbeinsidehv", "dvt-category.dvthv-rule-compnotvalidhvchild", "oracle.adf.dvt.hv-compnotvalidhvchild", "dvt-category.dvthv-rule-notvalidhvattr", "oracle.adf.dvt.hv-notvalidhvattr", "dvtacc-category.dvtacc-rule-compreqshortdesc", "oracle.adf.dvt.acc-compreqshortdesc", "dvtacc-category.dvtacc-rule-compreqsummary", "oracle.adf.dvt.acc-compreqsummary", "dvtacc-category.dvtacc-rule-geomapnoadasupport", null, "dvtacc-category.dvtacc-rule-graphreferencelinenoadasupport", "oracle.adf.dvt.acc-graphreferencelinenoadasupport", "dvtacc-category.dvtacc-rule-graphscrollbarnoadasupport", "oracle.adf.dvt.acc-graphscrollbarnoadasupport", "dvtacc-category.dvtacc-rule-graphseriesrollovernoadasupport", "oracle.adf.dvt.acc-graphseriesrollovernoadasupport", "dvtacc-category.dvtacc-rule-graphtimeselectornoadasupport", "oracle.adf.dvt.acc-graphtimeselectornoadasupport", "dvtacc-category.dvtacc-rule-graphtypenoadasupport", "oracle.adf.dvt.acc-graphtypenoadasupport", "dvtacc-category.dvtacc-rule-graphzoomdirectionnoadasupport", "oracle.adf.dvt.acc-graphzoomdirectionnoadasupport", "dvtacc-category.dvtacc-rule-hvnoadasupport", null, "ejb.broken-annotation", "oracle.jdeveloper.java.annotation-callback", "exceptions.insufficient-catch-block", "oracle.jdeveloper.java.insufficient-catch-block", "expressions.lowercase-long-literal", "oracle.jdeveloper.java.lowercase-long-literal", "extension.extension-class-assist", "oracle.jdeveloper.extension.class-assist", "highlighting.abstract-class", "oracle.jdeveloper.java.abstract-class", "highlighting.annotation", "oracle.jdeveloper.java.annotation", "highlighting.annotation-element", "oracle.jdeveloper.java.annotation-element", "highlighting.class", "oracle.jdeveloper.java.class", "highlighting.constructor", "oracle.jdeveloper.java.constructor", "highlighting.instance-field", "oracle.jdeveloper.java.instance-field", "highlighting.instance-method", "oracle.jdeveloper.java.instance-method", "highlighting.interface", "oracle.jdeveloper.java.interface", "highlighting.parameter", "oracle.jdeveloper.java.parameter", "highlighting.static-field", "oracle.jdeveloper.java.static-field", "highlighting.static-method", "oracle.jdeveloper.java.static-method", "highlighting.variable", "oracle.jdeveloper.java.variable", "java-errors.anonymous-extends-final", "oracle.jdeveloper.java.anonymous-extends-final", "java-errors.cast-incompatible", "oracle.jdeveloper.java.cast-incompatible", "java-errors.catch-unreachable", "oracle.jdeveloper.java.catch-unreachable", "java-errors.constant-unassignable", "oracle.jdeveloper.java.constant-unassignable", "java-errors.constructor-not-found", "oracle.jdeveloper.java.constructor-not-found", "java-errors.exceptions-unhandled", "oracle.jdeveloper.java.exceptions-unhandled", "java-errors.interface-conflicted", "oracle.jdeveloper.java.interface-conflicted", "java-errors.interface-duplicated", "oracle.jdeveloper.java.interface-duplicated", "java-errors.invalid-modifier", "oracle.jdeveloper.java.invalid-modifier", "java-errors.member-not-found", "oracle.jdeveloper.java.member-not-found", "java-errors.method-not-found", "oracle.jdeveloper.java.method-not-found", "java-errors.methods-unimplemented", "oracle.jdeveloper.java.methods-unimplemented", "java-errors.name-not-found", "oracle.jdeveloper.java.name-not-found", "java-errors.public-type-name-conflict", "oracle.jdeveloper.java.public-type-name-conflict", "java-errors.return-missing", "oracle.jdeveloper.java.return-missing", "java-errors.return-value-missing", "oracle.jdeveloper.java.return-value-missing", "java-errors.secondary-type", "oracle.jdeveloper.java.secondary-type", "java-errors.semantic-advisory", "oracle.jdeveloper.java.semantic-advisory", "java-errors.semantic-error", "oracle.jdeveloper.java.semantic-error", "java-errors.semantic-warning", "oracle.jdeveloper.java.semantic-warning", "java-errors.syntax-advisory", "oracle.jdeveloper.java.syntax-advisory", "java-errors.syntax-error", "oracle.jdeveloper.java.syntax-error", "java-errors.syntax-warning", "oracle.jdeveloper.java.syntax-warning", "java-errors.type-incompatible", "oracle.jdeveloper.java.type-incompatible", "java-errors.type-not-found", "oracle.jdeveloper.java.type-not-found", "java-errors.type-unassignable", "oracle.jdeveloper.java.type-unassignable", "java-errors.unchecked-cast", "oracle.jdeveloper.java.unchecked-cast", "java-errors.unchecked-conversion", "oracle.jdeveloper.java.unchecked-conversion", "java-errors.unnecessary-cast", "oracle.jdeveloper.java.unnecessary-cast", "java-errors.wildcard-invalid", "oracle.jdeveloper.java.wildcard-invalid", "javadoc.comment-html-is-unterminated", "oracle.jdeveloper.java.comment-html-is-unterminated", "javadoc.comment-period-missing", "oracle.jdeveloper.java.comment-period-missing", "javadoc.description-is-empty", "oracle.jdeveloper.java.description-is-empty", "javadoc.missing-comment", "oracle.jdeveloper.java.missing-comment", "javadoc.tag-description-missing", "oracle.jdeveloper.java.tag-description-missing", "javadoc.tag-invalid-see-reference", "oracle.jdeveloper.java.tag-invalid-see-reference", "javadoc.tag-is-duplicate", "oracle.jdeveloper.java.tag-is-duplicate", "javadoc.tag-is-misplaced", "oracle.jdeveloper.java.tag-is-misplaced", "javadoc.tag-is-missing", "oracle.jdeveloper.java.tag-is-missing", "javadoc.tag-misspelled", "oracle.jdeveloper.java.tag-misspelled", "javadoc.tags-incorrectly-sorted", "oracle.jdeveloper.java.tags-incorrectly-sorted", "jslint.new-expression-case-mismatch", "oracle.ide.javascript.jslint.new-expression-case-mismatch", "jslint.required-block", "oracle.ide.javascript.jslint.required-block", "jslint.unexpected-inc-dec", "oracle.ide.javascript.jslint.unexpected-inc-dec", "jsp-category.check-facelets-configuration", "oracle.jdeveloper.jsp.check-facelets-configuration", "jsp-category.check-valid-parent", "oracle.jdeveloper.jsp.check-valid-parent", "jsp-category.duplicate-facet", "oracle.jdeveloper.jsp.duplicate-facet", "jsp-category.duplicate-id", "oracle.jdeveloper.jsp.duplicate-id", "jsp-category.duplicate-jsf-id", "oracle.jdeveloper.jsp.duplicate-jsf-id", "jsp-category.el-syntax", "oracle.jdeveloper.jsp.el-syntax", "jsp-category.empty-facet", null, "jsp-category.empty-subview", "oracle.jdeveloper.jsp.empty-subview", "jsp-category.empty-verbatim", "oracle.jdeveloper.jsp.empty-verbatim", "jsp-category.high-available-app", "oracle.jdeveloper.jsp.high-available-app", "jsp-category.mutually-exclusive-atributes", "oracle.jdeveloper.jsp.mutually-exclusive-atributes", "jsp-category.mutually-required-atributes", "oracle.jdeveloper.jsp.mutually-required-atributes", "jsp-category.namespace-defined-but-not-installed", "oracle.jdeveloper.jsp.namespace-defined-but-not-installed", "jsp-category.nested-form-tags", "oracle.jdeveloper.jsp.nested-form-tags", "jsp-category.no-method-binding-method", "oracle.jdeveloper.jsp.no-method-binding-method", "jsp-category.no-naming-container-include", "oracle.jdeveloper.jsp.no-naming-container-include", "jsp-category.prefix-declared-in-taglib-but-not-used", "oracle.jdeveloper.jsp.prefix-declared-in-taglib-but-not-used", "jsp-category.prefix-declared-in-xmlns-but-not-used", "oracle.jdeveloper.jsp.prefix-declared-in-xmlns-but-not-used", "jsp-category.translator-errors", "oracle.jdeveloper.jsp.translator-errors", "jsp-category.translator-warnings", "oracle.jdeveloper.jsp.translator-warnings", "jsp-category.undefined-facet", "oracle.jdeveloper.jsp.undefined-facet", "jsp-category.unnecessary-component-group", "oracle.jdeveloper.jsp.unnecessary-component-group", "jsp-category.unreferenced-jar", "oracle.jdeveloper.jsp.unreferenced-jar", "jsp-category.validate-children", "oracle.jdeveloper.jsp.validate-children", "jsp-category.validate-forbidden-ancestor", "oracle.jdeveloper.jsp.validate-forbidden-ancestor", "jsp-category.validate-forbidden-descendant", "oracle.jdeveloper.jsp.validate-forbidden-descendant", "junit.ignore-test", "oracle.jdeveloper.java.junit.ignore-test", "junit.set-expected-exception", "oracle.jdeveloper.java.junit.set-expected-exception", "junit.set-timeout", "oracle.jdeveloper.java.junit.set-timeout", "names.constructor-method-name", "oracle.jdeveloper.java.constructor-method-name", "names.unconventional-class-name", "oracle.jdeveloper.java.unconventional-class-name", "names.unconventional-constant-name", "oracle.jdeveloper.java.unconventional-constant-name", "names.unconventional-field-name", "oracle.jdeveloper.java.unconventional-field-name", "names.unconventional-interface-name", "oracle.jdeveloper.java.unconventional-interface-name", "names.unconventional-method-name", "oracle.jdeveloper.java.unconventional-method-name", "names.unconventional-parameter-name", "oracle.jdeveloper.java.unconventional-parameter-name", "names.unconventional-variable-name", "oracle.jdeveloper.java.unconventional-variable-name", "no-id-found", "oracle.adf.faces.no-id-found", "oracle.adf.share.webapp-redundant-filters", "oracle.adf.share.webapp-redundant-filters", "oracle.adfdt.controller.adfc.config.source.audit.AdfScopeHaSupportNotSet", "oracle.adfdt.controller.adfc.config.source.audit.AdfScopeHaSupportNotSet", "oracle.adfdt.controller.adfc.source.audit.AdditionalBoundedTaskFlow", "oracle.adfdt.controller.adfc.source.audit.AdditionalBoundedTaskFlow", "oracle.adfdt.controller.adfc.source.audit.AdditionalUnboundedTaskFlowArtifact", "oracle.adfdt.controller.adfc.source.audit.AdditionalUnboundedTaskFlowArtifact", "oracle.adfdt.controller.adfc.source.audit.BadPageFragmentSemanticsInBinding", "oracle.adfdt.controller.adfc.bindings.audit.BadPageFragmentSemanticsInBinding", "oracle.adfdt.controller.adfc.source.audit.BadPageFragmentSemanticsInDialog", "oracle.adfdt.controller.adfc.source.audit.BadPageFragmentSemanticsInDialog", "oracle.adfdt.controller.adfc.source.audit.CustomizationIdNotDefined", "oracle.adfdt.controller.adfc.source.audit.CustomizationIdNotDefined", "oracle.adfdt.controller.adfc.source.audit.DefaultActivityNotDefined", "oracle.adfdt.controller.adfc.source.audit.DefaultActivityNotDefined", "oracle.adfdt.controller.adfc.source.audit.ELBeanModificationWithoutDirty", "oracle.adfdt.controller.adfc.source.audit.ELBeanModificationWithoutDirty", "oracle.adfdt.controller.adfc.source.audit.ELExpressionNotExpected", "oracle.adfdt.controller.adfc.source.audit.ELExpressionNotExpected", "oracle.adfdt.controller.adfc.source.audit.ELSyntaxError", "oracle.adfdt.controller.adfc.source.audit.ELSyntaxError", "oracle.adfdt.controller.adfc.source.audit.ELUnknownToken", "oracle.adfdt.controller.adfc.source.audit.ELUnknownToken", "oracle.adfdt.controller.adfc.source.audit.ManagedBeanNotSerializable", "oracle.adfdt.controller.adfc.source.audit.ManagedBeanNotSerializable", "oracle.adfdt.controller.adfc.source.audit.OutcomeNotFoundInActivity", "oracle.adfdt.controller.adfc.source.audit.OutcomeNotFoundInActivity", "oracle.adfdt.controller.adfc.source.audit.PageDoesNotExist", "oracle.adfdt.controller.adfc.source.audit.PageDoesNotExist", "oracle.adfdt.controller.adfc.source.audit.PageFragmentReferenceNotExpected", "oracle.adfdt.controller.adfc.source.audit.PageFragmentReferenceNotExpected", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch1", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch1", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch2", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch2", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch2b", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch2b", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch3", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch3", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch4", "oracle.adfdt.controller.adfc.source.audit.PageFragmentSemanticsDoNotMatch4", "oracle.adfdt.controller.adfc.source.audit.PageReferenceNotExpected", "oracle.adfdt.controller.adfc.source.audit.PageReferenceNotExpected", "oracle.adfdt.controller.adfc.source.audit.RequiredElementEmpty", "oracle.adfdt.controller.adfc.source.audit.RequiredElementEmpty", "oracle.adfdt.controller.adfc.source.audit.RequiredParametersNotSpecified", "oracle.adfdt.controller.adfc.source.audit.RequiredParametersNotSpecified", "oracle.adfdt.controller.adfc.source.audit.ScopeModifiedWithoutDirty", "oracle.adfdt.controller.adfc.source.audit.ScopeModifiedWithoutDirty", "oracle.adfdt.controller.adfc.source.audit.TaskFlowReturnActivitiesNotDefined", "oracle.adfdt.controller.adfc.source.audit.TaskFlowReturnActivitiesNotDefined", "oracle.adfdt.controller.adfc.source.audit.UnreferencedTaskFlowBinding", "oracle.adfdt.controller.adfc.bindings.audit.UnreferencedTaskFlowBinding", "oracle.adfdt.controller.adfc.source.audit.extra.DataControlScopeNotDefined", "oracle.adfdt.controller.adfc.source.audit.extra.DataControlScopeNotDefined", "oracle.ide.database.primary-key-missing", "oracle.ide.database.primary-key-missing", "oracle.ide.database.userprop-duff", null, "oracle.ide.html.non-default-size", "oracle.ide.html.non-default-size", "oracle.ide.javascript.deprecated-bom-property", "oracle.ide.javascript.deprecated-bom-property", "oracle.ide.javascript.duplicate-switch-case-label", "oracle.ide.javascript.duplicate-switch-case-label", "oracle.ide.javascript.empty-block", "oracle.ide.javascript.empty-block", "oracle.ide.javascript.empty-body", "oracle.ide.javascript.empty-body", "oracle.ide.javascript.jslint.duplicate-definition", "oracle.ide.javascript.jslint.duplicate-definition", "oracle.ide.javascript.jslint.expression-statement", "oracle.ide.javascript.jslint.expression-statement", "oracle.ide.javascript.jslint.forbidden-block", "oracle.ide.javascript.jslint.forbidden-block", "oracle.ide.javascript.jslint.nested-definition", "oracle.ide.javascript.jslint.nested-definition", "oracle.ide.javascript.jslint.switch-fall-thru", "oracle.ide.javascript.jslint.switch-fall-thru", "oracle.ide.javascript.jslint.unexpected-assignment-expression", "oracle.ide.javascript.jslint.unexpected-assignment-expression", "oracle.ide.javascript.jslint.unexpected-eval", "oracle.ide.javascript.jslint.unexpected-eval", "oracle.ide.javascript.jslint.unexpected-label", "oracle.ide.javascript.jslint.unexpected-label", "oracle.ide.javascript.jslint.unexpected-new-expression-construct", "oracle.ide.javascript.jslint.unexpected-new-expression-construct", "oracle.ide.javascript.jslint.unexpected-void", "oracle.ide.javascript.jslint.unexpected-void", "oracle.ide.javascript.jslint.unexpected-with-statement", "oracle.ide.javascript.jslint.unexpected-with-statement", "oracle.ide.javascript.jslint.unreachable-code", "oracle.ide.javascript.jslint.unreachable-code", "oracle.ide.javascript.line-too-long", "oracle.ide.javascript.line-too-long", "oracle.ide.javascript.missing-switch-default", "oracle.ide.javascript.missing-switch-default", "oracle.ide.javascript.switch-default-not-last", "oracle.ide.javascript.switch-default-not-last", "oracle.ide.javascript.syntax-error", "oracle.ide.javascript.syntax-error", "oracle.ide.javascript.unescaped-html-endtag-in-string-literal", "oracle.ide.javascript.unescaped-html-endtag-in-string-literal", "oracle.ide.javascript.unexpected-bitwise-operator", "oracle.ide.javascript.unexpected-bitwise-operator", "oracle.ide.javascript.unexpected-continue-statement", "oracle.ide.javascript.unexpected-continue-statement", "oracle.ide.javascript.unexpected-debugger-statement", "oracle.ide.javascript.unexpected-debugger-statement", "oracle.ide.javascript.unsupported-bom-property", "oracle.ide.javascript.unsupported-bom-property", "oracle.ide.javascript.unused-identifier", "oracle.ide.javascript.unused-identifier", "oracle.ide.xml.attribute-duplicated", "oracle.ide.xml.attribute-duplicated", "oracle.ide.xml.attribute-missing-error", "oracle.ide.xml.attribute-missing-error", "oracle.ide.xml.attribute-missing-warning", "oracle.ide.xml.attribute-missing-warning", "oracle.ide.xml.attribute-value-missing", "oracle.ide.xml.attribute-value-missing", "oracle.ide.xml.brokenref-advisory", "oracle.ide.xml.brokenref-advisory", "oracle.ide.xml.brokenref-error", "oracle.ide.xml.brokenref-error", "oracle.ide.xml.brokenref-warning", "oracle.ide.xml.brokenref-warning", "oracle.ide.xml.duplicatename-error", "oracle.ide.xml.duplicatename-error", "oracle.ide.xml.mismatched-end-tag", "oracle.ide.xml.mismatched-end-tag", "oracle.ide.xml.other-error", "oracle.ide.xml.other-error", "oracle.ide.xml.other-suggestion", "oracle.ide.xml.other-suggestion", "oracle.ide.xml.other-warning", "oracle.ide.xml.other-warning", "oracle.ide.xml.remoteref-reload-warning", "oracle.ide.xml.remoteref-reload-warning", "oracle.ide.xml.remoteref-warning", "oracle.ide.xml.remoteref-warning", "oracle.ide.xml.validation-advisory", "oracle.ide.xml.validation-advisory", "oracle.ide.xml.validation-error", "oracle.ide.xml.validation-error", "oracle.ide.xml.validation-warning", "oracle.ide.xml.validation-warning", "oracle.ide.xml.wellformedness-error", "oracle.ide.xml.wellformedness-error", "oracle.ide.xml.wellformedness-warning", "oracle.ide.xml.wellformedness-warning", "oracle.jbo.am.java-passivate", "oracle.jbo.am.java-passivate", "oracle.jbo.config-datasource", "oracle.jbo.config-datasource", "oracle.jbo.config-lazyloading", "oracle.jbo.config-lazyloading", "oracle.jbo.config-name", "oracle.jbo.config-name", "oracle.jbo.config-poolsize", "oracle.jbo.config-poolsize", "oracle.jbo.sql92.bindingstyle", "oracle.jbo.sql92.bindingstyle", "oracle.jbo.sql92.refresh", "oracle.jbo.sql92.refresh", "oracle.jbo.view-quoted-vcitem-string-literal", "oracle.jbo.view-quoted-vcitem-string-literal", "oracle.jbo.view.lov-rangesize", "oracle.jbo.view.lov-rangesize", "oracle.jbo.view.lov-readonly", "oracle.jbo.view.lov-readonly", "oracle.jbo.view.lov-recursive", "oracle.jbo.view.lov-recursive", "oracle.jbo.view.lov-switcher", "oracle.jbo.view.lov-switcher", "oracle.jdeveloper.java.access.array-field-access", "oracle.jdeveloper.java.array-field-access", "oracle.jdeveloper.java.access.enum-constructor-access", "oracle.jdeveloper.java.enum-constructor-access", "oracle.jdeveloper.java.access.unrestricted-field-access", "oracle.jdeveloper.java.unrestricted-field-access", "oracle.jdeveloper.java.annotations.at-override-violation", "oracle.jdeveloper.java.at-override-violation", "oracle.jdeveloper.java.annotations.remove-annotation-assist", "oracle.jdeveloper.java.annotation-assist", "oracle.jdeveloper.java.statements.multiple-assignment", "oracle.jdeveloper.java.multiple-assignment", "oracle.jdeveloper.java.statements.nested-assignment", "oracle.jdeveloper.java.nested-assignment", "oracle.jdeveloper.java.statements.trivial-assignment", "oracle.jdeveloper.java.trivial-assignment", "oracle.jdevimpl.css.audit.css-category.extended-color", "oracle.jdeveloper.css.extended-color", "oracle.jdevimpl.css.audit.css-category.semantic-error", "oracle.jdeveloper.css.semantic-error", "oracle.jdevimpl.css.audit.css-category.syntax-error", "oracle.jdeveloper.css.syntax-error", "oracle.jdevimpl.css.audit.css-category.unregistered-font-family", "oracle.jdeveloper.css.unregistered-font-family", "oracle.jdevimpl.json.syntax-error", "oracle.jdevimpl.json.syntax-error", "oracle.mdsdt.cust.role.audit.MDSTipCustValidationError", "oracle.mdsdt.cust.role.audit.MDSTipCustValidationError", "serialization.field-not-serializable", "oracle.jdeveloper.java.field-not-serializable", "serialization.field-transient-in-non-serializable-class", "oracle.jdeveloper.java.field-transient-in-non-serializable-class", "serialization.inner-class-serializable", "oracle.jdeveloper.java.inner-class-serializable", "serialization.readObject-or-writeObject-in-externalizable-class", null, "serialization.readObject-or-writeObject-in-nonserializable-class", "oracle.jdeveloper.java.readobject-or-writeobject-in-nonserializable-class", "serialization.readObject-or-writeObject-not-declared-private", null, "serialization.readResolve-or-writeReplace-not-declared-protected", null, "serialization.serialpersistentfields-field-with-nonstandard-modifiers", "oracle.jdeveloper.java.serialpersistentfields-field-with-nonstandard-modifiers", "serialization.serialversionuid-field-in-nonserializable-class", "oracle.jdeveloper.java.serialversionuid-field-in-nonserializable-class", "serialization.serialversionuid-field-missing", "oracle.jdeveloper.java.serialversionuid-field-missing", "serialization.serialversionuid-field-with-nonstandard-modifiers", "oracle.jdeveloper.java.serialversionuid-field-with-nonstandard-modifiers", "serialization.serialversionuid-stale", "oracle.jdeveloper.java.serialversionuid-stale", "shared-datacontrol", "oracle.adf.faces.region.shared-datacontrol", "single-root-in-fragment", "oracle.adf.faces.region.single-root-in-fragment", "size.nos", "oracle.jdeveloper.java.nos", "style-bad-selecter", "oracle.adf.faces.style-bad-selecter", "style-no-auto-heights", "oracle.adf.faces.style-no-auto-heights", "style-no-auto-widths", "oracle.adf.faces.style-no-auto-widths", "style-visual-root-present", "oracle.adf.faces.style-visual-root-present", "unused.constructor-deprecated", "oracle.jdeveloper.java.constructor-deprecated", "unused.field-deprecated", "oracle.jdeveloper.java.field-deprecated", "unused.method-deprecated", "oracle.jdeveloper.java.method-deprecated", "unused.type-deprecated", "oracle.jdeveloper.java.type-deprecated", "unused.unused-class", "oracle.jdeveloper.java.unused-class", "unused.unused-constructor", "oracle.jdeveloper.java.unused-constructor", "unused.unused-field", "oracle.jdeveloper.java.unused-field", "unused.unused-import", "oracle.jdeveloper.java.unused-import", "unused.unused-interface", "oracle.jdeveloper.java.unused-interface", "unused.unused-method", "oracle.jdeveloper.java.unused-method", "unused.unused-parameter", "oracle.jdeveloper.java.unused-parameter", "unused.unused-variable", "oracle.jdeveloper.java.unused-variable", "webservices.annotation-rule", "oracle.jdeveloper.webservice.annotation-error", "webservices.binding-missing-operations", "oracle.jdeveloper.webservice.binding-missing-operations", "webservices.broken-annotation", null, "webservices.broken-webxml", "oracle.jdeveloper.webservice.broken-webxml", "webservices.definition-no-namespace", "oracle.jdeveloper.webservice.definition-no-namespace", "webservices.document-encoded", "oracle.jdeveloper.webservice.document-encoded", "webservices.handler-chain-synchronization", "oracle.jdeveloper.webservice.handler-chain-synchronization", "webservices.implement-provider", "oracle.jdeveloper.webservice.implement-provider", "webservices.jrf-security-policy-property-crosschecker", "oracle.jdeveloper.webservice.jrf-security-policy-property-crosschecker", "webservices.method-annotation", "oracle.jdeveloper.webservice.method-annotation", "webservices.mismatch-annotation", "oracle.jdeveloper.webservice.mismatch-annotation", "webservices.mixed-up-policy-annotation-resolver", "oracle.jdeveloper.webservice.mixed-up-policy-annotation-resolver", "webservices.oneway-outbound-conflict-resolver", "oracle.jdeveloper.webservice.oneway-outbound-conflict-resolver", "webservices.stateful-conflict-resolver", "oracle.jdeveloper.webservice.stateful-conflict-resolver", "webservices.swap-element-type", "oracle.jdeveloper.webservice.swap-element-type", "webservices.transactional-conflict-resolver", "oracle.jdeveloper.webservice.transactional-conflict-resolver", "webservices.wls-policy-in-wsdl-and-service-resolver", "oracle.jdeveloper.webservice.wls-policy-in-wsdl-and-service-resolver", "webservices.wlspolicy-descriptor-synchronization", "oracle.jdeveloper.webservice.wlspolicy-descriptor-synchronization", "webservices.wsdl-impl-synchronization", "oracle.jdeveloper.webservice.wsdl-impl-synchronization", "webservices.xsd-import-under-types", "oracle.jdeveloper.webservice.xsd-import-under-types", "webservices.xsd-import-with-wsdl-import", "oracle.jdeveloper.webservice.xsd-import-with-wsdl-import", "webservices.xsd-schema-not-element-qualified", "oracle.jdeveloper.webservice.xsd-schema-not-element-qualified", "webservices.xsd-schema-not-under-types", "oracle.jdeveloper.webservice.xsd-schema-not-under-types", "xmlef-translation-validation.translation-rule-translatableattr", "oracle.ide.resourcebundle.translatable-attribute"};

    String getVersion() {
        return this.version;
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    boolean isSealed() {
        return this.sealed;
    }

    MultiMap<String, ValueHandle> getDelta() {
        return this.delta;
    }

    static void write(ExtensionBeanFactory factory, String id, String name, URL url, boolean sealed, boolean removeDisabled, boolean removeUndefined, boolean removeAssists, MultiMap<String, ValueHandle> delta) throws IOException {
        Collection handles;
        BeanDefinition<?> definition;
        XmlWriter writer = new XmlWriter(url, "UTF-8", true);
        writer.writeElementBegin(AUDIT_PROFILE);
        writer.writeAttribute("version", FORMAT_VERSION);
        writer.writeTextElement("id", id);
        writer.writeTextElement("name", name);
        writer.writeTextElement("sealed", sealed);
        Map<String, BeanDefinition<?>> definitions = factory.getDefinitions();
        LinkedHashSet<String> ids = new LinkedHashSet<String>(definitions.keySet());
        ids.addAll(delta.keySet());
        TreeSet<String> sortedIds = new TreeSet<String>();
        for (String beanId : ids) {
            ValueHandle handle;
            definition = definitions.get(beanId);
            if (removeUndefined && definition == null) continue;
            if (removeAssists) {
                if (definition instanceof RuleDefinition && ((RuleDefinition)definition).isAssist()) continue;
                handles = delta.get((Object)beanId);
                ValueHandle valueHandle = handle = handles != null ? (ValueHandle)handles.stream().filter(h -> h.getName().equals("severity")).findAny().orElse(null) : null;
                if (handle != null && "assist".equals(handle.getRepresentation())) continue;
            }
            if (removeDisabled) {
                if (definition instanceof CategoryDefinition) continue;
                handles = delta.get((Object)beanId);
                ValueHandle valueHandle = handle = handles != null ? (ValueHandle)handles.stream().filter(h -> h.getName().equals("enabled")).findAny().orElse(null) : null;
                if (handle != null && !handle.isTrue() || handle == null && (sealed || definition != null && !definition.isEnabledByDefault())) continue;
                if (definition instanceof HasCategory) {
                    for (CategoryDefinition category = ((HasCategory)((Object)definition)).getCategory(); category != null; category = category.getCategory()) {
                        sortedIds.add(category.getId());
                    }
                }
            }
            sortedIds.add(beanId);
        }
        for (String beanId : sortedIds) {
            definition = definitions.get(beanId);
            handles = delta.get((Object)beanId);
            ExtensionBean bean = definition instanceof CategoryDefinition || definition instanceof RuleDefinition || definition instanceof MetricDefinition || definition instanceof SuppressionSchemeDefinition ? factory.getBeans(false).get(beanId) : null;
            ProfileReaderWriter.writeBean(beanId, definition, bean, handles, writer);
        }
        writer.writeElementEnd(AUDIT_PROFILE);
        writer.close();
    }

    private static void writeBean(String id, BeanDefinition<?> definition, ExtensionBean bean, Collection<ValueHandle> handles, XmlWriter writer) throws IOException {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        if (definition != null && definition.hasEnabledProperty()) {
            values.put("enabled", definition.isEnabledByDefault() ? ENABLED_TRUE : ENABLED_FALSE);
        }
        if (bean != null) {
            for (PropertyDescriptor propertyDescriptor : Beans.getPropertyDescriptors(bean)) {
                values.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        if (handles != null) {
            for (ValueHandle valueHandle : handles) {
                values.put(valueHandle.getName(), valueHandle);
            }
        }
        if (!values.isEmpty()) {
            writer.writeElementBegin("bean");
            writer.writeAttribute("id", id);
            for (Map.Entry entry : values.entrySet()) {
                String name = (String)entry.getKey();
                if (entry.getValue() instanceof ValueHandle) {
                    ValueHandle handle = (ValueHandle)entry.getValue();
                    try {
                        ProfileReaderWriter.writeValue(writer, handle);
                    }
                    catch (Exception e) {
                        AuditLogger.error("marshaling property {0} of bean {1} failed ({2}): {3}", name, id, handle, e);
                    }
                    continue;
                }
                assert (bean != null);
                try {
                    ProfileReaderWriter.writeValue(writer, new ValueHandle(name, null, ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)bean, new Object[0])));
                }
                catch (Exception e) {
                    AuditLogger.error("marshaling property {0} of bean {1} failed (class {2}): {3}", name, id, bean.getClass(), e);
                }
            }
            writer.writeElementEnd("bean");
        }
    }

    private static void writeValue(XmlWriter writer, ValueHandle value) throws IOException {
        String name = value.getName();
        Object representation = value.getRepresentation();
        writer.writeElementBegin(name);
        if (representation == null) {
            writer.writeEmptyElement("null");
        } else if (representation instanceof String) {
            writer.writeText(representation);
        } else {
            try {
                for (ValueHandle nestedValue : (Collection)representation) {
                    ProfileReaderWriter.writeValue(writer, nestedValue);
                }
            }
            catch (ClassCastException e) {
                AuditLogger.error("unexpected representation {0}: {1}", representation, e);
            }
        }
        writer.writeElementEnd(name);
    }

    private void enter(String handler, String element, Object ... data) {
        this.log(this.level++, "enter", handler, element, data);
    }

    private void exit(String handler, String element, Object ... data) {
        this.log(--this.level, "exit ", handler, element, data);
    }

    private void log(int level, String action, String handler, String element, Object ... data) {
        if (LOG.isEnabled()) {
            String line = String.valueOf(this.locator.getLineNumber());
            StringBuilder builder = new StringBuilder();
            builder.append("    ", 0, Math.max(4 - line.length(), 0));
            builder.append(" ");
            builder.append(line);
            builder.append(" ");
            for (int i = 0; i < level; ++i) {
                builder.append("  ");
            }
            builder.append(handler);
            builder.append(" ");
            builder.append(action);
            builder.append(" <");
            builder.append(element);
            builder.append("> ");
            for (Object datum : data) {
                builder.append(" ");
                builder.append(datum);
            }
            LOG.trace(builder.toString());
        }
    }

    void read(URL url, ExtensionBeanFactory factory, boolean seal, boolean abbreviatedParse) throws IOException {
        block11: {
            LOG.trace("parsing {0}", (Object)url);
            this.url = url;
            this.sealed = seal;
            this.abbreviatedParse = abbreviatedParse;
            this.parser = new SAXParser();
            this.parser.setPreserveWhitespace(false);
            this.parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
            this.parser.setContentHandler((ContentHandler)new RootHandler());
            try (InputStream stream = URLFileSystem.openInputStream((URL)url);){
                this.parser.parse(stream);
                AuditHook.getAuditHook().mapDeprecatedIds(this.delta);
                if (this.sealed) {
                    for (BeanDefinition<?> definition : factory.getDefinitions().values()) {
                        String id = definition.getId();
                        if (!definition.hasEnabledProperty() || !definition.isEnabledByDefault() || this.delta.containsKey((Object)id)) continue;
                        this.delta.add((Object)id, (Object)ENABLED_FALSE);
                    }
                }
            }
            catch (XMLParseException e) {
                throw new IOException(e.getMessage() + ": " + e.getSystemId() + " (" + e.getLineNumber() + ":" + e.getColumnNumber() + ")", e);
            }
            catch (SAXException e) {
                if (abbreviatedParse && "abbreviated-parse".equals(e.getMessage())) break block11;
                throw new IOException(e.getMessage(), e);
            }
        }
        LOG.trace("parsing {0} completed", (Object)url);
    }

    private SAXException createSAXException(String message, Object[] arguments) {
        String text = MessageFormat.format(message, arguments) + this.at();
        LOG.trace(text);
        return new SAXException(text);
    }

    private void assertState(EncoderDecoderState state, EncoderDecoderState ... expectedStates) throws SAXException {
        for (EncoderDecoderState expected : expectedStates) {
            if (state != expected) continue;
            return;
        }
        throw this.createSAXException("illegal state {0}; expected: {1}", new Object[0]);
    }

    private String at() {
        return " (" + URLFileSystem.getPlatformPathName((URL)this.url) + ", line " + this.locator.getLineNumber() + ", column " + this.locator.getColumnNumber() + ")";
    }

    private class RootHandler
    extends DefaultHandler {
        private StringBuilder characters;
        private int stringElementsExpected;
        private static final String ABBREVIATED_PARSE = "abbreviated-parse";
        private static final String FORMAT_PREFIX = "Audit Profile ";

        private RootHandler() {
        }

        private void setExpected(String ... names) {
            ProfileReaderWriter.this.expected.clear();
            ProfileReaderWriter.this.expected.addAll(Arrays.asList(names));
        }

        private void appendExpected(StringBuilder builder) {
            switch (ProfileReaderWriter.this.expected.size()) {
                case 0: {
                    builder.append("no elements");
                    break;
                }
                case 1: {
                    builder.append("<").append(ProfileReaderWriter.this.expected.get(0)).append(">");
                    break;
                }
                case 2: {
                    builder.append("<").append(ProfileReaderWriter.this.expected.get(0)).append("> ");
                    builder.append("or ");
                    builder.append("<").append(ProfileReaderWriter.this.expected.get(1)).append(">");
                    break;
                }
                default: {
                    for (int i = 0; i < ProfileReaderWriter.this.expected.size() - 1; ++i) {
                        builder.append("<").append(ProfileReaderWriter.this.expected.get(1)).append(">, ");
                    }
                    builder.append("or ");
                    builder.append("<").append(ProfileReaderWriter.this.expected.get(ProfileReaderWriter.this.expected.size() - 1)).append(">");
                }
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ProfileReaderWriter.this.locator = locator;
        }

        @Override
        public void startDocument() {
            this.setExpected(ProfileReaderWriter.AUDIT_PROFILE, "java");
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            ProfileReaderWriter.this.enter("root", localName, new Object[0]);
            if (!ProfileReaderWriter.this.expected.contains(localName)) {
                StringBuilder builder = new StringBuilder();
                builder.append("unexpected element <").append(localName).append(">: expected ");
                this.appendExpected(builder);
                throw ProfileReaderWriter.this.createSAXException(builder.toString(), new Object[0]);
            }
            if (ProfileReaderWriter.AUDIT_PROFILE.equals(localName)) {
                ProfileReaderWriter.this.version = attributes.getValue("version");
                this.setExpected("id");
            } else if ("id".equals(localName)) {
                this.characters = new StringBuilder();
                this.setExpected(new String[0]);
            } else if ("name".equals(localName)) {
                this.characters = new StringBuilder();
                this.setExpected(new String[0]);
            } else if ("sealed".equals(localName)) {
                this.characters = new StringBuilder();
                this.setExpected(new String[0]);
            } else if ("java".equals(localName)) {
                this.setExpected("string");
                this.stringElementsExpected = 3;
            } else if ("string".equals(localName)) {
                this.characters = new StringBuilder();
                this.setExpected(new String[0]);
            } else if ("null".equals(localName)) {
                this.setExpected(new String[0]);
            } else if ("boolean".equals(localName)) {
                this.characters = new StringBuilder();
                this.setExpected(new String[0]);
            }
        }

        @Override
        public void characters(char[] characters, int start, int length) throws SAXException {
            if (this.characters == null) {
                StringBuilder builder = new StringBuilder("unexpected text content: expected ");
                this.appendExpected(builder);
                throw ProfileReaderWriter.this.createSAXException(builder.toString(), new Object[0]);
            }
            this.characters.append(characters, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
            ProfileReaderWriter.this.exit("root", localName, new Object[0]);
            if (ProfileReaderWriter.AUDIT_PROFILE.equals(localName)) {
                this.setExpected("id");
            } else if ("id".equals(localName)) {
                if (this.characters.length() > 0) {
                    ProfileReaderWriter.this.id = this.characters.toString();
                }
                this.setExpected("name");
                this.characters = null;
            } else if ("name".equals(localName)) {
                if (this.characters.length() == 0) {
                    throw ProfileReaderWriter.this.createSAXException("empty <name> element", new Object[0]);
                }
                ProfileReaderWriter.this.name = this.characters.toString();
                this.characters = null;
                if (ProfileReaderWriter.this.version.startsWith("12")) {
                    this.setExpected("sealed");
                } else {
                    if (ProfileReaderWriter.this.abbreviatedParse) {
                        throw new SAXException(ABBREVIATED_PARSE);
                    }
                    ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new BeanHandler());
                }
            } else if ("sealed".equals(localName)) {
                if (this.characters.length() == 0) {
                    throw ProfileReaderWriter.this.createSAXException("empty <seal> element", new Object[0]);
                }
                ProfileReaderWriter.this.sealed = ProfileReaderWriter.this.sealed || Boolean.parseBoolean(this.characters.toString());
                this.characters = null;
                if (ProfileReaderWriter.this.abbreviatedParse) {
                    throw new SAXException(ABBREVIATED_PARSE);
                }
                ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new BeanHandler());
            } else if ("string".equals(localName)) {
                String text = this.characters.toString();
                switch (this.stringElementsExpected) {
                    case 3: {
                        if (text.isEmpty()) {
                            throw ProfileReaderWriter.this.createSAXException("empty <string> element for format", new Object[0]);
                        }
                        if (text.startsWith(FORMAT_PREFIX)) {
                            ProfileReaderWriter.this.version = text.substring(FORMAT_PREFIX.length());
                            this.setExpected("string");
                            this.stringElementsExpected = 2;
                            break;
                        }
                        ProfileReaderWriter.this.version = "9.0.5";
                        this.setExpected("boolean");
                        this.stringElementsExpected = 0;
                        break;
                    }
                    case 2: {
                        if (text.isEmpty()) {
                            throw ProfileReaderWriter.this.createSAXException("empty <string> element for name", new Object[0]);
                        }
                        ProfileReaderWriter.this.name = text;
                        this.setExpected("string", "null");
                        this.stringElementsExpected = 1;
                        break;
                    }
                    case 1: {
                        if (!text.isEmpty()) {
                            ProfileReaderWriter.this.id = text;
                        }
                        if (ProfileReaderWriter.this.abbreviatedParse) {
                            throw new SAXException(ABBREVIATED_PARSE);
                        }
                        this.setExpected("object");
                        this.stringElementsExpected = 0;
                        ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new EncoderDecoderHandler(ProfileReaderWriter.this.version));
                    }
                }
                this.characters = null;
            } else if ("null".equals(localName)) {
                if (this.stringElementsExpected != 1) {
                    throw ProfileReaderWriter.this.createSAXException("element <null> unexpected", new Object[0]);
                }
                if (ProfileReaderWriter.this.abbreviatedParse) {
                    throw new SAXException(ABBREVIATED_PARSE);
                }
                this.setExpected("object");
                this.stringElementsExpected = 0;
                ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new EncoderDecoderHandler(ProfileReaderWriter.this.version));
            } else if ("boolean".equals(localName)) {
                if (this.characters.length() == 0) {
                    throw ProfileReaderWriter.this.createSAXException("empty <boolean> element for predefined", new Object[0]);
                }
                if ("true".equalsIgnoreCase(this.characters.toString())) {
                    ProfileReaderWriter.this.id = this.inferKeyFromURL(ProfileReaderWriter.this.url);
                }
                this.setExpected("object");
                ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new EncoderDecoderHandler(ProfileReaderWriter.this.version));
            }
        }

        private String inferKeyFromURL(URL url) {
            String fileName = URLFileSystem.getName((URL)url);
            String key = "all-metrics".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_METRICS") : ("all-rules".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_RULES") : ("audit-rules".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "AUDIT_RULES") : ("code-assist-rules".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "CODE_ASSIST_RULES") : ("javadoc-rules".equals(fileName) ? this.key("oracle.jdevimpl.javadoc.audit.DocCommenter", "JAVADOC_RULES") : ("audit-metrics-profile".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_METRICS") : ("audit-all-profile".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "ALL_RULES") : ("audit-default-profile".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "AUDIT_RULES") : ("audit-assist-profile".equals(fileName) ? this.key("oracle.jdeveloper.audit.service.ProfileRepository", "CODE_ASSIST_RULES") : ("Javadoc".equals(fileName) ? this.key("oracle.jdevimpl.javadoc.audit.DocCommenter", "JAVADOC_RULES") : null)))))))));
            return key;
        }

        private String key(String className, String fieldName) {
            try {
                Class<?> type = Class.forName(className);
                Field field = type.getField(fieldName);
                return (String)field.get(null);
            }
            catch (Throwable e) {
                return null;
            }
        }
    }

    private class NullHandler
    extends DefaultHandler {
        private final ContentHandler parent;
        private int depth;

        public NullHandler(ContentHandler parent) {
            this.parent = parent;
        }

        @Override
        public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) {
            ProfileReaderWriter.this.enter("null", localName, new Object[0]);
            ++this.depth;
        }

        @Override
        public void endElement(String uri, String localName, String qualifiedName) {
            ProfileReaderWriter.this.exit("null", localName, new Object[0]);
            if (--this.depth == 0) {
                ProfileReaderWriter.this.parser.setContentHandler(this.parent);
            }
        }
    }

    private class EncoderDecoderHandler
    extends DefaultHandler {
        private final Map<String, String> nameReferences = new HashMap<String, String>();
        private final Map<String, String> simpleValueReferences = new HashMap<String, String>();
        private final Deque<EncoderDecoderState> stateStack = new ArrayDeque<EncoderDecoderState>();
        private EncoderDecoderState state;
        private final Deque<EncoderDecoderValue> valueStack = new ArrayDeque<EncoderDecoderValue>();
        private EncoderDecoderValue value;
        private StringBuilder characters;
        private final Object[] migrationTable;
        private final Set<String> primitives = new HashSet<String>(Arrays.asList("class", "string", "boolean", "byte", "char", "short", "int", "long", "float", "double"));

        public EncoderDecoderHandler(String version) {
            ProfileReaderWriter.this.delta = new MultiMap();
            this.stateStack.push(EncoderDecoderState.SEEKING_ROOT);
            if (version.startsWith("11.1.1")) {
                this.state = EncoderDecoderState.SEEKING_BEAN_MAP;
                this.migrationTable = MIGRATE_11;
            } else {
                this.migrationTable = MIGRATE_11;
                this.state = EncoderDecoderState.SEEKING_ANALYZER_MAP;
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            EncoderDecoderState initialState = this.state;
            int initialDepth = this.stateStack.size();
            assert (!localName.trim().isEmpty()) : "namespaceURI " + namespaceURI + " qualifiedName " + qualifiedName;
            if (this.characters != null) {
                throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in text content", new Object[]{localName});
            }
            switch (this.state) {
                case SEEKING_ROOT: {
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected end-of-file", new Object[]{localName, this.state});
                }
                case SEEKING_ANALYZER_MAP: {
                    if (!"object".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <object>", new Object[]{localName, this.state});
                    }
                    if (!"java.util.HashMap".equals(attributes.getValue("class")) && !"java.util.LinkedHashMap".equals(attributes.getValue("class"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"class\" attribute value {0} in element <{1}> (state {2}): expected \"java.util.HashMap\" or \"java.util.LinkedHashMap\"", new Object[]{attributes.getValue("class"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_ANALYZER_ENTRY;
                    break;
                }
                case SEEKING_ANALYZER_ENTRY: {
                    if (!"void".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <void>", new Object[]{localName, this.state});
                    }
                    if (!"put".equals(attributes.getValue("method"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"method\" attribute value {0} in element <{1}> (state {2}): expected \"put\"", new Object[]{attributes.getValue("method"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_ANALYZER;
                    break;
                }
                case SEEKING_ANALYZER: {
                    if ("class".equals(localName)) break;
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <class>", new Object[]{localName, this.state});
                }
                case SEEKING_BEAN_MAP: {
                    if (!"object".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <object>", new Object[]{localName, this.state});
                    }
                    if (!"java.util.HashMap".equals(attributes.getValue("class")) && !"java.util.LinkedHashMap".equals(attributes.getValue("class"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"class\" attribute value {0} in element <{1}> (state {2}): expected \"java.util.HashMap\" or \"java.util.LinkedHashMap\"", new Object[]{attributes.getValue("class"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_BEAN_ENTRY;
                    break;
                }
                case SEEKING_BEAN_ENTRY: {
                    if (!"void".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <void>", new Object[]{localName, this.state});
                    }
                    if (!"put".equals(attributes.getValue("method"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"method\" attribute value {0} in element <{1}> (state {2}): expected \"put\"", new Object[]{attributes.getValue("method"), localName, this.state});
                    }
                    assert (this.value == null);
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_BEAN_ID;
                    this.value = new EncoderDecoderValue();
                    this.value.compoundHandle = new ArrayList<ValueHandle>();
                    break;
                }
                case SEEKING_BEAN_ID: {
                    if ("string".equals(localName)) break;
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <string>", new Object[]{localName, this.state});
                }
                case SEEKING_SETTER_LIST: {
                    if (!"object".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in state {1}: expected <string>", new Object[]{localName, this.state});
                    }
                    if (!"java.util.ArrayList".equals(attributes.getValue("class"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"class\" attribute value {0} in element <{1}> (state {2}): expected \"java.util.ArrayList\"", new Object[]{attributes.getValue("class"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_SETTERS_ADD;
                    break;
                }
                case SEEKING_SETTERS_ADD: {
                    if (!"void".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" (state {1}): expected <void>", new Object[]{localName, this.state});
                    }
                    if (!"add".equals(attributes.getValue("method"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"method\" attribute value {0} in element <{1}> (state {2}): expected \"add\"", new Object[]{attributes.getValue("method"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_SETTER_VALUE_PAIR;
                    break;
                }
                case SEEKING_SETTER_VALUE_PAIR: {
                    if (!"object".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in state {1}: expected <string>", new Object[]{localName, this.state});
                    }
                    if (!"oracle.jdeveloper.audit.service.Profile$Setter".equals(attributes.getValue("class"))) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected \"class\" attribute value {0} in element <{1}> (state {2}): expected \"oracle.jdeveloper.audit.service.Profile$Setter\"", new Object[]{attributes.getValue("class"), localName, this.state});
                    }
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_SETTER;
                    this.valueStack.push(this.value);
                    this.value = new EncoderDecoderValue();
                    break;
                }
                case SEEKING_SETTER: {
                    if ("null".equals(localName)) break;
                    String reference = attributes.getValue("idref");
                    if (reference == null) {
                        this.stateStack.push(this.state);
                        this.state = EncoderDecoderState.SEEKING_SETTER_NAME;
                        String id = attributes.getValue("id");
                        if (id == null) break;
                        if (id.isEmpty()) {
                            throw ProfileReaderWriter.this.createSAXException("id attribute of setter empty", new Object[0]);
                        }
                        this.value.pendingReference = id;
                        break;
                    }
                    this.value.name = this.nameReferences.get(reference);
                    if (this.value.name != null) break;
                    throw ProfileReaderWriter.this.createSAXException("Reference " + reference + " not found", new Object[0]);
                }
                case SEEKING_SETTER_NAME: {
                    if ("string".equals(localName)) break;
                    this.stateStack.push(this.state);
                    this.state = EncoderDecoderState.SEEKING_SETTER_NAME;
                    break;
                }
                case SEEKING_OBJECT_OR_VALUE: {
                    assert (this.value.pendingReference == null);
                    if ("object".equals(localName)) {
                        String reference = attributes.getValue("idref");
                        if (reference == null) {
                            this.stateStack.push(this.state);
                            this.state = EncoderDecoderState.SEEKING_VALUE;
                            String id = attributes.getValue("id");
                            if (id == null) break;
                            if (id.isEmpty()) {
                                throw ProfileReaderWriter.this.createSAXException("id attribute of setter empty", new Object[0]);
                            }
                            this.value.pendingReference = id;
                            break;
                        }
                        if (!this.simpleValueReferences.containsKey(reference)) {
                            throw ProfileReaderWriter.this.createSAXException("Reference " + reference + " not found", new Object[0]);
                        }
                        this.value.simpleValue = this.simpleValueReferences.get(reference);
                        this.state = EncoderDecoderState.SEEKING_OBJECT;
                        break;
                    }
                    if (this.primitives.contains(localName) || "null".equals(localName)) break;
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in state {1}: expected <object> or primitive", new Object[]{localName, this.state});
                }
                case SEEKING_OBJECT: {
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in state {1}: expected </object>", new Object[]{localName, this.state});
                }
                case SEEKING_VALUE: {
                    if (this.primitives.contains(localName) || "null".equals(localName)) break;
                    throw ProfileReaderWriter.this.createSAXException("unexpected element \"{0}\" in state {1}: expected primitive", new Object[]{localName, this.state});
                }
            }
            if (this.primitives.contains(localName)) {
                this.characters = new StringBuilder();
            }
            ProfileReaderWriter.this.enter("code", localName, new Object[]{initialState, initialDepth, this.state, this.stateStack.size(), this.value});
        }

        @Override
        public void characters(char[] characters, int start, int length) throws SAXException {
            if (this.characters == null) {
                throw ProfileReaderWriter.this.createSAXException("unexpected text content: expecting elements", new Object[0]);
            }
            this.characters.append(characters, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
            String primitiveText;
            EncoderDecoderState initialState = this.state;
            int initialDepth = this.stateStack.size();
            if (this.primitives.contains(localName)) {
                primitiveText = this.characters.toString();
                if ("true".equals(primitiveText)) {
                    primitiveText = "true";
                }
                if ("false".equals(primitiveText)) {
                    primitiveText = "false";
                }
                if (primitiveText.isEmpty()) {
                    throw ProfileReaderWriter.this.createSAXException("empty <{0}> element", new Object[]{localName});
                }
            } else {
                primitiveText = null;
            }
            this.characters = null;
            switch (this.state) {
                case SEEKING_ROOT: {
                    assert (this.stateStack.isEmpty());
                    break;
                }
                case SEEKING_ANALYZER_MAP: {
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_ROOT);
                    break;
                }
                case SEEKING_ANALYZER_ENTRY: {
                    if (!"object".equals(localName)) break;
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_ANALYZER_MAP);
                    break;
                }
                case SEEKING_ANALYZER: {
                    this.state = EncoderDecoderState.SEEKING_BEAN_MAP;
                    break;
                }
                case SEEKING_BEAN_MAP: {
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_ROOT, EncoderDecoderState.SEEKING_ANALYZER_ENTRY);
                    break;
                }
                case SEEKING_BEAN_ENTRY: {
                    if (!"object".equals(localName)) break;
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_BEAN_MAP);
                    break;
                }
                case SEEKING_BEAN_ID: {
                    this.value.name = primitiveText;
                    this.state = EncoderDecoderState.SEEKING_SETTER_LIST;
                    break;
                }
                case SEEKING_SETTER_LIST: {
                    if (!this.value.compoundHandle.isEmpty()) {
                        Collections.sort(this.value.compoundHandle);
                        ProfileReaderWriter.this.delta.put((Object)this.value.name, this.value.compoundHandle);
                    }
                    this.value = null;
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_BEAN_ENTRY);
                    break;
                }
                case SEEKING_SETTERS_ADD: {
                    if (!"object".equals(localName)) break;
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTER_LIST);
                    break;
                }
                case SEEKING_SETTER_VALUE_PAIR: {
                    EncoderDecoderValue enclosingValue = this.valueStack.pop();
                    if (this.value.name != null) {
                        ValueHandle handle = this.value.simpleValue != null ? new ValueHandle(this.value.name, this.value.simpleValue, null) : (this.value.compoundHandle != null ? new ValueHandle(this.value.name, this.value.compoundHandle, null) : new ValueHandle(this.value.name, null, null));
                        enclosingValue.compoundHandle.add(handle);
                    } else {
                        AuditLogger.warning("unexpected null name in <{0}> element{1}", localName, ProfileReaderWriter.this.at());
                    }
                    this.value = enclosingValue;
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTERS_ADD);
                    break;
                }
                case SEEKING_SETTER: {
                    if (this.value.pendingReference != null) {
                        this.nameReferences.put(this.value.pendingReference, this.value.name);
                        this.value.pendingReference = null;
                    }
                    this.state = EncoderDecoderState.SEEKING_OBJECT_OR_VALUE;
                    break;
                }
                case SEEKING_SETTER_NAME: {
                    if ("string".equals(localName)) {
                        this.value.name = Character.toLowerCase(primitiveText.charAt(3)) + primitiveText.substring(4);
                    }
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTER, EncoderDecoderState.SEEKING_SETTER_NAME);
                    if (this.state != EncoderDecoderState.SEEKING_SETTER) break;
                    ProfileReaderWriter.this.parser.setContentHandler((ContentHandler)new NullHandler(this));
                    break;
                }
                case SEEKING_OBJECT_OR_VALUE: {
                    if ("object".equals(localName)) {
                        if (this.value.pendingReference != null) {
                            this.simpleValueReferences.put(this.value.pendingReference, this.value.simpleValue);
                            this.value.pendingReference = null;
                        }
                    } else if (this.primitives.contains(localName) || "null".equals(localName)) {
                        this.value.compoundHandle = null;
                        this.value.simpleValue = primitiveText;
                    }
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTER_VALUE_PAIR);
                    break;
                }
                case SEEKING_OBJECT: {
                    if (!"object".equals(localName)) {
                        throw ProfileReaderWriter.this.createSAXException("unexpected end element \"{0}\" in state {1}: expected </object>", new Object[]{localName, this.state});
                    }
                    this.state = this.stateStack.pop();
                    ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTER_VALUE_PAIR);
                    break;
                }
                case SEEKING_VALUE: {
                    if ("object".equals(localName)) {
                        if (this.value.pendingReference != null) {
                            this.simpleValueReferences.put(this.value.pendingReference, this.value.simpleValue);
                            this.value.pendingReference = null;
                        }
                        this.state = this.stateStack.pop();
                        this.state = this.stateStack.pop();
                        ProfileReaderWriter.this.assertState(this.state, EncoderDecoderState.SEEKING_SETTER_VALUE_PAIR);
                        break;
                    }
                    if (!this.primitives.contains(localName) && !"null".equals(localName)) break;
                    this.value.compoundHandle = null;
                    this.value.simpleValue = primitiveText;
                }
            }
            this.characters = null;
            if (this.state == EncoderDecoderState.SEEKING_ROOT) {
                Collection sealedHandles = ProfileReaderWriter.this.delta.remove((Object)ProfileReaderWriter.SEALED_ID);
                if (sealedHandles != null) {
                    for (ValueHandle handle : sealedHandles) {
                        if (!"enabled".equals(handle.getName())) continue;
                        ProfileReaderWriter.this.sealed = ProfileReaderWriter.this.sealed || handle.isTrue();
                    }
                }
                int i = 0;
                while (i < this.migrationTable.length) {
                    Collection handles;
                    String id;
                    String name = (String)this.migrationTable[i++];
                    if ((id = (String)this.migrationTable[i++]) == null) {
                        ProfileReaderWriter.this.delta.remove((Object)name);
                        continue;
                    }
                    if (ProfileReaderWriter.this.delta.containsKey((Object)id) || (handles = ProfileReaderWriter.this.delta.remove((Object)name)) == null) continue;
                    ProfileReaderWriter.this.delta.put((Object)id, handles);
                }
            }
            ProfileReaderWriter.this.exit("code", localName, new Object[]{initialState, initialDepth, this.state, this.stateStack.size(), this.value});
        }
    }

    private static class EncoderDecoderValue {
        String name;
        List<ValueHandle> compoundHandle;
        String simpleValue;
        String pendingReference;

        private EncoderDecoderValue() {
        }

        public String toString() {
            return "[" + this.name + ", " + this.simpleValue + ", " + this.compoundHandle + "]";
        }
    }

    private static enum EncoderDecoderState {
        SEEKING_ROOT,
        SEEKING_ANALYZER_MAP,
        SEEKING_ANALYZER_ENTRY,
        SEEKING_ANALYZER,
        SEEKING_BEAN_MAP,
        SEEKING_BEAN_ENTRY,
        SEEKING_BEAN_ID,
        SEEKING_SETTER_LIST,
        SEEKING_SETTERS_ADD,
        SEEKING_SETTER_VALUE_PAIR,
        SEEKING_SETTER,
        SEEKING_SETTER_NAME,
        SEEKING_OBJECT_OR_VALUE,
        SEEKING_OBJECT,
        SEEKING_VALUE;

    }

    private class BeanHandler
    extends DefaultHandler {
        private final Deque<Tuple<String, Collection<ValueHandle>>> valueStack = new ArrayDeque<Tuple<String, Collection<ValueHandle>>>();
        private String name;
        private Collection<ValueHandle> handles = new ArrayList<ValueHandle>();
        private StringBuilder characters;
        private int depth;

        private BeanHandler() {
            ProfileReaderWriter.this.delta = new MultiMap();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            ProfileReaderWriter.this.enter("bean", localName, new Object[0]);
            if (this.characters != null) {
                throw ProfileReaderWriter.this.createSAXException("unexpected element <" + localName + "> in text content", new Object[0]);
            }
            if (this.depth == 0) {
                if (!"bean".equals(localName)) throw ProfileReaderWriter.this.createSAXException("unexpected element <" + localName + ">: expected <bean>", new Object[0]);
                assert (this.name == null && this.valueStack.isEmpty());
                this.name = attributes.getValue("id");
                this.handles = new ArrayList<ValueHandle>();
            } else if ("null".equals(localName)) {
                if (this.depth == 1) {
                    throw ProfileReaderWriter.this.createSAXException("unexpected element <null>: bean value cannot be null", new Object[0]);
                }
                this.handles = null;
            } else {
                if (this.handles == null) {
                    throw ProfileReaderWriter.this.createSAXException("unexpected element <" + localName + "> after <null> element", new Object[0]);
                }
                this.valueStack.push((Tuple<String, Collection<ValueHandle>>)new Tuple((Object)this.name, this.handles));
                this.name = localName;
                this.handles = new ArrayList<ValueHandle>();
            }
            ++this.depth;
        }

        @Override
        public void characters(char[] characters, int start, int length) throws SAXException {
            if (this.depth == 0) {
                throw ProfileReaderWriter.this.createSAXException("unexpected text content: expected <bean>", new Object[0]);
            }
            if (this.depth == 1) {
                throw ProfileReaderWriter.this.createSAXException("unexpected text content: expected value elements", new Object[0]);
            }
            if (this.handles == null) {
                throw ProfileReaderWriter.this.createSAXException("unexpected text content in <null> element", new Object[0]);
            }
            if (!this.handles.isEmpty()) {
                throw ProfileReaderWriter.this.createSAXException("unexpected text content after value element", new Object[0]);
            }
            if (this.characters == null) {
                this.characters = new StringBuilder();
            }
            this.characters.append(characters, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qualifedName) throws SAXException {
            ProfileReaderWriter.this.exit("bean", localName, new Object[0]);
            --this.depth;
            if (this.depth == -1) {
                assert (ProfileReaderWriter.AUDIT_PROFILE.equals(localName));
            } else if (this.depth == 0) {
                assert ("bean".equals(localName));
                assert (this.name != null && this.valueStack.isEmpty());
                if (this.characters != null) {
                    throw ProfileReaderWriter.this.createSAXException("unexpected text content in <bean> element", new Object[0]);
                }
                ProfileReaderWriter.this.delta.put((Object)this.name, this.handles);
                this.name = null;
                this.handles = null;
            } else if ("null".equals(localName)) {
                if (this.characters != null) {
                    throw ProfileReaderWriter.this.createSAXException("unexpected text content in <null> element", new Object[0]);
                }
                this.handles = null;
            } else {
                ValueHandle handle;
                if (this.name == null) {
                    AuditLogger.warning("unexpected null name in <{0}> element{1}", localName, ProfileReaderWriter.this.at());
                }
                if (this.valueStack.isEmpty()) {
                    throw ProfileReaderWriter.this.createSAXException("value element other than <bean> at top level", new Object[0]);
                }
                if (this.handles == null) {
                    assert (this.characters == null);
                    handle = new ValueHandle(this.name, null, null);
                } else if (this.characters != null) {
                    assert (this.handles.isEmpty());
                    String representation = this.characters.toString();
                    if ("true".equals(representation)) {
                        representation = "true";
                    } else if ("false".equals(representation)) {
                        representation = "false";
                    }
                    handle = new ValueHandle(this.name, representation, null);
                } else {
                    handle = new ValueHandle(this.name, this.handles, null);
                }
                Tuple<String, Collection<ValueHandle>> top = this.valueStack.pop();
                this.name = (String)top.object1();
                this.handles = (Collection)top.object2();
                this.handles.add(handle);
            }
            this.characters = null;
        }
    }
}

