/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.List;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.swing.Action;
import oracle.javatools.status.Severity;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AuditELContext;

class DefaultIssue
implements Violation {
    private final Rule rule;
    private String variation;
    private final Location location;
    private Location focusLocation;
    private Object[] parameters = NO_PARAMETERS;
    private Transform defaultTransform;
    private int transformMask;
    private final int serialNumber;
    private Suppression[] suppressions = NO_SUPPRESSIONS;
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static final Suppression[] NO_SUPPRESSIONS = new Suppression[0];

    DefaultIssue(Rule rule, Location location, int serialNumber) {
        this.rule = rule;
        this.location = location;
        this.transformMask = (1 << rule.getTransforms().length) - 1;
        this.defaultTransform = rule.getDefaultTransform();
        this.serialNumber = serialNumber;
    }

    public String getMessage() {
        return this.rule.message(this);
    }

    public String getHtmlMessage() {
        return this.rule.htmlMessage(this);
    }

    public Severity getSeverity() {
        return this.rule.getSeverity().getIssueSeverity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConstruct() {
        ModelAdapter model = this.location.getModel();
        boolean locked = false;
        try {
            model.beginRead();
            locked = true;
            Object object = model.getConstruct(this.location);
            return object;
        }
        catch (ModelAccessError e) {
            Object var4_6 = null;
            return var4_6;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            if (locked) {
                model.endRead();
            }
        }
    }

    public int getOffset() {
        return this.location.getOffset();
    }

    public int getLength() {
        return this.location.getLength();
    }

    public boolean hasTransforms() {
        return this.transformMask != 0;
    }

    public List<? extends Action> getTransforms() {
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        return transformer.createTransformActions(this, null, null);
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public String getVariation() {
        return this.variation;
    }

    public ModelAdapter getModel() {
        return this.location.getModel();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Location getFocusLocation() {
        return this.focusLocation;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length / 2;
    }

    @Override
    public String getParameterName(int index) {
        return (String)this.parameters[index * 2];
    }

    @Override
    public Object getParameterValue(int index) {
        return this.parameters[index * 2 + 1];
    }

    @Override
    public Object getParameterValue(String name) {
        for (int i = 0; i < this.parameters.length; i += 2) {
            if (!name.equals(this.parameters[i])) continue;
            return this.parameters[i + 1];
        }
        return null;
    }

    @Override
    public int getTransformCount() {
        int count = 0;
        for (int i = 0; i < 15; ++i) {
            if ((this.transformMask & 1 << i) == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Transform getTransform(int index) {
        for (int i = 0; i < 15; ++i) {
            if ((this.transformMask & 1 << i) == 0 || index-- != 0) continue;
            return this.rule.getTransforms()[i];
        }
        throw new IndexOutOfBoundsException(index + " of " + this.getTransformCount());
    }

    @Override
    public Transform getDefaultTransform() {
        Transform[] transforms = this.rule.getTransforms();
        for (int i = 0; i < transforms.length; ++i) {
            if ((this.transformMask & 1 << i) == 0 || transforms[i] != this.defaultTransform) continue;
            return this.defaultTransform;
        }
        return null;
    }

    public int getTransformMask() {
        return this.transformMask;
    }

    @Override
    public int getSuppressionCount() {
        return this.suppressions.length;
    }

    @Override
    public Suppression getSuppression(int index) {
        return this.suppressions[index];
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    void suspend(Object construct) {
        if (this.focusLocation == null && construct != null) {
            this.focusLocation = this.location.getModel().getFocusLocation(construct, this.location);
        }
        for (Parameter parameter : this.rule.parameters()) {
            boolean found = false;
            String requiredName = parameter.getName();
            for (int i = 0; i < this.parameters.length; i += 2) {
                if (!requiredName.equals(this.parameters[i])) continue;
                found = true;
                Object value = this.parameters[i + 1];
                if (value == null) {
                    this.rule.logWarning("Parameter ''{0}'' null", requiredName);
                    break;
                }
                if (parameter.getType().isInstance(value)) break;
                this.rule.logError("Parameter ''{0}'' type ''{1}'' not convertible to expected type ''{2}''", requiredName, value.getClass().getName(), parameter.getType().getName());
                break;
            }
            if (found || !parameter.isRequired()) continue;
            this.rule.logError("Required parameter ''{0}'' not added", requiredName);
        }
    }

    void close(List<Suppression> suppressions, AuditELContext expressionContext) {
        this.suppressions = suppressions.isEmpty() ? NO_SUPPRESSIONS : suppressions.toArray(new Suppression[suppressions.size()]);
        Transform[] transforms = this.rule.getTransforms();
        if (transforms != null) {
            for (int i = 0; i < transforms.length; ++i) {
                DeferredExpression condition;
                Transform transform = transforms[i];
                expressionContext.setBean(transform, this.rule, this);
                boolean applicable = true;
                for (Map.Entry<String, DeferredSetter> entry : transform.setters().entrySet()) {
                    DeferredSetter setter = entry.getValue();
                    try {
                        Object value = setter.set(transform, expressionContext);
                        if (!setter.isRequired() || value != null) continue;
                        applicable = false;
                        break;
                    }
                    catch (Throwable e) {
                        setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform, setter.getText(), e);
                    }
                }
                if (applicable && (condition = transform.condition()) != null) {
                    try {
                        Boolean value = (Boolean)condition.evaluate(expressionContext);
                        if (value == null) {
                            value = false;
                        }
                        applicable = value;
                    }
                    catch (PropertyNotFoundException e) {
                        applicable = false;
                        condition.log("evaluating \"{0}\" failed: {1}", condition.getText(), e.getMessage());
                    }
                    catch (Exception e) {
                        applicable = false;
                        condition.log("evaluating \"{0}\" failed: {1}", condition.getText(), e);
                    }
                }
                if (applicable) continue;
                this.transformMask &= ~(1 << i);
                if (transform != this.defaultTransform) continue;
                this.defaultTransform = null;
            }
            expressionContext.clear();
        }
    }

    void addParameter(String name, Object value) {
        if (this.parameters.length == 0) {
            this.parameters = new Object[]{name, value};
        } else {
            int count = this.parameters.length;
            this.parameters = new Object[count + 2];
            System.arraycopy(this.parameters, 0, this.parameters, 0, count);
            this.parameters[count] = name;
            this.parameters[count + 1] = value;
        }
    }

    void setFocusLocation(Location location) {
        this.focusLocation = location;
    }

    void setVariation(String name) {
        if (name != null) {
            for (String variation : this.rule.variations()) {
                if (!variation.equals(name)) continue;
                this.variation = variation;
                return;
            }
            throw new IllegalArgumentException("No variation \"" + name + "\" defined for rule " + this.rule.id());
        }
        this.variation = null;
    }

    void hideAllTransforms() {
        this.transformMask = 0;
        this.defaultTransform = null;
    }

    public void showTransform(Transform transform) {
        Transform[] transforms = this.rule.getTransforms();
        for (int i = 0; i < transforms.length; ++i) {
            if (transform != transforms[i]) continue;
            this.transformMask |= 1 << i;
            return;
        }
    }

    public void hideTransform(Transform transform) {
        Transform[] transforms = this.rule.getTransforms();
        for (int i = 0; i < transforms.length; ++i) {
            if (transform != transforms[i]) continue;
            this.transformMask &= ~(1 << i);
            return;
        }
        if (transform == this.defaultTransform) {
            this.defaultTransform = null;
        }
    }

    public void setDefaultTransform(Transform transform) {
        this.defaultTransform = transform;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Issue@");
        builder.append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        builder.append(this.rule.id());
        if (this.variation != null) {
            builder.append('(').append(this.variation).append(')');
        }
        builder.append('@').append(this.location);
        builder.append('[');
        for (i = 0; i < this.getParameterCount(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.getParameterName(i));
            builder.append('=');
            builder.append(this.getParameterValue(i));
        }
        builder.append("][");
        for (i = 0; i < this.getSuppressionCount(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.getSuppression(i));
        }
        builder.append("][");
        for (i = 0; i < this.getTransformCount(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.getTransform(i).id());
        }
        builder.append("]}");
        return builder.toString();
    }
}

