/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import com.sun.el.ExpressionFactoryImpl;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import oracle.ide.ExtensionRegistry;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.CategoryDefinition;
import oracle.jdeveloper.audit.extension.Condition;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.extension.HasCategory;
import oracle.jdeveloper.audit.extension.MetricDefinition;
import oracle.jdeveloper.audit.extension.ParameterDefinition;
import oracle.jdeveloper.audit.extension.Required;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.extension.SuppressionSchemeDefinition;
import oracle.jdeveloper.audit.extension.TransformBinding;
import oracle.jdeveloper.audit.extension.TransformDefinition;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.extension.Value;
import oracle.jdeveloper.audit.transform.CompositeTransform;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.PropertyDeferredException;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;
import oracle.jdevimpl.audit.util.SortedCollections;
import org.xml.sax.Locator;

public class DefaultExtensionBeanFactory
implements ExtensionBeanFactory {
    private Map<String, BeanDefinition<?>> definitions;
    private Map<String, BeanDefinition<?>> unloadedDefinitions;
    private Map<String, ExtensionBean> beans;
    private static DefaultExtensionBeanFactory defaultFactory;
    private static final Log LOG;
    private static Field definitionField;
    private static Field settersField;
    private static Field categoryCategoryField;
    private static Field conditionField;
    private static Field ruleParametersField;
    private static Field ruleCategoryField;
    private static Field ruleTransformsField;
    private static Field defaultTransformField;
    private static Field schemeParametersField;
    private static Field schemeCategoryField;
    private static Field schemeTransformsField;
    private static Field metricCategoryField;
    private static Field valueTypeField;
    private ExpressionFactory expressionFactory;
    private AuditELContext expressionContext;
    private int cycle;
    private static final Parameter[] NO_PARAMETERS;
    private static final Object LOCK;
    private final Comparator<?> propertyValueComparator = (l, r) -> ((PropertyDescriptor)l).getName().compareTo(((Value)r).getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultExtensionBeanFactory getDefaultFactory() {
        Object object = LOCK;
        synchronized (object) {
            if (defaultFactory == null) {
                defaultFactory = new DefaultExtensionBeanFactory(new BeanDefinition[0]);
            }
        }
        return defaultFactory;
    }

    public DefaultExtensionBeanFactory(BeanDefinition<?> ... definitions) {
        if (definitions != null && definitions.length > 0) {
            this.definitions = new LinkedHashMap(definitions.length);
            for (BeanDefinition<?> definition : definitions) {
                this.definitions.put(definition.getId(), definition);
            }
        }
    }

    public DefaultExtensionBeanFactory(Iterable<BeanDefinition<?>> definitions) {
        Iterator<BeanDefinition<?>> iterator;
        if (definitions != null && (iterator = definitions.iterator()).hasNext()) {
            this.definitions = new LinkedHashMap();
            do {
                BeanDefinition<?> definition = iterator.next();
                this.definitions.put(definition.getId(), definition);
            } while (iterator.hasNext());
        }
    }

    @Override
    public synchronized Map<String, BeanDefinition<?>> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = AuditHook.getAuditHook().getBeansById();
        }
        return this.definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, ExtensionBean> getBeans(boolean force) {
        LOG.trace("initializing beans");
        ++this.cycle;
        String LOGGER_ID = "audit-initialization";
        PerformanceLogger timer = PerformanceLogger.get();
        timer.startTiming(LOGGER_ID);
        int unloadedCount = -1;
        try {
            this.initialize();
            Map<String, BeanDefinition<?>> definitions = this.unloadedDefinitions == null ? this.getDefinitions() : this.unloadedDefinitions;
            unloadedCount = definitions.size();
            this.unloadedDefinitions = new LinkedHashMap();
            for (BeanDefinition<?> definition : definitions.values()) {
                if (!definition.isExtensionLoaded() && !force) {
                    this.unloadedDefinitions.put(definition.getId(), definition);
                    continue;
                }
                if (this.beans.containsKey(definition.getId())) continue;
                if (definition instanceof RuleDefinition) {
                    this.processRule((RuleDefinition)definition, force, this.beans);
                    continue;
                }
                if (definition instanceof SuppressionSchemeDefinition) {
                    this.processSuppressionScheme((SuppressionSchemeDefinition)definition, force, this.beans);
                    continue;
                }
                if (definition instanceof MetricDefinition) {
                    this.processMetric((MetricDefinition)definition, force, this.beans);
                    continue;
                }
                if (!(definition instanceof CategoryDefinition)) continue;
                this.processCategory((CategoryDefinition)definition, force, this.beans);
            }
        }
        catch (Throwable throwable) {
            LOG.trace("completed initializing beans");
            timer.stopTiming(LOGGER_ID, 5, "{0} cycle {1}, loaded {2} of {3}", new Object[]{this, this.cycle, this.unloadedDefinitions != null ? Integer.valueOf(unloadedCount - this.unloadedDefinitions.size()) : "?", unloadedCount});
            throw throwable;
        }
        LOG.trace("completed initializing beans");
        timer.stopTiming(LOGGER_ID, 5, "{0} cycle {1}, loaded {2} of {3}", new Object[]{this, this.cycle, this.unloadedDefinitions != null ? Integer.valueOf(unloadedCount - this.unloadedDefinitions.size()) : "?", unloadedCount});
        this.expressionContext.clear();
        return this.beans;
    }

    @Override
    public ExtensionBean getBean(String id, boolean force) {
        BeanDefinition<?> definition = this.getDefinitions().get(id);
        if (definition == null) {
            throw new IllegalArgumentException("definition for \"" + id + "\" not found in factory");
        }
        return this.getBean(id, definition, force);
    }

    @Override
    public ExtensionBean getBean(BeanDefinition<?> definition, boolean force) {
        String id = definition.getId();
        if (this.getDefinitions().get(id) != definition) {
            throw new IllegalArgumentException("definition " + definition + " not found in factory");
        }
        return this.getBean(id, definition, force);
    }

    private synchronized ExtensionBean getBean(String id, BeanDefinition<?> definition, boolean force) {
        BeanDefinition<?> unloadedDefinition;
        this.initialize();
        ExtensionBean bean = this.beans.get(id);
        if (bean != null) {
            return bean;
        }
        if (!force && !definition.isExtensionLoaded()) {
            return null;
        }
        if (this.unloadedDefinitions == null) {
            this.unloadedDefinitions = new LinkedHashMap(this.getDefinitions());
        }
        if ((unloadedDefinition = this.unloadedDefinitions.remove(id)) == null) {
            return null;
        }
        assert (unloadedDefinition == definition);
        if (definition instanceof RuleDefinition) {
            return this.processRule((RuleDefinition)definition, force, this.beans);
        }
        if (definition instanceof SuppressionSchemeDefinition) {
            return this.processSuppressionScheme((SuppressionSchemeDefinition)definition, force, this.beans);
        }
        if (definition instanceof MetricDefinition) {
            return this.processMetric((MetricDefinition)definition, force, this.beans);
        }
        if (definition instanceof CategoryDefinition) {
            return this.processCategory((CategoryDefinition)definition, force, this.beans);
        }
        return null;
    }

    private void initialize() {
        if (definitionField == null) {
            definitionField = this.getField(ExtensionBean.class, "definition");
            settersField = this.getField(ExtensionBean.class, "setters");
            categoryCategoryField = this.getField(Category.class, "category");
            conditionField = this.getField(Transform.class, "condition");
            ruleParametersField = this.getField(Rule.class, "parameters");
            ruleCategoryField = this.getField(Rule.class, "category");
            ruleTransformsField = this.getField(Rule.class, "transforms");
            defaultTransformField = this.getField(Rule.class, "defaultTransform");
            schemeParametersField = this.getField(SuppressionScheme.class, "parameters");
            schemeCategoryField = this.getField(SuppressionScheme.class, "category");
            schemeTransformsField = this.getField(SuppressionScheme.class, "transforms");
            metricCategoryField = this.getField(Metric.class, "category");
            valueTypeField = this.getField(Metric.class, "type");
        }
        if (this.beans == null) {
            this.expressionFactory = new ExpressionFactoryImpl();
            this.expressionContext = new AuditELContext();
            this.beans = new LinkedHashMap<String, ExtensionBean>();
        }
    }

    private Metric processMetric(MetricDefinition definition, boolean force, Map<String, ExtensionBean> beans) {
        try {
            TypeDefinition<?> valueTypeDefinition;
            Metric metric;
            TypeDefinition metricClass = definition.getImplementationClass();
            if (metricClass != null) {
                metric = (Metric)metricClass.getInstance(force);
                if (metric == null) {
                    metric = new Metric();
                }
            } else {
                metric = new Metric();
            }
            if ((valueTypeDefinition = definition.getValueType()) == null) {
                return null;
            }
            Class<?> valueType = valueTypeDefinition.getType(force);
            this.inject(definitionField, metric, definition, definition);
            this.inject(metricCategoryField, metric, this.category(definition, true, force, beans), definition);
            this.inject(valueTypeField, metric, valueType, definition);
            this.expressionContext.setBean(metric);
            this.configure(definition, metric, definition.getValues(), null, this.expressionFactory, this.expressionContext);
            beans.put(metric.id(), metric);
            for (String id : definition.getDeprecatedIds()) {
                beans.put(id, metric);
            }
            return metric;
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, e, "Metric ''{0}'' not created: {1}", definition.getId(), e);
            return null;
        }
    }

    private Rule processRule(RuleDefinition definition, boolean force, Map<String, ExtensionBean> beans) {
        String ruleId = definition.getId();
        TypeDefinition ruleClass = definition.getImplementationClass();
        try {
            Parameter[] parameters;
            Rule rule;
            if (ruleClass != null) {
                rule = (Rule)ruleClass.getInstance(force);
                if (rule == null) {
                    rule = new Rule();
                }
            } else {
                rule = new Rule();
            }
            this.inject(definitionField, rule, definition, definition);
            this.inject(ruleCategoryField, rule, this.category(definition, true, force, beans), definition);
            int parametersSize = definition.getParameters().size();
            if (parametersSize > 0) {
                parameters = new Parameter[parametersSize];
                int p = 0;
                for (ParameterDefinition parameter : definition.getParameters()) {
                    String parameterName = parameter.getName();
                    TypeDefinition typeDefinition = parameter.getParameterType();
                    Class<Object> type = typeDefinition.getType(force);
                    if (type == null) {
                        type = Object.class;
                    }
                    parameters[p++] = new DefaultParameter(parameterName, type, parameter.isRequired());
                    if (Beans.getPropertyDescriptor(rule, parameterName) == null) continue;
                    parameter.log(Level.SEVERE, "Parameter ''{0}'' conflicts with property of same name", parameterName);
                }
            } else {
                parameters = NO_PARAMETERS;
            }
            this.inject(ruleParametersField, rule, parameters, definition);
            this.expressionContext.setBean(rule);
            this.configure(definition, rule, definition.getValues(), null, this.expressionFactory, this.expressionContext);
            beans.put(ruleId, rule);
            for (String id : definition.getDeprecatedIds()) {
                beans.put(id, rule);
            }
            this.processBindings(definition.getTransformBindings(), definition, rule, null, force);
            return rule;
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, e, "Rule ''{0}'' not created: {1}", ruleId, e);
            return null;
        }
    }

    private SuppressionScheme processSuppressionScheme(SuppressionSchemeDefinition definition, boolean force, Map<String, ExtensionBean> beans) {
        String schemeId = definition.getId();
        TypeDefinition schemeClass = definition.getImplementationClass();
        try {
            Parameter[] parameters;
            SuppressionScheme scheme;
            if (schemeClass != null) {
                scheme = (SuppressionScheme)schemeClass.getInstance(force);
                if (scheme == null) {
                    scheme = new SuppressionScheme();
                }
            } else {
                scheme = new SuppressionScheme();
            }
            this.inject(definitionField, scheme, definition, definition);
            this.inject(schemeCategoryField, scheme, this.category(definition, true, force, beans), definition);
            int parametersSize = definition.getParameters().size();
            if (parametersSize > 0) {
                parameters = new Parameter[parametersSize];
                int p = 0;
                for (ParameterDefinition parameter : definition.getParameters()) {
                    String parameterName = parameter.getName();
                    TypeDefinition typeDefinition = parameter.getParameterType();
                    Class<Object> type = typeDefinition.getType(force);
                    if (type == null) {
                        type = Object.class;
                    }
                    parameters[p++] = new DefaultParameter(parameterName, type, parameter.isRequired());
                    if (Beans.getPropertyDescriptor(scheme, parameterName) == null) continue;
                    parameter.log(Level.SEVERE, "Parameter ''{0}'' conflicts with property of same name", parameterName);
                }
            } else {
                parameters = NO_PARAMETERS;
            }
            this.inject(schemeParametersField, scheme, parameters, definition);
            this.expressionContext.setBean(scheme);
            this.configure(definition, scheme, definition.getValues(), null, this.expressionFactory, this.expressionContext);
            beans.put(schemeId, scheme);
            for (String id : definition.getDeprecatedIds()) {
                beans.put(id, scheme);
            }
            this.processBindings(definition.getTransformBindings(), definition, null, scheme, force);
            return scheme;
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, e, "SuppressionScheme ''{0}'' not created: {1}", schemeId, e);
            return null;
        }
    }

    private <T extends BeanDefinition<?>> void processBindings(Collection<TransformBinding<? extends BeanDefinition<? extends ExtensionBean>>> bindings, BeanDefinition<?> definition, Rule rule, SuppressionScheme scheme, boolean force) {
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        Transform defaultTransform = null;
        String defaultTransformExtensionId = null;
        block9: for (TransformBinding<? extends BeanDefinition<? extends ExtensionBean>> binding : bindings) {
            Transform transform;
            TransformDefinition transformDefinition = binding.getTransform();
            if (transformDefinition == null) continue;
            String transformId = transformDefinition.getId();
            TypeDefinition transformClass = transformDefinition.getImplementationClass();
            if (transformDefinition.isComposite()) {
                if (transformClass != null) {
                    transform = (Transform)transformClass.getInstance(force);
                    if (!(transform instanceof CompositeTransform)) {
                        transformClass.log(Level.SEVERE, "Transform ''{0}'' class ''{1}'' does not extend ''{2}''", transformId, transform.getClass().getName(), CompositeTransform.class.getName());
                        continue;
                    }
                } else {
                    transform = new CompositeTransform();
                }
                CompositeTransform composite = (CompositeTransform)transform;
                for (TransformDefinition componentDefinition : transformDefinition.getTransforms()) {
                    TypeDefinition componentClass = componentDefinition.getImplementationClass();
                    Transform component = (Transform)componentClass.getInstance(force);
                    if (component == null) continue block9;
                    component.setEnabled(true);
                    this.inject(definitionField, component, componentDefinition, componentDefinition);
                    HashMap<String, DeferredSetter> deferredValues = new HashMap<String, DeferredSetter>();
                    this.expressionContext.setBean(component, rule != null ? rule : scheme);
                    this.configure(componentDefinition, component, this.merge(binding.getValues(), componentDefinition.getValues()), deferredValues, this.expressionFactory, this.expressionContext);
                    this.inject(settersField, component, deferredValues, componentDefinition);
                    composite.addComponent(component);
                }
            } else {
                transform = (Transform)transformClass.getInstance(force);
                if (transform == null) continue;
            }
            this.inject(definitionField, transform, transformDefinition, transformDefinition);
            HashMap<String, DeferredSetter> deferredValues = new HashMap<String, DeferredSetter>();
            this.expressionContext.setBean(transform, rule != null ? rule : scheme);
            this.configure(transformDefinition, transform, this.merge(binding.getValues(), transformDefinition.getValues()), deferredValues, this.expressionFactory, this.expressionContext);
            this.inject(settersField, transform, deferredValues, transformDefinition);
            Condition condition = binding.getCondition();
            if (condition != null) {
                String text = condition.getText();
                Object expressionText = switch (text.charAt(0)) {
                    case '#', '$' -> text;
                    default -> "${" + text + "}";
                };
                ValueExpression expression = null;
                try {
                    expression = this.expressionFactory.createValueExpression((ELContext)this.expressionContext, (String)expressionText, Boolean.TYPE);
                }
                catch (ELException e) {
                    binding.log(Level.SEVERE, e, "parsing \"{0}\" failed: {1}", new Object[]{text, e});
                }
                if (expression != null) {
                    DeferredExpression deferredExpression;
                    try {
                        this.expressionContext.setLocation(binding);
                        Boolean value = (Boolean)this.expressionContext.evaluateExpression(expression);
                        if (value == null) {
                            value = false;
                        }
                        deferredExpression = new ConstantDeferredExpression(value, text, condition);
                        this.inject(conditionField, transform, deferredExpression, transformDefinition);
                    }
                    catch (PropertyDeferredException e) {
                        deferredExpression = new DefaultDeferredExpression(expression, text, condition);
                        this.inject(conditionField, transform, deferredExpression, transformDefinition);
                    }
                    catch (PropertyNotFoundException e) {
                        deferredExpression = new ConstantDeferredExpression(false, text, condition);
                        this.inject(conditionField, transform, deferredExpression, transformDefinition);
                        condition.log(Level.SEVERE, "evaluating \"{0}\" failed: {1}", text, e.getMessage());
                    }
                    catch (Exception e) {
                        deferredExpression = new ConstantDeferredExpression(false, text, condition);
                        this.inject(conditionField, transform, deferredExpression, transformDefinition);
                        condition.log(Level.SEVERE, "evaluating \"{0}\" failed: {1}", text, e);
                    }
                }
            }
            transforms.add(transform);
            if (!binding.isDefault()) continue;
            if (defaultTransform == null) {
                defaultTransform = transform;
                defaultTransformExtensionId = binding.getExtensionId();
                continue;
            }
            binding.log(Level.SEVERE, "Default transform already defined as ''{0}'' by extension ''{1}''", defaultTransform.id(), defaultTransformExtensionId);
        }
        if (rule != null) {
            this.inject(ruleTransformsField, rule, transforms.toArray(new Transform[transforms.size()]), definition);
            this.inject(defaultTransformField, rule, defaultTransform, definition);
        } else {
            this.inject(schemeTransformsField, scheme, transforms.toArray(new Transform[transforms.size()]), definition);
        }
    }

    private Category processCategory(CategoryDefinition definition, boolean force, Map<String, ExtensionBean> beans) {
        Category parentCategory = this.category(definition, false, force, beans);
        TypeDefinition beanClass = definition.getImplementationClass();
        try {
            Category category;
            if (beanClass != null) {
                category = (Category)beanClass.getInstance(force);
                if (category == null) {
                    category = new Category();
                }
            } else {
                category = new Category();
            }
            this.inject(definitionField, category, definition, definition);
            this.inject(categoryCategoryField, category, parentCategory, definition);
            this.expressionContext.setBean(category);
            this.configure(definition, category, definition.getValues(), null, this.expressionFactory, this.expressionContext);
            beans.put(category.id(), category);
            for (String id : definition.getDeprecatedIds()) {
                beans.put(id, category);
            }
            return category;
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, e, "Category ''{0}'' not created: {1}", definition.getId(), e);
            return null;
        }
    }

    private Category category(HasCategory definition, boolean required, boolean force, Map<String, ExtensionBean> beans) {
        CategoryDefinition categoryDefinition = definition.getCategory();
        if (categoryDefinition != null) {
            ExtensionBean bean = beans.get(categoryDefinition.getId());
            if (bean instanceof Category) {
                return (Category)bean;
            }
            Category category = this.processCategory(categoryDefinition, force, beans);
            if (category != null) {
                return category;
            }
            return this.undefinedCategory(beans);
        }
        if (required) {
            return this.undefinedCategory(beans);
        }
        return null;
    }

    private Category undefinedCategory(Map<String, ExtensionBean> beans) {
        String UNDEFINED_CATEGORY_ID = "oracle.ide.audit.undefined";
        Category category = (Category)beans.get(UNDEFINED_CATEGORY_ID);
        if (category == null) {
            CategoryDefinition definition = (CategoryDefinition)this.getDefinitions().get(UNDEFINED_CATEGORY_ID);
            category = this.processCategory(definition, true, beans);
        }
        return category;
    }

    private Collection<Value> merge(Collection<Value> left, Collection<Value> right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        ArrayList<Value> values = new ArrayList<Value>(left.size() + right.size());
        SortedCollections.ComparisonIterator<Value, Value> iterator = SortedCollections.comparisonIterator(left, right);
        while (iterator.hasNext()) {
            switch (iterator.next()) {
                case LESS_THAN: {
                    values.add(iterator.left());
                    break;
                }
                case GREATER_THAN: {
                    values.add(iterator.right());
                    break;
                }
                case EQUAL: {
                    values.add(iterator.left());
                }
            }
        }
        return values;
    }

    private void log(Level level, String message, Object ... parameters) {
        Logger logger = ExtensionRegistry.getExtensionRegistry().getManifestLogger();
        logger.log(level, message, parameters);
    }

    private Field getField(Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            this.log(Level.SEVERE, "Field ''{0}'' of type ''{1}'' not found: {3}", name, type, e);
            return null;
        }
    }

    private void inject(Field field, Object object, Object value, Definition definition) {
        try {
            if (field != null) {
                field.set(object, value);
            }
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, e, "Field ''{0}'' of ''{1}'' not set to \"{2}\": {3}", field, object, value, e);
        }
    }

    private void configure(Definition definition, Object bean, Collection<Value> values, Map<String, DeferredSetter> deferredValues, ExpressionFactory expressionFactory, AuditELContext expressionContext) {
        Class<?> beanClass = bean.getClass();
        if (beanClass.isArray()) {
            Class<?> type = beanClass.getComponentType();
            Object[] array = (Object[])bean;
            int count = 0;
            for (Value value : values != null ? values : Collections.singleton((Value)definition)) {
                array[count++] = this.configure(null, expressionFactory, expressionContext, value, type, null, null);
            }
        } else {
            SortedCollections.ComparisonIterator<PropertyDescriptor, Value> iterator = SortedCollections.comparisonIterator(Beans.getPropertyDescriptors(bean), values, this.propertyValueComparator);
            while (iterator.hasNext()) {
                switch (iterator.next()) {
                    case LESS_THAN: {
                        PropertyDescriptor property = iterator.left();
                        if (property.getWriteMethod().getAnnotation(Required.class) == null) break;
                        definition.log(Level.SEVERE, "required property ''{0}'' not set", property.getName());
                        break;
                    }
                    case EQUAL: {
                        PropertyDescriptor property = iterator.left();
                        Value value = iterator.right();
                        Class<?> type = property.getPropertyType();
                        String name = property.getName();
                        Method writeMethod = property.getWriteMethod();
                        Object object = this.configure(deferredValues, expressionFactory, expressionContext, value, type, name, writeMethod);
                        try {
                            writeMethod.invoke(bean, object);
                        }
                        catch (Throwable e) {
                            value.log(Level.SEVERE, e, "property ''{0}'' not set: {1}", name, e);
                        }
                        break;
                    }
                    case GREATER_THAN: {
                        Value value = iterator.right();
                        value.log(Level.SEVERE, "property ''{0}'' not defined", value.getName());
                        break;
                    }
                }
            }
        }
    }

    private Object configure(Map<String, DeferredSetter> deferredValues, ExpressionFactory expressionFactory, AuditELContext expressionContext, Value value, Class<?> type, String name, Method writeMethod) {
        Object object;
        if (value.getText() != null) {
            ValueExpression expression;
            expressionContext.setLocation(value);
            String text = value.getText();
            Object expressionText = switch (text.charAt(0)) {
                case '#', '$' -> text;
                default -> "${" + text + "}";
            };
            try {
                expression = expressionFactory.createValueExpression((ELContext)expressionContext, (String)expressionText, type);
            }
            catch (ELException e) {
                value.log(Level.SEVERE, e, "parsing \"{0}\" failed: {1}", new Object[]{text, e});
                return null;
            }
            try {
                object = expressionContext.evaluateExpression(expression);
            }
            catch (PropertyDeferredException e) {
                if (deferredValues != null) {
                    DefaultDeferredSetter setter = new DefaultDeferredSetter(name, writeMethod, expression, text, value);
                    deferredValues.put(name, setter);
                } else {
                    value.log(Level.SEVERE, "deferred value not allowed in expression \"{0}\"", text);
                }
                return null;
            }
            catch (PropertyNotFoundException e) {
                value.log(Level.SEVERE, "evaluating \"{0}\" failed: {1}", text, e.getMessage());
                return null;
            }
            catch (Exception e) {
                value.log(Level.SEVERE, e, "evaluating \"{0}\" failed: {1}", text, e);
                return null;
            }
        }
        try {
            object = type.isArray() ? Array.newInstance(type.getComponentType(), value.getValues().size()) : type.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.configure(value, object, value.getValues(), deferredValues, expressionFactory, expressionContext);
        }
        catch (Throwable e) {
            value.log(Level.SEVERE, e, "new ''{0}'' not created: {1}", type, e);
            return null;
        }
        return object;
    }

    static {
        LOG = new Log("audit-initialization");
        NO_PARAMETERS = new Parameter[0];
        LOCK = new String("lock");
    }

    private static class DefaultParameter
    implements Parameter {
        private final String name;
        private final Class<?> type;
        private final boolean required;

        public DefaultParameter(String name, Class<?> type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "parameter " + this.name + (this.required ? " (required)" : "");
        }
    }

    private static class ConstantDeferredExpression
    implements DeferredExpression,
    Locator {
        private final Object value;
        private final String text;
        private final Definition definition;

        public ConstantDeferredExpression(Object value, String text, Definition locator) {
            this.value = value;
            this.text = text;
            this.definition = locator;
        }

        @Override
        public Object evaluate(ELContext context) {
            return this.value;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void log(String message, Object ... parameters) {
            this.definition.log(Level.SEVERE, message, parameters);
        }

        @Override
        public int getColumnNumber() {
            return this.definition.getColumnNumber();
        }

        @Override
        public int getLineNumber() {
            return this.definition.getLineNumber();
        }

        @Override
        public String getPublicId() {
            return this.definition.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.definition.getSystemId();
        }

        public String toString() {
            return this.getText();
        }
    }

    private static class DefaultDeferredExpression
    implements DeferredExpression,
    Locator {
        private final ValueExpression expression;
        private final String text;
        private final Definition definition;

        public DefaultDeferredExpression(ValueExpression expression, String text, Definition locator) {
            this.expression = expression;
            this.text = text;
            this.definition = locator;
        }

        @Override
        public Object evaluate(ELContext context) {
            AuditELContext auditContext = (AuditELContext)context;
            auditContext.setLocation(this.definition);
            return auditContext.evaluateExpression(this.expression);
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void log(String message, Object ... parameters) {
            this.definition.log(Level.SEVERE, message, parameters);
        }

        @Override
        public int getColumnNumber() {
            return this.definition.getColumnNumber();
        }

        @Override
        public int getLineNumber() {
            return this.definition.getLineNumber();
        }

        @Override
        public String getPublicId() {
            return this.definition.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.definition.getSystemId();
        }

        public String toString() {
            return this.getText();
        }
    }

    private static class DefaultDeferredSetter
    extends DefaultDeferredExpression
    implements DeferredSetter {
        private final String name;
        private final Method writeMethod;

        public DefaultDeferredSetter(String name, Method writeMethod, ValueExpression expression, String text, Definition locator) {
            super(expression, text, locator);
            this.name = name;
            this.writeMethod = writeMethod;
        }

        @Override
        public Object set(Object bean, ELContext context) {
            Object value = this.evaluate(context);
            try {
                this.writeMethod.invoke(bean, value);
                return value;
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedExceptionError(e.getCause());
            }
        }

        @Override
        public boolean isRequired() {
            return this.writeMethod.isAnnotationPresent(Required.class);
        }
    }
}

