/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.Comparator;
import javax.swing.event.ChangeListener;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.service.AuditModel;

class DefaultAuditModelComparator
implements Comparator<Object> {
    private int columnIndex = 0;
    private String columnName;
    private AuditModel model;
    private DefaultComparator defaultComparator;
    private volatile DefaultComparator comparator = this.defaultComparator = new DefaultComparator();
    private ChangeSupport support = new ChangeSupport((Object)this);
    private static final Log LOG = new Log("sorter");

    DefaultAuditModelComparator() {
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.comparator.compare(o1, o2);
    }

    public void setModel(AuditModel model) {
        LOG.trace("setting model");
        this.model = model;
        if (this.columnName == null) {
            return;
        }
        for (int i = 1; i < model.getColumnCount(); ++i) {
            Metric column = model.getColumn(i);
            if (!column.id().equals(this.columnName)) continue;
            this.columnIndex = i;
            return;
        }
        this.columnIndex = 0;
        this.defaultComparator.setDirection(1);
        this.comparator = this.defaultComparator;
    }

    public int getColumn() {
        return this.columnIndex;
    }

    public void setColumn(int index) {
        LOG.trace("setting column to {0}", index);
        if (index != this.columnIndex) {
            if (index == 0) {
                this.columnIndex = 0;
                this.columnName = null;
                this.defaultComparator.setDirection(1);
                this.comparator = this.defaultComparator;
            } else {
                Metric column = this.model.getColumn(index);
                Comparator<Object> columnComparator = column.comparator();
                if (columnComparator == null) {
                    return;
                }
                this.columnIndex = index;
                this.columnName = column.id();
                this.comparator = new ColumnComparator(this.model, index, columnComparator, this.defaultComparator);
            }
        } else {
            this.comparator.setDirection(-this.comparator.getDirection());
        }
        LOG.trace("firing state changed");
        this.support.fireStateChanged();
    }

    public int getDirection() {
        return this.comparator.getDirection();
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    private static class DefaultComparator
    implements Comparator<Object> {
        private volatile int direction = 1;

        private DefaultComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.direction * ((Comparable)o1).compareTo(o2);
        }

        public final int getDirection() {
            return this.direction;
        }

        public final void setDirection(int direction) {
            this.direction = direction;
        }
    }

    private static class ColumnComparator
    extends DefaultComparator {
        private AuditModel model;
        private int column;
        private Comparator<Object> comparator;
        private Comparator<Object> fallbackComparator;

        public ColumnComparator(AuditModel model, int column, Comparator<Object> comparator, Comparator<Object> fallbackComparator) {
            this.model = model;
            this.column = column;
            this.comparator = comparator;
            this.fallbackComparator = fallbackComparator;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object v1 = this.model.getValue(o1, this.column);
            Object v2 = this.model.getValue(o2, this.column);
            if (v1 == null) {
                return v2 == null ? this.fallbackComparator.compare(o1, o2) : -this.getDirection();
            }
            if (v2 == null) {
                return this.getDirection();
            }
            int comparison = this.getDirection() * this.comparator.compare(v1, v2);
            if (comparison == 0) {
                comparison = this.fallbackComparator.compare(o1, o2);
            }
            return comparison;
        }
    }
}

