/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.Comparator;
import java.util.List;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.transform.Transform;

public class CountColumn
extends Metric
implements AuditModelListener {
    private static final Log LOG = new Log("count-column");
    private AuditModel.Count count;
    private int columnIndex = -1;
    private static final Comparator<Object> INVERTING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o2).compareTo(o1);
        }
    };

    public void setCount(AuditModel.Count count) {
        this.count = count;
    }

    public AuditModel.Count getCount() {
        return this.count;
    }

    @Override
    public Comparator<Object> comparator() {
        return INVERTING_COMPARATOR;
    }

    @Override
    public void auditStarted(AuditModel model, List<Metric> columns, List<Location> locations, Object root, Class type) {
        LOG.trace("{0}: audit started", (Object)this.count);
        this.columnIndex = model.getColumnIndex(this);
    }

    @Override
    public void auditStopped(AuditModel model, boolean cancelled) {
    }

    @Override
    public void rowsInserted(AuditModel model, List<?> rows, Object parent, int index) {
        for (Object row : rows) {
            int value = model.getCount(row, this.count);
            model.setValue(row, this.columnIndex, value);
            LOG.trace("{1}: {2} inserted as {0}", value, (Object)this.count, row);
        }
    }

    @Override
    public void rowsRemoved(AuditModel model, List<?> rows, Object parent, int index) {
    }

    @Override
    public void rowsShown(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsHidden(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
    }

    @Override
    public void rowsRestructureBegin(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void rowsRestructureEnd(AuditModel model, Object parent, Object visibleParent) {
    }

    @Override
    public void countChanged(AuditModel model, Object row, AuditModel.Count count, int oldValue, int newValue) {
        if (count == this.count) {
            model.setValue(row, this.columnIndex, newValue);
            LOG.trace("{1}: {2} changed to {0}", newValue, (Object)count, row);
        }
    }

    @Override
    public void valueChanged(AuditModel model, Object row, int column, Object oldValue, Object newValue) {
    }

    @Override
    public void modelResorted(AuditModel model) {
    }

    @Override
    public void appliedTransformsChanged(AuditModel model, Object row, List<Transform> appliedTransforms) {
    }
}

