/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.concurrent.CancellationException;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.AuditLogPage;
import oracle.jdevimpl.audit.profile.AuditDialog;
import oracle.jdevimpl.audit.resource.AuditARB;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class AuditController
implements Controller {
    private String baseLabel = AuditARB.get("AUDIT_SELECTION_LABEL");
    private String singleSelectionLabel = AuditARB.get("AUDIT_SELECTION_LABEL");
    private String multipleSelectionLabel = AuditARB.get("AUDIT_MULTIPLE_SELECTION_LABEL");
    private ModelTypeFactory factory;
    private Context lastContext;
    private String lastLabel;
    private static final Log LOG = new Log("audit-controller");
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private static final Element[] NO_ELEMENTS = new Element[0];

    public ModelTypeFactory getFactory() {
        if (this.factory == null) {
            this.factory = AuditManager.getAuditManager().getDefaultModelTypeFactory();
        }
        return this.factory;
    }

    public boolean update(IdeAction action, Context context) {
        try {
            boolean enabled;
            Workspace workspace = context.getWorkspace();
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            Project project = context.getProject();
            Node node = context.getNode();
            Element[] selection = NO_ELEMENTS;
            if (!(context.getView() instanceof Editor)) {
                selection = context.getSelection();
            }
            LOG.trace("updating for {0}, selection {1}, {2}, {3}", (Object)node, (Object)selection, (Object)project, (Object)workspace);
            if (selection.length > 1) {
                this.lastContext = context;
                this.lastLabel = this.multipleSelectionLabel;
                auditor = this.getAuditor(workingSet);
                if (auditor == null) {
                    enabled = false;
                } else {
                    enabled = true;
                    for (Element element : selection) {
                        if (auditor.isAuditable(element, node, project, workspace)) continue;
                        enabled = false;
                        break;
                    }
                }
            } else if (selection.length == 1) {
                Element element = selection[0];
                if (element != null) {
                    this.lastContext = context;
                    this.lastLabel = element.getShortLabel();
                    Auditor auditor = this.getAuditor(workingSet);
                    enabled = auditor != null && auditor.isAuditable(element, node, project, workspace);
                } else {
                    AuditLogger.error("null element in selection", new Object[0]);
                    enabled = false;
                }
            } else if (node != null) {
                this.lastContext = context;
                this.lastLabel = node.getShortLabel();
                auditor = this.getAuditor(workingSet);
                enabled = auditor != null && auditor.isAuditable((Element)node, node, project, workspace);
            } else {
                enabled = false;
            }
            LOG.trace("action enabled {0}, label {1}", enabled, (Object)this.lastLabel);
            action.setEnabled(enabled);
            if (action.getValue("NoCtxName") == null) {
                action.putValue("NoCtxName", (Object)this.baseLabel);
            }
            String label = null;
            label = this.lastLabel != null && this.lastLabel.length() > 0 && enabled ? Strings.toString(this.singleSelectionLabel, this.lastLabel) : Strings.toString(this.singleSelectionLabel, "");
            action.putValue("Name", (Object)label);
        }
        catch (AssertionError e) {
            AuditLogger.error((Throwable)((Object)e), "Exception updating audit action for {0}: {1}", context, e);
        }
        catch (Exception e) {
            AuditLogger.error(e, "Exception updating audit action for {0}: {1}", context, e);
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        context = this.lastContext;
        String label = this.lastLabel;
        if (!AuditLogPage.isReady(this.lastLabel)) {
            MessageDialog dialog = new MessageDialog();
            dialog.setTitle(AuditARB.get("AUDIT_ALREADY_IN_PROGRESS_TITLE"));
            dialog.setContent(Strings.toString(AuditARB.get("AUDIT_ALREADY_IN_PROGRESS"), this.lastLabel));
            dialog.setType(MessageDialog.INFORMATION);
            dialog.show();
            return true;
        }
        try {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            Node node = context.getNode();
            Element[] selection = NO_ELEMENTS;
            if (!(context.getView() instanceof Editor)) {
                selection = context.getSelection();
            }
            LOG.trace("handling event on {4} for {0}, selection {1}, {2}, {3}", (Object)node, (Object)selection, (Object)project, (Object)workspace, (Object)action);
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            WorkingSet workingSet = workingSets.getCurrentWorkingSet();
            AuditManager manager = AuditManager.getAuditManager();
            Auditor auditor = this.getAuditor(workingSet);
            if (auditor == null) {
                return false;
            }
            auditor.setIgnoreAssists(true);
            boolean auditable = false;
            if (node != null && selection.length == 0) {
                selection = new Element[]{node};
            }
            for (Element element : selection) {
                auditable |= auditor.addElement(element, node, project, workspace);
            }
            if (!auditable) {
                MessageDialog dialog = new MessageDialog();
                dialog.setTitle(BUNDLE.get("audit.not-auditable.title"));
                String message = selection.length > 1 ? "audit.not-auditable.files.message" : "audit.not-auditable.file.message";
                dialog.setContent(BUNDLE.get(message, new Object[]{project.getShortLabel()}));
                dialog.setType(MessageDialog.WARNING);
                dialog.show();
                return true;
            }
            Profile profile = new AuditDialog(this.lastLabel).show();
            if (profile == null) {
                return true;
            }
            auditor.setProfile(profile);
            manager.runShowLogPage(context, auditor, label, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof CancellationException)) {
                        MessageDialog dialog = new MessageDialog();
                        dialog.setTitle(BUNDLE.get("audit.exception.title"));
                        if (e instanceof ModelAccessError) {
                            dialog.setContent(e.getMessage());
                        } else {
                            dialog.setContent(BUNDLE.get("audit.exception.message", new Object[]{e}));
                        }
                        dialog.setType(MessageDialog.ERROR);
                        dialog.show();
                    }
                }
            });
        }
        catch (Throwable e) {
            AuditLogger.error(e, "Unexpected exception during audit: {0}", e);
            throw new UnexpectedExceptionError(e);
        }
        return true;
    }

    private Auditor getAuditor(WorkingSet workingSet) {
        ModelTypeFactory factory = this.getFactory();
        if (factory != null) {
            Auditor auditor = AuditManager.getAuditManager().createAuditor(factory, new Class[0]);
            auditor.setWorkingSet(workingSet);
            return auditor;
        }
        return null;
    }
}

