/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Scrollable;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdeveloper.audit.bean.PropertyFieldListener;
import oracle.jdeveloper.audit.bean.PropertyItem;
import oracle.jdevimpl.audit.bean.BeanFieldFactory;
import oracle.jdevimpl.audit.bean.ExceptionField;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;
import oracle.jdevimpl.audit.util.Strings;

public class BeanPanel
extends JPanel
implements Scrollable {
    private String rootName;
    private Map customizers;
    private Object bean;
    private BeanCustomizer customizer;
    private List<PropertyItem> items;
    private ChangeHandler handler = new ChangeHandler();
    private Dimension preferredScrollableViewportSize;
    private ChangeSupport support = new ChangeSupport((Object)this);
    private static final Log LOG = new Log("field");

    public BeanPanel(Map customizers) {
        this(null, customizers);
    }

    public BeanPanel(String rootName, Map customizers) {
        super(new GridBagLayout());
        this.rootName = rootName;
        this.customizers = customizers;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public void setBean(Object bean) {
        LOG.trace("setting model to {0}", bean);
        this.flush();
        this.removeAll();
        this.items = new ArrayList<PropertyItem>();
        this.bean = bean;
        if (bean == null) {
            return;
        }
        this.customizer = this.getCustomizer(bean);
        Collection<PropertyDescriptor> descriptors = Beans.getPropertyDescriptors(bean);
        LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors) {
            map.put(descriptor.getName(), descriptor);
        }
        LinkedHashMap<String, Object> rootGroup = new LinkedHashMap<String, Object>();
        this.fillGroup(this.rootName, rootGroup, map, this.customizer);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.fill = 0;
        this.processGroup(rootGroup, constraints);
    }

    public Object getBean() {
        return this.bean;
    }

    private void processGroup(Map<String, Object> descriptors, GridBagConstraints constraints) {
        boolean separable = false;
        for (Map.Entry<String, Object> entry : descriptors.entrySet()) {
            String key;
            String name = key = entry.getKey();
            int indent = 0;
            if (key.charAt(0) == '+') {
                name = key.substring(1);
                indent = 16;
            }
            Object value = entry.getValue();
            if (Boolean.FALSE.equals(this.customizer.visible(this.bean, name))) continue;
            constraints.insets.top = this.getComponentCount() == 0 ? 0 : 6;
            constraints.insets.left += indent;
            if (value instanceof PropertyDescriptor) {
                PropertyDescriptor descriptor = (PropertyDescriptor)value;
                PropertyField field = this.createField(descriptor, this.bean);
                if (field == null) continue;
                this.items.add(field);
                field.setName(name);
                String labelText = this.customizer.label(this.bean, name);
                if (labelText == null) {
                    labelText = Strings.capitalizeAndSeparateAll(name);
                    field.setLabelText(labelText);
                } else {
                    labelText = StringUtils.stripMnemonic((String)labelText);
                    field.setLabelText(labelText);
                }
                JLabel label = field.getLabel();
                JComponent component = field.getComponent();
                boolean modifiable = !Boolean.FALSE.equals(this.customizer.modifiable(this.bean, name));
                constraints.gridx = 0;
                if (label == null) {
                    constraints.gridwidth = 2;
                } else {
                    label.setEnabled(modifiable);
                    int componentBaseline = field.getComponentBaseline();
                    int deltaTop = componentBaseline >= 0 ? componentBaseline - this.baseline(label) : 0;
                    constraints.gridwidth = 1;
                    constraints.weightx = 0.0;
                    constraints.insets.right = 8;
                    constraints.insets.top += deltaTop;
                    this.add((Component)label, constraints);
                    constraints.insets.top -= deltaTop;
                    constraints.insets.right = 0;
                    constraints.gridx = 1;
                }
                constraints.weightx = 1.0;
                if (field.getComponentTracksContainerWidth()) {
                    constraints.fill = 2;
                }
                component.setEnabled(modifiable);
                this.add((Component)component, constraints);
                constraints.fill = 0;
                ++constraints.gridy;
                separable = true;
            } else if (value instanceof Map) {
                this.processGroup((Map)value, constraints);
                separable = true;
            } else if (separable && "-".equals(name)) {
                constraints.gridx = 0;
                constraints.gridwidth = 2;
                constraints.weightx = 1.0;
                constraints.insets.top += 16;
                constraints.insets.bottom += 8;
                JSeparator component = new JSeparator();
                this.add((Component)component, constraints);
                constraints.insets.top -= 16;
                constraints.insets.bottom -= 8;
                ++constraints.gridy;
                separable = false;
            }
            constraints.insets.left += indent;
        }
    }

    private PropertyField createField(PropertyDescriptor descriptor, Object model) {
        PropertyField field;
        String name = descriptor.getName();
        Class<?> type = this.customizer.type(model, name);
        if (type == null) {
            type = descriptor.getPropertyType();
        }
        if ((field = this.customizer.field(model, name)) == null) {
            field = BeanFieldFactory.createField(type);
        }
        LOG.trace("got field {0} for {1} of {2}", (Object)field, (Object)name, type);
        if (field != null) {
            field.setDescriptor(descriptor);
            field.setType(type);
            try {
                field.load(model);
            }
            catch (Throwable e) {
                field = new ExceptionField(e);
            }
            field.addFieldListener(this.handler);
        }
        return field;
    }

    private void fillGroup(String name, Map<String, Object> group, Map<String, PropertyDescriptor> descriptors, BeanCustomizer customizer) {
        String[] items = customizer.items(this.bean, name);
        if (items != null) {
            Map<String, Object> accumulator = group;
            for (String item : items) {
                String itemName;
                String string = itemName = item.charAt(0) == '+' ? item.substring(1) : item;
                if ("*".equals(itemName)) {
                    accumulator = new LinkedHashMap<String, Object>();
                    continue;
                }
                if ("-".equals(itemName)) {
                    accumulator.put(item, null);
                    continue;
                }
                if ("=".equals(itemName) && name == this.rootName) {
                    accumulator.put(item, null);
                    continue;
                }
                PropertyDescriptor descriptor = customizer.descriptor(this.bean, itemName);
                if (descriptor == null) {
                    descriptor = descriptors.get(itemName);
                }
                if (descriptor != null) {
                    accumulator.put(item, descriptor);
                    descriptors.remove(itemName);
                    continue;
                }
                if (itemName.equals(name)) continue;
                LinkedHashMap<String, Object> nestedGroup = new LinkedHashMap<String, Object>();
                this.fillGroup(itemName, nestedGroup, descriptors, customizer);
                accumulator.put(item, nestedGroup);
            }
            if (accumulator != group) {
                group.putAll(descriptors);
                group.putAll(accumulator);
            }
        } else {
            group.putAll(descriptors);
        }
    }

    public boolean flush() {
        return this.handler.flush();
    }

    protected String getLabel(Object model, String name, String label) {
        return label;
    }

    protected Class getType(Object model, String name, Class type) {
        return type;
    }

    private BeanCustomizer getCustomizer(Object bean) {
        Class<?> beanClass = bean.getClass();
        CompositeBeanCustomizer composite = new CompositeBeanCustomizer();
        do {
            BeanCustomizer customizer;
            if ((customizer = (BeanCustomizer)this.customizers.get(beanClass)) == null) continue;
            composite.add(customizer);
        } while ((beanClass = beanClass.getSuperclass()) != null);
        return composite;
    }

    public void setPreferredScrollableViewportSize(Dimension size) {
        this.preferredScrollableViewportSize = size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredScrollableViewportSize != null ? this.preferredScrollableViewportSize : this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container viewport = this.getParent();
        return viewport.getHeight() > this.getMinimumSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    private int baseline(JComponent component) {
        Dimension preferredSize = component.getPreferredSize();
        return component.getBaseline(preferredSize.width, preferredSize.height);
    }

    private class ChangeHandler
    implements PropertyFieldListener {
        private PropertyField lastFieldChanged = null;

        private ChangeHandler() {
        }

        public boolean flush() {
            if (BeanPanel.this.bean != null && this.lastFieldChanged != null) {
                try {
                    LOG.trace("flushing changes to {0}", (Object)this.lastFieldChanged);
                    this.lastFieldChanged.apply(BeanPanel.this.bean);
                    for (PropertyItem item : BeanPanel.this.items) {
                        String name = item.getName();
                        boolean modifiable = !Boolean.FALSE.equals(BeanPanel.this.customizer.modifiable(BeanPanel.this.bean, name));
                        JLabel label = item.getLabel();
                        if (label != null) {
                            label.setEnabled(modifiable);
                        }
                        item.getComponent().setEnabled(modifiable);
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.trace("handling exception for {0} : {1}", (Object)this.lastFieldChanged, (Object)e);
                    this.lastFieldChanged.handleException(e);
                    this.lastFieldChanged.getComponent().requestFocus();
                    return false;
                }
            }
            return true;
        }

        @Override
        public void fieldEntered(PropertyField field) {
            LOG.trace("field entered {0}", (Object)field);
            this.flush();
        }

        @Override
        public void fieldChanged(PropertyField field) {
            this.lastFieldChanged = field;
            LOG.trace("field changed {0}", (Object)this.lastFieldChanged);
            BeanPanel.this.support.fireStateChanged();
        }

        @Override
        public void fieldCommitted(PropertyField field) {
            LOG.trace("field committed {0}", (Object)field);
            this.flush();
        }

        @Override
        public void fieldExited(PropertyField field) {
            LOG.trace("field exited {0}", (Object)field);
        }
    }

    private static class CompositeBeanCustomizer
    extends BeanCustomizer {
        private List<BeanCustomizer> customizers = new ArrayList<BeanCustomizer>();

        private CompositeBeanCustomizer() {
        }

        public void add(BeanCustomizer customizer) {
            assert (customizer != this);
            assert (!(customizer instanceof CompositeBeanCustomizer)) : customizer;
            this.customizers.add(customizer);
        }

        @Override
        public Class<?> getType() {
            return this.customizers.isEmpty() ? Object.class : this.customizers.get(0).getType();
        }

        @Override
        public Boolean visible(Object bean, String itemName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                Boolean value = customizer.visible(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String[] items(Object bean, String groupName) {
            return this.items(bean, groupName, this.customizers.iterator());
        }

        private String[] items(Object bean, String groupName, Iterator<BeanCustomizer> iterator) {
            while (iterator.hasNext()) {
                int index;
                BeanCustomizer customizer = iterator.next();
                assert (customizer != this);
                String[] items = customizer.items(bean, groupName);
                if (items == null) continue;
                String[] nestedItems = null;
                for (index = 0; index < items.length; ++index) {
                    if (!"*".equals(items[index])) continue;
                    nestedItems = this.items(bean, groupName, iterator);
                    break;
                }
                if (nestedItems != null) {
                    String[] expandedItems = new String[items.length + nestedItems.length - 1];
                    System.arraycopy(items, 0, expandedItems, 0, index);
                    System.arraycopy(nestedItems, 0, expandedItems, index, nestedItems.length);
                    System.arraycopy(items, index + 1, expandedItems, index + nestedItems.length, items.length - index - 1);
                    items = expandedItems;
                }
                return items;
            }
            return null;
        }

        @Override
        public PropertyDescriptor descriptor(Object bean, String propertyName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                PropertyDescriptor value = customizer.descriptor(bean, propertyName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Class type(Object bean, String propertyName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                Class value = customizer.type(bean, propertyName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String label(Object bean, String itemName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                String value = customizer.label(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public PropertyField field(Object bean, String propertyName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                PropertyField value = customizer.field(bean, propertyName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Boolean modifiable(Object bean, String itemName) {
            for (BeanCustomizer customizer : this.customizers) {
                assert (customizer != this);
                Boolean value = customizer.modifiable(bean, itemName);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public String valid(Object bean) {
            for (BeanCustomizer customizer : this.customizers) {
                String value = customizer.valid(bean);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }
}

