/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.ide.controls.AbstractCellEditor;
import oracle.javatools.ui.PolygonIcon;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdeveloper.audit.bean.PropertyFieldListener;
import oracle.jdevimpl.audit.bean.BeanFieldFactory;
import oracle.jdevimpl.audit.swing.DialogFactory;

public class ArrayField
extends PropertyField
implements ActionListener,
PropertyFieldListener,
ListSelectionListener,
MouseListener,
TableModelListener {
    private Class componentType;
    private ArrayTableModel model = new ArrayTableModel();
    private JTable table = new ArrayTable(this.model);
    private JPanel panel;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private PropertyField renderer;
    private PropertyField editor;
    private PolygonIcon arrowUp;
    private PolygonIcon arrowDown;
    private DisabledPolygonIcon disabledArrowUp;
    private DisabledPolygonIcon disabledArrowDown;
    private static final Log LOG = new Log("field");

    public ArrayField() {
        this.model.addTableModelListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.table), "Center");
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.upButton = new JButton(this.getMoveUpIcon());
        this.upButton.setDisabledIcon(this.getDisabledMoveUpIcon());
        this.downButton = new JButton(this.getMoveDownIcon());
        this.downButton.setDisabledIcon(this.getDisabledMoveDownIcon());
        Font font = this.addButton.getFont();
        font = new Font(font.getFamily(), font.getStyle(), font.getSize() - 2);
        Insets margin = new Insets(0, 2, 0, 2);
        this.addButton.setActionCommand("add");
        this.addButton.setMargin(margin);
        this.addButton.setFont(font);
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
        this.removeButton.setMargin(margin);
        this.removeButton.setFont(font);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.upButton.setActionCommand("up");
        this.upButton.setMargin(margin);
        this.upButton.addActionListener(this);
        this.upButton.setEnabled(false);
        this.downButton.setActionCommand("down");
        this.downButton.setMargin(margin);
        this.downButton.addActionListener(this);
        this.downButton.setEnabled(false);
        Dimension leftButtonSize = this.addButton.getPreferredSize();
        this.maximize(leftButtonSize, this.removeButton.getPreferredSize());
        Dimension rightButtonSize = this.upButton.getPreferredSize();
        this.maximize(rightButtonSize, this.downButton.getPreferredSize());
        leftButtonSize.height = rightButtonSize.height = Math.max(leftButtonSize.height, rightButtonSize.height);
        rightButtonSize.width = Math.max(rightButtonSize.width, rightButtonSize.height);
        this.addButton.setMinimumSize(leftButtonSize);
        this.addButton.setPreferredSize(leftButtonSize);
        this.removeButton.setMinimumSize(leftButtonSize);
        this.removeButton.setPreferredSize(leftButtonSize);
        this.upButton.setMinimumSize(rightButtonSize);
        this.upButton.setPreferredSize(rightButtonSize);
        this.downButton.setMinimumSize(rightButtonSize);
        this.downButton.setPreferredSize(rightButtonSize);
        JPanel buttons = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 3;
        buttons.add((Component)this.addButton, constraints);
        constraints.insets.left = 5;
        buttons.add((Component)this.removeButton, constraints);
        constraints.weightx = 1.0;
        buttons.add(Box.createHorizontalGlue(), constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        buttons.add((Component)this.upButton, constraints);
        buttons.add((Component)this.downButton, constraints);
        this.panel.add((Component)buttons, "South");
    }

    private void maximize(Dimension size, Dimension fromSize) {
        if (fromSize.height > size.height) {
            size.height = fromSize.height;
        }
        if (fromSize.width > size.width) {
            size.width = fromSize.width;
        }
    }

    @Override
    public void setValue(Object value) {
        this.model.setValue((Object[])value);
    }

    @Override
    public Object getValue() {
        return this.model.getValue();
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public boolean getComponentTracksContainerWidth() {
        if (this.renderer == null) {
            return super.getComponentTracksContainerWidth();
        }
        return this.renderer.getComponentTracksContainerWidth();
    }

    @Override
    public void setType(Class type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException(type + " not array type");
        }
        this.componentType = type.getComponentType();
        if (this.componentType.isArray()) {
            throw new IllegalArgumentException(type + " is multi-dimensional array type");
        }
        this.renderer = BeanFieldFactory.createField(this.componentType);
        if (this.editor != null) {
            this.editor.removeFieldListener(this);
        }
        this.editor = BeanFieldFactory.createField(this.componentType);
        this.editor.addFieldListener(this);
        super.setType(type);
    }

    @Override
    public boolean equals(Object left, Object right) {
        return Arrays.equals((Object[])left, (Object[])right);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row;
        if (e.getClickCount() == 2 && (row = this.table.rowAtPoint(e.getPoint())) >= 0) {
            this.edit(row);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        String command = ((JButton)event.getSource()).getActionCommand();
        int fromIndex = this.table.getSelectedRow();
        int toIndex = fromIndex + this.table.getSelectedRowCount() - 1;
        LOG.trace("*** action {2} requested on rows {0}-{1}", fromIndex, toIndex, (Object)command);
        if ("add".equals(command)) {
            if (fromIndex < 0) {
                fromIndex = this.model.getRowCount();
            }
            this.model.addRows(fromIndex);
            this.setSelection(fromIndex, fromIndex);
        } else if ("remove".equals(command)) {
            this.model.removeRows(fromIndex, toIndex);
            int rowCount = this.table.getRowCount();
            if (rowCount > 0) {
                if (fromIndex >= rowCount) {
                    fromIndex = rowCount - 1;
                }
                this.setSelection(fromIndex, fromIndex);
            } else {
                this.setSelection(-1, -1);
            }
        } else if ("up".equals(command)) {
            this.model.moveRows(fromIndex, toIndex, -1);
            this.setSelection(fromIndex - 1, toIndex - 1);
        } else if ("down".equals(command)) {
            this.model.moveRows(fromIndex, toIndex, 1);
            this.setSelection(fromIndex + 1, toIndex + 1);
        }
    }

    public void setSelection(final int fromIndex, final int toIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = ArrayField.this.table.getRowCount();
                if (fromIndex >= 0 && count > 0) {
                    int from = fromIndex;
                    int to = toIndex;
                    if (from >= count) {
                        from = count - 1;
                    }
                    if (to >= count) {
                        to = count - 1;
                    }
                    ArrayField.this.table.setRowSelectionInterval(from, to);
                } else {
                    ArrayField.this.table.clearSelection();
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.resetButtons();
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        LOG.trace("handling table changed {0}", (Object)event);
        this.fireFieldChanged();
        this.resetButtons();
    }

    private void resetButtons() {
        int selectionCount = this.table.getSelectedRowCount();
        int fromIndex = this.table.getSelectedRow();
        int toIndex = fromIndex + selectionCount - 1;
        int rowCount = this.table.getRowCount();
        LOG.trace("selection changed to rows {0}-{1} of {2} rows", fromIndex, toIndex, rowCount);
        this.removeButton.setEnabled(selectionCount > 0 && fromIndex >= 0 && toIndex < rowCount);
        this.upButton.setEnabled(fromIndex > 0 && toIndex < rowCount);
        this.downButton.setEnabled(fromIndex >= 0 && toIndex < rowCount - 1);
    }

    @Override
    public void fieldChanged(PropertyField field) {
    }

    @Override
    public void fieldCommitted(PropertyField propertyField) {
        this.fireFieldChanged();
    }

    @Override
    public void fieldEntered(PropertyField field) {
        this.fireFieldEntered();
    }

    @Override
    public void fieldExited(PropertyField field) {
        this.fireFieldExited();
    }

    private void edit(int row) {
        Object value = this.model.getValueAt(row, 0);
        this.editor.setValue(value);
        JComponent component = this.editor.getComponent();
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle("Edit '" + this.editor.getLabelText() + "'");
        dialog.setTitle("Edit '" + this.editor.getLabelText() + "' value");
        dialog.setContent(component);
        dialog.addCancelButton(null);
        JButton ok = dialog.addOkButton(null);
        JButton button = dialog.show();
        if (button == ok) {
            try {
                value = this.editor.getValue();
                this.model.setValueAt(value, row, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected Icon getMoveUpIcon() {
        if (this.arrowUp == null) {
            this.arrowUp = new PolygonIcon();
            this.arrowUp.addPoint(0, 3);
            this.arrowUp.addPoint(3, 0);
            this.arrowUp.addPoint(6, 3);
        }
        return this.arrowUp;
    }

    protected Icon getMoveDownIcon() {
        if (this.arrowDown == null) {
            this.arrowDown = new PolygonIcon();
            this.arrowDown.addPoint(0, 0);
            this.arrowDown.addPoint(3, 3);
            this.arrowDown.addPoint(6, 0);
        }
        return this.arrowDown;
    }

    protected Icon getDisabledMoveUpIcon() {
        if (this.disabledArrowUp == null) {
            this.disabledArrowUp = new DisabledPolygonIcon();
            this.disabledArrowUp.addPoint(0, 3);
            this.disabledArrowUp.addPoint(3, 0);
            this.disabledArrowUp.addPoint(6, 3);
        }
        return this.disabledArrowUp;
    }

    protected Icon getDisabledMoveDownIcon() {
        if (this.disabledArrowDown == null) {
            this.disabledArrowDown = new DisabledPolygonIcon();
            this.disabledArrowDown.addPoint(0, 0);
            this.disabledArrowDown.addPoint(3, 3);
            this.disabledArrowDown.addPoint(6, 0);
        }
        return this.disabledArrowDown;
    }

    private class ArrayTableModel
    extends AbstractTableModel {
        private List values = new ArrayList();

        private ArrayTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Object[] getValue() {
            Object[] value = this.values.toArray((Object[])Array.newInstance(ArrayField.this.componentType, this.values.size()));
            LOG.trace("array table model getting value as {0}", value);
            return value;
        }

        public void setValue(Object[] value) {
            LOG.trace("array table model resetting value to {0}", value);
            this.values.clear();
            if (value != null) {
                this.values.addAll(Arrays.asList(value));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.values.get(rowIndex);
        }

        public void addRows(int index) {
            LOG.trace("array table model adding row {0}", index);
            this.values.add(index, null);
            this.fireTableRowsInserted(index, index);
        }

        public void removeRows(int fromIndex, int toIndex) {
            LOG.trace("array table model removing row {0}-{1}", fromIndex, toIndex);
            int count = toIndex - fromIndex + 1;
            for (int i = 0; i < count; ++i) {
                this.values.remove(fromIndex);
            }
            this.fireTableRowsDeleted(fromIndex, toIndex);
        }

        public void moveRows(int fromIndex, int toIndex, int distance) {
            int i;
            int count = toIndex - fromIndex + 1;
            Object[] values = new Object[count];
            for (i = 0; i < count; ++i) {
                values[i] = this.values.remove(fromIndex);
            }
            this.fireTableRowsDeleted(fromIndex, toIndex);
            fromIndex += distance;
            toIndex += distance;
            for (i = 0; i < count; ++i) {
                this.values.add(fromIndex, values[i]);
            }
            this.fireTableRowsInserted(fromIndex, toIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            LOG.trace("array table model setting row {0} to {1}", rowIndex, value);
            this.values.set(rowIndex, value);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public class ArrayTable
    extends JTable {
        private Border focusBorder;
        private boolean focusBorderLoaded;

        public ArrayTable(TableModel dm) {
            super(dm);
            this.setTableHeader(null);
            this.setSelectionMode(1);
            TableColumn column = this.getColumnModel().getColumn(0);
            column.setCellRenderer(new FieldRenderer());
            column.setCellEditor(new FieldEditor());
            this.setPreferredScrollableViewportSize(new Dimension(this.getPreferredSize().width, 4 * (this.getRowHeight() + this.getIntercellSpacing().height)));
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.setSurrendersFocusOnKeystroke(true);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            this.getModel().setValueAt(aValue, row, this.convertColumnIndexToModel(column));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                try {
                    Object value = editor.getCellEditorValue();
                    this.setValueAt(value, this.editingRow, this.editingColumn);
                }
                finally {
                    this.removeEditor();
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            int column;
            int row;
            boolean focussed;
            super.paint(g);
            if (!this.focusBorderLoaded) {
                this.focusBorderLoaded = true;
                this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            if (this.isEditing()) {
                focussed = true;
                row = this.getEditingRow();
                column = this.getEditingColumn();
            } else {
                focussed = this.isFocusOwner();
                row = this.selectionModel.getLeadSelectionIndex();
                column = this.columnModel.getSelectionModel().getLeadSelectionIndex();
            }
            if (this.focusBorder != null && focussed && row >= 0 && row < this.getRowCount() && column >= 0 && column < this.getColumnCount()) {
                Rectangle bounds = this.getCellRect(row, column, false);
                if (g.getClipBounds().intersects(bounds)) {
                    LOG.trace("painting focus on row {0}", row);
                    this.focusBorder.paintBorder(this, g, bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
    }

    private static class DisabledPolygonIcon
    extends PolygonIcon {
        private DisabledPolygonIcon() {
        }

        public Color getColor(Component c) {
            return c.getBackground().darker();
        }
    }

    private class FieldEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Object value;

        private FieldEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            LOG.trace("array field getting cell editor value {0}", this.value);
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                return ((MouseEvent)event).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            LOG.trace("getting editor for row {0}, focus {1}", row);
            ArrayField.this.editor.setValue(value);
            JComponent component = ArrayField.this.editor.getComponent();
            ((Component)component).setForeground(table.getForeground());
            ((Component)component).setBackground(table.getBackground());
            return component;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.value = ArrayField.this.editor.getValue();
                LOG.trace("array field cell editing stopped, value {0}", this.value);
                this.fireEditingStopped();
                return true;
            }
            catch (Throwable e) {
                LOG.trace("array field cell editing stopped, exception {0}", (Object)e);
                return false;
            }
        }

        @Override
        public void cancelCellEditing() {
            LOG.trace("array field cell editing cancelled");
            this.fireEditingCanceled();
        }
    }

    private class FieldRenderer
    implements TableCellRenderer {
        private FieldRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LOG.trace("getting renderer for row {0}, focus {1}", row, (Object)hasFocus);
            ArrayField.this.renderer.setValue(value);
            JComponent component = ArrayField.this.renderer.getComponent();
            if (isSelected && !hasFocus) {
                ((Component)component).setForeground(table.getSelectionForeground());
                ((Component)component).setBackground(table.getSelectionBackground());
            } else {
                ((Component)component).setForeground(table.getForeground());
                ((Component)component).setBackground(table.getBackground());
            }
            return component;
        }
    }
}

