/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.javatools.buffer.TextBuffer;

public class TextBufferCommand
extends Command {
    private TextBuffer buffer;
    private List edits = new ArrayList();
    private UndoableEdit undoableEdit;

    public TextBufferCommand(String name, TextBuffer buffer) {
        super(Ide.findOrCreateCmdID((String)name), 0, name);
        this.buffer = buffer;
    }

    public void insert(int offset, char[] text) {
        this.add(new Edit(offset, text));
    }

    public void insert(int offset, String text) {
        this.add(new Edit(offset, text.toCharArray()));
    }

    public void remove(int offset, int length) {
        this.add(new Edit(offset, length));
    }

    private void add(Edit edit) {
        int index = Collections.binarySearch(this.edits, edit);
        if (index >= 0) {
            throw new IllegalArgumentException("edit " + edit + " conflicts with edit " + this.edits.get(index));
        }
        this.edits.add(-index - 1, edit);
    }

    public int doit() throws Exception {
        if (this.undoableEdit == null) {
            this.buffer.beginEdit();
            int i = this.edits.size();
            while (i-- > 0) {
                Edit edit = (Edit)this.edits.get(i);
                edit.apply(this.buffer);
            }
            this.undoableEdit = this.buffer.endEdit();
            this.edits = null;
        } else {
            this.undoableEdit.redo();
        }
        return 0;
    }

    public int undo() throws Exception {
        if (this.undoableEdit == null) {
            throw new IllegalStateException("no undoable edit created");
        }
        this.undoableEdit.undo();
        return 0;
    }

    private static class Edit
    implements Comparable {
        private final int offset;
        private final int length;
        private final char[] text;

        public Edit(int offset, char[] text) {
            this.offset = offset;
            this.text = text;
            this.length = 0;
        }

        public Edit(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.text = null;
        }

        public void apply(TextBuffer buffer) {
            if (this.length == 0) {
                buffer.insert(this.offset, this.text);
            } else {
                buffer.remove(this.offset, this.length);
            }
        }

        public int compareTo(Object object) {
            Edit that = (Edit)object;
            int comparison = this.offset - that.offset;
            if (comparison == 0 && this.length == 0 != (that.length == 0)) {
                comparison = that.length - this.length;
            }
            return comparison;
        }

        public boolean equals(Object object) {
            Edit that = (Edit)object;
            return this.offset == that.offset && this.length == that.length;
        }

        public int hashCode() {
            return this.offset * 31 + this.length;
        }
    }
}

