/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;

public class VCSSystem {
    private static final ExtensionRegistry extensions = ExtensionRegistry.getExtensionRegistry();
    private static final ClassLoader classLoader = extensions.getClassLoader("oracle.jdeveloper.vcs");
    private static boolean loaded;
    private static Object vcsManager;
    private static Method isVersioned;
    private static final Map<String, Connector> allConnectors;
    private static final SortedSet<Connector> activeConnectors;

    public VCSSystem() {
        if (!extensions.isFullyLoaded("oracle.jdeveloper.vcs")) {
            return;
        }
        this.load();
    }

    public void load() {
        try {
            if (isVersioned == null) {
                Class<?> managerClass = classLoader.loadClass("oracle.ide.vcs.VCSManager");
                Method getVCSManager = managerClass.getMethod("getVCSManager", new Class[0]);
                vcsManager = getVCSManager.invoke(null, new Object[0]);
                isVersioned = vcsManager.getClass().getMethod("isVersioned", URL.class);
            }
            if (allConnectors.isEmpty()) {
                Class<?> registrationsClass = classLoader.loadClass("oracle.ideimpl.vcscore.VersioningRegistrations");
                Method getInstance = registrationsClass.getMethod("getInstance", new Class[0]);
                Object registrationsInstance = getInstance.invoke(null, new Object[0]);
                Method getRegistrations = registrationsClass.getMethod("getRegistrations", new Class[0]);
                List registrationList = (List)getRegistrations.invoke(registrationsInstance, new Object[0]);
                if (registrationList.isEmpty()) {
                    return;
                }
                Class<?> registrationClass = registrationList.get(0).getClass();
                Method getId = registrationClass.getMethod("getVcsType", new Class[0]);
                Method getExtensionId = registrationClass.getMethod("getExtensionID", new Class[0]);
                Method getConnectionProviderMetaClass = registrationClass.getMethod("getConnectionProviderClass", new Class[0]);
                for (Object registration : registrationList) {
                    String id = (String)getId.invoke(registration, new Object[0]);
                    String extensionId = (String)getExtensionId.invoke(registration, new Object[0]);
                    MetaClass connectionProviderMetaClass = (MetaClass)getConnectionProviderMetaClass.invoke(registration, new Object[0]);
                    Connector connector = new Connector(id, extensionId, connectionProviderMetaClass);
                    allConnectors.put(id.toLowerCase(), connector);
                    if (!connector.isConnected()) continue;
                    activeConnectors.add(connector);
                }
            } else {
                for (Connector connector : allConnectors.values()) {
                    if (!connector.isConnected()) continue;
                    activeConnectors.add(connector);
                }
            }
            loaded = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public boolean isVersioned(URL url) {
        if (!loaded) {
            throw new IllegalStateException("VCS system not loaded");
        }
        try {
            return (Boolean)isVersioned.invoke(vcsManager, url);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public boolean isConnected() {
        return !activeConnectors.isEmpty();
    }

    public String getConnectedIds() {
        if (!loaded) {
            throw new IllegalStateException("VCS system not loaded");
        }
        switch (activeConnectors.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return VCSSystem.activeConnectors.first().id;
            }
            case 2: {
                return VCSSystem.activeConnectors.first().id + " and " + VCSSystem.activeConnectors.last().id;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Connector provider : activeConnectors.subSet(activeConnectors.first(), activeConnectors.last())) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(provider.id);
        }
        builder.append(", and ").append(VCSSystem.activeConnectors.last().id);
        return builder.toString();
    }

    public boolean connect(String id, Context context) {
        Connector connector;
        if (!loaded) {
            extensions.fullyLoadExtension(extensions.findExtension("oracle.jdeveloper.vcs"));
            this.load();
        }
        if (id.equalsIgnoreCase("team system") || id.equalsIgnoreCase("teamsystem")) {
            id = "VSTS";
        }
        if ((connector = allConnectors.get(id.toLowerCase())) == null) {
            throw new IllegalArgumentException("Version control system id " + id + " not found");
        }
        return connector.runConnect(context);
    }

    static {
        allConnectors = new HashMap<String, Connector>();
        activeConnectors = new TreeSet<Connector>();
    }

    static class Connector
    implements Comparable<Connector> {
        private final String id;
        private final String extensionId;
        private final MetaClass<?> providerClass;
        private Object provider;
        private boolean connected;

        public Connector(String id, String extensionId, MetaClass<?> providerClass) {
            this.id = id;
            this.extensionId = extensionId;
            this.providerClass = providerClass;
        }

        public String getId() {
            return this.id;
        }

        public String getExtensionId() {
            return this.extensionId;
        }

        public boolean isConnected() {
            if (this.connected) {
                return true;
            }
            if (!extensions.isFullyLoaded(this.extensionId)) {
                return false;
            }
            try {
                if (this.provider == null) {
                    this.provider = this.providerClass.newInstance();
                }
                this.connected = (Boolean)this.provider.getClass().getMethod("isConnected", new Class[0]).invoke(this.provider, new Object[0]);
                return this.connected;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        }

        public boolean runConnect(Context context) {
            try {
                if (this.provider == null) {
                    this.provider = this.providerClass.newInstance();
                }
                this.connected = (Boolean)this.provider.getClass().getMethod("runConnect", new Class[0]).invoke(this.provider, context);
                return this.connected;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return this.isConnected();
            }
        }

        @Override
        public int compareTo(Connector that) {
            return this.id.compareTo(that.id);
        }
    }
}

