/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.bean;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.PropertyField;

public abstract class AbstractEnumerationField
extends PropertyField
implements ActionListener,
ComboBoxModel {
    private JComboBox comboBox;
    private String[] enumerals;
    private Object selection;
    private CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();
    private static final String[] NO_ENUMERALS = new String[0];
    private static final Log LOG = new Log("field");

    public AbstractEnumerationField() {
        this(NO_ENUMERALS);
    }

    public AbstractEnumerationField(String[] enumerals) {
        this.enumerals = enumerals;
        this.comboBox = new JComboBox(this);
        this.comboBox.addActionListener(this);
        this.comboBox.addFocusListener(this);
    }

    public void setEnumerals(String[] newValue) {
        String[] oldValue = this.enumerals;
        if (this.selection != null) {
            boolean keep = false;
            for (int i = 0; i < newValue.length && !(keep = newValue.equals(this.selection)); ++i) {
            }
            if (oldValue.length > 0) {
                this.fireIntervalRemoved(0, oldValue.length - 1);
            }
            this.enumerals = newValue;
            this.fireIntervalAdded(0, newValue.length - 1);
            if (keep) {
                this.fireContentsChanged(-1, -1);
            } else {
                this.fireContentsChanged(-1, -1);
                this.fireFieldChanged();
            }
        } else {
            if (oldValue.length > 0) {
                this.fireIntervalRemoved(0, oldValue.length - 1);
            }
            this.enumerals = newValue;
            this.fireIntervalAdded(0, newValue.length - 1);
        }
    }

    @Override
    public void setValue(Object value) {
        String text = this.stringOf(value);
        this.comboBox.setSelectedItem(text);
    }

    @Override
    public Object getValue() {
        return this.valueOf((String)this.comboBox.getSelectedItem());
    }

    @Override
    public JComponent getComponent() {
        return this.comboBox;
    }

    @Override
    public boolean getComponentTracksContainerWidth() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOG.trace("enumeration {0} action performed", (Object)this);
        this.fireFieldChanged();
        this.fireFieldCommitted();
    }

    public Object valueOf(String text) {
        return text;
    }

    public String stringOf(Object value) {
        return (String)value;
    }

    @Override
    public Object getSelectedItem() {
        return this.selection;
    }

    @Override
    public void setSelectedItem(Object item) {
        this.selection = item;
    }

    @Override
    public Object getElementAt(int index) {
        return this.enumerals[index];
    }

    @Override
    public int getSize() {
        return this.enumerals.length;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listeners.remove(listener);
    }

    public void fireIntervalAdded(int index0, int index1) {
        Iterator<ListDataListener> i = this.listeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ListDataEvent event = new ListDataEvent(this, 1, index0, index1);
        do {
            i.next().intervalAdded(event);
        } while (i.hasNext());
    }

    public void fireIntervalRemoved(int index0, int index1) {
        Iterator<ListDataListener> i = this.listeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ListDataEvent event = new ListDataEvent(this, 2, index0, index1);
        do {
            i.next().intervalRemoved(event);
        } while (i.hasNext());
    }

    public void fireContentsChanged(int index0, int index1) {
        Iterator<ListDataListener> i = this.listeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ListDataEvent event = new ListDataEvent(this, 0, index0, index1);
        do {
            i.next().contentsChanged(event);
        } while (i.hasNext());
    }
}

