/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Version;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.AuditProvider;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdeveloper.audit.service.Transformer;

public abstract class AuditManager {
    private static AuditManager instance;
    private static boolean development;

    public static AuditManager getAuditManager() {
        return instance;
    }

    public static boolean isDevelopment() {
        return development;
    }

    public static void setAuditManager(AuditManager manager) {
        if (instance != null) {
            throw new IllegalStateException("audit manager already set");
        }
        instance = manager;
    }

    public abstract void register(AuditProvider var1);

    public abstract AuditPreferences getPreferences();

    public abstract ExtensionBeanFactory getDefaultExtensionBeanFactory();

    public abstract ProfileRepository getDefaultProfileRepository();

    public abstract ModelTypeFactory createModelTypeFactory(ModelType ... var1);

    public abstract ModelTypeFactory getDefaultModelTypeFactory();

    public abstract Profile createProfile(String var1);

    public abstract Profile createProfile(String var1, BeanDefinition<?> ... var2);

    public abstract Profile createProfile(String var1, String ... var2);

    public abstract Auditor createAuditor(ModelTypeFactory var1, Class<? extends Analyzer> ... var2);

    public abstract Auditor createAuditor(Class<? extends Analyzer> ... var1);

    public abstract AuditModel createModel();

    public abstract AuditModel runShowLogPage(Context var1, Auditor var2, String var3, Thread.UncaughtExceptionHandler var4);

    public abstract void showLogPage(Context var1, Auditor var2, AuditModel var3, String var4);

    public abstract Transformer createTransformer();

    public abstract Collection<URL> getStyleSheets();

    public abstract Map<Class<?>, BeanCustomizer> getBeanCustomizers();

    static {
        String property = System.getProperty("audit.development");
        development = property != null ? Boolean.valueOf(property) : Version.DEBUG_BUILD != 0;
    }
}

