/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class TSTInfo
extends CMSContentInfo {
    private ASN1Integer version;
    private ASN1ObjectID policyID;
    private AlgorithmIdentifier messageImprintHashAlgID;
    private ASN1OctetString messageImprintHashMsg;
    private ASN1Integer serialNumber;
    private Date genTime;
    private ASN1Integer accuracySecs = null;
    private ASN1Integer accuracyMilliSecs = null;
    private ASN1Integer accuracyMicroSecs = null;
    private boolean ordering = false;
    private ASN1Integer nonce;
    private GeneralName tsa;
    private Vector extensions;
    private byte[] exposedContent = null;

    public TSTInfo() {
        super(CMS.id_ct_TSTInfo);
    }

    public TSTInfo(ASN1ObjectID policyID, AlgorithmIdentifier messageImprintHashAlgID, ASN1OctetString messageImprintHashMsg, ASN1Integer serialNumber, Date genTime, boolean ordering) {
        this(policyID, messageImprintHashAlgID, messageImprintHashMsg, serialNumber, genTime, null, null, null, ordering, null, null, null);
    }

    public TSTInfo(ASN1ObjectID policyID, AlgorithmIdentifier messageImprintHashAlgID, ASN1OctetString messageImprintHashMsg, ASN1Integer serialNumber, Date genTime, ASN1Integer accuracySecs, ASN1Integer accuracyMilliSecs, ASN1Integer accuracyMicroSecs, boolean ordering, ASN1Integer nonce, GeneralName tsa, Vector extensions) {
        super(CMS.id_ct_TSTInfo);
        this.version = new ASN1Integer(1L);
        this.policyID = policyID;
        this.messageImprintHashAlgID = messageImprintHashAlgID;
        this.messageImprintHashMsg = messageImprintHashMsg;
        this.serialNumber = serialNumber;
        this.genTime = genTime;
        this.accuracySecs = accuracySecs;
        this.accuracyMilliSecs = accuracyMilliSecs;
        this.accuracyMicroSecs = accuracyMicroSecs;
        this.ordering = ordering;
        this.nonce = nonce;
        this.tsa = tsa;
        this.extensions = extensions;
    }

    public TSTInfo(InputStream is) throws IOException {
        super(CMS.id_ct_TSTInfo);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            try {
                UnsyncByteArrayOutputStream ddStore = new UnsyncByteArrayOutputStream();
                this.version.output((OutputStream)ddStore);
                this.policyID.output((OutputStream)ddStore);
                ASN1Sequence mi = new ASN1Sequence();
                mi.addElement((ASN1Object)this.messageImprintHashAlgID);
                mi.addElement((ASN1Object)this.messageImprintHashMsg);
                mi.output((OutputStream)ddStore);
                this.serialNumber.output((OutputStream)ddStore);
                ddStore.write(this.getGeneralizedTimeEncoding(this.genTime));
                if (this.accuracySecs != null || this.accuracyMilliSecs != null || this.accuracyMicroSecs != null) {
                    ASN1Sequence accuracy = new ASN1Sequence();
                    if (this.accuracySecs != null) {
                        accuracy.addElement((ASN1Object)this.accuracySecs);
                    }
                    if (this.accuracyMilliSecs != null) {
                        accuracy.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.accuracyMilliSecs, (int)0));
                    }
                    if (this.accuracyMicroSecs != null) {
                        accuracy.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.accuracyMicroSecs, (int)1));
                    }
                    accuracy.output((OutputStream)ddStore);
                }
                new ASN1Boolean(this.ordering).output((OutputStream)ddStore);
                if (this.nonce != null) {
                    this.nonce.output((OutputStream)ddStore);
                }
                if (this.tsa != null) {
                    new ASN1GenericConstructed((ASN1Object)this.tsa, 0).output((OutputStream)ddStore);
                }
                if (this.extensions != null && this.extensions.size() > 0) {
                    ASN1Sequence seq = new ASN1Sequence(this.extensions);
                    ASN1Utils.addImplicitTag((ASN1Object)seq, (int)1).output((OutputStream)ddStore);
                }
                byte[] buf = ddStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is Uninitialized " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    @Override
    public boolean isDetached() {
        if (this.version == null && this.policyID == null && this.messageImprintHashAlgID == null && this.messageImprintHashMsg == null && this.serialNumber == null && this.genTime == null && this.accuracySecs == null && this.accuracyMilliSecs == null && this.accuracyMicroSecs == null) {
            this.ordering = false;
            if (false && this.nonce == null && this.tsa == null && this.extensions == null) {
                return true;
            }
        }
        return false;
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    public ASN1ObjectID getPolicyID() {
        return this.policyID;
    }

    public AlgorithmIdentifier getMessageImprintHashAlgID() {
        return this.messageImprintHashAlgID;
    }

    public byte[] getMessageImprintHashMsg() {
        if (this.messageImprintHashMsg != null) {
            return this.messageImprintHashMsg.getValue();
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this.serialNumber != null) {
            return this.serialNumber.getValue();
        }
        return null;
    }

    public Date getGeneralizedTime() {
        return this.genTime;
    }

    public BigInteger getAccuracySeconds() {
        if (this.accuracySecs != null) {
            return this.accuracySecs.getValue();
        }
        return null;
    }

    public BigInteger getAccuracyMilliSeconds() {
        if (this.accuracyMilliSecs != null) {
            return this.accuracyMilliSecs.getValue();
        }
        return null;
    }

    public BigInteger getAccuracyMicroSeconds() {
        if (this.accuracyMicroSecs != null) {
            return this.accuracyMicroSecs.getValue();
        }
        return null;
    }

    public boolean getOrdering() {
        return this.ordering;
    }

    public BigInteger getNonce() {
        if (this.nonce != null) {
            return this.nonce.getValue();
        }
        return null;
    }

    public GeneralName getTSA() {
        return this.tsa;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public byte[] getTSTInfoData() throws IOException {
        return this.getExposedContent();
    }

    public String toString() {
        if (this.isDetached()) {
            return "Uninitialized TSTInfo Object";
        }
        StringBuffer sb = new StringBuffer("'TSTInfo' object");
        sb.append("\nVersion: " + this.version);
        sb.append("\nPolicy:" + this.policyID);
        sb.append("\nMessageImprint Hash Algorithm: " + this.messageImprintHashAlgID);
        sb.append("\nMessageImprint Hash: " + this.messageImprintHashMsg);
        sb.append("\nSerialNumber: " + this.serialNumber);
        sb.append("\nGenDate: " + this.genTime);
        if (this.accuracySecs != null) {
            sb.append("\nAccuracy Secs: " + this.accuracySecs);
        } else {
            sb.append("\nAccuracy Secs: Not Present");
        }
        if (this.accuracyMilliSecs != null) {
            sb.append("\nAccuracy MilliSecs: " + this.accuracyMilliSecs);
        } else {
            sb.append("\nAccuracy MilliSecs: Not Present");
        }
        if (this.accuracyMicroSecs != null) {
            sb.append("\nAccuracy MicroSecs: " + this.accuracyMicroSecs);
        } else {
            sb.append("\nAccuracy MilliSecs: Not Present");
        }
        sb.append("\nOrdering: " + this.ordering);
        if (this.nonce != null) {
            sb.append("\nNonce: " + this.nonce);
        } else {
            sb.append("\nNonce: Not Present");
        }
        if (this.tsa != null) {
            sb.append("\nTimeStampAuthority: " + this.tsa);
        } else {
            sb.append("\nTimeStampAuthority: Not Present");
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            sb.append("\nExtensions: " + this.extensions.size() + "\n");
            int j = this.extensions.size();
            for (int i = 0; i < j; ++i) {
                sb.append("\t" + i + ". " + (X509Extension)this.extensions.elementAt(i) + "\n");
            }
        } else {
            sb.append("\nExtensions: Not Present");
        }
        return sb.toString();
    }

    @Override
    public void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream si = new ASN1SequenceInputStream(is);
        try {
            this.version = new ASN1Integer((InputStream)si);
            if (!this.version.equals(1)) {
                throw new VersionException(this.version.getValue(), 1);
            }
            this.policyID = new ASN1ObjectID((InputStream)si);
            ASN1SequenceInputStream misi = new ASN1SequenceInputStream((InputStream)si);
            this.messageImprintHashAlgID = new AlgorithmIdentifier((InputStream)misi);
            this.messageImprintHashMsg = new ASN1OctetString((InputStream)misi);
            misi.terminate();
            this.serialNumber = new ASN1Integer((InputStream)si);
            this.genTime = this.parseGeneralizedTime((InputStream)si);
            this.accuracyMicroSecs = null;
            this.accuracyMilliSecs = null;
            this.accuracySecs = null;
            if (si.hasMoreData() && si.getCurrentTag() == 16) {
                ASN1SequenceInputStream ac = new ASN1SequenceInputStream((InputStream)si);
                if (ac.getCurrentTag() == 2) {
                    this.accuracySecs = new ASN1Integer((InputStream)ac);
                }
                if (ac.getCurrentTag() == 0) {
                    ac.setCurrentTag(2);
                    this.accuracyMilliSecs = new ASN1Integer((InputStream)ac);
                }
                if (ac.getCurrentTag() == 1) {
                    ac.setCurrentTag(2);
                    this.accuracyMicroSecs = new ASN1Integer((InputStream)ac);
                }
                ac.terminate();
            }
            this.ordering = false;
            if (si.hasMoreData() && si.getCurrentTag() == 1) {
                this.ordering = new ASN1Boolean((InputStream)si).getValue();
            }
            this.nonce = si.hasMoreData() && si.getCurrentTag() == 2 ? new ASN1Integer((InputStream)si) : null;
            if (si.hasMoreData() && si.getCurrentTag() == 0) {
                ASN1ConstructedInputStream ci = new ASN1ConstructedInputStream((InputStream)si, 0);
                this.tsa = new GeneralName((InputStream)ci);
                ci.terminate();
            } else {
                this.tsa = null;
            }
            if (si.hasMoreData() && si.getCurrentTag() == 1) {
                si.setCurrentTag(16);
                this.extensions = new Vector();
                ASN1SequenceInputStream ext = new ASN1SequenceInputStream((InputStream)si);
                while (ext.hasMoreData()) {
                    this.extensions.addElement(new X509Extension((InputStream)ext));
                }
                ext.terminate();
            } else {
                this.extensions = null;
            }
            si.terminate();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }

    private byte[] getGeneralizedTimeEncoding(Date date) throws IOException {
        if (date == null) {
            return null;
        }
        String sDate = this.formatDate(date);
        byte[] bDate = sDate.getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new ASN1Header(24, 0, 0, bDate.length).output((OutputStream)bos);
        bos.write(bDate);
        bos.close();
        return bos.toByteArray();
    }

    private String formatDate(Date d) {
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar(new SimpleTimeZone(0, ""));
        c.setTime(d);
        StringBuffer s = new StringBuffer();
        s.append(this.formatDateInt(c.get(1) / 100));
        s.append(this.formatDateInt(c.get(1) % 100));
        s.append(this.formatDateInt(c.get(2) + 1));
        s.append(this.formatDateInt(c.get(5)));
        int hour = c.get(10);
        if (c.get(9) == 1) {
            hour += 12;
        }
        s.append(this.formatDateInt(hour));
        s.append(this.formatDateInt(c.get(12)));
        s.append(this.formatDateInt(c.get(13)));
        s.append(this.formatMillis(c.get(14)));
        s.append("Z");
        return s.toString();
    }

    private String formatDateInt(int n) {
        String s = Integer.toString(n);
        if (s.length() == 2) {
            return s;
        }
        return "0" + s;
    }

    private String formatMillis(int n) {
        StringBuffer sb = new StringBuffer();
        if (n == 0) {
            return sb.toString();
        }
        sb.append(".");
        sb.append(n / 100);
        if ((n %= 100) == 0) {
            return sb.toString();
        }
        sb.append(n / 10);
        if ((n %= 10) == 0) {
            return sb.toString();
        }
        sb.append(n);
        return sb.toString();
    }

    private Date parseGeneralizedTime(InputStream is) throws IOException {
        int l;
        ASN1Header header = new ASN1Header(is);
        int length = header.getBodyLength();
        byte[] bDate = new byte[length];
        for (int bytesRead = 0; bytesRead < length; bytesRead += l) {
            l = is.read(bDate, bytesRead, length - bytesRead);
        }
        String sDate = new String(bDate);
        int year = Integer.parseInt(sDate.substring(0, 4));
        int month = Integer.parseInt(sDate.substring(4, 6));
        int day = Integer.parseInt(sDate.substring(6, 8));
        int hour = Integer.parseInt(sDate.substring(8, 10));
        int min = Integer.parseInt(sDate.substring(10, 12));
        int sec = Integer.parseInt(sDate.substring(12, 14));
        int mill = 0;
        if (sDate.charAt(14) == '.') {
            mill = this.parseMillis(sDate.substring(15, sDate.length() - 1));
        }
        SimpleTimeZone tz = new SimpleTimeZone(0, "");
        Calendar c = Calendar.getInstance(tz);
        c.set(year, month - 1, day, hour, min, sec);
        c.set(14, mill);
        return c.getTime();
    }

    private int parseMillis(String s) throws IOException {
        int length = s.length();
        switch (length) {
            case 0: {
                throw new IOException("Invalid fractional second format");
            }
            case 1: {
                return Integer.parseInt(s + "00");
            }
            case 2: {
                return Integer.parseInt(s + "0");
            }
            case 3: {
                return Integer.parseInt(s);
            }
        }
        return Integer.parseInt(s.substring(0, 3));
    }
}

