/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.ECIOutputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class CMSEncryptedDataOutputStream
extends CMSOutputStream {
    private ASN1ObjectID enclosedContentType;
    private Cipher cipher;
    private ECIOutputStream content_out;
    private AttributeSet unprotectedAttributes;
    private boolean writeEncryptedOutput = true;
    private boolean writingToConnector;
    private boolean terminated = false;
    private boolean prefaceOutput = false;

    public CMSEncryptedDataOutputStream(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType) throws NoSuchAlgorithmException, InvalidKeyException {
        this(out, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, null, true);
    }

    public CMSEncryptedDataOutputStream(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes) throws NoSuchAlgorithmException, InvalidKeyException {
        this(out, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, true);
    }

    public CMSEncryptedDataOutputStream(OutputStream out, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes, boolean writeEncryptedOutput) throws NoSuchAlgorithmException, InvalidKeyException {
        super(out);
        try {
            String algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(contentEncryptionAlgID));
            this.cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                this.cipher.init(1, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                this.cipher.init(1, contentEncryptionKey);
            }
        }
        catch (NoSuchPaddingException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        this.enclosedContentType = enclosedContentType;
        this.writeEncryptedOutput = writeEncryptedOutput;
        this.unprotectedAttributes = unprotectedAttributes;
        this.writingToConnector = false;
    }

    public CMSEncryptedDataOutputStream(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType) throws NoSuchAlgorithmException, InvalidKeyException {
        this(conn, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, null, true);
    }

    public CMSEncryptedDataOutputStream(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes) throws NoSuchAlgorithmException, InvalidKeyException {
        this(conn, contentEncryptionKey, contentEncryptionAlgID, enclosedContentType, unprotectedAttributes, true);
    }

    public CMSEncryptedDataOutputStream(CMSOutputConnector conn, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, ASN1ObjectID enclosedContentType, AttributeSet unprotectedAttributes, boolean writeEncryptedOutput) throws NoSuchAlgorithmException, InvalidKeyException {
        super(conn.getOutputStream());
        try {
            String algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(contentEncryptionAlgID));
            this.cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                this.cipher.init(1, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                this.cipher.init(1, contentEncryptionKey);
            }
        }
        catch (NoSuchPaddingException ed) {
            throw new NoSuchAlgorithmException(ed.toString());
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        this.enclosedContentType = enclosedContentType;
        this.writeEncryptedOutput = writeEncryptedOutput;
        this.unprotectedAttributes = unprotectedAttributes;
        this.writingToConnector = true;
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_encryptedData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            if (this.unprotectedAttributes == null) {
                ASN1Integer.outputValue((OutputStream)this.out, (int)0);
            } else {
                ASN1Integer.outputValue((OutputStream)this.out, (int)2);
            }
            this.content_out = new ECIOutputStream(this.out, this.cipher, this.enclosedContentType);
            this.content_out.writeInitial(this.writeEncryptedOutput);
            this.prefaceOutput = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.writeFinal();
        if (this.unprotectedAttributes != null) {
            ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.unprotectedAttributes, (int)1)).output(this.out);
        }
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
        if (!this.writingToConnector) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        } else {
            ((CMSOutputStream)this.out).terminate();
        }
        this.terminated = true;
    }

    @Override
    public void write(int ch) throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.write(ch);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.write(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_encryptedData;
    }
}

