/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cms.CIOutputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;

public class CMSDigestedDataOutputStream
extends CMSOutputStream {
    private MessageDigest md;
    private AlgorithmIdentifier digestAlgID;
    private boolean writingToConnector;
    private boolean terminated = false;
    private boolean writeEContentInfo;
    private ASN1ObjectID contentType;
    private CIOutputStream content_out;
    private boolean prefaceOutput = false;

    public CMSDigestedDataOutputStream(OutputStream out, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType) throws NoSuchAlgorithmException {
        this(out, digestAlgID, contentType, true);
    }

    public CMSDigestedDataOutputStream(OutputStream out, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType, boolean writeEContentInfo) throws NoSuchAlgorithmException {
        super(out);
        this.md = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
        this.digestAlgID = digestAlgID;
        this.contentType = contentType;
        this.writeEContentInfo = writeEContentInfo;
        this.writingToConnector = false;
    }

    public CMSDigestedDataOutputStream(CMSOutputConnector conn, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType) throws NoSuchAlgorithmException {
        this(conn, digestAlgID, contentType, true);
    }

    public CMSDigestedDataOutputStream(CMSOutputConnector conn, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType, boolean writeEContentInfo) throws NoSuchAlgorithmException {
        super(conn.getOutputStream());
        this.md = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
        this.digestAlgID = digestAlgID;
        this.contentType = contentType;
        this.writeEContentInfo = writeEContentInfo;
        this.writingToConnector = true;
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_digestedData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            if (this.contentType.equals((Object)CMS.id_data)) {
                ASN1Integer.outputValue((OutputStream)this.out, (int)0);
            } else {
                ASN1Integer.outputValue((OutputStream)this.out, (int)2);
            }
            this.digestAlgID.output(this.out);
            this.content_out = new CIOutputStream(this.out, this.contentType, !this.writeEContentInfo);
            this.content_out.writeInitial();
            this.prefaceOutput = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.writeFinal();
        ASN1OctetString.outputValue((OutputStream)this.out, (byte[])this.md.digest());
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
        if (!this.writingToConnector) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        } else {
            ((CMSOutputStream)this.out).terminate();
        }
        this.terminated = true;
    }

    @Override
    public void write(int ch) throws IOException {
        this.md.update((byte)ch);
        this.ensurePrefaceOutput();
        this.content_out.write(ch);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.md.update(b, off, len);
        this.ensurePrefaceOutput();
        this.content_out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_digestedData;
    }
}

