/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.util.Utils;

public class CMSDataContentInfo
extends CMSContentInfo {
    private byte[] documentBytes;

    public CMSDataContentInfo() {
        super(CMS.id_data);
    }

    public CMSDataContentInfo(byte[] documentBytes) {
        super(CMS.id_data);
        this.documentBytes = documentBytes;
    }

    public CMSDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_data);
        this.input(is);
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.documentBytes = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        return this.documentBytes;
    }

    @Override
    public boolean isDetached() {
        return this.documentBytes == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.documentBytes == null) {
            sb.append("detached CMS 'data' object");
        } else {
            sb.append("CMS 'data' object, " + Utils.plural((int)this.documentBytes.length, (String)"byte"));
        }
        return sb.toString();
    }

    public byte[] getData() {
        return this.documentBytes;
    }

    @Override
    protected void inputContent(InputStream is) throws IOException {
        this.documentBytes = new ASN1OctetString(is).getValue();
    }

    public int hashCode() {
        return new String(this.documentBytes).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSDataContentInfo)) {
            return false;
        }
        return Utils.areEqual((byte[])this.documentBytes, (byte[])((CMSDataContentInfo)obj).getData());
    }

    @Override
    protected void update() {
        super.update();
    }
}

