/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConsoleHistoryContentRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleHistoryId;
    private String opcRequestId;

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleHistoryId() {
        return this.consoleHistoryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).consoleHistoryId(this.consoleHistoryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbNodeId=").append(String.valueOf(this.dbNodeId));
        sb.append(",consoleHistoryId=").append(String.valueOf(this.consoleHistoryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConsoleHistoryContentRequest)) {
            return false;
        }
        GetConsoleHistoryContentRequest other = (GetConsoleHistoryContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbNodeId, other.dbNodeId) && Objects.equals(this.consoleHistoryId, other.consoleHistoryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbNodeId == null ? 43 : this.dbNodeId.hashCode());
        result = result * 59 + (this.consoleHistoryId == null ? 43 : this.consoleHistoryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleHistoryContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbNodeId = null;
        private String consoleHistoryId = null;
        private String opcRequestId = null;

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleHistoryId(String consoleHistoryId) {
            this.consoleHistoryId = consoleHistoryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleHistoryContentRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleHistoryId(o.getConsoleHistoryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleHistoryContentRequest build() {
            GetConsoleHistoryContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConsoleHistoryContentRequest buildWithoutInvocationCallback() {
            GetConsoleHistoryContentRequest request = new GetConsoleHistoryContentRequest();
            request.dbNodeId = this.dbNodeId;
            request.consoleHistoryId = this.consoleHistoryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

