/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.model.ExadbVmClusterStorageDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadbVmCluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="iormConfigCache")
    private final ExadataIormConfig iormConfigCache;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="lastUpdateHistoryEntryId")
    private final String lastUpdateHistoryEntryId;
    @JsonProperty(value="listenerPort")
    private final Long listenerPort;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="giVersion")
    private final String giVersion;
    @JsonProperty(value="gridImageId")
    private final String gridImageId;
    @JsonProperty(value="gridImageType")
    private final GridImageType gridImageType;
    @JsonProperty(value="systemVersion")
    private final String systemVersion;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="scanIpIds")
    private final List<String> scanIpIds;
    @JsonProperty(value="vipIds")
    private final List<String> vipIds;
    @JsonProperty(value="scanDnsRecordId")
    private final String scanDnsRecordId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="scanDnsName")
    private final String scanDnsName;
    @JsonProperty(value="zoneId")
    private final String zoneId;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="scanListenerPortTcpSsl")
    private final Integer scanListenerPortTcpSsl;
    @JsonProperty(value="privateZoneId")
    private final String privateZoneId;
    @JsonProperty(value="dataCollectionOptions")
    private final DataCollectionOptions dataCollectionOptions;
    @JsonProperty(value="totalECpuCount")
    private final Integer totalECpuCount;
    @JsonProperty(value="enabledECpuCount")
    private final Integer enabledECpuCount;
    @JsonProperty(value="vmFileSystemStorage")
    private final ExadbVmClusterStorageDetails vmFileSystemStorage;
    @JsonProperty(value="snapshotFileSystemStorage")
    private final ExadbVmClusterStorageDetails snapshotFileSystemStorage;
    @JsonProperty(value="totalFileSystemStorage")
    private final ExadbVmClusterStorageDetails totalFileSystemStorage;
    @JsonProperty(value="exascaleDbStorageVaultId")
    private final String exascaleDbStorageVaultId;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;

    @Deprecated
    @ConstructorProperties(value={"iormConfigCache", "id", "compartmentId", "availabilityDomain", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "lastUpdateHistoryEntryId", "listenerPort", "lifecycleState", "nodeCount", "shape", "displayName", "timeCreated", "lifecycleDetails", "timeZone", "hostname", "domain", "clusterName", "giVersion", "gridImageId", "gridImageType", "systemVersion", "sshPublicKeys", "licenseModel", "scanIpIds", "vipIds", "scanDnsRecordId", "freeformTags", "definedTags", "systemTags", "scanDnsName", "zoneId", "scanListenerPortTcp", "scanListenerPortTcpSsl", "privateZoneId", "dataCollectionOptions", "totalECpuCount", "enabledECpuCount", "vmFileSystemStorage", "snapshotFileSystemStorage", "totalFileSystemStorage", "exascaleDbStorageVaultId", "memorySizeInGBs"})
    public ExadbVmCluster(ExadataIormConfig iormConfigCache, String id, String compartmentId, String availabilityDomain, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String lastUpdateHistoryEntryId, Long listenerPort, LifecycleState lifecycleState, Integer nodeCount, String shape, String displayName, Date timeCreated, String lifecycleDetails, String timeZone, String hostname, String domain, String clusterName, String giVersion, String gridImageId, GridImageType gridImageType, String systemVersion, List<String> sshPublicKeys, LicenseModel licenseModel, List<String> scanIpIds, List<String> vipIds, String scanDnsRecordId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String scanDnsName, String zoneId, Integer scanListenerPortTcp, Integer scanListenerPortTcpSsl, String privateZoneId, DataCollectionOptions dataCollectionOptions, Integer totalECpuCount, Integer enabledECpuCount, ExadbVmClusterStorageDetails vmFileSystemStorage, ExadbVmClusterStorageDetails snapshotFileSystemStorage, ExadbVmClusterStorageDetails totalFileSystemStorage, String exascaleDbStorageVaultId, Integer memorySizeInGBs) {
        this.iormConfigCache = iormConfigCache;
        this.id = id;
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        this.listenerPort = listenerPort;
        this.lifecycleState = lifecycleState;
        this.nodeCount = nodeCount;
        this.shape = shape;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.timeZone = timeZone;
        this.hostname = hostname;
        this.domain = domain;
        this.clusterName = clusterName;
        this.giVersion = giVersion;
        this.gridImageId = gridImageId;
        this.gridImageType = gridImageType;
        this.systemVersion = systemVersion;
        this.sshPublicKeys = sshPublicKeys;
        this.licenseModel = licenseModel;
        this.scanIpIds = scanIpIds;
        this.vipIds = vipIds;
        this.scanDnsRecordId = scanDnsRecordId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.scanDnsName = scanDnsName;
        this.zoneId = zoneId;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
        this.privateZoneId = privateZoneId;
        this.dataCollectionOptions = dataCollectionOptions;
        this.totalECpuCount = totalECpuCount;
        this.enabledECpuCount = enabledECpuCount;
        this.vmFileSystemStorage = vmFileSystemStorage;
        this.snapshotFileSystemStorage = snapshotFileSystemStorage;
        this.totalFileSystemStorage = totalFileSystemStorage;
        this.exascaleDbStorageVaultId = exascaleDbStorageVaultId;
        this.memorySizeInGBs = memorySizeInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ExadataIormConfig getIormConfigCache() {
        return this.iormConfigCache;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getLastUpdateHistoryEntryId() {
        return this.lastUpdateHistoryEntryId;
    }

    public Long getListenerPort() {
        return this.listenerPort;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public String getShape() {
        return this.shape;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getGiVersion() {
        return this.giVersion;
    }

    public String getGridImageId() {
        return this.gridImageId;
    }

    public GridImageType getGridImageType() {
        return this.gridImageType;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public List<String> getScanIpIds() {
        return this.scanIpIds;
    }

    public List<String> getVipIds() {
        return this.vipIds;
    }

    public String getScanDnsRecordId() {
        return this.scanDnsRecordId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getScanDnsName() {
        return this.scanDnsName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public Integer getScanListenerPortTcpSsl() {
        return this.scanListenerPortTcpSsl;
    }

    public String getPrivateZoneId() {
        return this.privateZoneId;
    }

    public DataCollectionOptions getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public Integer getTotalECpuCount() {
        return this.totalECpuCount;
    }

    public Integer getEnabledECpuCount() {
        return this.enabledECpuCount;
    }

    public ExadbVmClusterStorageDetails getVmFileSystemStorage() {
        return this.vmFileSystemStorage;
    }

    public ExadbVmClusterStorageDetails getSnapshotFileSystemStorage() {
        return this.snapshotFileSystemStorage;
    }

    public ExadbVmClusterStorageDetails getTotalFileSystemStorage() {
        return this.totalFileSystemStorage;
    }

    public String getExascaleDbStorageVaultId() {
        return this.exascaleDbStorageVaultId;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadbVmCluster(");
        sb.append("super=").append(super.toString());
        sb.append("iormConfigCache=").append(String.valueOf((Object)this.iormConfigCache));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", backupSubnetId=").append(String.valueOf(this.backupSubnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", backupNetworkNsgIds=").append(String.valueOf(this.backupNetworkNsgIds));
        sb.append(", lastUpdateHistoryEntryId=").append(String.valueOf(this.lastUpdateHistoryEntryId));
        sb.append(", listenerPort=").append(String.valueOf(this.listenerPort));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", giVersion=").append(String.valueOf(this.giVersion));
        sb.append(", gridImageId=").append(String.valueOf(this.gridImageId));
        sb.append(", gridImageType=").append(String.valueOf((Object)this.gridImageType));
        sb.append(", systemVersion=").append(String.valueOf(this.systemVersion));
        sb.append(", sshPublicKeys=").append(String.valueOf(this.sshPublicKeys));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", scanIpIds=").append(String.valueOf(this.scanIpIds));
        sb.append(", vipIds=").append(String.valueOf(this.vipIds));
        sb.append(", scanDnsRecordId=").append(String.valueOf(this.scanDnsRecordId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", scanDnsName=").append(String.valueOf(this.scanDnsName));
        sb.append(", zoneId=").append(String.valueOf(this.zoneId));
        sb.append(", scanListenerPortTcp=").append(String.valueOf(this.scanListenerPortTcp));
        sb.append(", scanListenerPortTcpSsl=").append(String.valueOf(this.scanListenerPortTcpSsl));
        sb.append(", privateZoneId=").append(String.valueOf(this.privateZoneId));
        sb.append(", dataCollectionOptions=").append(String.valueOf((Object)this.dataCollectionOptions));
        sb.append(", totalECpuCount=").append(String.valueOf(this.totalECpuCount));
        sb.append(", enabledECpuCount=").append(String.valueOf(this.enabledECpuCount));
        sb.append(", vmFileSystemStorage=").append(String.valueOf((Object)this.vmFileSystemStorage));
        sb.append(", snapshotFileSystemStorage=").append(String.valueOf((Object)this.snapshotFileSystemStorage));
        sb.append(", totalFileSystemStorage=").append(String.valueOf((Object)this.totalFileSystemStorage));
        sb.append(", exascaleDbStorageVaultId=").append(String.valueOf(this.exascaleDbStorageVaultId));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadbVmCluster)) {
            return false;
        }
        ExadbVmCluster other = (ExadbVmCluster)((Object)o);
        return Objects.equals((Object)this.iormConfigCache, (Object)other.iormConfigCache) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.backupSubnetId, other.backupSubnetId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.backupNetworkNsgIds, other.backupNetworkNsgIds) && Objects.equals(this.lastUpdateHistoryEntryId, other.lastUpdateHistoryEntryId) && Objects.equals(this.listenerPort, other.listenerPort) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.shape, other.shape) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domain, other.domain) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.giVersion, other.giVersion) && Objects.equals(this.gridImageId, other.gridImageId) && Objects.equals((Object)this.gridImageType, (Object)other.gridImageType) && Objects.equals(this.systemVersion, other.systemVersion) && Objects.equals(this.sshPublicKeys, other.sshPublicKeys) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.scanIpIds, other.scanIpIds) && Objects.equals(this.vipIds, other.vipIds) && Objects.equals(this.scanDnsRecordId, other.scanDnsRecordId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.scanDnsName, other.scanDnsName) && Objects.equals(this.zoneId, other.zoneId) && Objects.equals(this.scanListenerPortTcp, other.scanListenerPortTcp) && Objects.equals(this.scanListenerPortTcpSsl, other.scanListenerPortTcpSsl) && Objects.equals(this.privateZoneId, other.privateZoneId) && Objects.equals((Object)this.dataCollectionOptions, (Object)other.dataCollectionOptions) && Objects.equals(this.totalECpuCount, other.totalECpuCount) && Objects.equals(this.enabledECpuCount, other.enabledECpuCount) && Objects.equals((Object)this.vmFileSystemStorage, (Object)other.vmFileSystemStorage) && Objects.equals((Object)this.snapshotFileSystemStorage, (Object)other.snapshotFileSystemStorage) && Objects.equals((Object)this.totalFileSystemStorage, (Object)other.totalFileSystemStorage) && Objects.equals(this.exascaleDbStorageVaultId, other.exascaleDbStorageVaultId) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.iormConfigCache == null ? 43 : this.iormConfigCache.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.backupSubnetId == null ? 43 : this.backupSubnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.backupNetworkNsgIds == null ? 43 : this.backupNetworkNsgIds.hashCode());
        result = result * 59 + (this.lastUpdateHistoryEntryId == null ? 43 : this.lastUpdateHistoryEntryId.hashCode());
        result = result * 59 + (this.listenerPort == null ? 43 : this.listenerPort.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.giVersion == null ? 43 : this.giVersion.hashCode());
        result = result * 59 + (this.gridImageId == null ? 43 : this.gridImageId.hashCode());
        result = result * 59 + (this.gridImageType == null ? 43 : this.gridImageType.hashCode());
        result = result * 59 + (this.systemVersion == null ? 43 : this.systemVersion.hashCode());
        result = result * 59 + (this.sshPublicKeys == null ? 43 : this.sshPublicKeys.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.scanIpIds == null ? 43 : this.scanIpIds.hashCode());
        result = result * 59 + (this.vipIds == null ? 43 : this.vipIds.hashCode());
        result = result * 59 + (this.scanDnsRecordId == null ? 43 : this.scanDnsRecordId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.scanDnsName == null ? 43 : this.scanDnsName.hashCode());
        result = result * 59 + (this.zoneId == null ? 43 : this.zoneId.hashCode());
        result = result * 59 + (this.scanListenerPortTcp == null ? 43 : this.scanListenerPortTcp.hashCode());
        result = result * 59 + (this.scanListenerPortTcpSsl == null ? 43 : this.scanListenerPortTcpSsl.hashCode());
        result = result * 59 + (this.privateZoneId == null ? 43 : this.privateZoneId.hashCode());
        result = result * 59 + (this.dataCollectionOptions == null ? 43 : this.dataCollectionOptions.hashCode());
        result = result * 59 + (this.totalECpuCount == null ? 43 : this.totalECpuCount.hashCode());
        result = result * 59 + (this.enabledECpuCount == null ? 43 : this.enabledECpuCount.hashCode());
        result = result * 59 + (this.vmFileSystemStorage == null ? 43 : this.vmFileSystemStorage.hashCode());
        result = result * 59 + (this.snapshotFileSystemStorage == null ? 43 : this.snapshotFileSystemStorage.hashCode());
        result = result * 59 + (this.totalFileSystemStorage == null ? 43 : this.totalFileSystemStorage.hashCode());
        result = result * 59 + (this.exascaleDbStorageVaultId == null ? 43 : this.exascaleDbStorageVaultId.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum GridImageType implements BmcEnum
    {
        ReleaseUpdate("RELEASE_UPDATE"),
        CustomImage("CUSTOM_IMAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GridImageType> map;

        private GridImageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GridImageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GridImageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GridImageType.class);
            map = new HashMap<String, GridImageType>();
            for (GridImageType v : GridImageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="iormConfigCache")
        private ExadataIormConfig iormConfigCache;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="lastUpdateHistoryEntryId")
        private String lastUpdateHistoryEntryId;
        @JsonProperty(value="listenerPort")
        private Long listenerPort;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="giVersion")
        private String giVersion;
        @JsonProperty(value="gridImageId")
        private String gridImageId;
        @JsonProperty(value="gridImageType")
        private GridImageType gridImageType;
        @JsonProperty(value="systemVersion")
        private String systemVersion;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="scanIpIds")
        private List<String> scanIpIds;
        @JsonProperty(value="vipIds")
        private List<String> vipIds;
        @JsonProperty(value="scanDnsRecordId")
        private String scanDnsRecordId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="scanDnsName")
        private String scanDnsName;
        @JsonProperty(value="zoneId")
        private String zoneId;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="scanListenerPortTcpSsl")
        private Integer scanListenerPortTcpSsl;
        @JsonProperty(value="privateZoneId")
        private String privateZoneId;
        @JsonProperty(value="dataCollectionOptions")
        private DataCollectionOptions dataCollectionOptions;
        @JsonProperty(value="totalECpuCount")
        private Integer totalECpuCount;
        @JsonProperty(value="enabledECpuCount")
        private Integer enabledECpuCount;
        @JsonProperty(value="vmFileSystemStorage")
        private ExadbVmClusterStorageDetails vmFileSystemStorage;
        @JsonProperty(value="snapshotFileSystemStorage")
        private ExadbVmClusterStorageDetails snapshotFileSystemStorage;
        @JsonProperty(value="totalFileSystemStorage")
        private ExadbVmClusterStorageDetails totalFileSystemStorage;
        @JsonProperty(value="exascaleDbStorageVaultId")
        private String exascaleDbStorageVaultId;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder iormConfigCache(ExadataIormConfig iormConfigCache) {
            this.iormConfigCache = iormConfigCache;
            this.__explicitlySet__.add("iormConfigCache");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            this.__explicitlySet__.add("lastUpdateHistoryEntryId");
            return this;
        }

        public Builder listenerPort(Long listenerPort) {
            this.listenerPort = listenerPort;
            this.__explicitlySet__.add("listenerPort");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            this.__explicitlySet__.add("giVersion");
            return this;
        }

        public Builder gridImageId(String gridImageId) {
            this.gridImageId = gridImageId;
            this.__explicitlySet__.add("gridImageId");
            return this;
        }

        public Builder gridImageType(GridImageType gridImageType) {
            this.gridImageType = gridImageType;
            this.__explicitlySet__.add("gridImageType");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.__explicitlySet__.add("systemVersion");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder scanIpIds(List<String> scanIpIds) {
            this.scanIpIds = scanIpIds;
            this.__explicitlySet__.add("scanIpIds");
            return this;
        }

        public Builder vipIds(List<String> vipIds) {
            this.vipIds = vipIds;
            this.__explicitlySet__.add("vipIds");
            return this;
        }

        public Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            this.__explicitlySet__.add("scanDnsRecordId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            this.__explicitlySet__.add("scanDnsName");
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            this.__explicitlySet__.add("zoneId");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder scanListenerPortTcpSsl(Integer scanListenerPortTcpSsl) {
            this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
            this.__explicitlySet__.add("scanListenerPortTcpSsl");
            return this;
        }

        public Builder privateZoneId(String privateZoneId) {
            this.privateZoneId = privateZoneId;
            this.__explicitlySet__.add("privateZoneId");
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            this.__explicitlySet__.add("dataCollectionOptions");
            return this;
        }

        public Builder totalECpuCount(Integer totalECpuCount) {
            this.totalECpuCount = totalECpuCount;
            this.__explicitlySet__.add("totalECpuCount");
            return this;
        }

        public Builder enabledECpuCount(Integer enabledECpuCount) {
            this.enabledECpuCount = enabledECpuCount;
            this.__explicitlySet__.add("enabledECpuCount");
            return this;
        }

        public Builder vmFileSystemStorage(ExadbVmClusterStorageDetails vmFileSystemStorage) {
            this.vmFileSystemStorage = vmFileSystemStorage;
            this.__explicitlySet__.add("vmFileSystemStorage");
            return this;
        }

        public Builder snapshotFileSystemStorage(ExadbVmClusterStorageDetails snapshotFileSystemStorage) {
            this.snapshotFileSystemStorage = snapshotFileSystemStorage;
            this.__explicitlySet__.add("snapshotFileSystemStorage");
            return this;
        }

        public Builder totalFileSystemStorage(ExadbVmClusterStorageDetails totalFileSystemStorage) {
            this.totalFileSystemStorage = totalFileSystemStorage;
            this.__explicitlySet__.add("totalFileSystemStorage");
            return this;
        }

        public Builder exascaleDbStorageVaultId(String exascaleDbStorageVaultId) {
            this.exascaleDbStorageVaultId = exascaleDbStorageVaultId;
            this.__explicitlySet__.add("exascaleDbStorageVaultId");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public ExadbVmCluster build() {
            ExadbVmCluster model = new ExadbVmCluster(this.iormConfigCache, this.id, this.compartmentId, this.availabilityDomain, this.subnetId, this.backupSubnetId, this.nsgIds, this.backupNetworkNsgIds, this.lastUpdateHistoryEntryId, this.listenerPort, this.lifecycleState, this.nodeCount, this.shape, this.displayName, this.timeCreated, this.lifecycleDetails, this.timeZone, this.hostname, this.domain, this.clusterName, this.giVersion, this.gridImageId, this.gridImageType, this.systemVersion, this.sshPublicKeys, this.licenseModel, this.scanIpIds, this.vipIds, this.scanDnsRecordId, this.freeformTags, this.definedTags, this.systemTags, this.scanDnsName, this.zoneId, this.scanListenerPortTcp, this.scanListenerPortTcpSsl, this.privateZoneId, this.dataCollectionOptions, this.totalECpuCount, this.enabledECpuCount, this.vmFileSystemStorage, this.snapshotFileSystemStorage, this.totalFileSystemStorage, this.exascaleDbStorageVaultId, this.memorySizeInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadbVmCluster model) {
            if (model.wasPropertyExplicitlySet("iormConfigCache")) {
                this.iormConfigCache(model.getIormConfigCache());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("backupSubnetId")) {
                this.backupSubnetId(model.getBackupSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkNsgIds")) {
                this.backupNetworkNsgIds(model.getBackupNetworkNsgIds());
            }
            if (model.wasPropertyExplicitlySet("lastUpdateHistoryEntryId")) {
                this.lastUpdateHistoryEntryId(model.getLastUpdateHistoryEntryId());
            }
            if (model.wasPropertyExplicitlySet("listenerPort")) {
                this.listenerPort(model.getListenerPort());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("giVersion")) {
                this.giVersion(model.getGiVersion());
            }
            if (model.wasPropertyExplicitlySet("gridImageId")) {
                this.gridImageId(model.getGridImageId());
            }
            if (model.wasPropertyExplicitlySet("gridImageType")) {
                this.gridImageType(model.getGridImageType());
            }
            if (model.wasPropertyExplicitlySet("systemVersion")) {
                this.systemVersion(model.getSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKeys")) {
                this.sshPublicKeys(model.getSshPublicKeys());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("scanIpIds")) {
                this.scanIpIds(model.getScanIpIds());
            }
            if (model.wasPropertyExplicitlySet("vipIds")) {
                this.vipIds(model.getVipIds());
            }
            if (model.wasPropertyExplicitlySet("scanDnsRecordId")) {
                this.scanDnsRecordId(model.getScanDnsRecordId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("scanDnsName")) {
                this.scanDnsName(model.getScanDnsName());
            }
            if (model.wasPropertyExplicitlySet("zoneId")) {
                this.zoneId(model.getZoneId());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcp")) {
                this.scanListenerPortTcp(model.getScanListenerPortTcp());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcpSsl")) {
                this.scanListenerPortTcpSsl(model.getScanListenerPortTcpSsl());
            }
            if (model.wasPropertyExplicitlySet("privateZoneId")) {
                this.privateZoneId(model.getPrivateZoneId());
            }
            if (model.wasPropertyExplicitlySet("dataCollectionOptions")) {
                this.dataCollectionOptions(model.getDataCollectionOptions());
            }
            if (model.wasPropertyExplicitlySet("totalECpuCount")) {
                this.totalECpuCount(model.getTotalECpuCount());
            }
            if (model.wasPropertyExplicitlySet("enabledECpuCount")) {
                this.enabledECpuCount(model.getEnabledECpuCount());
            }
            if (model.wasPropertyExplicitlySet("vmFileSystemStorage")) {
                this.vmFileSystemStorage(model.getVmFileSystemStorage());
            }
            if (model.wasPropertyExplicitlySet("snapshotFileSystemStorage")) {
                this.snapshotFileSystemStorage(model.getSnapshotFileSystemStorage());
            }
            if (model.wasPropertyExplicitlySet("totalFileSystemStorage")) {
                this.totalFileSystemStorage(model.getTotalFileSystemStorage());
            }
            if (model.wasPropertyExplicitlySet("exascaleDbStorageVaultId")) {
                this.exascaleDbStorageVaultId(model.getExascaleDbStorageVaultId());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            return this;
        }
    }
}

