/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.DriverManager;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.type.ColumnOrder;
import net.ucanaccess.util.Try;
import net.ucanaccess.util.UcanaccessRuntimeException;

public final class UcanaccessConnectionBuilder {
    private String dbPath;
    private final Map<Metadata.Property, Object> props = new EnumMap<Metadata.Property, Object>(Metadata.Property.class);

    public UcanaccessConnectionBuilder withDbPath(String _dbPath) {
        this.dbPath = _dbPath;
        return this;
    }

    public UcanaccessConnectionBuilder withUser(String _user) {
        return this.withProp(Metadata.Property.user, _user);
    }

    public UcanaccessConnectionBuilder withPassword(String _pass) {
        return this.withProp(Metadata.Property.password, _pass);
    }

    public UcanaccessConnectionBuilder withoutUserPass() {
        this.props.remove((Object)Metadata.Property.ignoreCase);
        this.props.remove((Object)Metadata.Property.password);
        return this;
    }

    public UcanaccessConnectionBuilder withColumnOrderData() {
        return this.withProp(Metadata.Property.columnOrder, (Object)ColumnOrder.DATA);
    }

    public UcanaccessConnectionBuilder withColumnOrderDisplay() {
        return this.withProp(Metadata.Property.columnOrder, (Object)ColumnOrder.DISPLAY);
    }

    public UcanaccessConnectionBuilder withConcatNulls(boolean _concatNulls) {
        return this.withProp(Metadata.Property.concatNulls, _concatNulls);
    }

    public UcanaccessConnectionBuilder withIgnoreCase(boolean _ignoreCase) {
        return this.withProp(Metadata.Property.ignoreCase, _ignoreCase);
    }

    public UcanaccessConnectionBuilder withImmediatelyReleaseResources() {
        return this.withProp(Metadata.Property.immediatelyReleaseResources, true);
    }

    public UcanaccessConnectionBuilder withInactivityTimeout(int _inactivityTimeout) {
        return this.withProp(Metadata.Property.inactivityTimeout, _inactivityTimeout);
    }

    public UcanaccessConnectionBuilder withMemory() {
        return this.withProp(Metadata.Property.memory, true);
    }

    public UcanaccessConnectionBuilder withNewDatabaseVersionProp(String _name) {
        return this.withProp(Metadata.Property.newDatabaseVersion, _name);
    }

    public UcanaccessConnectionBuilder withProp(Metadata.Property _prop, Object _value) {
        Objects.requireNonNull(_prop, "Property required");
        String val = Optional.ofNullable(_value).map(Object::toString).orElse("");
        this.props.put(_prop, val);
        return this;
    }

    public String getUrl() {
        Objects.requireNonNull(this.dbPath, "Database path required");
        String url = "jdbc:ucanaccess://" + this.dbPath;
        String propsStr = this.propsToString(";");
        if (!propsStr.isEmpty()) {
            url = url + ";" + propsStr;
        }
        return url;
    }

    public String getUser() {
        return (String)this.props.get((Object)Metadata.Property.user);
    }

    public String getPassword() {
        return (String)this.props.get((Object)Metadata.Property.password);
    }

    public UcanaccessConnection build() {
        Try.catching(() -> Class.forName(UcanaccessDriver.class.getName())).orThrow(UcanaccessRuntimeException::new);
        return Try.catching(() -> DriverManager.getConnection(this.getUrl(), this.getUser(), this.getPassword())).map(UcanaccessConnection.class::cast).orThrow();
    }

    String propsToString(CharSequence _delimiter) {
        LinkedHashMap<Metadata.Property, Object> copy = new LinkedHashMap<Metadata.Property, Object>(this.props);
        copy.remove((Object)Metadata.Property.user);
        copy.remove((Object)Metadata.Property.password);
        if (Integer.parseInt(copy.getOrDefault((Object)Metadata.Property.inactivityTimeout, -1).toString()) > -1) {
            copy.remove((Object)Metadata.Property.immediatelyReleaseResources);
        } else {
            copy.put(Metadata.Property.immediatelyReleaseResources, true);
        }
        return copy.entrySet().stream().map(e -> ((Metadata.Property)((Object)((Object)e.getKey()))).name() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(_delimiter));
    }

    public String toString() {
        return String.format("%s[user=%s, dbPath=%s, props={%s}]", this.getClass().getSimpleName(), this.props.get((Object)Metadata.Property.user), this.dbPath, this.propsToString(", "));
    }
}

