/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.DateTimeType;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.IJackcessOpenerInterface;
import net.ucanaccess.jdbc.IOnReloadReferenceListener;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.log.Logger;

public class DBReference {
    private static final String CIPHER_SPEC = "AES";
    private static List<IOnReloadReferenceListener> onReloadListeners = new ArrayList<IOnReloadReferenceListener>();
    private static String version;
    private File dbFile;
    private Database dbIO;
    private FileLock fileLock = null;
    private String id = this.id();
    private boolean inMemory = true;
    private long lastModified;
    private boolean openExclusive = false;
    private MemoryTimer memoryTimer;
    private boolean readOnly;
    private boolean readOnlyFileFormat;
    private boolean showSchema;
    private File tempHsql;
    private File toKeepHsql;
    private boolean immediatelyReleaseResources;
    private boolean encryptHSQLDB;
    private String encryptionKey;
    private String pwd;
    private IJackcessOpenerInterface jko;
    private Map<String, String> externalResourcesMapping;
    private boolean firstConnection = true;
    private Database.FileFormat dbFormat;
    private boolean columnOrderDisplay;
    private boolean hsqldbShutdown;
    private File mirrorFolder;
    private Set<File> links = new HashSet<File>();
    private boolean ignoreCase = true;
    private boolean mirrorReadOnly;
    private Integer lobScale;
    private boolean skipIndexes;
    private boolean sysSchema;
    private boolean preventReloading;
    private boolean concatNulls;
    private boolean mirrorRecreated;

    public DBReference(File fl, Database.FileFormat ff, IJackcessOpenerInterface _jko, String _pwd) throws IOException {
        this.dbFile = fl;
        this.pwd = _pwd;
        this.jko = _jko;
        this.lastModified = System.currentTimeMillis();
        this.memoryTimer = new MemoryTimer(this);
        Logger.turnOffJackcessLog();
        if (!fl.exists() && ff != null) {
            DatabaseBuilder dbb = new DatabaseBuilder();
            this.dbIO = dbb.setAutoSync(false).setFileFormat(ff).setFile(fl).create();
        } else {
            this.dbIO = _jko.open(fl, _pwd);
            try {
                this.readOnlyFileFormat = this.dbIO.getFileFormat().equals((Object)Database.FileFormat.V1997);
                this.dbFormat = this.dbIO.getFileFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbIO.setLinkResolver((linkerDb, linkeeFileName) -> {
                if (linkeeFileName == null) {
                    throw new IOException("Cannot resolve db link");
                }
                File linkeeFile = new File(linkeeFileName);
                Map<String, String> emr = this.externalResourcesMapping;
                if (!linkeeFile.exists() && emr != null && emr.containsKey(linkeeFileName.toLowerCase())) {
                    linkeeFile = new File(emr.get(linkeeFileName.toLowerCase()));
                }
                if (!linkeeFile.exists()) {
                    Logger.logWarning("External file " + linkeeFile.getAbsolutePath() + " does not exist");
                } else {
                    this.links.add(linkeeFile);
                }
                Database ldb = this.open(linkeeFile, _pwd);
                ldb.setDateTimeType(DateTimeType.LOCAL_DATE_TIME);
                return ldb;
            });
            this.dbIO.setDateTimeType(DateTimeType.LOCAL_DATE_TIME);
            this.dbIO.setEnforceForeignKeys(Boolean.valueOf(false));
        }
    }

    public Database open(File _dbfl, String _pwd) throws IOException {
        Logger.turnOffJackcessLog();
        Database ret = this.jko.open(_dbfl, _pwd);
        if (this.columnOrderDisplay) {
            ret.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
        return ret;
    }

    boolean loadedFromKeptMirror(Session session) throws UcanaccessSQLException {
        if (this.toKeepHsql != null && this.toKeepHsql.exists()) {
            if (this.getLastUpdateHSQLDB() >= this.dbFile.lastModified()) {
                return true;
            }
            try {
                this.closeHsqlDb(session, true);
            }
            catch (Exception _ex) {
                throw new UcanaccessSQLException(_ex);
            }
            return false;
        }
        return false;
    }

    public static boolean addOnReloadRefListener(IOnReloadReferenceListener _action) {
        return onReloadListeners.add(_action);
    }

    public static String getVersion() {
        return version;
    }

    public static boolean is2xx() {
        return version.startsWith("2.");
    }

    private long filesUpdateTime() {
        long lm = this.dbFile.lastModified();
        for (File fl : this.links) {
            lm = Math.max(lm, fl.lastModified());
        }
        return lm;
    }

    Connection checkLastModified(Connection _conn, Session _session) throws Exception {
        if (this.lastModified + 2000L > this.filesUpdateTime() || this.preventReloading && !this.checkInside()) {
            return _conn;
        }
        this.updateLastModified();
        this.closeHSQLDB(_session);
        this.dbIO.flush();
        this.dbIO.close();
        this.dbIO = this.open(this.dbFile, this.pwd);
        this.id = this.id();
        this.firstConnection = true;
        LoadJet lj = new LoadJet(this.getHSQLDBConnection(_session), this.dbIO);
        lj.setSkipIndexes(this.skipIndexes);
        lj.setSysSchema(this.sysSchema);
        lj.loadDB();
        return this.getHSQLDBConnection(_session);
    }

    private boolean checkInside(Database db) throws IOException {
        Table t = db.getSystemTable("MSysObjects");
        for (Row row : t) {
            Object dobj = row.get((Object)"DateUpdate");
            Object tobj = row.get((Object)"Type");
            if (dobj == null || tobj == null) continue;
            Date dt = (Date)dobj;
            short type = (Short)tobj;
            if (this.lastModified >= dt.getTime() || type != 1 && type != 5 && type != 8) continue;
            return true;
        }
        return false;
    }

    private boolean checkInside() throws IOException {
        boolean reload = this.checkInside(this.dbIO);
        if (reload) {
            return true;
        }
        for (File fl : this.links) {
            Database db = DatabaseBuilder.open((File)fl);
            reload = this.checkInside(db);
            db.close();
            if (!reload) continue;
            return true;
        }
        return false;
    }

    private File[] getHSQLDBFiles() {
        if (this.toKeepHsql == null) {
            return new File[0];
        }
        File folder = this.toKeepHsql.getParentFile();
        String name = this.toKeepHsql.getName();
        return new File[]{new File(folder, name + ".data"), new File(folder, name + ".script"), new File(folder, name + ".properties"), new File(folder, name + ".log"), new File(folder, name + ".lck"), new File(folder, name + ".lobs")};
    }

    private long getLastUpdateHSQLDB() {
        long lu = 0L;
        File[] fileArray = this.getHSQLDBFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File hsqlF = fileArray[n2];
            if (hsqlF.exists() && hsqlF.lastModified() > lu) {
                lu = hsqlF.lastModified();
            }
            ++n2;
        }
        if (this.toKeepHsql != null && this.toKeepHsql.exists() && this.toKeepHsql.lastModified() > lu) {
            lu = this.toKeepHsql.lastModified();
        }
        return lu;
    }

    private void closeHSQLDB(Session session) throws IOException {
        this.closeHsqlDb(session, false);
    }

    private void closeHsqlDb(Session _session, boolean _firstConnectionKeeptMirror) throws IOException {
        this.finalizeHsqlDb(_session);
        if (!this.inMemory) {
            if (this.toKeepHsql == null) {
                File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                File hbase = new File(folder, "Ucanaccess_" + String.valueOf(this));
                if (hbase.exists()) {
                    File[] fileArray = hbase.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File hsqlF = fileArray[n2];
                        Files.delete(hsqlF.toPath());
                        ++n2;
                    }
                }
                Files.delete(hbase.toPath());
            } else if (!this.immediatelyReleaseResources || _firstConnectionKeeptMirror) {
                Files.delete(this.toKeepHsql.toPath());
                if (!this.toKeepHsql.createNewFile()) {
                    Logger.logWarning("Could not create file " + String.valueOf(this.toKeepHsql));
                }
                File[] fileArray = this.getHSQLDBFiles();
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File hsqlf = fileArray[n3];
                    if (hsqlf.exists()) {
                        Files.delete(hsqlf.toPath());
                    }
                    ++n3;
                }
                this.mirrorRecreated = true;
            }
        }
    }

    public void decrementActiveConnection(Session session) {
        this.memoryTimer.decrementActiveConnection(session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void finalizeHsqlDb(Session _session) throws IOException {
        if (this.hsqldbShutdown) return;
        this.releaseLock();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Connection conn = this.getHSQLDBConnection(_session);
                try {
                    try (Statement st = conn.createStatement();){
                        st.execute("SHUTDOWN");
                        this.hsqldbShutdown = true;
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    File getDbFile() {
        return this.dbFile;
    }

    public Database getDbIO() {
        return this.dbIO;
    }

    private void setIgnoreCase(Connection _conn) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement st = _conn.createStatement();){
                st.execute("SET DATABASE COLLATION \"SQL_TEXT_UCC\"");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initHSQLDB(Connection _conn) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement st = _conn.createStatement();){
                st.execute("SET DATABASE SQL SYNTAX ora TRUE");
                st.execute("SET DATABASE SQL CONCAT NULLS " + this.concatNulls);
                if (this.lobScale == null && this.inMemory) {
                    st.execute("SET FILES LOB SCALE 1");
                } else if (this.lobScale != null) {
                    st.execute("SET FILES LOB SCALE " + String.valueOf(this.lobScale));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception _ex) {
            Logger.logWarning(_ex.toString());
        }
    }

    public Connection getHSQLDBConnection(Session _session) throws SQLException {
        boolean keptMirror = this.firstConnection && this.toKeepHsql != null && this.toKeepHsql.exists();
        Connection conn = DriverManager.getConnection(this.getHsqlUrl(_session), Optional.ofNullable(_session.getUser()).orElse("Admin"), _session.getPassword());
        if (version == null) {
            version = conn.getMetaData().getDriverVersion();
        }
        if (this.firstConnection) {
            if (this.ignoreCase && (!keptMirror || this.mirrorRecreated)) {
                this.setIgnoreCase(conn);
            }
            if (!this.mirrorReadOnly || !keptMirror || this.mirrorRecreated) {
                this.initHSQLDB(conn);
            }
            this.firstConnection = false;
            this.mirrorRecreated = false;
        }
        this.hsqldbShutdown = false;
        conn.setAutoCommit(false);
        return conn;
    }

    String getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getKey() throws SQLException {
        if (this.encryptionKey != null) return this.encryptionKey;
        String url = "jdbc:hsqldb:mem:" + this.id + "_tmp";
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Connection conn = DriverManager.getConnection(url);
            try {
                block18: {
                    Statement stmt = conn.createStatement();
                    try {
                        try (ResultSet rs = stmt.executeQuery("CALL CRYPT_KEY('AES', null) ");){
                            rs.next();
                            this.encryptionKey = rs.getString(1);
                        }
                        if (stmt == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                }
                if (conn == null) return this.encryptionKey;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            conn.close();
            return this.encryptionKey;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private String getHsqlUrl(Session _session) throws SQLException {
        try {
            if (this.openExclusive && this.fileLock == null) {
                this.lockMdbFile();
            }
            Object enc = "";
            String log = "";
            if (this.encryptHSQLDB) {
                enc = ";crypt_key=" + this.getKey() + ";crypt_type=aes;crypt_lobs=true";
            }
            if (!this.inMemory && this.toKeepHsql == null) {
                log = ";hsqldb.log_data=FALSE";
            }
            if (!this.inMemory && this.tempHsql == null) {
                if (this.toKeepHsql != null) {
                    if (!this.toKeepHsql.exists() && !this.toKeepHsql.createNewFile()) {
                        Logger.logWarning("Could not create file " + String.valueOf(this.toKeepHsql));
                    }
                    this.tempHsql = this.toKeepHsql;
                } else {
                    File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                    File hbase = new File(folder, "Ucanaccess_" + String.valueOf(this));
                    hbase.mkdir();
                    this.tempHsql = new File(hbase, this.id);
                    if (!this.tempHsql.createNewFile()) {
                        Logger.logWarning("Could not create file " + String.valueOf(this.tempHsql));
                    }
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (this.toKeepHsql == null) {
                            this.closeHSQLDB(_session);
                        } else {
                            this.finalizeHsqlDb(_session);
                        }
                    }
                    catch (Exception _ex) {
                        Logger.logWarning(_ex.toString());
                    }
                }));
            }
            String mro = this.mirrorReadOnly ? ";readonly=true" : "";
            return "jdbc:hsqldb:" + (String)(this.inMemory ? "mem:" + this.id : this.tempHsql.getAbsolutePath()) + (String)enc + log + mro;
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public long getInactivityTimeout() {
        return this.memoryTimer.inactivityTimeout;
    }

    private String id() {
        return String.valueOf(UUID.randomUUID()) + this.toString();
    }

    public void incrementActiveConnection() {
        this.memoryTimer.incrementActiveConnection();
    }

    public boolean isReadOnly() throws UcanaccessSQLException {
        if (this.readOnly) {
            this.lockMdbFile();
        }
        return this.readOnlyFileFormat || this.readOnly;
    }

    boolean isReadOnlyFileFormat() {
        return this.readOnlyFileFormat;
    }

    boolean isShowSchema() {
        return this.showSchema;
    }

    private File fileLock() {
        File folder = this.dbFile.getParentFile();
        String fileName = this.dbFile.getName();
        int suffixStart = fileName.lastIndexOf(46);
        if (suffixStart < 0) {
            suffixStart = fileName.length();
        }
        String suffix = Database.FileFormat.V2016 == this.dbFormat || Database.FileFormat.V2010 == this.dbFormat || Database.FileFormat.V2007 == this.dbFormat ? ".laccdb" : ".ldb";
        return new File(folder, fileName.substring(0, suffixStart) + suffix);
    }

    private void lockMdbFile() throws UcanaccessSQLException {
        try {
            RandomAccessFile raf;
            FileLock tryLock;
            File flLock = this.fileLock();
            if (!flLock.createNewFile()) {
                Logger.logWarning("Could not create file " + String.valueOf(flLock));
            }
            if ((tryLock = (raf = new RandomAccessFile(flLock, "rw")).getChannel().tryLock()) == null) {
                this.readOnly = true;
            } else {
                this.fileLock = tryLock;
                this.readOnly = false;
            }
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public void releaseLock() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
        }
    }

    public void reloadDbIO() throws IOException {
        this.dbIO.flush();
        this.dbIO.close();
        for (IOnReloadReferenceListener listener : onReloadListeners) {
            listener.onReload();
        }
        this.dbIO = this.open(this.dbFile, this.pwd);
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.memoryTimer.setInactivityTimeout(inactivityTimeout);
    }

    public void setInMemory(boolean _inMemory) {
        this.inMemory = _inMemory;
    }

    public void setOpenExclusive(boolean _openExclusive) {
        this.openExclusive = _openExclusive;
    }

    public void setShowSchema(boolean _showSchema) {
        this.showSchema = _showSchema;
    }

    void shutdown(Session _session) throws Exception {
        DBReferenceSingleton.getInstance().remove(this.dbFile.getAbsolutePath());
        if (this.immediatelyReleaseResources) {
            for (IOnReloadReferenceListener listener : onReloadListeners) {
                listener.onReload();
            }
        }
        this.memoryTimer.timer.cancel();
        this.dbIO.flush();
        this.dbIO.close();
        this.closeHSQLDB(_session);
    }

    public void updateLastModified() {
        this.lastModified = this.filesUpdateTime();
    }

    public void setImmediatelyReleaseResources(boolean _immediatelyReleaseResources) {
        this.immediatelyReleaseResources = _immediatelyReleaseResources;
    }

    public void setEncryptHSQLDB(boolean _encryptHSQLDB) {
        this.encryptHSQLDB = _encryptHSQLDB;
    }

    public void setExternalResourcesMapping(Map<String, String> _externalResourcesMapping) {
        this.externalResourcesMapping = _externalResourcesMapping;
    }

    public File getToKeepHsql() {
        return this.toKeepHsql;
    }

    public void setToKeepHsql(File _toKeepHsql) {
        this.toKeepHsql = _toKeepHsql;
    }

    public boolean isEncryptHSQLDB() {
        return this.encryptHSQLDB;
    }

    public void setColumnOrderDisplay() {
        this.columnOrderDisplay = true;
        if (this.dbIO != null) {
            this.dbIO.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public void setMirrorFolder(File _mirrorFolder) {
        this.mirrorFolder = _mirrorFolder;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean _ignoreCase) {
        this.ignoreCase = _ignoreCase;
    }

    public void setMirrorReadOnly(boolean _mirrorReadOnly) {
        this.mirrorReadOnly = _mirrorReadOnly;
    }

    public void setLobScale(Integer _lobScale) {
        this.lobScale = _lobScale;
    }

    public void setSkipIndexes(boolean _skipIndexes) {
        this.skipIndexes = _skipIndexes;
    }

    public void setSysSchema(boolean _sysSchema) {
        this.sysSchema = _sysSchema;
    }

    public boolean isPreventReloading() {
        return this.preventReloading;
    }

    public void setPreventReloading(boolean _preventReloading) {
        this.preventReloading = _preventReloading;
    }

    public boolean isConcatNulls() {
        return this.concatNulls;
    }

    public void setConcatNulls(boolean _concatNulls) {
        this.concatNulls = _concatNulls;
    }

    private static class MemoryTimer {
        private static final long INACTIVITY_TIMEOUT_DEFAULT = 120000L;
        private final DBReference dbReference;
        private final Timer timer;
        private int activeConnection;
        private long inactivityTimeout = 120000L;
        private long lastConnectionTime;

        MemoryTimer(DBReference _dbReference) {
            this.dbReference = _dbReference;
            this.timer = new Timer(this.getClass().getSimpleName() + "-" + _dbReference.getDbFile().getName(), true);
        }

        synchronized void decrementActiveConnection(final Session _session) {
            --this.activeConnection;
            if (this.dbReference.immediatelyReleaseResources && this.activeConnection == 0) {
                try {
                    this.dbReference.shutdown(_session);
                }
                catch (Exception _ex) {
                    Logger.logWarning("Error shutting down db " + String.valueOf(this.dbReference) + ": " + String.valueOf(_ex));
                }
                this.timer.cancel();
                return;
            }
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L && this.activeConnection == 0) {
                TimerTask task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
                        synchronized (UcanaccessDriver.class) {
                            if (System.currentTimeMillis() - this.getLastConnectionTime() >= inactivityTimeout && this.getActiveConnection() == 0) {
                                try {
                                    dbReference.shutdown(_session);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                this.timer.schedule(task, this.inactivityTimeout);
            }
        }

        synchronized int getActiveConnection() {
            return this.activeConnection;
        }

        synchronized long getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        synchronized void incrementActiveConnection() {
            ++this.activeConnection;
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L) {
                this.lastConnectionTime = System.currentTimeMillis();
            }
        }

        void setInactivityTimeout(int _inactivityTimeout) {
            this.inactivityTimeout = _inactivityTimeout;
        }
    }
}

