/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JaxbValidator
implements Validator {
    public static final String SCHEMA_LOCATION = "schema-location";
    public static final String ORAJAXB_SCHEMA_LOCATION = "ORAJAXB_SCHEMA_LOCATION";
    public static final String ORAJAXB_USERSPEC_SCHEMA_LOCATION = "ORAJAXB_USERSPEC_SCHEMA_LOCATION";
    public static final String ORAJAXB_SCHEMA_ENTITY_RESOLVER = "ORAJAXB_SCHEMA_ENTITY_RESOLVER";
    String contextPath;
    String pathSep = ":";
    ClassLoader loader;
    ValidationEventHandler validationEventHandler;
    HashMap properties;
    XMLError err;
    boolean isSecure;

    JaxbValidator(String string, ClassLoader classLoader) {
        this.contextPath = string;
        this.loader = classLoader;
        this.properties = new HashMap();
        this.err = new XMLError();
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = validationEventHandler;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        if (this.validationEventHandler == null) {
            this.validationEventHandler = new DefaultValidationEventHandler();
        }
        return this.validationEventHandler;
    }

    public boolean validate(Object object) throws JAXBException {
        block8: {
            boolean bl = false;
            XMLElement xMLElement = ((JaxbNode)object).getDOMNode();
            String string = xMLElement.getLocalName();
            String string2 = xMLElement.getNamespaceURI();
            if (string2 == null) {
                string2 = "";
            }
            try {
                XMLSchema xMLSchema;
                XMLDocument xMLDocument = ((JaxbNode)object).getOwnerDocument();
                StringTokenizer stringTokenizer = new StringTokenizer(this.contextPath, this.pathSep);
                schemaContext schemaContext2 = new schemaContext(stringTokenizer);
                while ((xMLSchema = this.getNextSchema(xMLDocument, schemaContext2)) != null) {
                    Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().elements();
                    while (enumeration.hasMoreElements()) {
                        XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
                        XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
                        if (xSDNodeArray == null) continue;
                        for (int i = 0; i < xSDNodeArray.length; ++i) {
                            XSDNode xSDNode = xSDNodeArray[i];
                            if (xSDNode.getName().equals(string) && xSDNode.getTargetNS().equals(string2)) {
                                return xMLElement.validateContent(xMLSchema);
                            }
                            XSDNode[] xSDNodeArray2 = ((XSDElement)xSDNode).getChildElements();
                            if (xSDNodeArray2 == null) continue;
                            for (int j = 0; j < xSDNodeArray2.length; ++j) {
                                XSDNode xSDNode2 = xSDNodeArray2[j];
                                if (!xSDNode2.getName().equals(string) || !xSDNode2.getTargetNS().equals(string2)) continue;
                                XSDValidator xSDValidator = new XSDValidator();
                                xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)xSDNode2);
                                return xMLElement.validateContent(xSDValidator);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl((Object)exception);
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(2, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                if (this.validationEventHandler == null || this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl)) break block8;
                throw new ValidationException(exception.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateRoot(Object object) throws JAXBException {
        XMLDocument xMLDocument = null;
        XMLSchema xMLSchema = null;
        if (object == null) {
            ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
            ValidationEventImpl validationEventImpl = new ValidationEventImpl(2, this.err.getMessage0(32112), (ValidationEventLocator)validationEventLocatorImpl);
            return this.getEventHandler().handleEvent((ValidationEvent)validationEventImpl);
        }
        try {
            xMLDocument = ((JaxbNode)object).getOwnerDocument();
            StringTokenizer stringTokenizer = new StringTokenizer(this.contextPath, this.pathSep);
            schemaContext schemaContext2 = new schemaContext(stringTokenizer);
            XMLElement xMLElement = ((JaxbNode)object).getDOMNode();
            XMLError xMLError = xMLElement.getXMLError();
            xMLSchema = this.getNextSchema(xMLDocument, schemaContext2);
            while (xMLSchema != null) {
                try {
                    if (xMLElement.validateContent(xMLSchema)) {
                        return true;
                    }
                    xMLSchema = this.getNextSchema(xMLDocument, schemaContext2);
                }
                catch (Exception exception) {
                    int n = xMLError.getNumMessages();
                    if (n == 1 && xMLError.getMessageId(0) == 24538 && (xMLSchema = this.getNextSchema(xMLDocument, schemaContext2)) != null) {
                        xMLError.reset();
                        continue;
                    }
                    ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl((Object)exception);
                    ValidationEventImpl validationEventImpl = new ValidationEventImpl(2, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                    if (this.validationEventHandler == null) return this.getEventHandler().handleEvent((ValidationEvent)validationEventImpl);
                    return this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl((Object)exception);
            ValidationEventImpl validationEventImpl = new ValidationEventImpl(2, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
            if (this.validationEventHandler == null) return this.getEventHandler().handleEvent((ValidationEvent)validationEventImpl);
            return this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
        }
    }

    XMLSchema getNextSchema(XMLDocument xMLDocument, schemaContext schemaContext2) throws Exception {
        Object object;
        Class[] classArray;
        String string = null;
        XMLSchema xMLSchema = null;
        if (schemaContext2.state == 0) {
            if (schemaContext2.url != null) {
                try {
                    classArray = null;
                    object = new XSDBuilder();
                    if (this.isSecure) {
                        object.setSecureProcessing();
                    }
                    if (schemaContext2.entResolver != null) {
                        object.setEntityResolver(schemaContext2.entResolver);
                        classArray = schemaContext2.entResolver.resolveEntity(null, schemaContext2.userSchLoc);
                    }
                    xMLSchema = classArray != null ? object.build(classArray) : object.build(schemaContext2.url);
                }
                catch (Exception exception) {
                    xMLSchema = null;
                }
            }
            ++schemaContext2.state;
            if (xMLSchema != null) {
                return xMLSchema;
            }
        }
        if (schemaContext2.state == 1) {
            while (schemaContext2.tokens.hasMoreTokens()) {
                string = schemaContext2.tokens.nextToken().concat(".ObjectFactory");
                try {
                    Class<?> clazz = Class.forName(string, true, this.loader);
                    Object obj = clazz.newInstance();
                    classArray = new Class[]{};
                    object = clazz.getMethod("getSchemaLocation", classArray);
                    Object[] objectArray = new Object[]{};
                    URL uRL = (URL)((Method)object).invoke(obj, objectArray);
                    XSDBuilder xSDBuilder = new XSDBuilder();
                    InputSource inputSource = null;
                    if (schemaContext2.entResolver != null) {
                        xSDBuilder.setEntityResolver(schemaContext2.entResolver);
                        inputSource = schemaContext2.entResolver.resolveEntity(null, schemaContext2.userSchLoc);
                    }
                    if ((xMLSchema = inputSource != null ? xSDBuilder.build(inputSource) : xSDBuilder.build(uRL)) == null) continue;
                    return xMLSchema;
                }
                catch (Exception exception) {
                }
            }
            ++schemaContext2.state;
        }
        if (schemaContext2.state == 2) {
            xMLSchema = xMLDocument.getSchema();
            ++schemaContext2.state;
            if (xMLSchema != null) {
                return xMLSchema;
            }
        }
        if (schemaContext2.state == 3) {
            return null;
        }
        return null;
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals(SCHEMA_LOCATION) || string.equals(ORAJAXB_SCHEMA_LOCATION)) {
            URL uRL = null;
            try {
                uRL = new File((String)object).toURL();
            }
            catch (Exception exception) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            this.properties.put(ORAJAXB_SCHEMA_LOCATION, uRL);
            this.properties.put(ORAJAXB_USERSPEC_SCHEMA_LOCATION, object);
            return;
        }
        if (string.equals(ORAJAXB_SCHEMA_ENTITY_RESOLVER)) {
            if (!(object instanceof EntityResolver)) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            this.properties.put(ORAJAXB_SCHEMA_ENTITY_RESOLVER, object);
            return;
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (!(object instanceof Boolean)) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            this.isSecure = (Boolean)object;
            return;
        }
        throw new PropertyException(this.err.getMessage0(32101));
    }

    public Object getProperty(String string) throws PropertyException {
        if (this.properties.get(string) == null) {
            throw new PropertyException(this.err.getMessage0(32101));
        }
        return this.properties.get(string);
    }

    private class schemaContext {
        URL url;
        EntityResolver entResolver;
        String userSchLoc;
        StringTokenizer tokens;
        XMLSchema schema = null;
        int state = 0;
        static final int IN_PROP = 0;
        static final int IN_OBJ_FAC = 1;
        static final int IN_XML_DOC = 2;
        static final int IN_DONE = 3;

        schemaContext(StringTokenizer stringTokenizer) {
            this.tokens = stringTokenizer;
            this.url = (URL)JaxbValidator.this.properties.get(JaxbValidator.ORAJAXB_SCHEMA_LOCATION);
            this.userSchLoc = (String)JaxbValidator.this.properties.get(JaxbValidator.ORAJAXB_USERSPEC_SCHEMA_LOCATION);
            this.entResolver = (EntityResolver)JaxbValidator.this.properties.get(JaxbValidator.ORAJAXB_SCHEMA_ENTITY_RESOLVER);
        }
    }
}

