/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.Validator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import javax.xml.bind.util.JAXBSource;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import oracle.xml.jaxb.JaxbUnmarshallerHandler;
import oracle.xml.jaxb.JaxbValidator;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JaxbUnmarshaller
implements Unmarshaller {
    DOMParser parser;
    String contextPath;
    ClassLoader loader;
    boolean validation = false;
    XMLSchema schema = null;
    ValidationEventHandler validationEventHandler;
    UnmarshallerHandler unmarshalHandler;
    XMLError err;
    HashMap properties;
    Validator validator;
    public static final String ORAJAXB_PRESERVE_WS = "ORAJAXB_PRESERVE_WS";
    public static final String ORAJAXB_SCHEMA_LOCATION = "ORAJAXB_SCHEMA_LOCATION";

    JaxbUnmarshaller(String string, ClassLoader classLoader) {
        this.contextPath = string;
        this.loader = classLoader;
        this.parser = new DOMParser();
        this.parser.setPreserveWhitespace(true);
        this.parser.setSecureProcessing();
        this.err = new XMLError();
        this.properties = new HashMap();
        this.validator = new JaxbValidator(string, classLoader);
    }

    void setUnmarshalHandler(UnmarshallerHandler unmarshallerHandler) {
        this.unmarshalHandler = unmarshallerHandler;
    }

    public Object unmarshal(File file) throws JAXBException {
        XMLDocument xMLDocument = null;
        Object object = null;
        boolean bl = true;
        try {
            this.parser.parse((InputStream)new FileInputStream(file));
            xMLDocument = this.parser.getDocument();
            ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
            xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
            object = this.unmarshal(xMLDocument.getDocumentElement());
        }
        catch (Exception exception) {
            if (this.validationEventHandler != null) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
            }
            throw new JAXBException(this.err.getMessage0(32104), (Throwable)exception);
        }
        if (this.validation) {
            if (this.validationEventHandler != null) {
                this.validator.setEventHandler(this.validationEventHandler);
            }
            if (!(bl = this.validator.validateRoot(object))) {
                throw new UnmarshalException(this.err.getMessage0(32105));
            }
        }
        return object;
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        XMLDocument xMLDocument = null;
        Object object = null;
        boolean bl = true;
        try {
            this.parser.parse(inputStream);
            xMLDocument = this.parser.getDocument();
            ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
            xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
            object = this.unmarshal(xMLDocument.getDocumentElement());
        }
        catch (Exception exception) {
            if (this.validationEventHandler != null) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
            }
            throw new JAXBException(this.err.getMessage0(32104), (Throwable)exception);
        }
        if (this.validation) {
            if (this.validationEventHandler != null) {
                this.validator.setEventHandler(this.validationEventHandler);
            }
            if (!(bl = this.validator.validateRoot(object))) {
                throw new UnmarshalException(this.err.getMessage0(32105));
            }
        }
        return object;
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        XMLDocument xMLDocument = null;
        Object object = null;
        boolean bl = true;
        try {
            this.parser.parse(reader);
            xMLDocument = this.parser.getDocument();
            ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
            xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
            object = this.unmarshal(xMLDocument.getDocumentElement());
        }
        catch (Exception exception) {
            if (this.validationEventHandler != null) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
            }
            throw new JAXBException(this.err.getMessage0(32104), (Throwable)exception);
        }
        if (this.validation) {
            if (this.validationEventHandler != null) {
                this.validator.setEventHandler(this.validationEventHandler);
            }
            if (!(bl = this.validator.validateRoot(object))) {
                throw new UnmarshalException(this.err.getMessage0(32105));
            }
        }
        return object;
    }

    public Object unmarshal(URL uRL) throws JAXBException {
        XMLDocument xMLDocument = null;
        Object object = null;
        boolean bl = true;
        try {
            this.parser.parse(uRL);
            xMLDocument = this.parser.getDocument();
            ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
            xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
            object = this.unmarshal(xMLDocument.getDocumentElement());
        }
        catch (Exception exception) {
            if (this.validationEventHandler != null) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
            }
            throw new UnmarshalException(this.err.getMessage0(32105), (Throwable)exception);
        }
        if (this.validation) {
            if (this.validationEventHandler != null) {
                this.validator.setEventHandler(this.validationEventHandler);
            }
            if (!(bl = this.validator.validateRoot(object))) {
                throw new UnmarshalException(this.err.getMessage0(32105));
            }
        }
        return object;
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        XMLDocument xMLDocument = null;
        Object object = null;
        boolean bl = true;
        try {
            this.parser.parse(inputSource);
            xMLDocument = this.parser.getDocument();
            ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
            xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
            object = this.unmarshal(xMLDocument.getDocumentElement());
        }
        catch (Exception exception) {
            if (this.validationEventHandler != null) {
                ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl();
                ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
            }
            throw new JAXBException(this.err.getMessage0(32104), (Throwable)exception);
        }
        if (this.validation) {
            if (this.validationEventHandler != null) {
                this.validator.setEventHandler(this.validationEventHandler);
            }
            if (!(bl = this.validator.validateRoot(object))) {
                throw new UnmarshalException(this.err.getMessage0(32105));
            }
        }
        return object;
    }

    public Object unmarshal(Node node) throws JAXBException {
        String string = ":";
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.contextPath, string);
        Exception exception = null;
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().concat(".ObjectFactory");
            try {
                Class<?> clazz = Class.forName(string2, true, this.loader);
                Object obj = clazz.newInstance();
                Class[] classArray = new Class[]{Node.class};
                Method method = clazz.getMethod("unmarshal", classArray);
                Object[] objectArray = new Object[]{node};
                Object object = method.invoke(obj, objectArray);
                if (object == null) continue;
                return object;
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
            }
        }
        if (exception != null) {
            throw new JAXBException("Error in Calling ObjectFactory", exception);
        }
        return null;
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source instanceof SAXSource) {
            if (source instanceof JAXBSource) {
                XMLDocument xMLDocument = null;
                XMLReader xMLReader = ((SAXSource)source).getXMLReader();
                InputSource inputSource = SAXSource.sourceToInputSource(source);
                DocumentBuilder documentBuilder = new DocumentBuilder();
                xMLReader.setContentHandler((ContentHandler)documentBuilder);
                try {
                    xMLReader.parse(inputSource);
                    xMLDocument = documentBuilder.getDocument();
                    ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
                    xMLDocument.reportSAXEvents((ContentHandler)this.unmarshalHandler);
                    return this.unmarshal(xMLDocument.getDocumentElement());
                }
                catch (Exception exception) {
                    if (this.validationEventHandler != null) {
                        ValidationEventLocatorImpl validationEventLocatorImpl = new ValidationEventLocatorImpl((Object)exception);
                        ValidationEventImpl validationEventImpl = new ValidationEventImpl(2, exception.getMessage(), (ValidationEventLocator)validationEventLocatorImpl);
                        this.validationEventHandler.handleEvent((ValidationEvent)validationEventImpl);
                    }
                    throw new UnmarshalException(this.err.getMessage0(32105));
                }
            }
            InputSource inputSource = ((SAXSource)source).getInputSource();
            return this.unmarshal(inputSource);
        }
        if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            if (inputStream != null) {
                return this.unmarshal(inputStream);
            }
            Reader reader = ((StreamSource)source).getReader();
            if (reader != null) {
                return this.unmarshal(reader);
            }
            String string = ((StreamSource)source).getSystemId();
            if (string != null) {
                URL uRL = null;
                try {
                    uRL = new URL(string);
                    return this.unmarshal(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new JAXBException(this.err.getMessage0(32104), (Throwable)malformedURLException);
                }
            }
        } else if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            return this.unmarshal(node);
        }
        return null;
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(new XMLDocument());
        return this.unmarshalHandler;
    }

    public void setValidating(boolean bl) throws JAXBException {
        this.validation = bl;
        if (!this.validation) {
            return;
        }
        String string = ":";
        String string2 = null;
        Exception exception = null;
        URL uRL = (URL)this.properties.get("schema-location");
        EntityResolver entityResolver = (EntityResolver)this.properties.get("ORAJAXB_SCHEMA_ENTITY_RESOLVER");
        if (uRL != null) {
            try {
                InputSource inputSource = null;
                XSDBuilder xSDBuilder = new XSDBuilder();
                if (entityResolver != null) {
                    xSDBuilder.setEntityResolver(entityResolver);
                    inputSource = entityResolver.resolveEntity(null, uRL.toString());
                }
                this.schema = inputSource != null ? xSDBuilder.build(inputSource) : xSDBuilder.build(uRL);
                return;
            }
            catch (Exception exception2) {
                throw new JAXBException("Error in building the schema from the specified schema location", (Throwable)exception2);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.contextPath, string);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().concat(".ObjectFactory");
            try {
                Class<?> clazz = Class.forName(string2, true, this.loader);
                Object obj = clazz.newInstance();
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod("getSchemaLocation", classArray);
                Object[] objectArray = new Object[]{};
                uRL = (URL)method.invoke(obj, objectArray);
                InputSource inputSource = null;
                XSDBuilder xSDBuilder = new XSDBuilder();
                if (entityResolver != null) {
                    xSDBuilder.setEntityResolver(entityResolver);
                    inputSource = entityResolver.resolveEntity(null, uRL.toString());
                }
                if (inputSource != null) {
                    this.schema = xSDBuilder.build(inputSource);
                    continue;
                }
                this.schema = xSDBuilder.build(uRL);
            }
            catch (Exception exception3) {
                if (exception != null) continue;
                exception = exception3;
            }
        }
        if (exception != null) {
            throw new JAXBException("Error in Calling ObjectFactory", exception);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.validation;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = validationEventHandler;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        if (this.validationEventHandler == null) {
            return new DefaultValidationEventHandler();
        }
        return this.validationEventHandler;
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals(ORAJAXB_PRESERVE_WS)) {
            String string2 = (String)object;
            if (!string2.equals("true") && !string2.equals("false")) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            if (string2.equals("false")) {
                this.parser.setPreserveWhitespace(false);
            }
            this.properties.put(ORAJAXB_PRESERVE_WS, object);
        } else if (string.equals("ORAJAXB_SCHEMA_ENTITY_RESOLVER")) {
            if (!(object instanceof EntityResolver)) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            this.parser.setEntityResolver((EntityResolver)object);
            this.properties.put("ORAJAXB_SCHEMA_ENTITY_RESOLVER", object);
            this.validator.setProperty("ORAJAXB_SCHEMA_ENTITY_RESOLVER", object);
        } else if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing") && object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.parser.setSecureProcessing();
            }
        } else if (string.equals(ORAJAXB_SCHEMA_LOCATION) || string.equals("schema-location")) {
            URL uRL = null;
            try {
                uRL = new File((String)object).toURL();
            }
            catch (Exception exception) {
                throw new PropertyException(this.err.getMessage0(32101));
            }
            this.properties.put(ORAJAXB_SCHEMA_LOCATION, uRL);
            this.validator.setProperty(ORAJAXB_SCHEMA_LOCATION, object);
            this.parser.setXMLSchema((Object)uRL);
        } else {
            throw new PropertyException(this.err.getMessage0(32101));
        }
    }

    public Object getProperty(String string) throws PropertyException {
        if (this.properties.get(string) == null) {
            throw new PropertyException(this.err.getMessage0(32101));
        }
        return this.properties.get(string);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        throw new UnsupportedOperationException();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        throw new UnsupportedOperationException();
    }

    public void setListener(Unmarshaller.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public Unmarshaller.Listener getListener() {
        throw new UnsupportedOperationException();
    }
}

