/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.jaxb.JaxbUnmarshallerHandler;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JaxbMarshaller
implements Marshaller {
    String contextPath;
    ClassLoader loader;
    ValidationEventHandler validationEventHandler;
    UnmarshallerHandler unmarshalHandler;
    HashMap properties;
    XMLError err;

    JaxbMarshaller(String string, ClassLoader classLoader) {
        this.contextPath = string;
        this.loader = classLoader;
        this.validationEventHandler = new DefaultValidationEventHandler();
        this.err = new XMLError();
        this.properties = new HashMap(5);
        this.properties.put("jaxb.encoding", "UTF-8");
        this.properties.put("jaxb.formatted.output", new Boolean(false));
    }

    void setUnmarshalHandler(UnmarshallerHandler unmarshallerHandler) {
        this.unmarshalHandler = unmarshallerHandler;
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (result instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            Writer writer = ((StreamResult)result).getWriter();
            String string = result.getSystemId();
            Object var6_14 = null;
            if (outputStream == null && writer == null) {
                if (string == null) {
                    throw new JAXBException(this.err.getMessage0(32103));
                }
                try {
                    outputStream = new FileOutputStream(string);
                }
                catch (IOException iOException) {
                    JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
                    jAXBException.initCause((Throwable)iOException);
                    throw jAXBException;
                }
            }
            if (outputStream != null) {
                this.marshal(object, outputStream);
            } else {
                this.marshal(object, writer);
            }
        } else if (result instanceof DOMResult) {
            XMLNode xMLNode = (XMLNode)((DOMResult)result).getNode();
            XMLDocument xMLDocument = !(xMLNode instanceof XMLDocument) ? (XMLDocument)xMLNode.getOwnerDocument() : (XMLDocument)xMLNode;
            XMLNode xMLNode2 = (XMLNode)this.getNode(object);
            xMLDocument.appendChild((Node)((XMLNode)xMLDocument.adoptNode((Node)xMLNode2)));
            ((DOMResult)result).setNode((Node)xMLDocument);
        } else if (result instanceof JAXBResult) {
            try {
                JAXBResult jAXBResult = (JAXBResult)result;
                XMLDocument xMLDocument = ((JaxbNode)object).getOwnerDocument();
                ((JaxbUnmarshallerHandler)this.unmarshalHandler).setNodeFactory(xMLDocument);
                ((XMLNode)this.getNode(object)).reportSAXEvents((ContentHandler)this.unmarshalHandler);
                this.marshal(object, (ContentHandler)this.unmarshalHandler);
            }
            catch (Exception exception) {
                JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
                jAXBException.initCause((Throwable)exception);
                throw jAXBException;
            }
        } else if (result instanceof SAXResult) {
            ContentHandler contentHandler = ((SAXResult)result).getHandler();
            this.marshal(object, contentHandler);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        try {
            ((JaxbNode)object).marshal(outputStream, this.properties, this.err);
        }
        catch (Exception exception) {
            JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
            jAXBException.initCause((Throwable)exception);
            throw jAXBException;
        }
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        try {
            ((JaxbNode)object).marshal(writer, this.properties, this.err);
        }
        catch (Exception exception) {
            JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
            jAXBException.initCause((Throwable)exception);
            throw jAXBException;
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        try {
            contentHandler.startDocument();
            ((JaxbNode)object).marshal(contentHandler, this.properties, this.err);
            contentHandler.endDocument();
        }
        catch (Exception exception) {
            JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
            jAXBException.initCause((Throwable)exception);
            throw jAXBException;
        }
    }

    public void marshal(Object object, Node node) throws JAXBException {
        try {
            ((JaxbNode)object).marshal(node, this.properties, this.err);
        }
        catch (Exception exception) {
            JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
            jAXBException.initCause((Throwable)exception);
            throw jAXBException;
        }
    }

    public Node getNode(Object object) throws JAXBException {
        try {
            return ((JaxbNode)object).getDOMNode();
        }
        catch (Exception exception) {
            JAXBException jAXBException = new JAXBException(this.err.getMessage0(32103));
            jAXBException.initCause((Throwable)exception);
            throw jAXBException;
        }
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (!(string.equals("jaxb.encoding") || string.equals("jaxb.formatted.output") || string.equals("jaxb.noNamespaceSchemaLocation") || string.equals("jaxb.schemaLocation"))) {
            throw new PropertyException(this.err.getMessage0(32101));
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (this.properties.get(string) == null) {
            throw new PropertyException(this.err.getMessage0(32101));
        }
        return this.properties.get(string);
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = validationEventHandler;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void marshal(Object object, XMLStreamWriter xMLStreamWriter) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object object, XMLEventWriter xMLEventWriter) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        throw new UnsupportedOperationException();
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        throw new UnsupportedOperationException();
    }

    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    public void setListener(Marshaller.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public Marshaller.Listener getListener() {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object object, File file) throws JAXBException {
        throw new UnsupportedOperationException();
    }
}

