/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.HttpGetThread;
import oracle.sdovis.util.HttpPostThread;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsUtil;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsFeatureType {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String name = null;
    private String nsAlias = null;
    private String nsAliasURL = null;
    private String xmlns = "http://www.opengis.net/wfs";
    private String title = null;
    private String abstractText = null;
    private String keywords = null;
    private String srs = null;
    private ArrayList operations = new ArrayList();
    private double[] latlongBoundingBox = null;
    private String metadataURL = null;
    private String metadataType = null;
    private String metadataFormat = null;
    private ArrayList<String> outputFormats = new ArrayList();
    private ArrayList<String> otherSRS = new ArrayList();
    private Hashtable attributeTypes = null;
    private Hashtable attributeNullable = null;

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getNameSpaceAlias() {
        return this.nsAlias;
    }

    public void setNameSpaceAlias(String ns) {
        this.nsAlias = ns;
    }

    public String getNameSpaceAliasURL() {
        return this.nsAliasURL;
    }

    public void setNameSpaceAliasURL(String ns) {
        this.nsAliasURL = ns;
    }

    public String getXMLNameSpace() {
        return this.xmlns;
    }

    public void setXMLNameSpace(String nsxml) {
        this.xmlns = nsxml;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tl) {
        this.title = tl;
    }

    public String getAbstract() {
        return this.abstractText;
    }

    public void setAbstract(String abst) {
        this.abstractText = abst;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keyString) {
        this.keywords = keyString;
    }

    public String getSRS() {
        return this.srs;
    }

    public void setSRS(String srsname) {
        this.srs = srsname;
    }

    public ArrayList getOperations() {
        return this.operations;
    }

    public void addOperation(String oper) {
        if (oper == null) {
            return;
        }
        this.operations.add(oper);
    }

    public void removeOperation(String oper) {
        if (oper == null) {
            return;
        }
        this.operations.remove(oper);
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public double[] getLatLongBoundingBox() {
        return this.latlongBoundingBox;
    }

    public void setLatLongBoundingBox(double[] mbr) {
        this.latlongBoundingBox = mbr;
    }

    public String getMetadataURL() {
        return this.metadataURL;
    }

    public void setMetadataURL(String url) {
        this.metadataURL = url;
    }

    public String getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(String type) {
        this.metadataType = type;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String format) {
        this.metadataFormat = format;
    }

    public Hashtable getAttributeTypes() {
        return this.attributeTypes;
    }

    public void setAttributeTypes(Hashtable types) {
        this.attributeTypes = types;
    }

    public Hashtable getAttributeNullable() {
        return this.attributeNullable;
    }

    public void setAttributeNullable(Hashtable nullable) {
        this.attributeNullable = nullable;
    }

    public String[] getAttributeNames() {
        if (this.attributeTypes == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = this.attributeTypes.keys();
        while (e.hasMoreElements()) {
            names.add((String)e.nextElement());
        }
        if (names.size() == 0) {
            return null;
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public String[] getGeometryAttributes() {
        if (this.attributeTypes == null) {
            return null;
        }
        String[] attrs = this.getAttributeNames();
        if (attrs == null || attrs.length == 0) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < attrs.length; ++i) {
            String type = (String)this.attributeTypes.get(attrs[i]);
            if (type == null || !this.isOGCgeometryType(type)) continue;
            names.add(attrs[i]);
        }
        if (names.size() == 0) {
            return null;
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    private boolean isOGCgeometryType(String type) {
        if (type == null) {
            return false;
        }
        return type.toUpperCase().indexOf("AbstractGeometryType".toUpperCase()) > -1 || type.toUpperCase().indexOf("BoxType".toUpperCase()) > -1 || type.toUpperCase().indexOf("CoordType".toUpperCase()) > -1 || type.toUpperCase().indexOf("CoordinatesType".toUpperCase()) > -1 || type.toUpperCase().indexOf("GeometryAssociationType".toUpperCase()) > -1 || type.toUpperCase().indexOf("GeometryCollectionType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LinearRingType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("LineStringType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiGeometryPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiLineStringPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiLineStringType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPointPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPointType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPolygonPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiPolygonType".toUpperCase()) > -1 || type.toUpperCase().indexOf("MultiSurfacePropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PointType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonPropertyType".toUpperCase()) > -1 || type.toUpperCase().indexOf("PolygonType".toUpperCase()) > -1 || type.toUpperCase().indexOf("SurfaceMemberType".toUpperCase()) > -1 || type.toUpperCase().indexOf("SurfacePropertyType".toUpperCase()) > -1;
    }

    public Hashtable readAttributesWithTypesUsingHttpGet(String url, long timeout, String wfsVersion) {
        String result;
        block13: {
            if (url == null || url.trim().length() == 0 || this.name == null) {
                return null;
            }
            String version = "1.0.0";
            if (wfsVersion != null) {
                version = wfsVersion;
            }
            String fullname = "";
            if (this.nsAlias != null) {
                fullname = fullname + this.nsAlias + ":";
            }
            fullname = fullname + this.name;
            String getreq = url.trim();
            if (getreq.lastIndexOf(63) > -1) {
                if (!getreq.endsWith("?") && !getreq.endsWith("&")) {
                    getreq = getreq + "&";
                }
            } else if (!getreq.endsWith("&")) {
                getreq = getreq + "?";
            }
            getreq = getreq + "VERSION=" + version + "&SERVICE=WFS&REQUEST=DescribeFeatureType&TYPENAME=" + fullname;
            log.info("Request: " + getreq);
            result = "";
            try {
                if (timeout <= 0L) {
                    result = Util.issueHttpGetRequest(getreq);
                    break block13;
                }
                HttpGetThread getThread = new HttpGetThread(getreq);
                getThread.start();
                getThread.checkTimeout(timeout);
                if (getThread.isCompleted()) {
                    result = getThread.getResponse();
                    break block13;
                }
                Exception ex = getThread.getException();
                if (ex == null) {
                    log.warning("Request timeout.");
                } else {
                    log.warning(ex.getMessage());
                }
                getThread = null;
                return null;
            }
            catch (Exception e) {
                log.info(e.getMessage());
                return null;
            }
        }
        this.attributeTypes = this.processAttributeTypesRequest(result);
        return this.attributeTypes;
    }

    public Hashtable readAttributesWithTypesUsingHttpPost(String url, long timeout, String wfsVersion) {
        String result;
        block10: {
            if (url == null || url.trim().length() == 0 || this.name == null) {
                return null;
            }
            String version = "1.0.0";
            if (wfsVersion != null) {
                version = wfsVersion;
            }
            String postreq = url.trim();
            String fullname = "";
            if (this.nsAlias != null) {
                fullname = fullname + this.nsAlias + ":";
            }
            fullname = fullname + this.name;
            String xmlns_str = "";
            if (this.nsAlias != null && this.nsAliasURL != null) {
                xmlns_str = "   xmlns:" + this.nsAlias + "=\"" + this.nsAliasURL + "\"\n";
            }
            String xml = "<?xml version=\"1.0\" ?>\n<wfs:DescribeFeatureType\n   service=\"WFS\"\n   version=\"" + version + "\"\n" + "   xmlns:wfs=\"" + this.xmlns + "\"\n" + xmlns_str + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xmlns:xd=\"http://www.w3.org/2001/XMLSchema\"\n";
            xml = version.equals("1.1.0") ? xml + "   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.1.0/WFS.xsd\">\n" : xml + "   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.0.0/WFS-basic.xsd\">\n";
            xml = xml + "   <wfs:TypeName>" + fullname + "</wfs:TypeName>\n";
            xml = xml + "</wfs:DescribeFeatureType>\n";
            log.info("Request: " + xml);
            result = "";
            try {
                if (timeout <= 0L) {
                    HttpConnection hurl = new HttpConnection();
                    hurl.connect(postreq);
                    hurl.sendXMLRequest("", xml);
                    result = hurl.getXMLResponse();
                    break block10;
                }
                HttpPostThread postThread = new HttpPostThread(postreq, xml, null);
                postThread.start();
                postThread.checkTimeout(timeout);
                if (postThread.isCompleted()) {
                    result = postThread.getResponse();
                    break block10;
                }
                Exception ex = postThread.getException();
                if (ex == null) {
                    log.warning("Request timeout.");
                } else {
                    log.warning(ex.getMessage());
                }
                postThread = null;
                return null;
            }
            catch (Exception e) {
                log.info(e.getMessage());
                return null;
            }
        }
        this.attributeTypes = this.processAttributeTypesRequest(result);
        return this.attributeTypes;
    }

    private Hashtable processAttributeTypesRequest(String result) {
        if (result == null) {
            return null;
        }
        Hashtable<String, String> output = new Hashtable<String, String>();
        try {
            String type;
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(result)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            if (root == null) {
                log.info("No root node found while processing attribute types.");
                return null;
            }
            if (root.getNodeName().indexOf("schema") < 0) {
                NodeList nodes = doc.getChildNodes();
                if (nodes == null || nodes.getLength() < 1) {
                    log.info("Unable to find schema node.");
                    return null;
                }
                boolean found = false;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node nd = nodes.item(i);
                    if (nd.getNodeName().indexOf("schema") <= -1) continue;
                    root = nd;
                    found = true;
                    break;
                }
                if (!found) {
                    log.info("Unable to find schema node.");
                    return null;
                }
            }
            String alias = "";
            String rootName = root.getNodeName();
            int index = rootName.indexOf(":");
            if (index > -1) {
                alias = rootName.substring(0, index) + ":";
            } else {
                ArrayList childs = XMLDOMParser.getRealChildNodes(root);
                if (childs != null) {
                    for (int i = 0; i < childs.size(); ++i) {
                        Node child = (Node)childs.get(i);
                        int idx = child.getNodeName().indexOf(":element");
                        if (idx <= -1) continue;
                        alias = child.getNodeName().substring(0, idx + 1);
                        break;
                    }
                }
            }
            Vector nodes = WfsUtil.getChildNodes(root, alias + "element");
            String featType = null;
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    Node child = (Node)nodes.get(i);
                    String name = XMLDOMParser.getAttribute(child, "name");
                    if (name == null || !name.trim().equalsIgnoreCase(name)) continue;
                    type = XMLDOMParser.getAttribute(child, "type");
                    if (type == null) continue;
                    featType = Util.normalize(type.trim());
                    break;
                }
            }
            if (featType == null) {
                log.info("Unable to find feature type attribute.");
                return null;
            }
            nodes = WfsUtil.getChildNodes(root, alias + "complexType");
            Node featTypeNode = null;
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    Node child = (Node)nodes.get(i);
                    type = XMLDOMParser.getAttribute(child, "name");
                    if (type == null || !type.trim().equalsIgnoreCase(featType)) continue;
                    featTypeNode = child;
                    break;
                }
            }
            if (featTypeNode == null) {
                log.info("Unable to find feature node.");
                return null;
            }
            nodes = WfsUtil.getChildNodes(featTypeNode, alias + "complexContent");
            if (nodes == null) {
                return null;
            }
            Node cxcontent = (Node)nodes.get(0);
            if ((nodes = WfsUtil.getChildNodes(cxcontent, alias + "extension")) == null) {
                log.info("Unable to find extension node.");
                return null;
            }
            Node extension = (Node)nodes.get(0);
            if ((nodes = WfsUtil.getChildNodes(extension, alias + "sequence")) == null) {
                log.info("Unable to find sequence node.");
                return null;
            }
            Node sequence = (Node)nodes.get(0);
            if ((nodes = WfsUtil.getChildNodes(sequence, alias + "element")) == null) {
                log.info("Unable to find element nodes.");
                return null;
            }
            for (int i = 0; i < nodes.size(); ++i) {
                Node child = (Node)nodes.get(i);
                String ref = XMLDOMParser.getAttribute(child, "ref");
                if (ref != null) {
                    if (ref.indexOf("gml:") == -1) {
                        output.put(Util.normalize(ref), ref);
                        continue;
                    }
                    output.put(ref, ref);
                    continue;
                }
                String name = XMLDOMParser.getAttribute(child, "name");
                if (name == null) continue;
                String type2 = XMLDOMParser.getAttribute(child, "type");
                if (type2 != null) {
                    String attrType = Util.normalize(type2.trim());
                    output.put(name.trim(), attrType);
                } else {
                    Vector cnodes = WfsUtil.getChildNodes(child, alias + "simpleType");
                    if (cnodes != null) {
                        Node sptypeNode = (Node)cnodes.get(0);
                        if ((cnodes = WfsUtil.getChildNodes(sptypeNode, alias + "restriction")) != null) {
                            Node rttypeNode = (Node)cnodes.get(0);
                            type2 = XMLDOMParser.getAttribute(rttypeNode, "base");
                            if (type2 != null) {
                                String attrType = Util.normalize(type2.trim());
                                output.put(name.trim(), attrType);
                            }
                        }
                    } else {
                        Node chNode;
                        NodeList elemsref;
                        Node cplxnode;
                        Vector choiceNodes;
                        cnodes = WfsUtil.getChildNodes(child, alias + "complexType");
                        if (cnodes != null && (choiceNodes = WfsUtil.getChildNodes(cplxnode = (Node)cnodes.get(0), alias + "choice")) != null && (elemsref = (chNode = (Node)choiceNodes.get(0)).getChildNodes()) != null) {
                            String finalType = null;
                            for (int k = 0; k < elemsref.getLength(); ++k) {
                                Node elemnd = elemsref.item(k);
                                if (!Util.normalize(elemnd.getNodeName()).equalsIgnoreCase("element")) continue;
                                String refType = XMLDOMParser.getAttribute(elemnd, "ref");
                                if (refType == null || refType.trim().length() <= 0) continue;
                                if (finalType == null) {
                                    if (refType.indexOf("gml:") == -1) {
                                        finalType = Util.normalize(refType.trim());
                                        continue;
                                    }
                                    finalType = refType.trim();
                                    continue;
                                }
                                finalType = refType.indexOf("gml:") == -1 ? finalType + "," + Util.normalize(refType.trim()) : finalType + "," + refType.trim();
                            }
                            if (finalType != null) {
                                output.put(name.trim(), finalType);
                            }
                        }
                    }
                }
                String nillable = XMLDOMParser.getAttribute(child, "nillable");
                if (nillable == null) continue;
                if (this.attributeNullable == null) {
                    this.attributeNullable = new Hashtable();
                }
                this.attributeNullable.put(name.trim(), nillable);
            }
        }
        catch (Exception e) {
            log.info("Exception in processAttributeTypesRequest: " + e.getMessage());
            return null;
        }
        return output;
    }

    public String[] getOutputFormats() {
        if (this.outputFormats.size() == 0) {
            return null;
        }
        return this.outputFormats.toArray(new String[this.outputFormats.size()]);
    }

    public void addOutputFormat(String format) {
        if (format != null && !this.outputFormats.contains(format)) {
            this.outputFormats.add(format);
        }
    }

    public void removeOutptutFormat(String format) {
        int indexToRemove = -1;
        if (format != null && this.outputFormats.size() > 0) {
            for (int i = 0; i < this.outputFormats.size(); ++i) {
                if (!this.outputFormats.get(i).equals(format)) continue;
                indexToRemove = i;
                break;
            }
        }
        if (indexToRemove > -1) {
            this.outputFormats.remove(indexToRemove);
        }
    }

    public String[] getOtherSRS() {
        if (this.otherSRS.size() == 0) {
            return null;
        }
        return this.otherSRS.toArray(new String[this.otherSRS.size()]);
    }

    public void addOtherSRS(String srs) {
        if (srs != null && !this.otherSRS.contains(srs)) {
            this.otherSRS.add(srs);
        }
    }

    public void removeOtherSRS(String srs) {
        if (srs != null && this.otherSRS.contains(srs)) {
            this.otherSRS.remove(srs);
        }
    }
}

