/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML2;

public class MetaDataUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static int getMDType(String type) {
        if (type == null || type.length() == 0) {
            return 0;
        }
        if ((type = type.trim()).equalsIgnoreCase("style")) {
            return 1;
        }
        if (type.equalsIgnoreCase("theme")) {
            return 2;
        }
        if (type.equalsIgnoreCase("basemap")) {
            return 3;
        }
        if (type.equalsIgnoreCase("tile-layer")) {
            return 4;
        }
        if (type.equalsIgnoreCase("tile-task")) {
            return 5;
        }
        if (type.equalsIgnoreCase("edit-session")) {
            return 6;
        }
        return 0;
    }

    public static String getMDTypeName(int type) {
        switch (type) {
            case 1: {
                return "style";
            }
            case 2: {
                return "theme";
            }
            case 3: {
                return "basemap";
            }
            case 4: {
                return "tile-layer";
            }
            case 5: {
                return "tile-task";
            }
            case 6: {
                return "edit-session";
            }
        }
        return "unknown";
    }

    public static String toXML(HashMap map, int type) {
        String tname = MetaDataUtil.getMDTypeName(type);
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<mapviewer-meta-data type=\"" + tname + "\">\n");
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            sb.append("  <col name=\"" + name + "\">\n");
            Object value = e.getValue();
            if (value == null) {
                sb.append("  </col>\n");
                continue;
            }
            if (name.equalsIgnoreCase("name") || name.equalsIgnoreCase("description") || name.equalsIgnoreCase("type")) {
                sb.append((String)value);
            } else if (name.equalsIgnoreCase("definition") || name.equalsIgnoreCase("styling_rules")) {
                sb.append("<![CDATA[\n");
                sb.append((String)value + "\n");
                sb.append("\n]]>\n");
            } else if (name.equalsIgnoreCase("image") || name.equalsIgnoreCase("map_adapter")) {
                byte[] bd = (byte[])value;
                if (bd != null && bd.length > 0) {
                    String base64 = Util.base64Encode(bd);
                    sb.append(base64);
                }
            } else if (name.equalsIgnoreCase("geometry") || name.equalsIgnoreCase("area") || name.equalsIgnoreCase("bound")) {
                JGeometry geom = (JGeometry)value;
                String gml = "";
                try {
                    gml = GML2.to_GMLGeometry((JGeometry)geom);
                    sb.append("<![CDATA[\n");
                    sb.append(gml);
                    sb.append("\n]]>\n");
                }
                catch (Exception e1) {
                    log.warning("Error while converting geometry to GML." + e1.getMessage());
                }
            } else {
                sb.append(value);
            }
            sb.append("  </col>\n");
        }
        sb.append("</mapviewer-meta-data>\n");
        return sb.toString();
    }
}

