/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.DirectionalLight;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PerspectiveCamera;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class ShadedReliefThemeDefinition
extends ThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private GeoRasterThemeDefinition grdef;
    private int dispW;
    private int dispH;
    private int bounces;
    private int weight;
    private String rtParams;
    private Camera cam;
    private Group gr;
    private Vector3d camDirection;
    private Vector3d camUp;
    private Vector3d bkgColor;
    private Vector3d bkgAmbientLight;
    private LightSource[] lights;
    private Material[] materials;

    public ShadedReliefThemeDefinition(String name, GeoRasterThemeDefinition grt, Vector3d camLocation, double camAngle, int bounces_, int weight_) {
        this.name = name;
        this.grdef = grt;
        this.bounces = bounces_;
        this.weight = weight_;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(camLocation, this.camDirection, this.camUp, camAngle);
        this.materials = null;
        this.gr = null;
    }

    public ShadedReliefThemeDefinition(String name, GeoRasterThemeDefinition grt, Vector3d camLocation, double camAngle, int dispW_, int dispH_, int bounces_, int weight_) {
        this.name = name;
        this.grdef = grt;
        this.dispW = dispW_;
        this.dispH = dispH_;
        this.bounces = bounces_;
        this.weight = weight_;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(camLocation, this.camDirection, this.camUp, camAngle);
        this.materials = null;
        this.gr = null;
    }

    public ShadedReliefThemeDefinition(String name, String dataSource, String geoRasterTable, String geoRasterColumn, String rasterID, String rasterTable, String rasterPyramid, String query, Vector3d camLocation, double camAngle, int dispW_, int dispH_, int bounces_, int weight_) {
        this.name = name;
        this.grdef = new GeoRasterThemeDefinition(name, dataSource, geoRasterTable, geoRasterColumn, rasterID, rasterTable, rasterPyramid, query);
        this.dispW = dispW_;
        this.dispH = dispH_;
        this.bounces = bounces_;
        this.weight = weight_;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(camLocation, this.camDirection, this.camUp, camAngle);
        this.materials = null;
        this.gr = null;
    }

    public void setStandardRTParams() {
        this.camDirection = new Vector3d(0.0, -1.0, 0.0);
        this.camUp = new Vector3d(0.0, 0.0, 1.0);
        this.bkgColor = new Vector3d(0.5, 0.5, 0.5);
        this.bkgAmbientLight = new Vector3d(0.3, 0.3, 0.3);
        this.lights = new LightSource[1];
        Vector3d lDir = new Vector3d(0.0, -1.0, -1.0);
        Vector3d lCol = new Vector3d(0.3, 0.3, 0.3);
        this.lights[0] = new DirectionalLight(lDir, lCol);
    }

    public int getWeight() {
        return this.weight;
    }

    public int getBounces() {
        return this.bounces;
    }

    public int getDispW() {
        return this.dispW;
    }

    public int getDispH() {
        return this.dispH;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Group getGroup() {
        return this.gr;
    }

    public Vector3d getBackgroundColor() {
        return this.bkgColor;
    }

    @Override
    public String getThemeType() {
        return "SHADED_RELIEF";
    }

    public Vector3d getAmbientLight() {
        return this.bkgAmbientLight;
    }

    public LightSource[] getLights() {
        return this.lights;
    }

    public LightSource getLight(int idx) {
        return this.lights[idx];
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public Material getMaterial(int idx) {
        return this.materials[idx];
    }

    public ThemeDefinition getGeorDef() {
        return this.grdef;
    }

    @Override
    public String getXMLDefinition() {
        return "";
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.grdef.getBaseTable());
        ti.setType("SHADED_RELIEF");
        ti.setKeyColumn(this.grdef.mKeyColumn);
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.grdef.getGeoRasterColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }

    @Override
    public Field[] getDistinctAttrColumns() {
        return null;
    }
}

