/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.LRSThemeQueryHelper;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.GeomMetaTable;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.util.RTree;

public class LRSThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected StylingRule[] styleRules = null;
    protected String baseTable;
    protected String spatialColumn;
    protected String joinTable = null;
    protected String startMeasure = null;
    protected String endMeasure = null;
    protected String measure = null;
    protected String lrsTableLink = null;
    protected String joinTableLink = null;
    private String query = null;
    private String dbType = "ORACLE";
    private int[] bindingVaraiblesNumArray = null;
    private int totalBindingVariablesNum = 0;
    protected transient LRSThemeQueryHelper queryHelper = null;
    protected String keyColumn = "";
    protected double mXMin;
    protected double mYMin;
    protected double mXMax;
    protected double mYMax;
    protected Hashtable sridCache = new Hashtable(5);
    protected boolean no_Unpickler = false;
    protected boolean reorient_Lines = true;
    protected RTree styTree = null;
    protected Rectangle2D treeMBR = null;
    protected Vector styFeats = new Vector(100, 100);
    protected boolean mPassThrough = false;
    protected String table_Alias = null;
    protected String baseColumnType = null;
    boolean isHeatMapTheme = false;
    private String rtreeIndexName;
    private Rectangle2D baseTableMBR;
    private Rectangle2D baseTableLatLonMBR;
    private boolean basetableGeodetic;
    private boolean spatialIndexHintEnabled = true;
    private int numKeyColumns = 1;
    static String idxNameQuery = "select index_name from user_sdo_index_info where table_name=:1 and column_name=:2";
    static String idxMBRQuery = "select sdo_index_geodetic, sdo_root_mbr from user_sdo_index_metadata where sdo_index_name=:1";

    public LRSThemeDefinition(String name, String dataSrc, String baseTable, String spatialColumn, String keyColumn, String joinTable, String startMeasure, String endMeasure, String lrsTableLink, String joinTableLink, int srid, StylingRule[] styleRules) {
        this.name = name;
        this.dataSource = dataSrc;
        this.baseTable = baseTable;
        this.spatialColumn = spatialColumn;
        this.joinTable = joinTable;
        this.startMeasure = startMeasure;
        this.endMeasure = endMeasure;
        this.lrsTableLink = lrsTableLink;
        this.joinTableLink = joinTableLink;
        this.keyColumn = keyColumn;
        this.styleRules = styleRules;
        this.srid = srid;
        if (ThemeUtils.isCompositeKey(keyColumn)) {
            this.numKeyColumns = ThemeUtils.getCompositeKeyCount(keyColumn);
        }
        this.is9i = ((AbstractDBDataSource)DSManager.get(dataSrc)).is9i();
        this.mPassThrough = true;
        this.baseColumnType = Util.getColumnTypeName(dataSrc, baseTable, spatialColumn);
    }

    public LRSThemeDefinition() {
    }

    private String constructQuery() {
        String cond;
        int i;
        ArrayList<String> keyAttrs = new ArrayList<String>(2);
        ArrayList<String> labelAttrs = new ArrayList<String>(2);
        ArrayList<String> attrs = new ArrayList<String>(8);
        String[] labels = this.getLabelColumns();
        if (labels != null) {
            for (i = 0; i < labels.length; ++i) {
                String upAttr = labels[i].toUpperCase();
                labelAttrs.add(upAttr);
            }
        }
        if (this.styleRules != null) {
            for (i = 0; i < this.styleRules.length; ++i) {
                RenderingRule[] rrules;
                String[] attrColumns = this.styleRules[i].getAttributeColumnsAsArray();
                if (attrColumns != null) {
                    for (int k = 0; k < attrColumns.length; ++k) {
                        String upAttr = attrColumns[k].toUpperCase();
                        if (attrs.contains(upAttr)) continue;
                        attrs.add(upAttr);
                    }
                }
                if ((rrules = this.styleRules[i].getRenderingRules()) == null) continue;
                for (int k = 0; k < rrules.length; ++k) {
                    String[] styleColumns = rrules[k].getStyleColumns();
                    if (styleColumns != null) {
                        for (int l = 0; l < styleColumns.length; ++l) {
                            String styColumn = styleColumns[l].toUpperCase();
                            if (attrs.contains(styColumn)) continue;
                            attrs.add(styColumn);
                        }
                    }
                    String substyle = rrules[k].getSubStyleName();
                    String[] subColumns = rrules[k].getSubStyleColumns();
                    if (subColumns == null) continue;
                    for (int l = 0; l < subColumns.length; ++l) {
                        String styColumn = subColumns[l].toUpperCase();
                        if (attrs.contains(styColumn)) continue;
                        attrs.add(styColumn);
                    }
                }
            }
        }
        if (this.keyColumn != null && ThemeUtils.isCompositeKey(this.keyColumn)) {
            log.severe("composite primary key is not supported.");
            return null;
        }
        if (this.keyColumn != null && !this.keyColumn.equalsIgnoreCase("ROWID")) {
            keyAttrs.add(this.keyColumn.toUpperCase());
        }
        if (this.getIdentifiableColumns() != null) {
            Field[] infoCols = this.getIdentifiableColumns();
            for (int k = 0; k < infoCols.length; ++k) {
                String colName;
                int idx = attrs.indexOf(infoCols[k].getName());
                if (idx >= 0 || attrs.contains(colName = infoCols[k].getName().toUpperCase())) continue;
                attrs.add(colName);
            }
        }
        String orderByClause = "";
        if (this.styleRules[0].getOrderByColumns() != null) {
            if (this.styleRules.length > 1 && !attrs.contains(this.styleRules[0].getOrderByColumns())) {
                attrs.add(this.styleRules[0].getOrderByColumns());
            }
            orderByClause = " ORDER BY " + this.styleRules[0].getOrderByColumns() + " ";
            if (this.styleRules[0].getSortOrder() != null) {
                orderByClause = orderByClause + this.styleRules[0].getSortOrder() + " ";
            }
        }
        String labelColumns = "";
        for (int i2 = 0; i2 < labelAttrs.size(); ++i2) {
            labelColumns = labelColumns + labelAttrs.get(i2) + ", ";
        }
        String attrKeyCol = "";
        for (int i3 = 0; i3 < keyAttrs.size(); ++i3) {
            attrKeyCol = attrKeyCol + keyAttrs.get(i3) + ", ";
        }
        String attrColumns = "";
        for (int i4 = 0; i4 < attrs.size(); ++i4) {
            attrColumns = attrColumns + attrs.get(i4) + ", ";
        }
        this.bindingVaraiblesNumArray = new int[this.styleRules.length];
        this.totalBindingVariablesNum = 0;
        this.bindingVaraiblesNumArray[0] = 0;
        StylingRule rule = this.styleRules[0];
        String baseQuery = "";
        if (this.dbType.equalsIgnoreCase("ORACLE")) {
            baseQuery = "SELECT " + attrKeyCol + " " + labelColumns + " " + attrColumns + " " + "SDO_LRS.CLIP_GEOM_SEGMENT(" + this.spatialColumn + ", " + this.startMeasure + ", " + this.endMeasure + ") " + this.spatialColumn + " " + "FROM " + this.baseTable + ", " + this.joinTable + " " + "WHERE " + this.lrsTableLink + "=" + this.joinTableLink;
        }
        if ((cond = this.styleRules[0].getFeatureCond()) != null) {
            baseQuery = baseQuery + " AND " + cond;
            this.bindingVaraiblesNumArray[0] = SharedUtils.countBindingVariables(cond);
            this.totalBindingVariablesNum += this.bindingVaraiblesNumArray[0];
        }
        this.query = baseQuery = baseQuery + orderByClause;
        log.finest("Theme base-query [" + this.name + "]: " + baseQuery);
        return this.query;
    }

    public String getQueryString() {
        return this.constructQuery();
    }

    public boolean isQueryPassThrough() {
        return this.mPassThrough;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String tb) {
        this.baseTable = tb;
    }

    public String getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(String tb) {
        this.joinTable = tb;
    }

    public String getStartMeasure() {
        return this.startMeasure;
    }

    public void setStarMeasure(String attr) {
        this.startMeasure = attr;
    }

    public String getEndMeasure() {
        return this.endMeasure;
    }

    public void setEndMeasure(String attr) {
        this.endMeasure = attr;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String attr) {
        this.measure = attr;
    }

    public String getLRSTableLink() {
        return this.lrsTableLink;
    }

    public void setLRSTableLink(String attr) {
        this.lrsTableLink = attr;
    }

    public String getJoinTableLink() {
        return this.joinTableLink;
    }

    public void setJoinTableLink(String attr) {
        this.joinTableLink = attr;
    }

    public String getGeomColumn() {
        return this.spatialColumn;
    }

    public void setGeomColumn(String geom) {
        this.spatialColumn = geom;
    }

    public void setKeyColumn(String key) {
        this.keyColumn = key;
    }

    @Override
    public String getKeyColumn() {
        return this.keyColumn;
    }

    public int getNumKeyColumns() {
        return this.numKeyColumns;
    }

    public void setStylingRules(StylingRule[] sr) {
        this.styleRules = sr;
    }

    public StylingRule[] getStylingRules() {
        return this.styleRules;
    }

    public boolean hasTextLabel() {
        if (this.styleRules == null) {
            return false;
        }
        for (int i = 0; i < this.styleRules.length; ++i) {
            StylingRule rule = this.styleRules[i];
            if (rule == null || rule.getLabelStyleName() == null) continue;
            String func = rule.getLabelFunction();
            double f = 0.0;
            try {
                f = Double.parseDouble(func);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!(f > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getThemeType() {
        return "LRS";
    }

    public String getCacheGroupName(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Hashtable getSRidCache() {
        return this.sridCache;
    }

    private void getSpatialMetaData() throws SQLException {
        GeomMetaTable gmt = new GeomMetaTable(this.dataSource);
        gmt.query(this.getBaseTable(), this.getGeomColumn());
        this.mXMin = gmt.getXMin();
        this.mYMin = gmt.getYMin();
        this.mXMax = gmt.getXMax();
        this.mYMax = gmt.getYMax();
        gmt.closeQuery();
        gmt = null;
    }

    public Rectangle2D getTreeMBR() {
        return this.treeMBR;
    }

    public RTree getTree() {
        return this.styTree;
    }

    public boolean buildRTree(List styfeatures) {
        this.styTree = null;
        this.treeMBR = null;
        int size = styfeatures.size();
        if (size == 0) {
            return false;
        }
        RTree _styTree = new RTree(2, 8, 2);
        double[][][] mbh = new double[size][][];
        Object[] o = new Object[size];
        for (int i = 0; i < size; ++i) {
            mbh[i] = new double[2][];
            mbh[i][0] = new double[2];
            mbh[i][1] = new double[2];
            StyledFeatureI sf = (StyledFeatureI)styfeatures.get(i);
            JSDOGeometry geom = sf.getGeometry();
            double[] geomMBR = geom.getMBR();
            int dim = geom.getDimensions();
            double minX = geomMBR[0];
            double minY = geomMBR[1];
            double maxX = 0.0;
            double maxY = 0.0;
            if (geomMBR.length == 4) {
                maxX = geomMBR[2];
                maxY = geomMBR[3];
            } else {
                maxX = geomMBR[dim];
                maxY = geomMBR[dim + 1];
            }
            mbh[i][0][0] = minX;
            mbh[i][0][1] = maxX;
            mbh[i][1][0] = minY;
            mbh[i][1][1] = maxY;
            if (this.treeMBR == null) {
                this.treeMBR = new Rectangle2D.Double(minX, minY, 0.0, 0.0);
            } else {
                this.treeMBR.add(minX, minY);
            }
            this.treeMBR.add(maxX, maxY);
            o[i] = sf;
            this.styFeats.add(sf);
        }
        long t0 = System.currentTimeMillis();
        try {
            _styTree.packTree((double[][][])mbh, o);
            this.styTree = _styTree;
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            this.styTree = null;
            _styTree = null;
            this.treeMBR = null;
            this.styFeats.clear();
            return false;
        }
        log.finer("STR pack tree elapsed time: " + (System.currentTimeMillis() - t0) + " mseconds for " + size + " geometries");
        return true;
    }

    public Vector searchStyledFeatures(Rectangle2D queryWin) {
        Vector<StyledFeatureI> stylefeats = new Vector<StyledFeatureI>(100, 100);
        if (this.styTree == null || this.treeMBR == null) {
            return stylefeats;
        }
        double xl = queryWin.getMinX();
        double yl = queryWin.getMinY();
        double xh = queryWin.getMaxX();
        double yh = queryWin.getMaxY();
        boolean getAll = false;
        if (MapMaker.isSpecial(xl, yl, xh, yh) || queryWin.contains(this.treeMBR)) {
            getAll = true;
        } else if (this.treeMBR.getWidth() == 0.0 && this.treeMBR.getHeight() == 0.0 && queryWin.contains(new Point2D.Double(this.treeMBR.getCenterX(), this.treeMBR.getCenterY()))) {
            getAll = true;
        }
        if (getAll) {
            for (int i = 0; i < this.styFeats.size(); ++i) {
                StyledFeatureI sf = (StyledFeatureI)this.styFeats.get(i);
                sf.setShapeToNull();
                stylefeats.add(sf);
            }
            return stylefeats;
        }
        if (this.treeMBR.intersects(queryWin)) {
            boolean gotSome = false;
            double[][] searchMBR = new double[][]{new double[2], new double[2]};
            searchMBR[0][0] = queryWin.getMinX();
            searchMBR[0][1] = queryWin.getMaxX();
            searchMBR[1][0] = queryWin.getMinY();
            searchMBR[1][1] = queryWin.getMaxY();
            ArrayList a = new ArrayList(500);
            a.clear();
            long t0 = System.currentTimeMillis();
            gotSome = this.styTree.search((double[][])searchMBR, a);
            log.finer("Rtree search time: " + (System.currentTimeMillis() - t0) + " mseconds" + "   #Features returned: " + a.size());
            if (gotSome) {
                for (int i = 0; i < a.size(); ++i) {
                    StyledFeatureI sf = (StyledFeatureI)a.get(i);
                    sf.setShapeToNull();
                    stylefeats.add(sf);
                }
            }
        }
        return stylefeats;
    }

    @Override
    public String getXMLDefinition() {
        StringBuffer xmlDef = new StringBuffer(2048);
        xmlDef.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(xmlDef);
        xmlDef.append(">\n");
        this.getInfoFields(xmlDef);
        StylingRule[] rules = this.getStylingRules();
        if (rules != null) {
            for (int i = 0; i < rules.length; ++i) {
                StylingRule sr = rules[i];
                xmlDef.append("  <rule" + LRSThemeDefinition.getRuleAttributes(sr) + ">\n");
                xmlDef.append(LRSThemeDefinition.getRuleFeatures(sr));
                xmlDef.append(LRSThemeDefinition.getRuleLabel(sr));
                xmlDef.append("  </rule>\n");
            }
        }
        xmlDef.append("</styling_rules>");
        return xmlDef.toString();
    }

    public void setQueryHelper(LRSThemeQueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public LRSThemeQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    void getCommonAttributes(StringBuffer xmlAttr) {
        String key;
        String themeType = this.getThemeType();
        if (themeType != null && themeType.trim().length() > 0) {
            xmlAttr.append(" theme_type=\"" + themeType + "\"");
        }
        if ((key = this.getKeyColumn()) != null && key.trim().length() > 0) {
            xmlAttr.append(" key_column=\"" + key + "\"");
        }
        if (this.table_Alias != null) {
            xmlAttr.append(" table_alias=\"" + this.table_Alias + "\"");
        }
    }

    void getInfoFields(StringBuffer infoFields) {
        if (this.identifiableColumns == null || this.identifiableColumns.length == 0) {
            return;
        }
        infoFields.append("  <hidden_info>\n");
        for (int i = 0; i < this.identifiableColumns.length; ++i) {
            infoFields.append("    <field column=\"" + this.identifiableColumns[i].getName() + "\"" + " name=\"" + this.identifiableColumns[i].getDisplayName() + "\"/>\n");
        }
        infoFields.append("  </hidden_info>\n");
    }

    public static String getRuleAttributes(StylingRule sr) {
        String ruleAttr = "";
        if (sr.getStarColumn()) {
            ruleAttr = ruleAttr + " column=\"*\"";
        } else {
            String[] attr = sr.getAttributeColumnsAsArray();
            if (attr != null) {
                ruleAttr = ruleAttr + " column=\"" + attr[0];
                for (int i = 1; i < attr.length; ++i) {
                    ruleAttr = ruleAttr + "," + attr[i];
                }
                ruleAttr = ruleAttr + "\"";
            }
        }
        String orderBy = sr.getOrderByColumns();
        if (orderBy != null) {
            ruleAttr = ruleAttr + " order_by=\"" + orderBy + "\"";
            String sortOrder = sr.getSortOrder();
            if (sortOrder != null) {
                ruleAttr = ruleAttr + " sort_order=\"" + sortOrder + "\"";
            }
        }
        return ruleAttr;
    }

    public static String getRuleFeatures(StylingRule sr) {
        String styleName;
        String ruleFeat = "    <features";
        boolean asis = sr.isQueryPassThrough();
        if (asis) {
            ruleFeat = ruleFeat + " asis=\"true\"";
        }
        if ((styleName = sr.getFeatureStyleName()) != null) {
            ruleFeat = ruleFeat + " style=\"" + styleName + "\"";
        }
        ruleFeat = ruleFeat + ">";
        String featCondition = sr.getFeatureCond();
        if (featCondition != null) {
            StringBuffer str = new StringBuffer(featCondition);
            str = LRSThemeDefinition.removeXMLEntities(str);
            ruleFeat = ruleFeat + " " + str.toString();
        }
        ruleFeat = ruleFeat + " </features>\n";
        return ruleFeat;
    }

    public static String getRuleLabel(StylingRule sr) {
        String labelFunc;
        String labelStyle;
        if (!sr.getLabeled()) {
            return "";
        }
        double v = 0.0;
        try {
            v = Double.parseDouble(sr.getLabelFunction());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sr.getLabelFunction() == null || v <= 0.0) {
            return "";
        }
        String ruleLabel = "    <label";
        String labelCol = sr.getLabelColumn();
        if (labelCol != null) {
            ruleLabel = ruleLabel + " column=\"" + labelCol + "\"";
        }
        if ((labelStyle = sr.getLabelStyleName()) != null) {
            ruleLabel = ruleLabel + " style=\"" + labelStyle + "\">";
        }
        if ((labelFunc = sr.getLabelFunction()) != null) {
            ruleLabel = ruleLabel + " " + labelFunc;
        }
        ruleLabel = ruleLabel + " </label>\n";
        return ruleLabel;
    }

    public static StringBuffer removeXMLEntities(StringBuffer inBuf) {
        int idx = 0;
        String inStr = inBuf.toString();
        while ((idx = inStr.indexOf("<")) > 0) {
            inBuf = inBuf.replace(idx, idx + 1, "&lt;");
            inStr = inBuf.toString();
        }
        while ((idx = inStr.indexOf(">")) > 0) {
            inBuf = inBuf.replace(idx, idx + 1, "&gt;");
            inStr = inBuf.toString();
        }
        while ((idx = inStr.indexOf("\"")) > 0) {
            inBuf = inBuf.replace(idx, idx + 1, "&quot;");
            inStr = inBuf.toString();
        }
        return inBuf;
    }

    public String getTableAlias() {
        return this.table_Alias;
    }

    public void setTableAlias(String alias) {
        this.table_Alias = alias;
    }

    public ThemeStyleInfo[] getStyleList() {
        if (this.styleRules == null || this.styleRules.length == 0) {
            return null;
        }
        StyleCache sc = DSManager.getStyleCache(this.dataSource);
        if (sc == null) {
            log.warning("cannot locate the style cache for datasource: " + this.dataSource);
            return null;
        }
        Vector<ThemeStyleInfo> stylesV = new Vector<ThemeStyleInfo>();
        String name = this.getHighlightStyleName();
        if (name != null) {
            Style sty = sc.get(name);
            if (sty == null) {
                log.warning("Highlight style '" + name + "' cannot be found for theme " + this.getName() + ".");
            } else {
                ThemeStyleInfo si = new ThemeStyleInfo(name);
                si.setRendering(true);
                si.setHighlighting(true);
                si.setType(sty.getModel().getTypeName());
                si.setDescription(sty.getModel().getDescription());
                stylesV.add(si);
            }
        }
        ArrayList<String> renderStyles = new ArrayList<String>();
        ArrayList<String> labelStyles = new ArrayList<String>();
        for (int i = 0; i < this.styleRules.length; ++i) {
            StylingRule r = this.styleRules[i];
            name = r.getFeatureStyleName();
            if (name == null || renderStyles.contains(name.toUpperCase())) continue;
            Style sty = sc.get(name);
            if (sty == null) {
                log.warning("Render style '" + name + "' cannot be found for theme " + this.getName() + ".");
            } else {
                ThemeStyleInfo si = new ThemeStyleInfo(name);
                si.setRendering(true);
                si.setType(sty.getModel().getTypeName());
                si.setDescription(sty.getModel().getDescription());
                stylesV.add(si);
                renderStyles.add(name.toUpperCase());
            }
            RenderingRule[] rrules = this.styleRules[i].getRenderingRules();
            if (rrules != null) {
                for (int j = 0; j < rrules.length; ++j) {
                    name = rrules[j].getStyleName();
                    if (name == null || renderStyles.contains(name.toUpperCase())) continue;
                    sty = sc.get(name);
                    if (sty == null) {
                        log.warning("Render style '" + name + "' cannot be found for theme " + this.getName() + ".");
                        continue;
                    }
                    ThemeStyleInfo si = new ThemeStyleInfo(name);
                    si.setRendering(true);
                    si.setType(sty.getModel().getTypeName());
                    si.setDescription(sty.getModel().getDescription());
                    stylesV.add(si);
                    renderStyles.add(name.toUpperCase());
                }
            }
            if ((name = r.getLabelStyleName()) == null || labelStyles.contains(name.toUpperCase())) continue;
            sty = sc.get(name);
            if (sty == null) {
                log.warning("Label style '" + name + "' cannot be found for theme " + this.getName() + ".");
                continue;
            }
            ThemeStyleInfo si = new ThemeStyleInfo(name);
            si = new ThemeStyleInfo(name);
            si.setLabeling(true);
            si.setType(sty.getModel().getTypeName());
            si.setDescription(sty.getModel().getDescription());
            stylesV.add(si);
            labelStyles.add(name.toUpperCase());
        }
        return stylesV.toArray(new ThemeStyleInfo[stylesV.size()]);
    }

    public void setRenderingRules(RenderingRule[][] rrules) {
        if (this.styleRules == null || rrules == null || this.styleRules.length == 0) {
            return;
        }
        for (int i = 0; i < this.styleRules.length; ++i) {
            if (rrules.length <= i) continue;
            this.styleRules[i].setRenderingRules(rrules[i]);
        }
    }

    public RenderingRule[] getRenderingRules(int ruleIndex) {
        if (this.styleRules == null || this.styleRules.length == 0 || ruleIndex >= this.styleRules.length) {
            return null;
        }
        return this.styleRules[ruleIndex].getRenderingRules();
    }

    @Override
    public RenderingRule[] getRenderingRules() {
        if (this.styleRules == null || this.styleRules.length == 0) {
            return null;
        }
        return this.styleRules[0].getRenderingRules();
    }

    @Override
    public void setRenderingRules(RenderingRule[] rrules) {
        if (this.styleRules == null || this.styleRules.length == 0) {
            return;
        }
        this.styleRules[0].setRenderingRules(rrules);
    }

    public String getBaseColumnType() {
        return this.baseColumnType;
    }

    public void setBaseColumnType(String typeName) {
        this.baseColumnType = typeName;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.baseTable);
        ti.setType("LRS");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.getGeomColumn());
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        ArrayList<String> styleNames = new ArrayList<String>();
        if (this.styleRules != null) {
            for (int i = 0; i < this.styleRules.length; ++i) {
                RenderingRule[] rrules;
                String style = this.styleRules[i].getFeatureStyleName();
                if (style != null && !styleNames.contains(style.toUpperCase())) {
                    styleNames.add(style.toUpperCase());
                }
                if ((rrules = this.styleRules[i].getRenderingRules()) == null) continue;
                for (int j = 0; j < rrules.length; ++j) {
                    style = rrules[j].getStyleName();
                    if (style == null || styleNames.contains(style.toUpperCase())) continue;
                    styleNames.add(style.toUpperCase());
                }
            }
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }

    @Override
    public String[] getLabelingStyles() {
        ArrayList<String> styleNames = new ArrayList<String>();
        if (this.styleRules != null) {
            for (int i = 0; i < this.styleRules.length; ++i) {
                String style = this.styleRules[i].getLabelStyleName();
                if (style == null || styleNames.contains(style.toUpperCase())) continue;
                styleNames.add(style.toUpperCase());
            }
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }

    @Override
    public String[] getLabelColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.styleRules != null) {
            Hashtable cols = new Hashtable(10);
            for (int i = 0; i < this.styleRules.length; ++i) {
                String labelCol = this.styleRules[i].getLabelColumn();
                if (labelCol == null || cols.get(labelCol) != null) continue;
                columns.add(labelCol);
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        return columns.toArray(new String[columns.size()]);
    }

    public String getRtreeIndexName() {
        return this.rtreeIndexName;
    }

    public void setRtreeIndexName(String rtreeIndexName) {
        this.rtreeIndexName = rtreeIndexName;
    }

    public Rectangle2D getBaseTableMBR() {
        return this.baseTableMBR;
    }

    public void setBaseTableMBR(Rectangle2D baseTableMBR) {
        this.baseTableMBR = baseTableMBR;
    }

    public boolean isBasetableGeodetic() {
        return this.basetableGeodetic;
    }

    public void setBasetableGeodetic(boolean basetableGeodetic) {
        this.basetableGeodetic = basetableGeodetic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateIndexInfo(Connection conn) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement(idxNameQuery);
            pst.setString(1, this.baseTable);
            pst.setString(2, this.spatialColumn);
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                String idxName = rs.getString(1);
                this.setRtreeIndexName(idxName);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while querying spatial index name for theme " + this.getName() + ": " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateIndexMBR(Connection conn, String idxName) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement(idxMBRQuery);
            pst.setString(1, idxName);
            rs = pst.executeQuery();
            if (rs != null && rs.next()) {
                String geod = rs.getString(1);
                this.basetableGeodetic = "TRUE".equalsIgnoreCase(geod);
                JSDOGeometry mbrGeom = JDBCUtil.loadGeometry(rs, 2, true);
                this.baseTableMBR = Util.geom2MBR(mbrGeom, this.basetableGeodetic);
                if (this.basetableGeodetic) {
                    this.baseTableLatLonMBR = this.baseTableMBR;
                } else {
                    double[] latlons = Util.transform(conn, this.baseTableMBR.getMinX(), this.baseTableMBR.getMinY(), this.baseTableMBR.getMaxX(), this.baseTableMBR.getMaxY(), this.srid, 8307);
                    this.baseTableLatLonMBR = new Rectangle2D.Double(latlons[0], latlons[1], latlons[2] - latlons[0], latlons[3] - latlons[1]);
                }
            }
        }
        catch (Exception ex) {
            log.warning("Exception while querying spatial index metadata for theme " + this.getName() + ": " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public boolean isSpatialIndexHintEnabled() {
        return this.spatialIndexHintEnabled;
    }

    public void setSpatialIndexHintEnabled(boolean spatialIndexHintEnabled) {
        this.spatialIndexHintEnabled = spatialIndexHintEnabled;
    }

    public Rectangle2D getBaseTableLatLonMBR() {
        return this.baseTableLatLonMBR;
    }

    public void setBaseTableLatLonMBR(Rectangle2D baseTableLatLonMBR) {
        this.baseTableLatLonMBR = baseTableLatLonMBR;
    }
}

