/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.sam;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.sam.Cluster;
import oracle.spatial.util.RTree;

public class ClusterContext {
    StyledFeatureI[] features;
    int maxClusters;
    int w;
    int h;
    RTree rTree;

    public ClusterContext(StyledFeatureI[] features, int maxClusters, int w, int h) {
        this.features = features;
        this.maxClusters = maxClusters;
        this.w = w;
        this.h = h;
    }

    public void init() {
        this.buildRTree();
    }

    private void buildRTree() {
        this.rTree = new RTree(2, 10, 2);
        int size = this.features.length;
        double[][][] mbh = new double[size][][];
        Object[] o = new Object[size];
        StringBuffer sb = new StringBuffer(8000);
        sb.append("{");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        DecimalFormat decimalFormat = new DecimalFormat("0.##", decimalFormatSymbols);
        for (int i = 0; i < size; ++i) {
            mbh[i] = new double[2][];
            mbh[i][0] = new double[2];
            mbh[i][1] = new double[2];
            StyledFeatureI sf = this.features[i];
            Point2D pt = sf.getPoint();
            mbh[i][0][0] = pt.getX();
            mbh[i][0][1] = pt.getX();
            mbh[i][1][0] = pt.getY();
            mbh[i][1][1] = pt.getY();
            sb.append(" " + decimalFormat.format(pt.getX()) + ", " + decimalFormat.format(pt.getY()) + ",");
            if (i % 10 == 0) {
                sb.append("\n");
            }
            o[i] = sf;
        }
        sb.append("\n};");
        System.out.println(sb);
        long t0 = System.currentTimeMillis();
        try {
            this.rTree.packTree((double[][][])mbh, o);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.rTree = null;
        }
        System.out.println("STR pack tree elapsed time: " + (System.currentTimeMillis() - t0) + " mseconds for " + size + " geometries");
    }

    public void computeNN() {
    }

    public void mergeClusters(Cluster a, Cluster b) {
    }

    public RTree getRTree() {
        return this.rTree;
    }
}

